$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtTam',
            popover: {
                title: 'Tamanho',
                description: 'Neste campo adicionamos o tamanho.',
                position: 'top'
            }
        },
        {
            element: '#txtOrdem',
            popover: {
                title: 'Ordem',
                description: 'Aqui, adicionamos a ordem do tamanho.',
                position: 'top'
            }
        },
        {
            element: '#txtFaixa',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'E neste campo, adicionamos a faixa do tamanho.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o tamanho.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtTaxaCartao').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let tamanho = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('TAMANHO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/tamanho`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtTam: {
                    required: true,
                },
                txtOrdem: {
                    required: true,
                },
            },
            messages: {
                txtTam: {
                    required: "Informe um tamanho válido.",
                },
                txtOrdem: {
                    required: "Informe uma ordem válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    try {
        let response1 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"tabtam", 
                "camposSelect":["count(TAM) as CONTAGEM"], 
                "where": ["1 = 1"]}`, null);
        let jsonStr1 = await response1.json();
        $('#txtOrdem').val(jsonStr1.RESULT[0][0].CONTAGEM + 1);
    } catch (error) {
        console.error(error);
    }

    if (tamanho != '' && tamanho != 'create') {

        if (await liberarRegistro('TAMANHO', tamanho) == false) {
            window.location.href = '../tamanho';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tabtam", 
                    "camposSelect":["TAM", "ACRESCIMO", "FAIXA"], 
                    "where": ["tam = '${tamanho}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtTam').val(jsonStr.RESULT[0][0].TAM);
                    $('#txtOrdem').val(jsonStr.RESULT[0][0].ACRESCIMO);
                    $('#txtFaixa').val(jsonStr.RESULT[0][0].FAIXA);


                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $('#txtTam').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    tamanho = {};

                    tamanho.TAM = $('#txtTam').val().toUpperCase();
                    tamanho.ACRESCIMO = $('#txtOrdem').val();
                    tamanho.FAIXA = $('#txtFaixa').val().toUpperCase();

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/tamanho?', `JSON=${encodeURIComponent(JSON.stringify(tamanho))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Tamanho: ${tamanho.TAM}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/tamanho`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro('Número de ordem já utilizado, favor alterar.');
                }
            }
        });
});