<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Tag</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.243.6.1">
  <!-- Google Font: Source Sans Pro -->
  <!-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.243.6.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.243.6.1'>
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.243.6.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.243.6.1" />
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.243.6.1">
  <!-- AutoComplete -->
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.243.6.1">

  <style>
    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    #cardPrincipal {
      min-height: 400px;
      display: flex;
      justify-content: center;
    }

    .botoes {
      margin-top: 19px !important;
      margin-left: 7px;
    }

    #tabelaTag tbody {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Tag</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">
  
            </div><!-- /.col -->
          </div><!-- /.row -->

          <div class="card" id="cardPrincipal">
            <div class="row ml-2 mt-3 mr-2" id="tourbotoes">
              <div class="col-sm-12 mt-12">
                <div class="row">
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtProduto">Produto</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-Produto" name="btn-Produto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpar-Produto" name="btn-limpar-Produto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtTag">Tag</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtTag" name="txtTag" class="form-control" placeholder="Tag">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-Tag" name="btn-Tag" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpar-Tag" name="btn-limpar-Tag" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtTabPreco">Tabela Preço</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtTabPreco" name="txtTabPreco" class="form-control" placeholder="Tabela de Preço">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-TabPreco" name="btn-TabPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpar-TabPreco" name="btn-limpar-TabPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12" hidden>
                    <label data-error="wrong" data-success="right" for="txtColunas">Colunas</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtColunas" name="txtColunas" class="form-control" disabled readonly>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12" hidden>
                    <label data-error="wrong" data-success="right" for="txtColunaInicial">Coluna Inicial</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtColunaInicial" name="txtColunaInicial" class="form-control" disabled readonly>
                    </div>
                  </div>
                  <div class="float-right botoes col-lg-4 col-4">
                    <button id="btnGerar" class="btn-sisp btn btn-success"><i class="fas fa-cogs"></i> Gerar</button>
                    <button id="btnLimpar" class="btn-sisp btn btn-danger"><i class="fas fa-trash"></i> Limpar</button>
                    <button id="btnImprimir" class="btn-sisp btn btn-primary"><i class="fas fa-print"></i> Imprimir</button>
                  </div>
                  <div class="col-lg-4 col-4 p-0">
                    <button id="btnBuscaNFEntrada" style="margin-top: 19px; margin-left: 1px" class="btn-sisp btn btn-primary">Busca NF Entrada</button>
                  </div>
                </div>
              </div>
            </div>

            <div class="card-body" id="itensTag">
              <div class="card">
                <div class="card-body">
                  <div id="divTabGrade">
                    <div class="row">
                      <div class="col-12">
                        <h5><b>Grade</b></h5>
                      </div>
                    </div>
                    <div class="row pt-2">
                      <div class="col-sm-12 table-responsive">
                        <table id="tabelaGrade" class="table table-responsive-sm table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12">
                      <h5><b>Tag</b></h5>
                    </div>
                  </div>
                  <div class="row pt-2">
                    <div class="col-sm-12 table-responsive">
                      <table id="tabelaTag" class="table table-responsive-sm table-select table-hover" width="100%">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <button id="btnConsultar" class='btn btn-primary btn-sisp d-none' type='button'><span class="fas fa-search"></span>Consultar </button>

  <div class="modal fade" id="modal-nf-entrada" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar NF</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="form-row">
            <div class="col-lg-4 col-sm-4 form-group">
              <label for="txtNFEntrada">Nota: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtNFEntrada" name="txtNFEntrada" class="form-control" placeholder="Nota">
              </div>
            </div>
            <div class="col-lg-2 col-sm-2 form-group">
              <label for="txtSerieEntrada">Série: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtSerieEntrada" name="txtSerieEntrada" class="form-control" placeholder="Série">
              </div>
            </div>
            <div class="col-lg-6 col-sm-6">
              <div class="col-sm-12 icheck-secondary pt-4">
                <input class="form-check-input" type="checkbox" id="cbCompEtiqueta">
                <label class="form-check-label mb-2" for="cbCompEtiqueta">Buscar Composição Etiqueta</label>
              </div>
            </div>
            <div class="col-lg-12 col-sm-12 form-group">
              <label for="txtCodCreEntrada">Fornecedor: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCodCreEntrada" name="txtCodCreEntrada" class="form-control" placeholder="Fornecedor">
                <div class="input-group-append">
                  <button class="btn bg-danger create" id="btnCodCre" name="btnCodCre" data-button="absolute" type="button">
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                  <button class="btn bg-danger create" id="btnACodCre" type="button">
                    <i class="m-0 p-0 fas fa-trash"></i>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConsultarNFEntrada" class="btn btn-sisp btn-primary"> Consultar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.243.6.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.243.6.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/sisplan.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.243.6.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.243.6.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.243.6.1"></script>
  <script src="utils/cookies.js?versao=3.243.6.1"></script>
  <!-- SweetAlert2 -->
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.243.6.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/driver.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="config.js?versao=3.243.6.1"></script>
  <script>
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELTAG');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/reltag/reltag.js?versao=3.243.6.1`;
      insereJavaScriptPagina(sArquivo);
    });
  </script>

</body>

</html>