$(document).ready(async function () {

  const filtroDeposito = await buscaDepositoEmpresaUsuario();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relPosEstoque == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosEstoque: ['MATERIAL', 'DESC_MATERIAL'] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosEstoque: novasColunas }))

      $('#tabelaPosicaoEstoque').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaPosicaoEstoque').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltrosRel',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  let modalAberto = false;

  $('#btnFiltrosRel').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimpaFiltros').on('click', function () {
    limpaFiltros();
  });

  $('#btnConsultar').on('click', async function () {
    await fazConsulta();
    $('#modal-filtros').modal('hide');

  });

  await preencheOrdenacaoTela('RelPosEstoque');

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) {
      $("#tabelaPosicaoEstoque").DataTable().destroy();
      $("#tabelaPosicaoEstoque").empty();
    }
    try {
      dataSetCols = [];
      $.LoadingOverlay('show');

      const url = `/sisplan/impressao/v1/relposestoque?`;
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtMeta").val();
        if ($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) {
          $('#tabelaPosicaoEstoque').DataTable().destroy();
          $('#tabelaPosicaoEstoque').empty();
        }
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        msgAlerta("Nenhum registro encontrado!");
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      let indiceValor;

      const camposDireita = ['TOTAL', 'CUSTO', 'PRECO', 'PRECO_VEN', 'PRECO_COMPRA', 'GRAMATURA', 'QTDE_ATUAL', 'CUSTO_INDUSTRIAL', 'CUSTO_REAL'];
      for (let i = 1; i < 200; i++) {
        camposDireita.push('QTD' + i);
      }
      const indiceDireita = [];
      for (let i = 0; i < keys.length; i++) {
        if (keys[i] == 'VALOR') {
          indiceValor = i;
        } else if (camposDireita.includes(keys[i])) {
          indiceDireita.push(i);
        }
      }

      $('#tabelaPosicaoEstoque').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetCols,
        data: jsonStr,
        columnDefs: [{
          targets: 0,
          // searchable: false
        },
        {
          "className": 'pr-4 text-right',
          targets: indiceDireita
        }]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaPosicaoEstoque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaPosicaoEstoque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = `/sisplan/impressao/v1/relposestoque?`;
        const filtros = await retornaFiltros();
        await exportaCSV(url, filtros, false, null, 'Relatório de Posição de Estoque', '#tabelaPosicaoEstoque');
      })

      $('#tabelaPosicaoEstoque').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relPosEstoque).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPosicaoEstoque').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relPosEstoque ?? ['MATERIAL', 'DESC_MATERIAL'])
  })

  $('#btnCarregaEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros(bInventario = false) {

    let estoqueNegativo = 'N';
    let consideraDtCad = 'N';

    let cbConsideraCodigo = 'N';
    let cbConsideraCor = 'N';
    let cbConsideraDeposito = 'N';
    let cbConsideraGrupo = 'N';
    let cbConsideraMarca = 'N';
    let cbConsideraLinha = 'N';
    let cbConsideraColecao = 'N';
    let cbConsideraSubColecao = 'N';
    let cbConsideraStatus = 'N';
    let cbConsideraTabPreco = 'N';
    let cbConsideraPeriodo = 'N';
    let cbConsideraCategoria = 'N';
    let cbConsideraQualidade = 'N';
    let cbConsideraGramatura = 'N';
    let cbConsideraComposicao = 'N';


    if ($('#cbEstoqueNegativo').is(':checked')) {
      estoqueNegativo = 'S';
    }
    if ($('#cbConsideraDtCad').is(':checked')) {
      consideraDtCad = 'S';
    }

    if ($('#cbConsideraCodigo').is(':checked')) {
      cbConsideraCodigo = 'S';
    }

    if ($('#cbConsideraCor').is(':checked')) {
      cbConsideraCor = 'S';
    }

    if ($('#cbConsideraDeposito').is(':checked')) {
      cbConsideraDeposito = 'S';
    }

    if ($('#cbConsideraGrupo').is(':checked')) {
      cbConsideraGrupo = 'S';
    }

    if ($('#cbConsideraMarca').is(':checked')) {
      cbConsideraMarca = 'S';
    }

    if ($('#cbConsideraLinha').is(':checked')) {
      cbConsideraLinha = 'S';
    }

    if ($('#cbConsideraColecao').is(':checked')) {
      cbConsideraColecao = 'S';
    }

    if ($('#cbConsideraSubColecao').is(':checked')) {
      cbConsideraSubColecao = 'S';
    }

    if ($('#cbConsideraStatus').is(':checked')) {
      cbConsideraStatus = 'S';
    }

    if ($('#cbConsideraTabPreco').is(':checked')) {
      cbConsideraTabPreco = 'S';
    }

    if ($('#cbConsideraPeriodo').is(':checked')) {
      cbConsideraPeriodo = 'S';
    }

    if ($('#cbConsideraCategoria').is(':checked')) {
      cbConsideraCategoria = 'S';
    }

    if ($('#cbConsideraQualidade').is(':checked')) {
      cbConsideraQualidade = 'S';
    }

    if ($('#cbConsideraGramatura').is(':checked')) {
      cbConsideraGramatura = 'S';
    }

    if ($('#cbConsideraComposicao').is(':checked')) {
      cbConsideraComposicao = 'S';
    }

    const empresasFiltradas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const vendas = $('input[name="rdTipoTodos"]:checked').val();
    const produtos = $('input[name="filtroTodos"]:checked').val();
    const data = $('#txtData').val().replace();
    const codigo = await formataListas($('#txtProduto').val().toString());
    let deposito = await formataListas($('#txtDepositoUsuario').val().toString());
    if (deposito == '') {
      deposito = filtroDeposito;
    }
    const grupo = await formataListas($('#txtGrupoPA').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const status = await formataListas($('#txtStatus').val().toString());
    const gramatura = await formataListas($('#txtGramatura').val().toString());
    const composicao = await formataListas($('#txtComposicao').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const tabPreco = await formataListas($('#txtTabPreco').val().toString());
    const diasPrazo = $('#selectPrazo').val();
    const lote = $('#txtLote').val();
    const subColecao = await formataListas($('#txtSubColecao').val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const prazo = await formataListas($('#txtTabPrazo').val().toString());
    const categoria = await formataListas($('#txtCategoria').val().toString());
    const selPrazos = $('#selectPrazo').val();

    const filtros =
      `EMP_IDS=${empresasFiltradas}&` +
      `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
      `PRODUTOS=${produtos}&` +
      `CONSIDERACODIGO=${cbConsideraCodigo}&` +
      `CONSIDERACOR=${cbConsideraCor}&` +
      `CONSIDERADEPOSITO=${cbConsideraDeposito}&` +
      `CONSIDERAGRUPO=${cbConsideraGrupo}&` +
      `CONSIDERAMARCA=${cbConsideraMarca}&` +
      `CONSIDERALINHA=${cbConsideraLinha}&` +
      `CONSIDERACOLECAO=${cbConsideraColecao}&` +
      `CONSIDERASUBCOLECAO=${cbConsideraSubColecao}&` +
      `CONSIDERASTATUS=${cbConsideraStatus}&` +
      `CONSIDERATABPRECO=${cbConsideraTabPreco}&` +
      `CONSIDERAPERIODO=${cbConsideraPeriodo}&` +
      `CONSIDERACATEGORIA=${cbConsideraCategoria}&` +
      `CONSIDERAQUALIDADE=${cbConsideraQualidade}&` +
      `CONSIDERAGRAMATURA=${cbConsideraGramatura}&` +
      `CONSIDERACOMPOSICAO=${cbConsideraComposicao}&` +
      `VENDAS=${vendas}&` +
      `ESTOQUENEGATIVO=${estoqueNegativo}&` +
      `CONSIDERADTCAD=${consideraDtCad}&` +
      `DATA=${data}&` +
      `CODIGO=${codigo}&` +
      `DEPOSITO=${deposito}&` +
      `GRUPO=${grupo}&` +
      `STATUS=${status}&` +
      `GRAMATURA=${gramatura}&` +
      `COMPOSICAO=${composicao}&` +
      `MARCA=${marca}&` +
      `LINHA=${linha}&` +
      `TABPRECO=${tabPreco}&` +
      `DIASPRAZO=${diasPrazo}&` +
      `LOTE=${lote}&` +
      `COLECAO=${colecao}&` +
      `SUBCOLECAO=${subColecao}&` +
      `COR=${cor}&` +
      `QUALIDADE=${qualidade}&` +
      `PRAZO=${prazo}&` +
      `CATEGORIA=${categoria}&` +
      `SELECTPRAZO=${selPrazos}&` +
      `SETORINVENTARIO=${pegaChave('#txtSetor')}&` +
      `DATAINVENTARIO=${$('#txtDataInventario').val()}&` +
      `INVENTARIO=${bInventario ? 'S' : 'N'}`;

    return filtros;
  };

  componenteFiltro('produto', true);
  componenteFiltro('cor', true);
  componenteFiltro('depositoUsuario', true);
  componenteFiltro('grupoPA', true);
  componenteFiltro('marca', true);
  componenteFiltro('linha', true);
  componenteFiltro('colecao', true);
  componenteFiltro('subColecao', true);
  componenteFiltro('status', true);
  componenteFiltro('tabPrazo', true);
  componenteFiltro('categoria', true);
  componenteFiltro('qualidade', true);
  componenteFiltro('gramatura', true);
  componenteFiltro('composicao', true);
  componenteFiltro('tabPreco', true);

  function limpaFiltros() {
    $('#txtProduto').empty().trigger('change');
    $('#txtDepositoUsuario').empty().trigger('change');
    $('#txtGrupoPA').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtStatus').empty().trigger('change');
    $('#txtGramatura').empty().trigger('change');
    $('#txtComposicao').empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtLinha').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#txtLote').val('');
    $('#selectPrazo').val('00');
    $('#txtSubColecao').empty().trigger('change');
    $('#txtCor').empty().trigger('change');
    $('#txtQualidade').empty().trigger('change');
    $('#txtTabPrazo').empty().trigger('change');
    $('#txtCategoria').empty().trigger('change');

    $('#txtData').val('1200-01-01');
    $('#rdFiltroTodos').prop('checked', true);
    $('#rdFiltroAtivos').prop('checked', false);
    $('#rdFiltroInativos').prop('checked', false);
    $('#rdTipoTodos').prop('checked', true);
    $('#rdTipoProducao').prop('checked', false);
    $('#rdTipoRevenda').prop('checked', false);
    $('#cbConsideraDtCad').prop('checked', false);
    $('#cbPosseCadDep').prop('checked', false);
    $('#cbEstoqueNegativo').prop('checked', false);
  }

  retornaHintRelatorio('btnImprimir', 'RelPosEstoquePadrao')

  $('#txtOrdem').on('change', function () {
    retornaHintRelatorio('btnImprimir', $("#txtOrdem option")
      .toArray()
      .map(map => {
        return [map.selected, $(map)
          .attr('nome_prt')]
      })
      .filter(filter => filter[0] == true)[0][1])
  })

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const filtros = await retornaFiltros();
        let url = `/sisplan/impressao/v1/relposestoque?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
        const ordem = `&TELA_ORDENACAO=RelPosEstoque&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPosEstoque');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, "POST", 300000, false, 'relposestoque');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#btnConfirmarInventario').on('click', async function () {
    if (isChecked('#cbEstoqueNegativo')) {
      msgAlerta('Impossível gerar inventário com a opção "Estoque negativo" marcada.');
      return;
    }

    $.LoadingOverlay("show");
    try {
      const url = `/sisplan/impressao/v1/relposestoque?`;
      const filtros = await retornaFiltros(true);
      const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        msgAlerta(jsonStr.mensagem);
        return;
      }

      msgAlerta('Inventário gerado com sucesso.')
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#btnInventario').on('click', function () {
    $('#txtDataInventario').val($('#txtData').val());
    $('#modalInventario').modal('show');
  });

  $('#txtSetor').autocompleta(1, `JSON={ "tabela":"cadfluxo", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btn-Setor').pesquisa_serverside(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Setor');
  $('#btn-limpa-Setor').on('click', function () { $('#txtSetor').val(''); });

})
