$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'gravar')) {
                    $('.driver-next-btn').on('click', location.reload());
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'formcard1') {
                    $('.driver-close-btn').on('click', location.reload());
                };
            }
        });

        driver.defineSteps([{
            element: '#divCashback',
            popover: {
                title: 'Lista de Cashback',
                description: 'Aqui estão os registros de cashback gerados/utilizados pelos clientes.',
                position: 'top'
            }
        },
        {
            element: '#btnFiltros',
            popover: {
                title: 'Filtros',
                description: 'Aqui, você tem a opção de filtrar as informações que deseja analisar.',
                position: 'bottom'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Imprimir',
                description: 'Imprime os dados filtrados.',
                position: 'bottom'
            }
        },
        {
            element: '#boxDashboard',
            popover: {
                title: 'Totalizadores',
                description: 'Aqui você tem um total resumido dos dados apresentados abaixo',
                position: 'top'
            }
        },
        {
            element: '#txtQuantidade',
            popover: {
                title: 'Quantidade',
                description: 'Adicionamos neste campo a quantidade da unidade.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a Unidade.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

function anosEntre(inicio, fim) {
    const anos = [];
    for (let i = inicio; i <= fim; i++) {
        anos.push(String(i));
    }
    // eslint-disable-next-line prefer-template
    return anos.map(ano => ano).toString();
}

$('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
});

async function retornaFiltros() {
    const produto = await formataListas($('#txtProduto').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const tabpreco = await formataListas($('#txtTabPreco').val().toString());
    const prazo = $('#selectPrazo').val();
    const todasEmpresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')];
    const emissaoDe = $('#dtEmissaoDe').val();
    const emissaoAte = $('#dtEmissaoAte').val();
    const ordemImpressao = $('#txtOrdem').val();
    const modelo = await formataListas($('#txtModelo').val().toString());
    const emitido = $('#cbEmitido').prop('checked');
    const pendente = $('#cbPendente').prop('checked');
    const agrupado = $('#cbAgrupado').prop('checked');
    const devolvido = $('#cbDevolvido').prop('checked');
    const cancelado = $('#cbCancelado').prop('checked');
    const tipovenda = await formataListas($('#txtTipoVenda').val().toString());
    let retorno = `CODIGO=${produto}` +
        `&GRUPO=${grupo}` +
        `&MARCA=${marca}` +
        `&LINHA=${linha}` +
        `&ETIQUETA=${etiqueta}` +
        `&COLECAO=${colecao}` +
        `&TABPRECO=${tabpreco}` +
        `&PRAZO=${prazo}` +
        `&EMISSAO_DE=${emissaoDe}` +
        `&EMISSAO_ATE=${emissaoAte}` +
        `&EMPRESAS_FILTRO=${todasEmpresas}` +
        `&OPCAORELATORIO=${ordemImpressao}` +
        `&MODELO=${modelo}` +
        `&EMITIDO=${emitido}` +
        `&PENDENTE=${pendente}` +
        `&AGRUPADO=${agrupado}` +
        `&DEVOLVIDO=${devolvido}` +
        `&CANCELADO=${cancelado}` +
        `&TIPO_VENDA=${tipovenda}`;
    return retorno;
}

$(document).ready(async function () {

    let options = {
        series: [{
            name: "Quantidade",
            data: [{}]
        }],
        chart: {
            type: 'bar',
            height: 300
        },
        tooltip: {
            x: {
                formatter: function (val) {
                    return val;
                }
            }
        },
        xaxis: {
            type: 'category',
            labels: {
                formatter: function (val) {
                    return val.split(' - ')[0];
                }
            }
        },
        title: {
            text: 'Top 30 tamanhos mais vendidos',
        },
        fill: {
            colors: ['#75BE25']
        }
    };

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relDesempenhoTamanho == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relDesempenhoTamanho: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relDesempenhoTamanho: novasColunas }))

            $('#tabelaDados').DataTable().columns().visible(true);

            $('#tabelaDados').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                }
            )

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });


    adicionarConteudoModal(
        'Desempenho por Tamanho', [
        {
            tipo: 'paragrafo',
            valor: 'Após o entendimento da cobertura de estoque e também do desempenho por produto (referência) a análise do desempenho por tamanho é ' +
                'essencial para a gestão. Neste relatório o ideal é separar as visões/consultas por partes (superiores e/ou inferiores), avaliando um grupo de cada vez, ' +
                'como por exemplo (calça e/ou camiseta) para que o resultado dê um norte em proporção de grade na hora de produzir e/ou comprar. ' +
                'Também é possível analisar vendas por tamanho em unidades diferentes.',
        },
        {
            tipo: 'paragrafo',
            valor: 'Qual tamanho vende mais? Qual vende menos?'
        },
        {
            tipo: 'lista',
            itens: [
                'Atenção aos tamanhos que vendem mais, facilitando a decisão ao montar uma nova grade (não incluindo tamanhos que não tiveram um bom desempenho).',
                'Cidade, clima, perfil de loja, gênero, regionalidades, são fatores que podem interferir diretamente no desempenho de venda de cada tamanho em uma loja.'
            ]
        },
    ]
    );

    await preencheOrdenacaoTela('DesempenhoTamanho');

    componenteFiltro('colecao', true);
    componenteFiltro('produto', true);
    componenteFiltro('marca', true);
    componenteFiltro('grupo', true);
    componenteFiltro('linha', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('tabPreco', true);
    componenteFiltro('modelo', true);
    componenteFiltro('tipoVenda', true);
    // limparFiltros(true);

    $('#btnLimparFiltros').on('click', function () {
        $('#dtEmissaoDe').val('1200-01-01');
        $('#dtEmissaoAte').val('2500-12-31');
        $('#txtProduto').empty().trigger('change');
        $('#txtColecao').empty().trigger('change');
        $('#txtModelo').empty().trigger('change');
        $('#txtGrupo').empty().trigger('change');
        $('#txtEtiqueta').empty().trigger('change');
        $('#txtLinha').empty().trigger('change');
        $('#txtMarca').empty().trigger('change');
        $('#txtTabPreco').empty().trigger('change');
        $('#selectPrazo').val('00');
        $('#txtTipoVenda').empty().trigger('change');
    })

    $("#btnFiltros").on("click", function () {
        $("#modal-filtros").modal("show");
    });

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    function aplicaEstiloTabela() {

        const tabela = document.getElementById("tabelaDados");
        const linhas = tabela.getElementsByTagName("tr");

        for (let i = 0; i < linhas.length; i++) {
            const celulas = linhas[i].getElementsByTagName("td");
            for (let j = 4; j < celulas.length - 2; j++) {
                if (parseInt(celulas[j].textContent) > 0) {
                    celulas[j].style.fontWeight = 'bold';
                }
            }
        }
    }

    function formataColuna(coluna) {
        const partes = coluna.split('HIFEN');
        coluna = partes[1];
        return coluna;
    }

    function esconderColunas() {

        const c = $('#tabelaDados').DataTable().columns()[0].length;

        for (let i = 4; i < c - 3; i++) {
            $('#tabelaDados').DataTable().column(i).visible(true);
            sum = 0;
            $('#tabelaDados').DataTable().column(i, { search: 'applied' }).data().each(function (value) {
                let valor = parseFloat(value);
                if (!isNaN(valor)) {
                    sum += valor;
                }
            });
            if (sum == 0) {
                $('#tabelaDados').DataTable().column(i).visible(false);
            }
        }

        let listaColsInv = [];

        $('#tabelaDados').DataTable().columns().every(function () {
            if (!this.visible()) {
                listaColsInv.push(this.dataSrc());
            }
        });

        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relDesempenhoTamanho: listaColsInv }));
    }

    retornaHintRelatorio('btnImprimir', 'DesempenhoTamanhoPadrao')

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/reldesempenhotamanho?`;
                const params = await retornaFiltros();

                let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
                if (arquivo != undefined) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnConsultar').on('click', async function () {
        const url = '/sisplan/impressao/v1/reldesempenhotamanho?';
        const filtros = await retornaFiltros();
        const dataSetCols = [];

        $.LoadingOverlay('show');
        if ($("#txtOrdem option").toArray().lenght > 0) {
            retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
        }
        try {
            try {
                const response = await requisicao('GET', url, filtros, '', 600000);
                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if ($.fn.DataTable.isDataTable('#tabelaDados')) {
                    $('#tabelaDados').DataTable().destroy();
                    $('#tabelaDados').empty();
                };

                if (jsonStr.length == 0) {
                    msgAlerta('Nenhum registro encontrado!');
                    return;
                }

                if (response.status != 200) {
                    console.error(jsonStr.mensagem);
                }

                const dataSet = jsonStr;
                const alvoCols = (Object.keys(jsonStr[0]).length) - 1;

                const keys = Object.keys(dataSet[0]);
                for (let k in keys) {
                    if (keys.hasOwnProperty(k)) {
                        dataSetCols.push({
                            'title': formataColuna(keys[k]),
                            'data': keys[k]
                        });
                    }
                }

                const indiceDireita = [];
                for (let i = 4; i < alvoCols; i++) {
                    indiceDireita.push(i);                   
                }

                $('#tabelaDados').DataTable({
                    bPaginate: true,
                    filter: true,
                    sort: true,
                    info: true,
                    destroy: true,
                    "language": {
                        "sEmptyTable": "Nenhum registro encontrado",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhum registro encontrado",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }
                    },
                    colReorder: true,
                    columns: dataSetCols,
                    data: dataSet,
                    order: [],
                    columnDefs: [
                        {
                            targets: [alvoCols - 2], render: function (data, type, row, meta) {
                                let preco = 0;
                                if (typeof row[`${alvoCols - 2}HIFENVALOR`] == 'string' && row[`${alvoCols - 2}HIFENVALOR`] != '') {
                                    preco = row[`${alvoCols - 2}HIFENVALOR`].replace(',', '.');
                                } else {
                                    preco = row[`${alvoCols - 2}HIFENVALOR`];
                                }
                                const precoFormatado = parseFloat(preco).toFixed(2);
                                return precoFormatado == "NaN" ? row[`${alvoCols - 2}HIFENPRECO_TAB`] : precoFormatado;
                            }
                        },
                        {
                            targets: [alvoCols - 1], render: function (data, type, row, meta) {
                                let preco = 0;
                                if (typeof row[`${alvoCols - 1}HIFENPRECO_TAB`] == 'string' && row[`${alvoCols - 1}HIFENPRECO_TAB`] != '') {
                                    preco = row[`${alvoCols - 1}HIFENPRECO_TAB`].replace(',', '.');
                                } else {
                                    preco = row[`${alvoCols - 1}HIFENPRECO_TAB`];
                                }
                                const precoFormatado = parseFloat(preco).toFixed(4);
                                return precoFormatado == "NaN" ? row[`${alvoCols - 1}HIFENPRECO_TAB`] : precoFormatado;
                            }
                        },
                        {
                            "targets": indiceDireita,
                            "className": 'pr-4 text-right'
                        }
                    ]
                });

                $('#modal-filtros').modal('hide');

                aplicaEstiloTabela();

                $('#tabelaDados').DataTable().on('draw', function () {
                    aplicaEstiloTabela();
                });

                $('#tabelaDados').DataTable().on('page.dt', function () {
                    aplicaEstiloTabela();
                })

                $('#tabelaDados').DataTable().columns().visible(true);

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

                // adiciona o botão na tabela e adiciona a função de abrir o modal
                $('#tabelaDados_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaDados_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const url = '/sisplan/impressao/v1/reldesempenhotamanho?';
                    const filtros = await retornaFiltros();
                    await exportaCSV(url, filtros, false, null, 'Relatório Desempenho por Tamanho', '#tabelaDados');
                })

                $('#tabelaDados').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.relDesempenhoTamanho).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                )

                esconderColunas();

                dataSetCols.map(item => { item.QTDE = 0 });

                dataSetCols.map(item => {
                    dataSet.map(it => {
                        if (!["CODIGO", "DESCRICAO", "COR", "DESC_COR", "QTDE_TOTAL", "VALOR", "PRECO_TAB", "EMPRESA"].includes(item.title)) {
                            item.QTDE += it[item.data];
                        };
                    });
                });

                dataSetCols.sort(function (a, b) {
                    if (a.QTDE < b.QTDE) {
                        return 1;
                    } else if (a.QTDE > b.QTDE) {
                        return -1;
                    } else {
                        return 0;
                    }
                });

                let arrDadosGrafico = [];
                dataSetCols.map((item, index) => {
                    if ((arrDadosGrafico.length < 30) && (!["CODIGO", "DESCRICAO", "COR", "DESC_COR", "QTDE_TOTAL", "VALOR", "PRECO_TAB", "EMPRESA"].includes(item.title))) {
                        arrDadosGrafico.push({
                            x: item.title,
                            y: item.QTDE
                        });
                    }
                });

                options.series[0].data = arrDadosGrafico;
                const chart = new ApexCharts(document.querySelector("#chart"), options);
                chart.render();

            } catch (error) {
                console.error(error);
                msgAlerta('Erro ao buscar os dados para análise, tente novamente.');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaDados').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relDesempenhoTamanho ?? [])
    })
});