$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'gravar')) {
          $('.driver-next-btn').on('click', location.reload());
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'formcard1') {
          $('.driver-close-btn').on('click', location.reload());
        };
      }
    });

    driver.defineSteps([{
      element: '#divCashback',
      popover: {
        title: 'Lista de Cashback',
        description: 'Aqui estão os registros de cashback gerados/utilizados pelos clientes.',
        position: 'top'
      }
    },
    {
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui, você tem a opção de filtrar as informações que deseja analisar.',
        position: 'bottom'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Imprimir',
        description: 'Imprime os dados filtrados.',
        position: 'bottom'
      }
    },
    {
      element: '#boxDashboard',
      popover: {
        title: 'Totalizadores',
        description: 'Aqui você tem um total resumido dos dados apresentados abaixo',
        position: 'top'
      }
    },
    {
      element: '#txtQuantidade',
      popover: {
        title: 'Quantidade',
        description: 'Adicionamos neste campo a quantidade da unidade.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a Unidade.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

let tabelaContas = []
let tabelaAnalise = []
let tabelaDetalha = []
let tabelaResumo = []
let sCampo = ''
let sPeriodo = '';

const tabelaPadrao = {
  "sEmptyTable": "Nenhum registro encontrado",
  "sInfo": "_TOTAL_ registros",
  "sInfoEmpty": " 0 registros",
  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
  "sInfoPostFix": "",
  "sInfoThousands": ".",
  "sLengthMenu": "_MENU_ resultados",
  "sLoadingRecords": "Carregando...",
  "sProcessing": "Processando...",
  "sZeroRecords": "Nenhum registro encontrado",
  "sSearch": "Pesquisar",
  "oPaginate": {
    "sNext": "Próximo",
    "sPrevious": "Anterior",
    "sFirst": "Primeiro",
    "sLast": "Último"
  },
  "oAria": {
    "sSortAscending": ": Ordenar colunas de forma ascendente",
    "sSortDescending": ": Ordenar colunas de forma descendente"
  }
}

function retornaEmpresas() {
  const listaEmpresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray() : [];
  const listaEmpPaths = listaEmpresas.map(input => {
    const labelText = $(`label[for="${input.id}"]`).text();
    const empresa = `_${labelText.substring(0, labelText.indexOf('-') - 1)}`;
    return empresa;
  });
  return listaEmpPaths.map(emp => `${emp}`).toString();
}

async function retornaFiltros() {
  const dataDe = $('#dtPeriodoDe').val();
  const dataAte = $('#dtPeriodoAte').val();
  const dataPeriodoDe = $('#dtPeriodoComissaoDe').val();
  const dataPeriodoAte = $('#dtPeriodoComissaoAte').val();
  const situacao = await formataListas($('#txtSituacao').val().toString());
  const classe = await formataListas($('#txtClasse').val().toString());
  const statusDesc = await formataListas($('#txtStatus').val().toString());
  const banco = await formataListas($('#txtBanco').val().toString());
  const tipoVenda = await formataListas($('#txtTipoVenda').val().toString());
  const moeda = await formataListas($('#txtMoeda').val().toString());

  const receber = $('#cbReceber').is(':checked') ? 'S' : 'N';
  const pagar = $('#cbPagar').is(':checked') ? 'S' : 'N';
  const chequesReceber = $('#cbChequesReceber').is(':checked') ? 'S' : 'N';
  const chequesPagar = $('#cbChequesPagar').is(':checked') ? 'S' : 'N';
  const comissoes = $('#cbComissao').is(':checked') ? 'S' : 'N';
  const compras = $('#cbCompras').is(':checked') ? 'S' : 'N';
  const vendas = $('#cbVendas').is(':checked') ? 'S' : 'N';

  const provisaoReceber = $('#cbProvisaoReceber').is(':checked') ? 'S' : 'N';
  const provisaoPagar = $('#cbProvisaoPagar').is(':checked') ? 'S' : 'N';

  const analise = isChecked('#rdMensal') ? 0 : isChecked('#rdPeriodo') ? 1 : isChecked('#rdDiaria') ? 2 : null;
  const pedLiberado = isChecked('#rdTodosPed') ? 0 : isChecked('#tdComercial') ? 1 : isChecked('#rdFinanceiro') ? 2 : isChecked('#rdAmbos') ? 3 : null;
  const statusAP = isChecked('#rdTodasAP') ? 0 : isChecked('#rdBloqueada') ? 1 : isChecked('#rdAnalise') ? 2 : isChecked('#rdLiberada') ? 3 : null;

  const empresas = retornaEmpresas();
  const todasEmpresas = $('#cbTodasAsEmpresas').is(':checked') ? 'S' : 'N';

  filtros =
    `DATA_DE=${dataDe}` +
    `&DATA_ATE=${dataAte}` +
    `&DATA_PERIODO_DE=${dataPeriodoDe}` +
    `&DATA_PERIODO_ATE=${dataPeriodoAte}` +
    `&SITUACAO=${situacao}` +
    `&CLASSE=${classe}` +
    `&STATUS_DESC=${statusDesc}` +
    `&BANCO=${banco}` +
    `&TIPO_VENDA=${tipoVenda}` +
    `&MOEDA=${moeda}` +

    `&RECEBER=${receber}` +
    `&PAGAR=${pagar}` +
    `&CHEQUES_RECEBER=${chequesReceber}` +
    `&CHEQUES_PAGAR=${chequesPagar}` +
    `&COMISSOES=${comissoes}` +
    `&COMPRAS=${compras}` +
    `&VENDAS=${vendas}` +

    `&PROVISAO_RECEBER=${provisaoReceber}` +
    `&PROVISAO_PAGAR=${provisaoPagar}` +

    `&ANALISE=${analise}` +
    `&PED_LIBERADO=${pedLiberado}` +
    `&STATUS_AP=${statusAP}` +

    `&EMPRESAS=${empresas}` +
    `&TODAS_EMPRESAS=${todasEmpresas}`;
  return filtros;
}

$(document).ready(async function () {
  componenteFiltro('situacao', true);
  componenteFiltro('classe', true);
  componenteFiltro('banco', true);
  componenteFiltro('status', true);
  componenteFiltro('tipoVenda', true);
  componenteFiltro('moeda', true);
  limparFiltros();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  async function buscaDataAtual(adiciona30 = false) {
    $('#dtPeriodoDe').val(formataData(new Date()));

    if (adiciona30) {
      const dataAtual = new Date();
      const dataComMais30dias = formataData(new Date(dataAtual.getFullYear(), dataAtual.getMonth(), dataAtual.getDate() + 30));

      $('#dtPeriodoAte').val(dataComMais30dias);
      $('#dtPeriodoComissaoAte').val(dataComMais30dias);
    }
  }

  buscaDataAtual(true);

  $('#btnLimparFiltros').on('click', function () {
    limpaFiltros();
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/imprimerelanalisefluxo?';
        const filtros = await retornaFiltros();

        let arquivo = await GeraRelatorio(`${url + filtros}&`, 'POST', 100000, false, 'RelAnalisefluxo');
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    const url = '/sisplan/relanalisefluxo/v1/buscaanalisefluxo?';
    const filtros = await retornaFiltros();

    $.LoadingOverlay('show');
    try {
      try {
        const response = await requisicao('GET', url, filtros, null, 150000);
        if (!response) {
          return;
        }
        const jsonStr = await response.json();
        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          return;
        }
        if (response.status != 200) {
          console.error(jsonStr.mensagem);
        }
        const dataSet = jsonStr;
        const colunas = retornaColunas()

        tabelaContas = dataSet.Saldo
        tabelaAnalise = dataSet.Analise
        tabelaDetalha = dataSet.Detalha
        // tabelaResumo = dataSet.resumo

        $('#tabelaContas').DataTable({
          paging: true,
          filter: false,
          sort: true,
          info: true,
          destroy: true,
          "language": tabelaPadrao,
          data: tabelaContas,
          columns: colunas.dataSetColsContas,
          columnDefs: [{
            targets: [3, 4, 5],
            render: function (data, type, row) {
              return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2 });
            }
          }],
        });

        $('#tabelaDetalha').DataTable({
          autoWidth: true,
          paging: true,
          filter: false,
          sort: true,
          info: true,
          destroy: true,
          "language": tabelaPadrao,
          data: tabelaDetalha,
          columns: colunas.dataSetColsDetalha,
          columnDefs: [{
            targets: [4, 5, 6, 29, 52],
            render: function (data, type, row) {
              if (type === 'display' || type === 'filter') {
                var date = new Date(data);
                var dia = date.getDate();
                var mes = date.getMonth() + 1;
                var ano = date.getFullYear();
                if (dia < 10) {
                  dia = '0' + dia;
                }
                if (mes < 10) {
                  mes = '0' + mes;
                }
                return dia + '/' + mes + '/' + ano;
              } else {
                return data;
              }
            },
          }],
        });

        $('#tabelaAnalise').DataTable({
          order: false,
          paging: true,
          filter: false,
          sort: true,
          info: true,
          pageLength: 20,
          destroy: true,
          "language": tabelaPadrao,
          data: tabelaAnalise,
          columns: colunas.dataSetColsAnalise,
          columnDefs: [{
            targets: [2, 3, 4, 5, 6, 7, 8, 9],
            render: function (data, type, row) {
              return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2 });
            }
          }],
          rowCallback: async function (row, data) {
            const isPrimeiraLinha = data.periodo === 'Saldo Inicial.';
            $(row).find('td').each(function (index, cell) {
              const coluna = colunas.dataSetColsAnalise[index];
              const valorColuna = data[coluna.data];

              if (isPrimeiraLinha && coluna.data !== 'periodo' && coluna.data !== 'saldo') {
                $(cell).html(null);
              } else if (coluna.data == 'periodo') {
                $(cell).css('background-color', 'rgba(168, 168, 168, 0.5)');
                $(cell).css('font-weight', 'bold');
              }
              if (coluna.data == 'inadimplencia') {
                if (valorColuna <= 0) {
                  $(cell).html(null)
                }
              }
              if (coluna.data == 'saldo') {
                if (valorColuna > 0) {
                  $(cell).css('color', '#75BE25');
                  $(cell).css('font-weight', 'bold');
                } else {
                  $(cell).css('color', 'red');
                  $(cell).css('font-weight', 'bold');
                }
              } else if (data.codPer == '00') {
                $(cell).css('background-color', 'rgba(168, 168, 168, 0.6)');
              }
              else if (data.codPer == '00') {
                $(cell).css('background-color', 'rgba(168, 168, 168, 0.6)');
              } else if (data.codPer == '01') {
                $(cell).css('color', 'red');
                $(cell).css('font-weight', 'bold');
              } else if (coluna.data == 'valorRec'
                || coluna.data == 'chequeRec'
                || coluna.data == 'valorVenda') {
                $(cell).css('color', '#75BE25');
                $(cell).css('font-weight', 'bold');
              } else if (coluna.data == 'valorPago'
                || coluna.data == 'chequePag'
                || coluna.data == 'valorCom'
                || coluna.data == 'valorCompra') {
                ;
                $(cell).css('color', 'red');
                $(cell).css('font-weight', 'bold');
              }
            });
          },

          initComplete: function () {
            const saldoInicialRow = dataSet.Analise.find(row => row.periodo === 'Saldo Inicial.');
            const filteredData = dataSet.Analise.filter(row => row.periodo !== 'Saldo Inicial.');
            const sortedData = filteredData.sort((a, b) => {
              const codPerA = a.codPer.toString();
              const codPerB = b.codPer.toString();
              return codPerA.localeCompare(codPerB);
            });
            sortedData.unshift(saldoInicialRow);
            this.api().clear().rows.add(sortedData).draw();
          },
        });

        $('#modal-filtros').modal('hide');

      } catch (error) {
        console.error(error);
        msgAlerta('Erro ao buscar os dados para análise, tente novamente.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaAnalise').on('dblclick', 'tr', function (e) {
    const celula = $(this).find('td').index(e.target)
    const linha = $('#tabelaAnalise').DataTable().row($(this)).data()
    const colunas = $('#tabelaAnalise').DataTable().settings().init().columns
    const nomeColuna = colunas[celula].data

    $('#tabAnalise').removeClass('active')
    $('#divAnalise').removeClass('active show')
    $('#divDetalha').addClass('active show')
    $('#tabDetalha').addClass('active')

    sCampo = nomeColuna
    sPeriodo = linha.codPer

    setTimeout(function () {
      carregaTabelaDetalhaFiltrada(nomeColuna, linha.codPer)
    }, 200);

    $('#tabResumo').removeClass('disabled')
  })

  function carregaTabelaDetalhaFiltrada(colunaFiltro, periodoFiltro) {
    $.LoadingOverlay('show');
    try {
      if ($.fn.DataTable.isDataTable('#tabelaDetalha')) {
        $("#tabelaDetalha").DataTable().destroy();
        $("#tabelaDetalha").empty();
      }
      const dados = tabelaDetalha.filter((row) => row[colunaFiltro] > 0 && row.codPer == periodoFiltro)

      const colunas = retornaColunas()
      $('#tabelaDetalha').DataTable({
        autoWidth: true,
        paging: true,
        filter: false,
        sort: true,
        info: true,
        destroy: true,
        "language": tabelaPadrao,
        data: dados,
        columns: colunas.dataSetColsDetalha,
        columnDefs: [{
          targets: [4, 5, 6, 29, 52],
          render: function (data, type, row) {
            if (type === 'display' || type === 'filter') {
              var date = new Date(data);
              var dia = date.getDate();
              var mes = date.getMonth() + 1;
              var ano = date.getFullYear();
              if (dia < 10) {
                dia = '0' + dia;
              }
              if (mes < 10) {
                mes = '0' + mes;
              }
              return dia + '/' + mes + '/' + ano;
            } else {
              return data;
            }
          },
        }],
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#tabResumo').on('click', function () {
    geraResumo(sCampo, sPeriodo)
  })

  $('input[name="rgResumo"]').on('change', function () {
    geraResumo(sCampo, sPeriodo)
  })

  $('input[name="rgBusca"]').on('change', function () {
    geraResumo(sCampo, sPeriodo)
  })

  function retornaParams(sCampo, sPeriodo) {
    const resumo = $('input[name="rgResumo"]:checked').val()
    const busca = $('input[name="rgBusca"]:checked').val()
    return `&BUSCA=${busca}&RESUMO=${resumo}&NOME_CAMPO=${sCampo}&PERIODO=${sPeriodo}&DATA_DE=${$('#dtPeriodoDe').val()}&`
  }

  async function geraResumo() {
    const params = retornaParams(sCampo, sPeriodo)
    const body = {
      detalha: tabelaDetalha,
      analise: tabelaAnalise,
      resumo: tabelaResumo
    }
    const response = await requisicao('POST', '/sisplan/relanalisefluxo/v1/geraresumofluxo?', JSON.stringify(params), JSON.stringify(body), 150000);

    if (response.status != 200) {
      throw msgAlerta('Não foi possível buscar os dados de resumo')
    }

    const jsonStr = await response.json()
    carregaTabelaResumo(jsonStr.resumo)
  }

  function carregaTabelaResumo(dados) {
    $.LoadingOverlay('show');
    try {
      if ($.fn.DataTable.isDataTable('#tabelaResumo')) {
        $("#tabelaResumo").DataTable().destroy();
        $("#tabelaResumo").empty();
      }

      const colunas = retornaColunas()
      $('#tabelaResumo').DataTable({
        autoWidth: true,
        paging: true,
        "language": tabelaPadrao,
        data: dados,
        columns: colunas.dataSetColsResumo,
        columnDefs: [{
          targets: [2, 3, 4],
          render: function (data, type, row) {
            return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2 });
          }
        },
        {
          targets: [5],
          render: function (data, type, row) {
            if (type === 'display' || type === 'filter') {
              var date = new Date(data);
              var dia = date.getDate();
              var mes = date.getMonth() + 1;
              var ano = date.getFullYear();
              if (dia < 10) {
                dia = '0' + dia;
              }
              if (mes < 10) {
                mes = '0' + mes;
              }
              return dia + '/' + mes + '/' + ano;
            } else {
              return data;
            }
          },
        }],
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function limpaFiltros() {
    $('#txtSituacao').empty().trigger('change');
    $('#txtClasse').empty().trigger('change');
    $('#txtStatus').empty().trigger('change');
    $('#txtBanco').empty().trigger('change');
    $('#txtTipoVenda').empty().trigger('change');
    $('#txtMoeda').empty().trigger('change');
    $('#dtPeriodoComissaoDe').val('1200-01-01')
    buscaDataAtual(true)
  }

  $('input[name="rgAgrupa"]').on('change', function () {
    geraAgrupamento(sCampo)
  })

  $('#tabAgrupamento').on('click', function () {
    geraAgrupamento(sCampo)
  })

  async function geraAgrupamento(sCampo) {
    $.LoadingOverlay('show')
    try {
      const body = {
        detalha: tabelaDetalha
      }
      const response = await requisicao('POST', '/sisplan/relanalisefluxo/v1/geraagrupamentofluxo?', JSON.stringify(`&NOME_CAMPO=${sCampo}&AGRUPA=${$('input[name="rgAgrupa"]:checked').val()}&`), JSON.stringify(body), 150000);

      if (response.status != 200) {
        throw msgAlerta('Não foi possível buscar os dados de agrupamento')
      }

      const jsonStr = await response.json()
      carregaTabelaAgrupamento(jsonStr.agrupamento)
    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function carregaTabelaAgrupamento(dados) {
    $.LoadingOverlay('show');
    try {
      if ($.fn.DataTable.isDataTable('#tabelaAgrupamento')) {
        $("#tabelaAgrupamento").DataTable().destroy();
        $("#tabelaAgrupamento").empty();
      }

      const colunas = retornaColunas()

      let dadosFiltrados = dados.filter(function (item) {
        return item.valor !== 0;
      });

      $('#tabelaAgrupamento').DataTable({
        autoWidth: true,
        paging: true,
        "language": tabelaPadrao,
        data: dadosFiltrados,
        columns: colunas.dataSetColsAgrupamento,
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  }






















  function retornaColunas() {
    const columnsDetalha = [{
      title: 'Empresa',
      data: 'emp',
    },
    {
      title: 'Tipo',
      data: 'tipo',
    },
    {
      title: 'Número',
      data: 'numero',
    },
    {
      title: 'Documento',
      data: 'docto',
    },
    {
      title: 'Data de Retorno',
      data: 'retorno',
    },
    {
      title: 'Data de Emissão',
      data: 'emissao',
    },
    {
      title: 'Data de Vencimento',
      data: 'vencimento',
    },
    {
      title: 'Cliente',
      data: 'cliente',
    },
    {
      title: 'Nome do Cliente',
      data: 'nome',
    },
    {
      title: 'Código da Situação',
      data: 'codSituacao',
    },
    {
      title: 'Situação',
      data: 'situacao',
    },
    {
      title: 'Valor Pago',
      data: 'valorPago',
    },
    {
      title: 'Valor Recebido',
      data: 'valorRecebido',
    },
    {
      title: 'Cheque Recebido',
      data: 'chequeRecebido',
    },
    {
      title: 'Cheque Pago',
      data: 'chequePago',
    },
    {
      title: 'Valor Compra',
      data: 'valorCompra',
    },
    {
      title: 'Valor Venda',
      data: 'valorVenda',
    },
    {
      title: 'Cod. Per',
      data: 'codPer',
    },
    {
      title: 'Pend. Rec',
      data: 'pendRec',
    },
    {
      title: 'Pend. Pag',
      data: 'pendPag',
    },
    {
      title: 'Observacao',
      data: 'observacao',
    },
    {
      title: 'Conta',
      data: 'conta',
    },
    {
      title: 'Descrição da Conta',
      data: 'descConta',
    },
    {
      title: 'Prev. Pag',
      data: 'prevPag',
    },
    {
      title: 'Banco',
      data: 'banco',
    },
    {
      title: 'Nome do Banco',
      data: 'nomeBanco',
    },
    {
      title: 'Valor Comissão',
      data: 'valorCom',
    },
    {
      title: 'Ped Cli',
      data: 'pedCli',
    },
    {
      title: 'Art Cli',
      data: 'artCli',
    },
    {
      title: 'Data de Entrega',
      data: 'dataEntrega',
    },
    {
      title: 'Percentual de Comissão',
      data: 'percCom',
    },
    {
      title: 'Valor Duplicata',
      data: 'valorDup',
    },
    {
      title: 'Código de Representante',
      data: 'codRep',
    },
    {
      title: 'Nome Representante',
      data: 'nomeRep',
    },
    {
      title: 'Condição',
      data: 'condicao',
    },
    {
      title: 'Classe',
      data: 'classe',
    },
    {
      title: 'Descrição da Classe',
      data: 'descClasse',
    },
    {
      title: 'Código do Banco',
      data: 'codigoBanco',
    },
    {
      title: 'Banco Rec',
      data: 'bancoRec',
    },
    {
      title: 'Prev Rec',
      data: 'prevRec',
    },
    {
      title: 'Prev Terc',
      data: 'prevTerc',
    },
    {
      title: 'Tipo Com',
      data: 'tipoCom',
    },
    {
      title: 'Tipo Entidade',
      data: 'tipoEntidade',
    },
    {
      title: 'LanÇamento',
      data: 'lancamento',
    },
    {
      title: 'Valor Moeda',
      data: 'valorMoeda',
    },
    {
      title: 'Fantasia',
      data: 'fantasia',
    },
    {
      title: 'Taxa da Moeda',
      data: 'taxaMoeda',
    },
    {
      title: 'Moeda',
      data: 'moeda',
    },
    {
      title: 'Abrev',
      data: 'abrev',
    },
    {
      title: 'Desp Antecipa',
      data: 'despAntecipa',
    },
    {
      title: 'Valor_Os_P',
      data: 'valorOsP',
    },
    {
      title: 'Valor_Os_B',
      data: 'valorOsB',
    },
    {
      title: 'Vencimento Original',
      data: 'venctoOrig',
    },
    {
      title: 'Historico',
      data: 'historico',
    },
    {
      title: 'Descrição Histórico',
      data: 'descHist',
    },
    {
      title: 'Prev Tecel',
      data: 'prevTecel',
    },
    {
      title: 'Valor Antec Pag',
      data: 'valorAntecPag',
    },
    {
      title: 'Prev Tint',
      data: 'prevTint',
    }];

    const columnsContas = [
      {
        title: 'Conta',
        data: 'conta',
      },
      {
        title: 'Descrição',
        data: 'descricao',
      },
      {
        title: 'Titular',
        data: 'titular',
      },
      {
        title: 'Saldo',
        data: 'saldo',
      },
      {
        title: 'Saldo Atual',
        data: 'saldoAtual',
      },
      {
        title: 'Saldo Mês Anterior',
        data: 'saldoMesAnt',
      }];

    const columnsAnalise = [
      {
        title: 'Período',
        data: 'periodo',
      },
      {
        title: 'Inadimplência',
        data: 'inadimplencia',
      },
      {
        title: 'Valor Receber',
        data: 'valorRec',
      },
      {
        title: 'Cheque Rec',
        data: 'chequeRec',
      },
      {
        title: 'Valor Venda',
        data: 'valorVenda',
      },
      {
        title: 'Valor Pagar',
        data: 'valorPago',
      },
      {
        title: 'Cheque Pag',
        data: 'chequePag',
      },
      {
        title: 'Valor Com',
        data: 'valorCom',
      },
      {
        title: 'Valor Compra',
        data: 'valorCompra',
      },
      {
        title: 'Saldo',
        data: 'saldo',
      },
    ];

    const columnsResumo = [{
      title: 'Código',
      data: 'codigo',
    },
    {
      title: 'Descrição',
      data: 'descricao',
    },
    {
      title: 'Valor',
      data: 'valor',
    },
    {
      title: 'Valor Recebido',
      data: 'valorRecebido',
    },
    {
      title: 'Saldo',
      data: 'saldo',
    },
    {
      title: 'Data',
      data: 'data',
    },
    {
      title: 'Docto',
      data: 'docto',
    },
    {
      title: 'Observação',
      data: 'observacao',
    },
    {
      title: 'Estrutura',
      data: 'estrutura',
    },
    {
      title: 'Lançamento',
      data: 'lancamento',
    }
    ];

    const columnsAgrupamento = [{
      title: 'Código',
      data: 'codigo',
    },
    {
      title: 'Descrição',
      data: 'descricao',
    },
    {
      title: 'Valor',
      data: 'valor',
    }];

    const dataSetColsDetalha = [];

    columnsDetalha.forEach((column) => {
      dataSetColsDetalha.push({
        title: column.title,
        data: column.data,
      });
    });

    const dataSetColsContas = [];

    columnsContas.forEach((column) => {
      dataSetColsContas.push({
        title: column.title,
        data: column.data,
      });
    });

    const dataSetColsAnalise = [];

    columnsAnalise.forEach((column) => {
      dataSetColsAnalise.push({
        title: column.title,
        data: column.data,
      });
    });

    const dataSetColsResumo = [];

    columnsResumo.forEach((column) => {
      dataSetColsResumo.push({
        title: column.title,
        data: column.data,
      });
    });

    const dataSetColsAgrupamento = [];

    columnsAgrupamento.forEach((column) => {
      dataSetColsAgrupamento.push({
        title: column.title,
        data: column.data,
      });
    });

    return { dataSetColsContas, dataSetColsDetalha, dataSetColsAnalise, dataSetColsResumo, dataSetColsAgrupamento }
  }
});