$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#geral',
      popover: {
        title: 'Cadastro Geral',
        description: 'Clique aqui para abrir a aba de cadastro Geral.',
        position: 'top'
      }
    },
    {
      element: '#DadosGerais',
      popover: {
        title: 'Dados de Cadastro Geral',
        description: 'Esses são os campos que você informará os dados gerais de cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtTabelaPreco',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#dataIni',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#dataFim',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#divProduto',
      popover: {
        title: 'Incluir Produto',
        description: 'Aqui você pode incluir um produto.',
        position: 'top'
      }
    },
    {
      element: '#tipos',
      popover: {
        title: 'Tipo',
        description: 'Aqui você seleciona o tipo de regra.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Ao clicar nesse botão você grava os dados inseridos.',
        position: 'left'
      }
    }
    ]);

    driver.start();
  });
});


$(document).ready(async function () {
  const parametrosSistema = await BuscaParametrosSistema('S');
  const quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
  const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
  const utilizaTabCorTam = (await CopiaParametro('VENDA', 5) == 1);
  var parametrosVenda = await BuscaParametrosVenda();
  let listaProdutosFiltrados = [];
  let novosCodigos = [];
  validaParametroRegra();

  $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
  $('#btnTabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela de Preço', 'regiao');
  $('#btnATabelaPreco').on('click', function () {
    $('#txtTabelaPreco').val('');
    $('#txtTabelaPreco').trigger('blur');
  });

  $('#txtColecao').pesquisa_variosServerside(1, '{ "tabela":"colecao", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btnColecao').pesquisa_serversideSel('#txtColecao', `{ "tabela":"colecao", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Coleção');
  $('#btnAColecao').on('click', function () {
    $('#txtColecao').empty().trigger('change');
  });

  $('#txtSubColecao').pesquisa_variosServerside(1, '{ "tabela":"cadtag", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btnSubColecao').pesquisa_serversideSel('#txtSubColecao', `{ "tabela":"cadtag", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Sub-Coleção');
  $('#btnASubColecao').on('click', function () {
    $('#txtSubColecao').empty().trigger('change');
  });

  $('#txtMarca').pesquisa_variosServerside(1, '{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btnMarca').pesquisa_serversideSel('#txtMarca', `{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Marca');
  $('#btnAMarca').on('click', function () {
    $('#txtMarca').empty().trigger('change');
  });

  $('#txtEtiqueta').pesquisa_variosServerside(1, '{ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btnEtiqueta').pesquisa_serversideSel('#txtEtiqueta', `{ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Etiqueta');
  $('#btnAEtiqueta').on('click', function () {
    $('#txtEtiqueta').empty().trigger('change');
  });

  $('#txtGrupo').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#btnGrupo').pesquisa_serversideSel('#txtGrupo', `{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Grupo');
  $('#btnAGrupo').on('click', function () {
    $('#txtGrupo').empty().trigger('change');
  });

  if (utilizaTabCorTam) {
    $('#txtProduto').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["1=2"]}', 'CODIGO', 'DESCRICAO');
    const pesquisaServerSideSel = {
      tabela: "PRODUTO",
      camposSelect: ["PRODUTO.CODIGO CODIGO", "PRODUTO.DESCRICAO DESCRICAO", "PRECO_COR_TAM.COR COR", "PRECO_COR_TAM.TAM TAM", "PRECO_COR_TAM.PRECO PRECO"],
      camposSelectSubSelect: ["CODIGO", "DESCRICAO", "COR", "TAM", "PRECO"],
      innerJoin: [
        { tabela: "PRECO_COR_TAM", condicao: "PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO" },
      ],
      groupBy: ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM", "PRECO_COR_TAM.PRECO"],
      groupBySubSelect: ["CODIGO", "DESCRICAO", "COR", "TAM", "PRECO"],
      camposWhereServerSide: ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM", "PRECO_COR_TAM.PRECO"]
    };
    $('#btnProduto').pesquisa_serversideSel('#txtProduto', `${JSON.stringify(pesquisaServerSideSel)}`, 'Pesquisa de Produto', undefined);
    $('#btnAProduto').on('click', function () {
      $('#txtProduto').empty().trigger('change');
    });
  } else {
    $('#txtProduto').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#btnProduto').pesquisa_serversideSel('#txtProduto', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO", "MARCA", "GRUPO", "ETIQUETA"], "where": null}`, 'Pesquisa de Produto');
    $('#btnAProduto').on('click', function () {
      $('#txtProduto').empty().trigger('change');
    });
  }

  $('.select2-selection__rendered').css('max-width', $($('#txtProduto', 'txtColecao', 'txtSubColecao', 'txtMarca', 'txtEtiqueta', 'txtGrupo').parent().children()[1]).css('width'));

  $('#tabela-promo').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollY: '205px',
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  $('#tabela-empAcesso').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollY: '180px',
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  if (utilizaTabCorTam) {
    $('#tabela-produtos').DataTable({
      paging: false,
      filter: true,
      info: false,
      order: true,
      destroy: true,
      scrollY: '205px',
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "columns": [
        {
          'title': 'CODIGO',
          'data': 'CODIGO'
        },
        {
          'title': 'DESC_PRODUTO',
          'data': 'DESC_PRODUTO'
        },
        {
          'title': 'OPERACAO',
          'data': 'OPERACAO'
        },
        {
          'title': 'COR',
          'data': 'COR'
        },
        {
          'title': 'TAM',
          'data': 'TAM'
        },
        {
          'title': 'PRECO',
          'data': 'PRECO'
        },
        {
          'title': 'VALOR',
          'data': 'VALOR'
        },
        {
          'title': 'EXCLUIR',
          'data': 'EXCLUIR'
        }
      ]
    });
  } else {
    $('#tabela-produtos').DataTable({
      paging: false,
      filter: true,
      info: false,
      order: true,
      destroy: true,
      scrollY: '205px',
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
      "columns": [
        {
          'title': 'CODIGO',
          'data': 'CODIGO'
        },
        {
          'title': 'DESC_PRODUTO',
          'data': 'DESC_PRODUTO'
        },
        {
          'title': 'OPERACAO',
          'data': 'OPERACAO'
        },
        {
          'title': 'PRECO_00',
          'data': 'PRECO_00'
        },
        {
          'title': 'VALOR',
          'data': 'VALOR'
        },
        {
          'title': 'EXCLUIR',
          'data': 'EXCLUIR'
        }
      ]
    });
  }

  $("#txtPrecoProduto").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtValorAdd").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtValorPromo").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtDescontoPromo").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  await preencheEmpresas();

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let regra = parametros[parametros.length - 1];

  $('#tabela-empAcesso').on('click', 'td', function () {
    selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
  });

  $('#btnVoltar').on('click', async function () {
    window.location.href = `${BASE_URI}/regrapromocao`;
  });

  $("#checkDescPromo, #checkValorPromo").on("change", function () {
    $("#txtValorAdd").val("");
    $("#txtValorAdd").maskMoney('destroy');
      $("#txtValorAdd").maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
      });
  })

  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtDescricao: { required: true, },
      txtTabelaPreco: { required: true, },
      dataIni: { required: true, },
      dataFim: { required: true, },
    },
    messages: {
      txtDescricao: { required: 'Descrição inválida.', },
      txtTabelaPreco: { required: 'Tabela de preço inválida.', },
      dataIni: { required: 'Data inicial inválida.', },
      dataFim: { required: 'Data final inválida.', },
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    },

    // Gravar
    async submitHandler(form, event) {
      event.preventDefault();
      try {
        $.LoadingOverlay("show");
        if ($('#tabela-produtos').DataTable().rows().count() == 0) {
          msgAlerta('Favor incluir ao menos um produto a regra.');
          return;
        };
        if ($('#tabela-promo').DataTable().rows().count() == 0) {
          msgAlerta('Favor incluir ao menos uma promoção a regra.');
          return;
        };

        const codigo = regra == 'create' ? await RetornaProximo('REGRA_PROMOCAO', 'REGRA_PROMOCAO', 'REGRA', 4) : regra;

        let empresas = [];
        for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
          let dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
          empresas.push(dados[1].split(' - ')[0]);
        };

        if (empresas == '' || empresas == null) {
          msgAlerta('Selecione ao menos uma empresa.');
          return
        }

        let arrRegras = [];
        for (let i = 0; i < $('#tabela-promo').DataTable().rows().count(); i++) {
          arrRegras.push({
            VALOR: $('#tabela-promo').DataTable().rows(i).data()[0][1],
            DESCONTO: $('#tabela-promo').DataTable().rows(i).data()[0][2],
            CAMPO: '',
            CHAVE: '',
            OPERACAO: $('#tabela-promo').DataTable().rows(i).data()[0][3]
          });
        };

        let arrProdutos = [];
        for (let i = 0; i < $('#tabela-produtos').DataTable().rows().count(); i++) {
          if (utilizaTabCorTam) {
            arrProdutos.push({
              CODIGO: $('#tabela-produtos').DataTable().rows(i).data()[0].CODIGO,
              TIPO: 'P',
              OPERACAO: $('#tabela-produtos').DataTable().rows(i).data()[0].OPERACAO,
              COR: $('#tabela-produtos').DataTable().rows(i).data()[0].COR,
              TAM: $('#tabela-produtos').DataTable().rows(i).data()[0].TAM,
              VALOR: Number($('#tabela-produtos').DataTable().rows(i).data()[0].VALOR)
            });
          } else {
            arrProdutos.push({
              CODIGO: $('#tabela-produtos').DataTable().rows(i).data()[0].CODIGO,
              TIPO: 'P',
              OPERACAO: $('#tabela-produtos').DataTable().rows(i).data()[0].OPERACAO,
              VALOR: Number($('#tabela-produtos').DataTable().rows(i).data()[0].VALOR)
            });
          }
        };

        const objRegra = {
          CODREGRA: Number(codigo),
          DESC_REGRA: $('#txtDescricao').val(),
          REGIAO: pegaChave('#txtTabelaPreco'),
          DT_INICIAL: `${$("#dataIni").val()}T00:00:00Z`,
          DT_FINAL: `${$("#dataFim").val()}T00:00:00Z`,
          TIPO: $('#checkValorTabela').prop('checked') ? 'V' : 'Q',
          MODELO: utilizaTabCorTam ? 3 : 1,
          EMPRESA: empresas,
          REGRA: arrRegras,
          ITENS: arrProdutos,
          CODIGOS_NOVOS: novosCodigos
        };

        try {
          if (novosCodigos.length > 0) {
            const validacaoItens = await validacaoItensRegraPromocao(objRegra);
            
            if (validacaoItens.indexOf("REGRA:") != -1) {
              await mensagemValidacaoItensRegraPromocao(validacaoItens);
            }
          }

          const response = await requisicao('POST', '/sisplan/cadastros/v1/regrapromocao?', '', `JSON=${JSON.stringify(objRegra)}`, 240000);

          if (!response) {
            return;
          };

          if (response.status != 200) {
            const jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return;
          };

          $.LoadingOverlay("hide");
          toastr.success(
            `Cadastro efetuado com sucesso! Regra: ${codigo}`,
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/regrapromocao`;
            }
          }
          ).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px"
          });
        } catch (error) {
          msgErro(`Não foi possível gravar os dados da regra`);
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });

  $('#txtTabelaPreco').on('blur', async function () {
    $('#btnAProduto').trigger('click');
    if ($(this).val() != '') {
      if (utilizaTabCorTam) {
        const pesquisaServerSideSelAlterada = {
          tabela: "PRODUTO",
          camposSelect: ["PRODUTO.CODIGO CODIGO", "PRODUTO.DESCRICAO DESCRICAO", "PRECO_COR_TAM.COR COR", "PRECO_COR_TAM.TAM TAM", "PRECO_COR_TAM.PRECO PRECO"],
          camposSelectSubSelect: ["CODIGO", "DESCRICAO", "COR", "TAM", "PRECO"],
          innerJoin: [
            { tabela: "PRECO_COR_TAM", condicao: "PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO" },
          ],
          where: [`PRECO_COR_TAM.REGIAO = '${pegaChave($(this).val())}'`],
          groupBy: ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM", "PRECO_COR_TAM.PRECO"],
          groupBySubSelect: ["CODIGO", "DESCRICAO", "COR", "TAM", "PRECO"],
          camposWhereServerSide: ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM", "PRECO_COR_TAM.PRECO"]
        };
        $('#btnProduto').unbind('click');
        $('#btnProduto').pesquisa_serversideSel('#txtProduto', `${JSON.stringify(pesquisaServerSideSelAlterada)}`, 'Pesquisa de Produto', undefined, [5]);
      } else {
        $('#btnProduto').pesquisa_serversideSel('#txtProduto', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO", "MARCA", "GRUPO", "ETIQUETA"], "where": null}`, 'Pesquisa de Produto');
      }
    } else {
      if (utilizaTabCorTam) {
        $('#txtProduto').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["1=2"]}', 'CODIGO', 'DESCRICAO');
        const pesquisaServerSideSel = {
          tabela: "PRODUTO",
          camposSelect: ["PRODUTO.CODIGO CODIGO", "PRODUTO.DESCRICAO DESCRICAO", "PRECO_COR_TAM.COR COR", "PRECO_COR_TAM.TAM TAM", "PRECO_COR_TAM.PRECO PRECO"],
          camposSelectSubSelect: ["CODIGO", "DESCRICAO", "COR", "TAM", "PRECO"],
          innerJoin: [
            { tabela: "PRECO_COR_TAM", condicao: "PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO" },
          ],
          groupBy: ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM", "PRECO_COR_TAM.PRECO"],
          groupBySubSelect: ["CODIGO", "DESCRICAO", "COR", "TAM", "PRECO"],
          camposWhereServerSide: ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM", "PRECO_COR_TAM.PRECO"]
        };
        $('#btnProduto').pesquisa_serversideSel('#txtProduto', `${JSON.stringify(pesquisaServerSideSel)}`, 'Pesquisa de Produto', undefined, [5]);
        $('#btnAProduto').on('click', function () {
          $('#txtProduto').empty().trigger('change');
        });
      } else {
        $('#txtProduto').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnProduto').pesquisa_serversideSel('#txtProduto', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO", "MARCA", "GRUPO", "ETIQUETA"], "where": null}`, 'Pesquisa de Produto');
        $('#btnAProduto').on('click', function () {
          $('#txtProduto').empty().trigger('change');
        });
      }
    }
  });

  if (utilizaTabCorTam) {
    $('#pesquisaModal').on('shown.bs.modal', function () {
      $('#pesquisaModalTable').on('draw.dt', function () {
        const labelPesquisa = $('#pesquisaModalLabel').html();

        if (labelPesquisa == 'Pesquisa de Produto') {
          const rows = $('.campoSel');

          for (let i = 0; i < rows.length; i++) {
            $(`#${rows[i].id}`).on('click', function () {
              const indiceSelecionado = (this.id).replace('check', '');
              const data = $('#pesquisaModalTable').DataTable().data().toArray();
              const rowSelecionada = data[indiceSelecionado];
              const objetoRow = {
                codigo: rowSelecionada[1],
                cor: rowSelecionada[3],
                tam: rowSelecionada[4],
                valor: rowSelecionada[5]
              };

              const index = listaProdutosFiltrados.findIndex(i => i.codigo === objetoRow.codigo && i.cor === objetoRow.cor && i.tam === objetoRow.tam);

              if (index != -1) {
                listaProdutosFiltrados.splice(index, 1);
              } else {
                listaProdutosFiltrados.push(objetoRow);
              }
            });
          };
        };
      });
    });
  };

  if (regra != '' && regra != 'create') {
    try {
      $.LoadingOverlay('show');
      try {
        let dadosRegra = await buscaDadosRegra(regra);

        if (dadosRegra == null) {
          msgAlerta('Regra não encontrada.');
          setTimeout(() => { window.location.href = `${BASE_URI}/regrapromocao`; }, 3000);
        }

        $('#txtCodigo').val(regra);
        $('#txtDescricao').val(dadosRegra[0].DESC_REGRA);
        $('#dataIni').val(dadosRegra[0].DT_INICIAL ? dadosRegra[0].DT_INICIAL.slice(0, 10) : '');
        $('#dataFim').val(dadosRegra[0].DT_FINAL ? dadosRegra[0].DT_FINAL.slice(0, 10) : '');
        insereValor('#txtTabelaPreco', dadosRegra[0].REGIAO, dadosRegra[0].DESCRICAO);

        let empresasRegra = dadosRegra[0].EMPRESA.split(',');
        empresasRegra.map((empRegra) => {
          $('#tabela-empAcesso').DataTable().rows().data().map((empresa, index) => {
            if (empRegra == empresa[1].split(' - ')[0]) {
              $($('.checkEmpresa')[index]).prop('checked', true);
              $($("table#tabela-empAcesso tr")[index + 1]).addClass("selected");
            }
          });
        });

        if (dadosRegra[0].TIPO == 'Q') {
          $('#checkQuantidade').prop('checked', true);
          alteraCheck();
        };

        dadosRegra.map((regra) => {
          adicionaPromocao(
            regra.SEQ,
            regra.VALOR,
            regra.DESCONTO,
            regra.OPERACAO == "" ? ">=" : regra.OPERACAO
          );
        });

        let dadosProdutos = await buscaProdutosRegra(regra);
        if (dadosProdutos == null) {
          msgAlerta('Regra não possui produtos cadastrados.');
          return;
        }

        let dataSetCols = [];
        let keys = Object.keys(dadosProdutos[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        dataSetCols.push({
          'title': 'EXCLUIR',
          'data': 'EXCLUIR'
        });

        if (utilizaTabCorTam) {
          dataSetCols[7].render = function () {
            return retornaBotaoOpcoes();
          };
        } else {
          dataSetCols[5].render = function () {
            return retornaBotaoOpcoes();
          };
        }

        $('#tabela-produtos').DataTable({
          paging: false,
          filter: true,
          scrollY: '205px',
          info: false,
          order: true,
          destroy: true,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          "data": dadosProdutos,
          "columns": dataSetCols
        });

      } catch (error) {
        console.error(error);
        msgErro('Erro ao retornar os dados da regra.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnCarregar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($('#txtTabelaPreco').val() == '') {
        msgAlerta('Tabela de preço não informada, favor verificar.');
        return;
      }
      $('#tabela-produtos').DataTable().rows().remove().draw(false);
      const considerar = $('#selectConsiderar').val();
      const descricao = $('#txtDescricaoProduto').val();
      const precoAte = $('#txtPrecoProduto').val() != '' ? $('#txtPrecoProduto').val() : '0.00';
      const regiao = pegaChave('#txtTabelaPreco');

      const dados = await retornaProdutos(considerar, descricao, precoAte, regiao);
      if (dados.length == 0) {
        msgAlerta('Nenhum produto encontrado.');
        return;
      }

      let dataSetCols = [];
      let keys = Object.keys(dados[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      dataSetCols.push({
        'title': 'EXCLUIR',
        'data': 'EXCLUIR'
      });

      if (utilizaTabCorTam) {
        dataSetCols[7].render = function () {
          return retornaBotaoOpcoes();
        };
      } else {
        dataSetCols[5].render = function () {
          return retornaBotaoOpcoes();
        };
      }

      $('#tabela-produtos').DataTable({
        paging: false,
        filter: true,
        scrollY: '205px',
        info: false,
        order: true,
        destroy: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "data": dados,
        "columns": dataSetCols
      });

      $('#txtDescricaoProduto').val('');
      $('#txtPrecoProduto').val('0.00');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnIncluirPromo').on('click', async function () {
    adicionaPromocao(
      $('#tabela-promo').DataTable().rows().count() + 1,
      $('#txtValorPromo').val() != '' ? $('#txtValorPromo').val() : '0.00',
      $('#txtDescontoPromo').val() != '' ? $('#txtDescontoPromo').val() : '0.00',
      $("#selectOperacao").val()
    );

    $('#txtValorPromo').val('0.00');
    $('#txtDescontoPromo').val('0.00');
  });

  $('#btnRemover').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      $('#tabela-produtos').DataTable().rows().remove().draw(false);

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnIncluir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($('#txtTabelaPreco').val() == '') {
        msgAlerta('Favor adicionar uma tabela de preço.');
        return;
      }

      if (utilizaTabCorTam) {
        if ((await formataListas($('#txtColecao').val().toString()) == '') && (await formataListas($('#txtMarca').val().toString()) == '') && (await formataListas($('#txtEtiqueta').val().toString()) == '') && (await formataListas($('#txtGrupo').val().toString()) == '') && (await formataListas($('#txtMarca').val().toString()) == '')) {
          const listaProduto = listaProdutosFiltrados;
          await validaPrecoProduto(listaProduto);
          listaProdutosFiltrados = [];

          for (let i = 0; i < listaProduto.length; i++) {
            const dados = $('#tabela-produtos').DataTable().rows().data().toArray();
            const codigo = listaProduto[i].codigo;
            const cor = listaProduto[i].cor;
            const tam = listaProduto[i].tam;
            const indice = dados.findIndex((item) => item.CODIGO == codigo && item.COR == cor && item.TAM == tam);
            if (indice != -1) {
              msgAlerta('Produto já incluso na regra, impossível continuar!');
              return;
            }
          }
          for (let i = 0; i < listaProduto.length; i++) {
            const produto = listaProduto[i];
            const codigoProduto = produto.codigo;
            const corProduto = produto.cor;
            const tamProduto = produto.tam;
            const descricao = await retornaJsonPesquisaPadrao(`{"tabela": "PRODUTO", "camposSelect": ["DESCRICAO"], "where": ["CODIGO = '${codigoProduto}'"]}`);
            const preco = await retornaPrecoProduto(codigoProduto, pegaChave('#txtTabelaPreco'), corProduto, tamProduto);
            adicionaProduto(
              codigoProduto,
              descricao[0].DESCRICAO,
              preco,
              corProduto,
              tamProduto
            );
          }
        } else {
          const colecao = await formataListas($('#txtColecao').val().toString()) != '' ? ` AND PRODUTO.COLECAO IN (${await formataListas($('#txtColecao').val().toString())})` : '';
          const subColecao = await formataListas($('#txtSubColecao').val().toString()) != '' ? ` AND PRODUTO.CODTAG IN (${await formataListas($('#txtSubColecao').val().toString())})` : '';
          const marca = await formataListas($('#txtMarca').val().toString()) != '' ? ` AND PRODUTO.MARCA IN (${await formataListas($('#txtMarca').val().toString())})` : '';
          const etiqueta = await formataListas($('#txtEtiqueta').val().toString()) != '' ? ` AND PRODUTO.ETIQUETA IN (${await formataListas($('#txtEtiqueta').val().toString())})` : '';
          const grupo = await formataListas($('#txtGrupo').val().toString()) != '' ? ` AND PRODUTO.GRUPO IN (${await formataListas($('#txtGrupo').val().toString())})` : '';
          const pesquisaProdutos = {
            "tabela": "PRODUTO",
            "camposSelect": ["PA_ITEN.CODIGO, PRODUTO.DESCRICAO, PA_ITEN.COR, PA_ITEN.TAM"],
            "innerJoin": [
              { "tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
              { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR" },
            ],
            "where": [`CADCOR.INATIVO = 'N' ${colecao + subColecao + marca + etiqueta + grupo}`]
          }
          const produtos = await retornaJsonPesquisaPadrao(`${JSON.stringify(pesquisaProdutos)}`);

          if (produtos) {
            for (let i = 0; i < produtos.length; i++) {

              let preco = await retornaPrecoProduto(produtos[i].CODIGO, pegaChave('#txtTabelaPreco'), produtos[i].COR, produtos[i].TAM);

              if (preco != null) {

                adicionaProduto(
                  produtos[i].CODIGO,
                  produtos[i].DESCRICAO,
                  preco,
                  produtos[i].COR,
                  produtos[i].TAM
                );
              }
            }
          }
        }
      } else {
        if ((await formataListas($('#txtColecao').val().toString()) == '') && (await formataListas($('#txtMarca').val().toString()) == '') && (await formataListas($('#txtEtiqueta').val().toString()) == '') && (await formataListas($('#txtGrupo').val().toString()) == '') && (await formataListas($('#txtMarca').val().toString()) == '')) {
          await validaPrecoProduto();
          const listaProduto = $('#txtProduto').val();

          for (let i = 0; i < listaProduto.length; i++) {
            const dados = $('#tabela-produtos').DataTable().rows().data().toArray();
            const codigo = listaProduto[i];
            const indice = dados.findIndex((item) => item.CODIGO == codigo);
            if (indice != -1) {
              msgAlerta('Produto já incluso na regra, impossível continuar!');
              return;
            }
          }
          for (let i = 0; i < listaProduto.length; i++) {
            let produto = listaProduto[i];
            let descricao = await retornaJsonPesquisaPadrao(`{"tabela": "PRODUTO", "camposSelect": ["DESCRICAO"], "where": ["CODIGO = '${listaProduto[i]}'"]}`);
            let preco = await retornaPrecoProduto(listaProduto[i], pegaChave('#txtTabelaPreco'));
            adicionaProduto(
              produto,
              descricao[0].DESCRICAO,
              preco
            );
          }
        } else {
          const colecao = await formataListas($('#txtColecao').val().toString()) != '' ? ` AND COLECAO IN (${await formataListas($('#txtColecao').val().toString())})` : '';
          const subColecao = await formataListas($('#txtSubColecao').val().toString()) != '' ? ` AND CODTAG IN (${await formataListas($('#txtSubColecao').val().toString())})` : '';
          const marca = await formataListas($('#txtMarca').val().toString()) != '' ? ` AND MARCA IN (${await formataListas($('#txtMarca').val().toString())})` : '';
          const etiqueta = await formataListas($('#txtEtiqueta').val().toString()) != '' ? ` AND ETIQUETA IN (${await formataListas($('#txtEtiqueta').val().toString())})` : '';
          const grupo = await formataListas($('#txtGrupo').val().toString()) != '' ? ` AND GRUPO IN (${await formataListas($('#txtGrupo').val().toString())})` : '';
          const produtos = await retornaJsonPesquisaPadrao(`{"tabela": "PRODUTO", "camposSelect": ["CODIGO, DESCRICAO"], "where": [" 1=1 ${colecao + subColecao + marca + etiqueta + grupo}"]}`);

          if (produtos) {
            for (let i = 0; i < produtos.length; i++) {

              let preco = await retornaPrecoProduto(produtos[i].CODIGO, pegaChave('#txtTabelaPreco'));

              if (preco != null) {

                adicionaProduto(
                  produtos[i].CODIGO,
                  produtos[i].DESCRICAO,
                  preco
                );
              }
            }
          }
        }
      }
    } finally {
      $.LoadingOverlay('hide');
    }
    $('#txtProduto').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtSubColecao').empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtEtiqueta').empty().trigger('change');
    $('#txtGrupo').empty().trigger('change');
    $('#txtValorAdd').val('');
  });

  async function validaPrecoProduto(listaProdutoTabCorTam = []) {
    let listaProduto;

    if (utilizaTabCorTam) {
      listaProduto = listaProdutoTabCorTam;
    } else {
      listaProduto = $('#txtProduto').val();
    };

    const listaProdutoFormatada = [];
    for (let i = 0; i < listaProduto.length; i++) {
      let preco;

      if (utilizaTabCorTam) {
        preco = await retornaPrecoProduto(listaProduto[i].codigo, pegaChave('#txtTabelaPreco'), listaProduto[i].cor, listaProduto[i].tam);
      } else {
        preco = await retornaPrecoProduto(listaProduto[i], pegaChave('#txtTabelaPreco'));
      }
      if (preco != null) {
        listaProdutoFormatada.push(utilizaTabCorTam ? listaProduto[i].codigo : listaProduto[i]);
      }
    }

    if (listaProdutoFormatada.length > 0) {
      $('#txtProduto').val(listaProdutoFormatada).trigger('change');
    } else {
      $('#txtProduto').empty().trigger('change');
    }
    const listaProdutosSemPreco = listaProduto.filter(produtos => !listaProdutoFormatada.includes(utilizaTabCorTam ? produtos.codigo : produtos));

    if (listaProdutosSemPreco.length > 0) {
      msgAlerta(`Produto(s) ${listaProdutosSemPreco.toString()} sem preço cadastrado na tabela de preço ${pegaChave('#txtTabelaPreco')}`)
    }
  };

  $('#checkValorTabela, #checkQuantidade').on('change', function () {
    alteraCheck();
  });

  function alteraCheck() {
    if ($('#checkValorTabela').prop('checked')) {
      $('#htmlValor').html('Valor');
      $('#txtValorPromo').prop('placeholder', 'Valor');
      $("#divOperacao").addClass("d-none");
      $("#selectOperacao").val(">=");
    } else {
      $('#htmlValor').html('Quantidade');
      $('#txtValorPromo').prop('placeholder', 'Quantidade');
      $("#divOperacao").removeClass("d-none");
    }
  }

  async function buscaDadosRegra(regra) {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';
      const response = await requisicao('GET', url, `JSON={ "tabela":"REGRA_PROMOCAO",
            "camposSelect":["REGRA_PROMOCAO.DESC_REGRA", "REGRA_PROMOCAO.REGIAO", "REGRA_PROMOCAO.DT_INICIAL", "REGRA_PROMOCAO.DT_FINAL", "REGRA_PROMOCAO.EMPRESA",
            "REGRA_PROMOCAO.VALOR", "REGRA_PROMOCAO.DESCONTO", "REGRA_PROMOCAO.TIPO", "REGRA_PROMOCAO.SEQ", "REGRA_PROMOCAO.MODELO", "REGIAO.DESCRICAO", "REGRA_PROMOCAO.OPERACAO"],
            "innerjoin": [{"tabela": "REGIAO", "condicao": "REGRA_PROMOCAO.REGIAO = REGIAO.REGIAO"}],
            "where": ["REGRA = ${regra}"]}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      if (jsonStr.RESULT[0].length > 0) {
        return jsonStr.RESULT[0];
      }
      return null;


    } catch (error) {
      console.error(error);
    }
  }

  async function buscaProdutosRegra(regra) {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';

      let innerJoin = '';
      let camposSelect = '';

      if (utilizaTabCorTam) {
        innerJoin = `"innerjoin": [{"tabela": "PRECO_COR_TAM", "condicao": "PRECO_COR_TAM.CODIGO = REGRA_PROMOCAOI.CODIGO AND PRECO_COR_TAM.COR = REGRA_PROMOCAOI.COR AND PRECO_COR_TAM.TAM = REGRA_PROMOCAOI.TAM AND PRECO_COR_TAM.REGIAO = '${pegaChave('#txtTabelaPreco')}'"}, {"tabela": "PRODUTO", "condicao": "REGRA_PROMOCAOI.CODIGO = PRODUTO.CODIGO"}]`;
        camposSelect = `"camposSelect": ["REGRA_PROMOCAOI.CODIGO", "PRODUTO.DESCRICAO DESC_PRODUTO","REGRA_PROMOCAOI.OPERACAO", "REGRA_PROMOCAOI.COR", "REGRA_PROMOCAOI.TAM", "PRECO_COR_TAM.PRECO", "REGRA_PROMOCAOI.VALOR"]`;
      } else {
        innerJoin = `"innerjoin": [{"tabela": "TABPRECO", "condicao": "TABPRECO.CODIGO = REGRA_PROMOCAOI.CODIGO AND TABPRECO.REGIAO = '${pegaChave('#txtTabelaPreco')}'"}]`;
        camposSelect = `"camposSelect": ["REGRA_PROMOCAOI.CODIGO", "TABPRECO.DESC_PRODUTO", "REGRA_PROMOCAOI.OPERACAO", "TABPRECO.PRECO_00", "REGRA_PROMOCAOI.VALOR"]`;
      }

      const response = await requisicao('GET', url, `JSON={ "tabela":"REGRA_PROMOCAOI", ${camposSelect}, ${innerJoin}, "where": ["REGRA_PROMOCAOI.REGRA = ${regra}"]}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      if (jsonStr.RESULT[0].length > 0) {
        return jsonStr.RESULT[0];
      }
      return null;


    } catch (error) {
      console.error(error);
    }
  }

  async function preencheEmpresas() {
    let dataSet = await RetornaEmpresas();
    $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
    for (let i = 0; i < dataSet.length; i++) {
      const empresa = dataSet[i];
      $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_ID} - ${empresa.EMP_NOME} - ${empresa.EMP_PAT}`]).draw(false);
    }
  }

  function adicionaProduto(codigo, descricao, preco, cor = '', tam = '') {
    if (utilizaTabCorTam) {
      $('#tabela-produtos').DataTable().row.add({
        CODIGO: codigo,
        DESC_PRODUTO: descricao,
        OPERACAO: $('#checkDescPromo').is(':checked') ? 'D' : 'V',
        COR: cor,
        TAM: tam,
        PRECO: preco,
        VALOR: $('#txtValorAdd').val() != '' ? $('#txtValorAdd').val() : '0.00',
        EXCLUIR: retornaBotaoOpcoes()
      }).draw(false);
      novosCodigos.push({ codigo: codigo, cor: cor, tam: tam })
    } else {
      $('#tabela-produtos').DataTable().row.add({
        CODIGO: codigo,
        DESC_PRODUTO: descricao,
        OPERACAO: $('#checkDescPromo').is(':checked') ? 'D' : 'V',
        PRECO_00: preco,
        VALOR: $('#txtValorAdd').val() != '' ? $('#txtValorAdd').val() : '0.00',
        EXCLUIR: retornaBotaoOpcoes()
      }).draw(false);
      novosCodigos.push({ codigo: codigo })
    }
  };

  function adicionaPromocao(ordem, valor, desconto, operacao) {
    $('#tabela-promo').DataTable().row.add([
      ordem,
      valor,
      desconto,
      operacao,
      retornaBotaoOpcoes()
    ]).draw(false);
  }

  $('#tabela-produtos').on('click', '.btn-excluir', async function () {
    $('#tabela-produtos').DataTable().row($(this).parents('tr')).remove().draw(false);


  });

  $('#tabela-promo').on('click', '.btn-excluir', async function () {
    $('#tabela-promo').DataTable().row($(this).parents('tr')).remove().draw(false);
  });

  async function retornaProdutos(considerar, descricao, precoAte, regiao) {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';

      let sWhere = '';

      if (utilizaTabCorTam) {
        sWhere = `PRECO_COR_TAM.REGIAO = '${regiao}'`;
        if ((considerar == '1') && (descricao != '')) {
          sWhere += ` AND PRODUTO.DESCRICAO LIKE ('[PERCENTUAL]${descricao}[PERCENTUAL]')`;
        } else if ((considerar == '0') && (descricao != '')) {
          sWhere += ` AND PRODUTO.DESCRICAO NOT LIKE ('[PERCENTUAL]${descricao}[PERCENTUAL]')`;
        }
      } else {
        sWhere = `REGIAO = '${regiao}'`;
        if ((considerar == '1') && (descricao != '')) {
          sWhere += ` AND DESC_PRODUTO LIKE ('[PERCENTUAL]${descricao}[PERCENTUAL]')`;
        } else if ((considerar == '0') && (descricao != '')) {
          sWhere += ` AND DESC_PRODUTO NOT LIKE ('[PERCENTUAL]${descricao}[PERCENTUAL]')`;
        }
      }

      if (utilizaTabCorTam) {
        if (precoAte > 0) {
          sWhere += ` AND PRECO_COR_TAM.PRECO <= ${precoAte}`;
        }
      } else {
        if (precoAte > 0) {
          sWhere += ` AND PRECO_00 <= ${precoAte}`;
        }
      }

      let pesquisa = '';

      if (utilizaTabCorTam) {
        pesquisa = `{"tabela":"PRECO_COR_TAM","camposSelect":["PRECO_COR_TAM.CODIGO", "PRODUTO.DESCRICAO DESC_PRODUTO", "PRECO_COR_TAM.COR", "PRECO_COR_TAM.TAM","PRECO_COR_TAM.PRECO"], "innerJoin": [{ "tabela": "PRODUTO", "condicao": "PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO" }], "where": ["${sWhere}"]}`
      } else {
        pesquisa = `{"tabela":"TABPRECO","camposSelect":["CODIGO", "DESC_PRODUTO", "PRECO_00"],"where": ["${sWhere}"]}`
      }

      const json = encodeURIComponent(pesquisa);

      const response = await requisicao('GET', url, `JSON=${encodeURIComponent(json)}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      let dados = jsonStr.RESULT[0];
      for (let i = 0; i < dados.length; i++) {
        dados[i].OPERACAO = 'D';
        dados[i].VALOR = '0.00';
      }

      return dados;

    } catch (error) {
      console.error(error);
      msgErro('Erro ao buscar dados do usuário');
    }
  }

  async function retornaPrecoProduto(codigo, regiao, cor = '', tam = '') {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';

      let pesquisa = '';

      if (utilizaTabCorTam) {
        pesquisa = `JSON={ "tabela": "PRECO_COR_TAM", "camposSelect": ["PRECO"], "where": ["CODIGO = '${codigo}' AND REGIAO = '${regiao}' AND COR = '${cor}' AND TAM = '${tam}'"]}`
      } else {
        pesquisa = `JSON={ "tabela":"TABPRECO","camposSelect":["PRECO_00"],"where": ["CODIGO = '${codigo}' and REGIAO = '${regiao}'"]}`;
      }

      const response = await requisicao('GET', url, pesquisa);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      if (jsonStr.RESULT[0].length > 0) {
        return utilizaTabCorTam ? jsonStr.RESULT[0][0].PRECO : jsonStr.RESULT[0][0].PRECO_00;
      }

      return null;

    } catch (error) {
      console.error(error);
    }
  }

  async function buscaEmpresaUsuario(codigo) {
    try {
      const url = '/Sisplan/Funcoes/v1/pesquisa?';
      const response = await requisicao('GET', url, `JSON={ "tabela":"acesso_empresa", "camposSelect":["EMPRESA"], "where": ["USUARIO = '${codigo}'"]}`);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      if (jsonStr.RESULT[0].length > 0) {
        return jsonStr.RESULT[0];
      }
      return '';


    } catch (error) {
      console.error(error);
      msgErro('Erro ao buscar dados da empresa do usuário');
    }
  }

  $('.collapse').on('shown.bs.collapse', function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

    clicked
      .parent()
      .find(".fa-angle-right")
      .removeClass("fa-angle-right")
      .addClass("fa-angle-down");
  })
    .on('hidden.bs.collapse', function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });

  async function RetornaEmpresas() {
    let _url = `/sisplan/funcoes/v1/pesquisa?`;
    let _params = `JSON={"tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME", "REPLACE(EMP_PAT, '_', '') EMP_PAT"], "where": null}`;

    try {
      let response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return '';
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return '';
      }

      const arrDados = jsonStr.RESULT[0];
      return arrDados;
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as empresas.');
      return '';
    }
  }

  function botaoSelecionarGrid() {
    return '<div class="form-check icheck-primary">' +
      '<input type="checkbox" class="align-self-center checkEmpresa" value""><label></label>' +
      '</div>';
  };

  function retornaBotaoOpcoes() {
    return '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:white"></span></button>  ' +
      '   </div>';
  }

  function validaParametroRegra() {
    if (parametrosVenda[29] == 0) {
      msgAlerta("Parâmetro da regra de promoção não está ativo, verifique!");
    }
  }

  async function validacaoItensRegraPromocao(objRegra) {
    try {
      const response = await requisicao('POST', '/sisplan/regrapromocao/v1/validaitensregrapromocao?', '', `JSON=${JSON.stringify(objRegra)}`, 240000);

      if (!response) {
        throw new Error("Não foi possível validar os itens da regra de promoção.");
      }

      let json = await response.text();
      if (response.status != 200) {
        json = await response.json();
        throw new Error(json.mensagem);
      }

      return json;

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    }
  }

  async function mensagemValidacaoItensRegraPromocao(codigosRepetidos) {
    if (parametrosVenda[29] == '1') {
      await new Promise((resolve, reject) => {
        msgAlerta(`Os produtos listados abaixo já possuem uma regra de promoção cadastrada que inclui uma tabela de preço, empresa ou datas idênticas às do registro atual.\n\n ${codigosRepetidos}.`,
          () => {
            resolve()
          },
          () => {
            reject()
          },
          () => {
            reject()
          },
          () => {
            reject()
          },
        );
      })
    } else if (parametrosVenda[29] == '2') {
      await new Promise((resolve, reject) => {
        msgAlerta(`Os produtos listados abaixo já possuem uma regra de promoção cadastrada que inclui uma tabela de preço, empresa ou datas idênticas às do registro atual.\n\n ${codigosRepetidos}.`,
          undefined,
          undefined,
          () => {
            reject()
          },
          () => {
            reject()
          },
        )
      })
    } else {
      await new Promise((resolve, reject) => {
        msgAlerta(`Os produtos listados abaixo já possuem uma regra de promoção cadastrada que inclui uma tabela de preço, empresa ou datas idênticas às do registro atual.\n\n ${codigosRepetidos}.`,
          undefined,
          undefined,
          () => {
            resolve()
          },
          () => {
            resolve()
          },
        )
      })
    }
  }

});