$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaRegraFiscal',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma redução.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaRegra',
                popover: {
                    title: 'Tabela Reduções',
                    description: 'Aqui estão os dados das reduções cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("REGRAFISCAL");

    // autocompleta 
    $('#txtOperacao').autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);

    // pesquisa
    $('#btnOperacao').pesquisa('#txtOperacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Regra Fiscal', 'OPERACAO FISCAL');

    $('#btnLimpaOperacao').on('click', function () {
        $('#txtOperacao').val('');
    });

    // autocompleta 
    $('#txtRegra').autocompleta(1, `JSON={ "tabela":"REGRA_FISCAL", "camposSelect":[ "num_controle chave", "descricao descricao"], "where": null}`);

    // pesquisa
    $('#btnRegra').pesquisa('#txtRegra', 'NUM_CONTROLE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGRA_FISCAL", "camposSelect":[ "num_controle", "descricao"]}`, 'Pesquisa Regra Fiscal', 'regra_fiscal');

    $('#btnARegra').on('click', function () {
        $('#txtRegra').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
            '    <button class="dropdown-item" type="button" title="Duplicar" id="btnDuplicar">Duplicar</button>     ' +
            '</div>';
        return retorno;
    };

    consultaReducao();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaReducao(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtRegra').val('');
    });

    async function consultaReducao(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            let where = ''
            where += pegaChave('#txtRegra') != '' ? ` AND NUM_CONTROLE = '${pegaChave('#txtRegra')}'` : '';
            where += pegaChave('#txtOperacao') != '' ? ` AND COD_OPER = '${pegaChave('#txtOperacao')}'` : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"regra_fiscal", "camposSelect":[ "num_controle", "DESCRICAO"], "where": ["1=1 ${where}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"regra_fiscal", "camposSelect":[ "num_controle", "DESCRICAO"], "where": null, "limit": 10000}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaRegra').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "NUM_CONTROLE"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    }

    $('#btnNovaRegraFiscal').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "regrafiscal/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $("#tabelaRegra").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaRegra').DataTable().rows($(this).parents('tr')).data();

        await abreModalAnexos(data[0].NUM_CONTROLE, data[0].DESCRICAO, 'REGRAFISCAL');
    })

    $('#tabelaRegra').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaRegra').DataTable().row($(this).parents('tr')).data();
            window.location.href = `regrafiscal/${data.NUM_CONTROLE}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaRegra').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaRegra').DataTable().row($(this)).data();
            window.location.href = `regrafiscal/${data.NUM_CONTROLE}`;
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaRegra').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaRegra").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $('#tabelaRegra').on('click', '#btnDuplicar', async function () {
        let data = $('#tabelaRegra').DataTable().row($(this).parents('tr')).data();
        $('#modalDuplicarRegra').modal('show');
        insereValor('#txtCodigoOrigem', data.NUM_CONTROLE, data.DESCRICAO)
        $('#txtCodigoDestino').val(await RetornaProximo('REGRA_FISCAL', 'REGRA_FISCAL', 'NUM_CONTROLE', 0))
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/reducao?", `CODIGOREDUCAO=${encodeURIComponent(valorLinha.NUM_CONTROLE)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnDuplciarRegra').on('click', async function () {
        const codigoDestinoExiste = await buscaValor('REGRA_FISCAL', 'NUM_CONTROLE', 'NUM_CONTROLE', $('#txtCodigoDestino').val())
        if (!$('#txtCodigoDestino').val()) {
            throw msgAlerta('Código não informado, impossível continuar!');
        }
        if (codigoDestinoExiste) {
            throw msgAlerta('Código informado já existe, impossível continuar!');
        }
        if (!$('#txtDescricaoDestino').val()) {
            throw msgAlerta('Descrição não informada, impossível continuar!');
        }

        const response = await requisicao('PUT', `/sisplan/Cadastros/v1/reducao?`, `CODIGO_ORIGEM=${pegaChave('#txtCodigoOrigem')}&CODIGO_DESTINO=${$('#txtCodigoDestino').val()}&DESCRICAO_DESTINO=${$('#txtDescricaoDestino').val()}`, 15000);

        if (!response) {
            return
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        toastr.success(`Regra Fiscal duplicada com sucesso: ${$('#txtCodigoDestino').val()}!`, "Confirmação", {
            toastClass: "success",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                window.location.href = `${BASE_URI}/regrafiscal`
            },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
    });

});