<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Prospecção</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Theme style -->
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.243.6.1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
    <!-- Google Font: Source Sans Pro -->
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.243.6.1" />

    <link href='../dist/css/bootstrap.min.css?versao=3.243.6.1'>

    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.243.6.1">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.243.6.1">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.243.6.1">

    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.243.6.1">

    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.243.6.1">
    <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.243.6.1">

    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.243.6.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.243.6.1" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.243.6.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        .form-control:disabled,
        .form-control[readonly] {
            background-color: #f7f7f7;
            opacity: 1;
        }

        #msform {
            text-align: start;
            position: relative;
        }

        .card {
            box-shadow: none !important;
            border-radius: 0 !important;
            margin-bottom: 0 !important;
        }

        .card-header {
            box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
        }

        .card.card-header {
            border-bottom: 1px dashed #ddd;
            box-shadow: none !important;
        }

        .card-body {
            padding-left: 1.25rem !important;
            padding-top: 0px;
            padding-bottom: 0px;
            padding-right: 1.25rem !important;
        }

        .fa-angle-right,
        .fa-angle-down {
            color: #343a40;
        }

        .header-content-page .title-page,
        .title-content-page .title,
        .title-page {
            font-size: 20px;
            line-height: normal;
            font-weight: 500;
            color: var(--font-color);
            margin: 0;
            font-family: Roboto, Arial, sans-serif;
        }

        #btnHistorico {
            background-color: #3ca2d3 !important;
        }

        #btnConfirmarHistorico {
            background-color: #3ca2d3 !important;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 5px 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 0 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            border-radius: 3px !important;
        }

        #multiCollapseContábil {
            position: relative;
            z-index: 99999999;
        }

        td {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        @media (max-width: 1194.8px) {
            .centralizaBotao {
                text-align: center;
            }
        }

        /* Estilo para telas maiores ou iguais a 992px (telas lg e maiores) */
        @media (min-width: 1195px) {
            .centralizaBotao {
                text-align: start;
            }
        }

        td.ColunaVermelha {
            color: red;
            font-weight: 600;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        include_once('../../../menu.php');
        ?>
        <div id="myModal" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 id="myModalLabel" class="modal-title"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p id="myModalText"></p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                        <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="wrapper">
            <div id="myModal" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 id="myModalLabel" class="modal-title"></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <p id="myModalText"></p>
                        </div>
                        <div class="modal-footer">
                            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-wrapper">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6 col-12">
                            </div><!-- /.col -->
                            <div class="col-sm-6 col-12">
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div>
                </div>
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <div class="card" style="height:auto;min-height:715px">
                                    <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                        <h2 class="m-0">Cadastro de Prospecção</h2>
                                        <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                                            <i class="fas fa-question-circle"></i>
                                        </button>
                                    </div>
                                    <fieldset>
                                        <div class="card-body">
                                            <form style="text-align:left!important;" id="msform" name="msform">
                                                <div class="card card-header" role="tab" id="dados">
                                                    <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample1" href="#multiCollapseExample1" aria-expanded="true" aria-controls="collapseOne1">
                                                        <div class="row">
                                                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                                                <i class="fas fa-angle-down"></i>
                                                            </div>
                                                            <div class="col-11">
                                                                <h4 class="title-page">
                                                                    Dados
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse  show" id="multiCollapseExample1">
                                                    <div class="card card-body mt-2">
                                                        <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="dados-tab">
                                                            <div class="row">
                                                                <div class="col-md-3 col-12 mt-2 pt-2 ">
                                                                    <fieldset class="form border-Field p-0">
                                                                        <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                                                                        <div class="form-row mb-0">
                                                                            <div class="icheck-primary mr-5 ml-2"><input type="radio" id="rdPessoaFisica" checked name="rdPessoa" value="0"><label class="labelCheck" for="rdPessoaFisica">Física</label></div>
                                                                            <div class="icheck-primary"><input type="radio" id="rdPessoaJuridica" name="rdPessoa" value="1"><label class="labelCheck" for="rdPessoaJuridica">Jurídica</label></div>
                                                                    </fieldset>
                                                                </div>
                                                                <div class="col-lg-4 col-md-auto col-3 d-flex mt-2 mb-lg-0 p-0">
                                                                    <div class="col-6 pl-0">
                                                                        <label for="txtCadastro">Cadastro:</label>
                                                                        <div class="relative">
                                                                            <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtCadastro" name="Cadastro">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-6 pr-0">
                                                                        <label for="txtRetorno">Retorno:</label>
                                                                        <div class="relative">
                                                                            <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtRetorno" name="Retorno">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-5 text-left pr-0 mt-2">
                                                                    <label for="">Origem do Lead: *</label>
                                                                    <div class="relative">
                                                                        <select name="" id="txtOrigem" value="" class="form-group input-default">
                                                                            <option value="0" selected>Selecione uma opção</option>
                                                                            <option value="1">Redes Sociais</option>
                                                                            <option value="2">Indicação</option>
                                                                            <option value="3">Prospecção Ativa</option>
                                                                            <option value="4">Google</option>
                                                                            <option value="5">Formulário</option>
                                                                            <option value="6">Eventos</option>
                                                                            <option value="7">Outros</option>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-2 text-left pr-0" id="tutorialCodigo">
                                                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" readonly class="input-default focus form-control validate" aria-describedby="cepError" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-5 col-12 text-left pr-0" id="tutorialRazao">
                                                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtRazao">Razão social: *</label>
                                                                    <div class="input-group">
                                                                        <input type="text" class="input-default focus form-control validate" required id="txtRazao" name="txtRazao" placeholder="Razão Social">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-5 col-12 text-left pr-0" id="tutorialFantasia">
                                                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtFantasia">Fantasia: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" class="input-default focus form-control validate" aria-describedby="ordemError" id="txtFantasia" name="txtFantasia" placeholder="Fantasia">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialCnpj">
                                                                    <label data-error="wrong" data-success="right" for="txtCNPJ">CNPJ/CPF: *</label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtCNPJ" name="txtCNPJ" aria-describedby="CNPJError" class="form-control" required placeholder="CNPJ ou CPF">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialInscricao">
                                                                    <label data-error="wrong" data-success="right" for="txtInscricao">Inscricao: *</label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtInscricao" name="txtInscricao" class="form-control" required placeholder="Inscricao">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialEndereco">
                                                                    <label data-error="wrong" data-success="right" for="txtEndereco">Endereço: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEndereco" name="txtEndereco" class="form-control" placeholder="Endereço">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialNumero">
                                                                    <label data-error="wrong" data-success="right" for="txtNumero">Número: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtNumero" name="txtNumero" class="form-control" placeholder="Número">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialBairro">
                                                                    <label data-error="wrong" data-success="right" for="txtBairro">Bairro: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtBairro" name="txtBairro" class="form-control" placeholder="Bairro">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialComplemento">
                                                                    <label data-error="wrong" data-success="right" for="txtComplemento">Complemento: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtComplemento" name="txtComplemento" class="form-control" placeholder="Complemento">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialCep">
                                                                    <label data-error="wrong" data-success="right" for="txtCep">Cep: *</label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtCep" name="txtCep" class="form-control" required placeholder="Cep">
                                                                        <div class="input-group-append">
                                                                            <button class="btn bg-danger" id="btnCep" name="btnCep" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                            <button class="btn bg-danger" id="btnACep" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialCidade">
                                                                    <label data-error="wrong" data-success="right" for="txtCidade">Cidade: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" disabled id="txtCidade" name="txtCidade" class="form-control" placeholder="Cidade">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialEstado">
                                                                    <label data-error="wrong" data-success="right" for="txtEstado">Estado: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" disabled id="txtEstado" name="txtEstado" class="form-control" placeholder="Estado">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialEntidade">
                                                                    <label data-error="wrong" data-success="right" for="txtEntidade">Entidade: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEntidade" name="txtEntidade" class="form-control" placeholder="Entidade">
                                                                        <div class="input-group-append">
                                                                            <button class="btn bg-danger" id="btnEntidade" name="btnEntidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                            <button class="btn bg-danger" id="btnAEntidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialRamo">
                                                                    <label data-error="wrong" data-success="right" for="txtRamo">Ramo de Atividade: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtRamo" name="txtRamo" class="form-control" placeholder="Ramo de Atividade">
                                                                        <div class="input-group-append">
                                                                            <button class="btn bg-danger" id="btnRamo" name="btnRamo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                            <button class="btn bg-danger" id="btnARamo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialRepresentante">
                                                                    <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtRepresentante" name="txtRepresentante" class="form-control" placeholder="Representante">
                                                                        <div class="input-group-append">
                                                                            <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                            <button class="btn bg-danger" id="btnARepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialCNAE">
                                                                    <label data-error="wrong" data-success="right" for="txtCNAE">CNAE: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtCNAE" name="txtCNAE" class="form-control" placeholder="CNAE">
                                                                        <div class="input-group-append">
                                                                            <button class="btn bg-danger" id="btnCNAE" name="btnCNAE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                                            <button class="btn bg-danger" id="btnACNAE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialSite">
                                                                    <label data-error="wrong" data-success="right" for="txtSite">Site: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSite" name="txtSite" class="form-control" placeholder="Site">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-4 text-left pr-0" id="tutorialQtdeColaboradores">
                                                                    <label data-error="wrong" data-success="right" for="txtQtdeColaboradores">Qtde Colaboradores: </label>
                                                                    <div class="input-group">
                                                                        <input type="numeric" data-selecionado="false" class="input-default focus form-control validate" value="0" id="txtQtdeColaboradores" name="txtQtdeColaboradores" class="form-control" placeholder="Qtde Colaboradores">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card card-header" role="tab" id="contatos">
                                                    <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample2" href="#multiCollapseExample2" aria-expanded="true" aria-controls="collapseOne1">
                                                        <div class="row">
                                                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                                                <i class="fas fa-angle-right"></i>
                                                            </div>
                                                            <div class="col-11">
                                                                <h4 class="title-page">
                                                                    Contatos
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div class="collapse" id="multiCollapseExample2">
                                                    <div class="card card-body mt-2">
                                                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="contatos-tab">
                                                            <div class="row">
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialContato">
                                                                    <label data-error="wrong" data-success="right" for="txtContato">Contato: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtContato" name="txtContato" class="form-control" placeholder="Contato">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialSetor">
                                                                    <label data-error="wrong" data-success="right" for="txtSetor">Setor: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSetor" name="txtSetor" class="form-control" placeholder="Setor">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialTelefone">
                                                                    <label data-error="wrong" data-success="right" for="txtTelefone">Telefone: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtTelefone" name="txtTelefone" class="form-control" placeholder="Telefone">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialEmail">
                                                                    <label data-error="wrong" data-success="right" for="txtEmail">Email: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEmail" name="txtEmail" class="form-control" placeholder="Email">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialContato2">
                                                                    <label data-error="wrong" data-success="right" for="txtContato2">Contato: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtContato2" name="txtContato2" class="form-control" placeholder="Contato">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialSetor2">
                                                                    <label data-error="wrong" data-success="right" for="txtSetor2">Setor: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSetor2" name="txtSetor2" class="form-control" placeholder="Setor">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialTelefone2">
                                                                    <label data-error="wrong" data-success="right" for="txtTelefone2">Telefone: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtTelefone2" name="txtTelefone2" class="form-control" placeholder="Telefone">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialEmail2">
                                                                    <label data-error="wrong" data-success="right" for="txtEmail2">Email: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEmail2" name="txtEmail2" class="form-control" placeholder="Email">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialContato3">
                                                                    <label data-error="wrong" data-success="right" for="txtContato3">Contato: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtContato3" name="txtContato3" class="form-control" placeholder="Contato">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialSetor3">
                                                                    <label data-error="wrong" data-success="right" for="txtSetor3">Setor: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSetor3" name="txtSetor3" class="form-control" placeholder="Setor">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialTelefone3">
                                                                    <label data-error="wrong" data-success="right" for="txtTelefone3">Telefone: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtTelefone3" name="txtTelefone3" class="form-control" placeholder="Telefone">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialEmail3">
                                                                    <label data-error="wrong" data-success="right" for="txtEmail3">Email: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEmail3" name="txtEmail3" class="form-control" placeholder="Email">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialContato4">
                                                                    <label data-error="wrong" data-success="right" for="txtContato4">Contato: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtContato4" name="txtContato4" class="form-control" placeholder="Contato">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialSetor4">
                                                                    <label data-error="wrong" data-success="right" for="txtSetor4">Setor: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSetor4" name="txtSetor4" class="form-control" placeholder="Setor">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialTelefone4">
                                                                    <label data-error="wrong" data-success="right" for="txtTelefone4">Telefone: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtTelefone4" name="txtTelefone4" class="form-control" placeholder="Telefone">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialEmail4">
                                                                    <label data-error="wrong" data-success="right" for="txtEmail4">Email: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEmail4" name="txtEmail4" class="form-control" placeholder="Email">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialContato5">
                                                                    <label data-error="wrong" data-success="right" for="txtContato5">Contato: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtContato5" name="txtContato5" class="form-control" placeholder="Contato">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialSetor5">
                                                                    <label data-error="wrong" data-success="right" for="txtSetor5">Setor: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtSetor5" name="txtSetor5" class="form-control" placeholder="Setor">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialTelefone5">
                                                                    <label data-error="wrong" data-success="right" for="txtTelefone5">Telefone: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtTelefone5" name="txtTelefone5" class="form-control" placeholder="Telefone">
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-3 text-left pr-0" id="tutorialEmail5">
                                                                    <label data-error="wrong" data-success="right" for="txtEmail5">Email: </label>
                                                                    <div class="input-group">
                                                                        <input type="text" data-selecionado="false" class="input-default focus form-control validate" id="txtEmail5" name="txtEmail5" class="form-control" placeholder="Email">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-lg-12 col-12 text-left pr-0 pl-3">
                                                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Observação:</label>
                                                                    <div class="input-group">
                                                                        <textarea class="input-default focus form-control create" id="txtObs" name="txtObs" placeholder="Observação" rows="5" cols="50" style="resize: none;"></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-lg-auto col-md-auto col-auto mt-0 ml-2">
                                                                    <fieldset class="form border-Field p-0">
                                                                        <legend class="textoBorda pb-0 mb-0">Status</legend>
                                                                        <div class="d-flex">
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="rdStatusProsp" checked name="rdFiltroStatus" value="0"><label class="labelCheck" for="rdStatusProsp">Em Prospecção</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="rdStatusSemCont" name="rdFiltroStatus" value="1"><label class="labelCheck" for="rdStatusSemCont">Sem Contato</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="rdStatusSemInt" name="rdFiltroStatus" value="2"><label class="labelCheck" for="rdStatusSemInt">Sem Interesse</label></div>
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="rdStatusSemOrc" name="rdFiltroStatus" value="3"><label class="labelCheck" for="rdStatusSemOrc">Sem Orçamento</label></div>
                                                                            <div class="icheck-primary"><input type="radio" id="rdStatusSatisfeito" name="rdFiltroStatus" value="4"><label class="labelCheck" for="rdStatusSatisfeito">Satisfeito</label></div>
                                                                    </fieldset>
                                                                </div>
                                                                <div class="col-lg-auto col-md-auto col-auto mt-0 pr-0">
                                                                    <fieldset class="form border-Field p-0">
                                                                        <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                                                                        <div class="d-flex">
                                                                            <div class="icheck-primary mr-3"><input type="radio" id="rdTipoAtivo" checked name="rdFiltroTipo" value=0"><label class="labelCheck" for="rdTipoAtivo">Ativo</label></div>
                                                                            <div class="icheck-primary mr-1"><input type="radio" id="rdTipoReceptivo" name="rdFiltroTipo" value="1"><label class="labelCheck" for="rdTipoReceptivo">Receptivo</label></div>
                                                                    </fieldset>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-lg-auto col-md-auto col-6 ml-2 mr-2">
                                                                    <fieldset class="form border-Field p-0">
                                                                        <legend class="textoBorda pb-0 mb-0">Forma Contato</legend>
                                                                        <div class="form-row justify-content-center">
                                                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="LIGACAO" id="cbLigacao"><label class="labelCheck" for="cbLigacao"> Ligação</label></div>
                                                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="EMAIL" id="cbEmail"><label class="labelCheck" for="cbEmail"> E-mail</label></div>
                                                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="VISITA" id="cbVisita"><label class="labelCheck" for="cbVisita"> Visita</label></div>
                                                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="WHATS" id="cbWhatsapp"><label class="labelCheck" for="cbWhatsapp">WhatsApp</label></div>
                                                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckForma" value="OUTROS" id="cbOutros"><label class="labelCheck" for="cbOutros"> Outros</label></div>
                                                                        </div>
                                                                    </fieldset>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="card card-header" role="tab" id="historico">
                                                    <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample3" href="#multiCollapseExample3" aria-expanded="true" aria-controls="collapseOne1">
                                                        <div class="row">
                                                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                                                                <i class="fas fa-angle-right"></i>
                                                            </div>
                                                            <div class="col-11">
                                                                <h4 class="title-page">
                                                                    Histórico
                                                                </h4>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <div class="collapse" id="multiCollapseExample3">
                                                    <div class="card card-body">
                                                        <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="historico-tab">
                                                            <div class="pt-2 form-row">
                                                                <div class="col-lg-12 table-responsive table-selecttable-lg">
                                                                    <table id="tabelaHistorico" class="table table-sm table-select table-hover" style="width: 100%; white-space: nowrap">
                                                                        <thead>
                                                                        </thead>
                                                                        <tbody>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <button type="button" class="btn btn-primary btn-sisp mt-2 mb-2" id="btnHistorico">Incluir/Alterar Histórico</button>
                                                                <!-- <button type="button" id="btnExcluirHistorico" style="font-size:15px; margin-right:0%" class="btn-sisp action-button" data-dismiss="modal">Excluir</button> -->
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- cabo os panel -->
                                                <input type="button" name="gravar" id="gravar" class="btn-sisp action-button" value="Gravar" />
                                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                            </form>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
        <div id="modal-historico" class="modal" tabindex="-1" data-backdrop="static" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header">
                        <h4 class="modal-title">Incluir Histórico</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="card card-body mt-2">
                            <div class="row">
                                <div class="col-md-5 col-12 p-0 mt-2">
                                    <fieldset class="form border-Field p-0">
                                        <legend class="textoBorda pb-0 mb-0">Forma Contato</legend>
                                        <div class="form-row justify-content-center">
                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckFormaHist" disabled value="LIGACAO" id="cbHistLigacao"><label class="labelCheck" for="cbHistLigacao"> Ligação</label></div>
                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckFormaHist" disabled value="EMAIL" id="cbHistEmail"><label class="labelCheck" for="cbHistEmail"> E-mail</label></div>
                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckFormaHist" disabled value="VISITA" id="cbHistVisita"><label class="labelCheck" for="cbHistVisita"> Visita</label></div>
                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckFormaHist" disabled value="WHATS" id="cbHistWhatsapp"><label class="labelCheck" for="cbHistWhatsapp">WhatsApp</label></div>
                                            <div class="icheck-primary mr-2"><input type="checkbox" class="configCheckFormaHist" disabled value="OUTROS" id="cbHistOutros"><label class="labelCheck" for="cbHistOutros"> Outros</label></div>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-lg-7 col-md-auto col-3 d-flex mb-lg-0 p-0">
                                    <div class="col-3 ml-2">
                                        <label for="txtHistVisita">Visita:</label>
                                        <div class="relative">
                                            <input type="date" max="2500-12-31" value="1200-01-01" disabled class="input-default focus form-control validate" id="txtHistVisita" name="Visita">
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <label for="txtHistHora">Hora:</label>
                                        <div class="relative">
                                            <input type="time" value="00:00:00" step="1" disabled class="input-default focus form-control validate" id="txtHistHora" name="HoraVisita">
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <label for="txtHistRetorno">Retorno:</label>
                                        <div class="relative">
                                            <input type="date" max="2500-12-31" value="1200-01-01" disabled class="input-default focus form-control validate" id="txtHistRetorno" name="Retorno">
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <label for="">Prioridade: </label>
                                        <div class="relative">
                                            <select name="" disabled id="txtHistPrioridade" value="" class="form-group input-default">
                                                <option value="0" selected disabled></option>
                                                <option value="1">Normal</option>
                                                <option value="2">Média</option>
                                                <option value="3">Alta</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12 col-md-3 text-left pl-0" style="padding-right: 8px !important;">
                                    <label data-error="wrong" data-success="right" for="txtHistRepresentante">Representante: </label>
                                    <div class="input-group">
                                        <input type="text" disabled data-selecionado="false" class="input-default focus form-control validate" id="txtHistRepresentante" name="txtHistRepresentante" class="form-control" placeholder="Representante">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" disabled id="btnHistRepresentante" name="btnHistRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" disabled id="btnAHistRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-3 text-left pl-0" style="padding-right: 8px !important;">
                                    <label data-error="wrong" data-success="right" for="txtHistRamo">Ramo de Atividade: </label>
                                    <div class="input-group">
                                        <input type="text" disabled data-selecionado="false" class="input-default focus form-control validate" id="txtHistRamo" name="txtHistRamo" class="form-control" placeholder="Ramo de Atividade">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" disabled id="btnHistRamo" name="btnHistRamo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" disabled id="btnAHistRamo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-3 text-left pl-0" style="padding-right: 8px !important;">
                                    <label data-error="wrong" data-success="right" for="txtHistStatus">Status: </label>
                                    <div class="input-group">
                                        <input type="text" disabled data-selecionado="false" class="input-default focus form-control validate" id="txtHistStatus" name="txtHistStatus" class="form-control" placeholder="Status">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" disabled id="btnHistStatus" name="btnHistStatus" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" disabled id="btnAHistStatus" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-3 text-left p-0">
                                    <div class="col-12 col-md-12 text-left p-0">
                                        <label data-error="wrong" data-success="right" for="txtHistContato">Contato: </label>
                                        <div class="input-group">
                                            <input type="text" disabled data-selecionado="false" class="input-default focus form-control validate" id="txtHistContato" name="txtHistContato" class="form-control" placeholder="Contato">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12 col-12 text-left p-0">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtHistObs">Observação:</label>
                                    <div class="input-group">
                                        <textarea class="input-default focus form-control create" disabled id="txtHistObs" name="txtHistObs" placeholder="Observação" rows="4" cols="50" style="resize: none;"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="pt-2 form-row">
                                <div class="col-lg-12 table-responsive table-selecttable-lg">
                                    <table id="tabelaCadHistorico" class="table table-sm table-select table-hover" style="width: 100%; white-space: nowrap">
                                        <thead>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start">
                        <div class="row col-12 col-md-12 p-0">
                            <div class="col-9 col-md-9 d-flex justify-content-start">
                                <button class="btn btn-sisp mr-2" style="background-color: #218838; color:#fff" id="btnIncluirHistorico">Incluir</button>
                                <button class="btn btn-primary btn-sisp mr-2" id="btnAlterarHistorico">Alterar</button>
                                <button type="button" class="btn btn-danger btn-sisp mr-2" id="btnExcluirHistorico">Excluir</button>

                                <button class="btn btn-primary btn-sisp mr-2 d-none" id="btnConfirmarHistorico">Confirmar</button>
                                <button type="button" class="btn btn-danger btn-sisp d-none" id="btnDesistirHistorico">Desistir</button>
                            </div>
                            <div class="col-3 col-md-3 d-flex justify-content-end">
                                <button type="button" class="btn bg-gradient-danger btn-sisp ml-auto" data-dismiss="modal" id="btnFecharHistorico">Fechar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
        include_once('../../../footer.php');
        ?>

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->
    </div>
    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.243.6.1"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.243.6.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.243.6.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.243.6.1"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.243.6.1"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>
    <script src="dist/js/valida_cpf_cnpj.js?versao=3.243.6.1"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.243.6.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.243.6.1"></script>
    <script src="../utils/funcoes.js?versao=3.243.6.1"></script>
    <script src="../utils/cookies.js?versao=3.243.6.1"></script>
    <script src="../dist/js/driver.min.js?versao=3.243.6.1"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.243.6.1"></script>
    <script src="../dist/js/jquery.mask.min.js?versao=3.243.6.1"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.243.6.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.243.6.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('PROSPECCAO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("PROSPECCAO");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/prospeccao`
                });
                return;
            }


            const queryString = window.location.href;
            const parametros = queryString.split("/");
            const prospeccao = parametros[parametros.length - 1];

            $(window).on("beforeunload", function(e) {
                // e.preventDefault();
                e.stopPropagation();
                deletaRegistro("PROSPECCAO", getCookie("usuario"), prospeccao);
                return undefined;
            });

            sArquivo = `${BASE_URI}/pages/prospeccao/cadastro_prospeccao/prospeccao.js?versao=3.243.6.1`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>