$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaOrdemProducao",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova ordem de produção.",
          position: "right",
        },
      },
      {
        element: "#tabelaOrdemProducao",
        popover: {
          title: "Tabela Ordem de Produção Simples",
          description: "Aqui estão os dados das ordens de produção cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORDEMPRODUCAO");

  MontaPesquisa();

  $('#btn-limpa-Produto').on('click', function () {
    $('#txtProdutoConsulta').val('');
  });

  $('#btn-limpa-OrdemProducao').on('click', function () {
    $('#txtOrdemProducaoConsulta').val('');
  });

  $('#btn-limpa-ClienteConsulta').on('click', function () {
    $('#txtClienteConsulta').val('');
  });

  $('#btn-limpa-PedidoConsulta').on('click', function () {
    $('#txtPedidoConsulta').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtOrdemProducaoConsulta').val('');
    $('#txtProdutoConsulta').val('');
    $('#txtDataSaidaIni').val('1200-01-01');
    $('#txtDataSaidaFim').val('2500-12-31');
    $('#txtDataRetornoIni').val('1200-01-01');
    $('#txtDataRetornoFim').val('2500-12-31');
    $('#txtStatus').val('Todos');
    $('#txtSituacao').val('Normal');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnNovaOrdemProducao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "ordemproducao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  await consultaOrdemProducao();


  function MontaPesquisa() {
    let opcaoTexto = $("#txtSituacao option:selected").val();
    let TabelaBusca = opcaoTexto == "Normal" ? "faccao" : "faccaor";
    $('#txtOrdemProducaoConsulta').autocompleta(1, `JSON={ "tabela": "${TabelaBusca}", "camposSelect":[ "numero chave", "descricao descricao"], "where": null, "groupBy": ["numero", "descricao"]}`);
    $('#btn-OrdemProducao').pesquisa('#txtOrdemProducaoConsulta', 'NUMERO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "${TabelaBusca}", "camposSelect":[ "numero", "descricao"], "groupBy": ["numero", "descricao"]}`, 'Pesquisa Ordem de Produção', TabelaBusca);
  }

  $('#txtProdutoConsulta').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btn-Produto').pesquisa('#txtProdutoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON=  { "tabela":"produto", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa de Produto', 'produto');
  $('#txtClienteConsulta').autocompleta(1, `JSON={ "tabela":"faccao", "camposSelect":["faccao.cliente chave", "entidade.nome descricao"], "leftJoin": [{"tabela": "entidade", "condicao": "entidade.codcli = faccao.cliente"}], "groupBy" : ["faccao.cliente" , "entidade.nome"], "where": null}`);
  
  $('#txtPedidoConsulta').autocompleta(1, `JSON={ "tabela":"pedido", "camposSelect":["pedido.numero chave", "codcli.nome descricao"], "leftJoin": [{"tabela": "entidade", "condicao": "entidade.codcli = pedido.codcli"}], "where": null}`);
  
  $('#btn-ClienteConsulta').pesquisa('#txtClienteConsulta', 'CLIENTE', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "FACCAO", "camposSelect": ["FACCAO.CLIENTE", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = FACCAO.CLIENTE"}], "groupBy": ["FACCAO.CLIENTE", "ENTIDADE.NOME"]}`, 'Pesquisa de Cliente', 'faccao');
  $('#btn-PedidoConsulta').pesquisa('#txtPedidoConsulta', 'NUMERO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PEDIDO",    "camposSelect": ["PEDIDO.NUMERO", "ENTIDADE.NOME"],    "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}] }`, 'Pesquisa de Pedido', 'pedido');

  $('#txtSituacao').change(function () {
    $('#txtOrdemProducaoConsulta').val('');
    MontaPesquisa();
  });

  async function consultaOrdemProducao(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let status = $('#txtStatus').val();

      if (status == 1) {
        status = '  AND (QT_ORIG-(QUANT+QUANT_2+QUANT_I+QUANT_F)) > 0 '
      } else if (status == 2) {
        status = '  AND (QUANT_F) > 0 '
      } else if (status == 3) {
        status = '  AND ((QT_ORIG-(QUANT+QUANT_2+QUANT_I+QUANT_F)) <= 0 AND (QUANT_F) > 0) '
      }

      const numero = pegaChave('#txtOrdemProducaoConsulta') != '' ? ` AND FACCAO.NUMERO = '${pegaChave('#txtOrdemProducaoConsulta')}'` : '';
      const produto = pegaChave('#txtProdutoConsulta') != '' ? ` AND FACCAO.CODIGO = '${pegaChave('#txtProdutoConsulta')}'` : '';
      const cliente = pegaChave('#txtClienteConsulta') != '' ? ` AND FACCAO.CLIENTE = '${pegaChave('#txtClienteConsulta')}'` : '';
      const pedido = pegaChave('#txtPedidoConsulta') != '' ? ` AND FACCAO.PEDIDO = '${pegaChave('#txtPedidoConsulta')}'` : '';
      const DataEmiIni = $('#txtDataSaidaIni').val();
      const DataEmiFim = $('#txtDataSaidaFim').val();
      const DataRetornoIni = $('#txtDataRetornoIni').val();
      const DataRetornoFim = $('#txtDataRetornoFim').val();
      const tela = ` AND FACCAO.TELA  = 'F'`;
      let params;
      if (bBotao) {
        params = `{"tabela":"faccao", "camposSelect":[ "distinct faccao.numero", "faccao.descricao", "faccao.pedido", "faccao.codcli", "entidade.nome", "faccao.dt_r", "faccao.dt_s"], "leftJoin": [{"tabela": "entidade", "condicao": "entidade.codcli = faccao.codcli"}], "where": ["1=1 ${numero}${produto}${cliente}${pedido}${encodeURIComponent(status)} AND DT_S >= '${DataEmiIni}' AND DT_S <= '${DataEmiFim}' AND DT_R >= '${DataRetornoIni}' AND DT_R <= '${DataRetornoFim}' ${tela}"]}`;
      } else {
        params = `{"tabela":"faccao", "camposSelect":[ "distinct faccao.numero", "faccao.descricao", "faccao.pedido", "faccao.codcli", "entidade.nome", "faccao.dt_r", "faccao.dt_s"],  "leftJoin": [{"tabela": "entidade", "condicao": "entidade.codcli = faccao.codcli"}],"where": ["1=1 ${tela}"]}`;
      }

      const jsonStr = await retornaJsonPesquisaPadrao(params);

      $('#tabelaOrdemProducao').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr,
        "columns": [{
          "data": "NUMERO"
        },
        {
          "data": "DESCRICAO"
        },
        {
          "data": "PEDIDO"
        },
        {
          "data": "CODCLI"
        },
        {
          "data": "NOME"
        },
        {
          "data": "DT_S"
        },
        {
          "data": "DT_R"
        },
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }

  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>  ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      `    <button class="dropdown-item" type="button" title=${getCookie('cod_usuario') == '0000' ? '"Este botão chama o Layout RelOrdemProducao.FR3"' : '"Imprimir"' } id="btn-imprimir">Imprimir</button>     ` +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/ordemproducao/v1/ordemproducao?", `NUMEROORDEM=${encodeURIComponent(valorLinha.NUMERO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaOrdemProducao').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOrdemProducao').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `ordemproducao/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaOrdemProducao").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaOrdemProducao').DataTable().rows($(this).parents('tr')).data();

    await abreModalAnexos(data[0].NUMERO, data[0].DESCRICAO, 'ORDEMPRODUCAO');
  })

  $('#tabelaOrdemProducao').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOrdemProducao').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `ordemproducao/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemProducao').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaOrdemProducao").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOrdemProducao(true);
  });

  $("#tabelaOrdemProducao").on("click", "#btn-imprimir", async function () {
    try {
      $.LoadingOverlay("show");

      let data = $("#tabelaOrdemProducao").DataTable().row($(this).parents("tr")).data();
      let url = `/sisplan/impressao/v1/relordemproducao?numero=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('Ordemproducao');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Ordem de Produção');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  retornaHintRelatorio('btnImprimirOFs','RelAcessoOrdemProducao')

  $("#btnImprimirOFs").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      const numero = pegaChave('#txtOrdemProducaoConsulta');
      const produto = pegaChave('#txtProdutoConsulta');
      const cliente = pegaChave('#txtClienteConsulta');
      const pedido = pegaChave('#txtPedidoConsulta');
      const DataEmiIni = $('#txtDataSaidaIni').val();
      const DataEmiFim = $('#txtDataSaidaFim').val();
      const DataRetornoIni = $('#txtDataRetornoIni').val();
      const DataRetornoFim = $('#txtDataRetornoFim').val();
      const url = `/sisplan/impressao/v1/relacessoordemproducao?NUMERO_OF=${numero}&PEDIDO_OF=${pedido}&CODCLI_OF=${cliente}&CODIGO_PROD=${produto}&DT_EMI_INI=${DataEmiIni}&DT_EMI_FIM=${DataEmiFim}&DT_RETORNO_INI=${DataRetornoIni}&DT_RETORNO_FIM=${DataRetornoFim}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoOrdemProducao');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RelAcessoOrdemProducao');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

});