<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Ordem de Compra</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.243.6.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.243.6.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.243.6.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.243.6.1">
  <style>
    #tabelaOrdemCompra td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaOrdemCompra td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    #modalPesquisaPedido div {
      z-index: 999 !important;
    };

  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Ordem de Compra</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
 
            </div>
          </div>
        </div>
        <div class="container-fluid" id="divTabelaOrdemCompra">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
              <button id="btnImprimir" class="btn-sisp btn btn-success"><i class="fas fa-print"></i> Imprimir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Ordem de Compra</h5>
              <table id="tabelaOrdemCompra" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Numero
                    </th>
                    <th class="th-sm">Fornecedor
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div> 

      <div id="modal-filtros" class="modal"  tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-6">
                  <label for="txtDataEmiDe">Data Emissão De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmiDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-6">
                  <label for="txtDataEmiAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmiAte" name="DataDe">
                  </div>
                </div>                                                 
              </div> 
              
              <div class="row">
                <div class="col-lg-12">
                  <label data-error="wrong" data-success="right" for="txtOrdemCompraConsulta">Ordem de Compra </label>
                  <div class="input-group">
                    <input type="text" class="input-default col-lg-3 col-12 focus form-control" id="txtOrdemCompraConsulta" name="txtOrdemCompraConsulta" class="form-control" placeholder="Ordem de Compra">
                    <button class="btn bg-danger" id="btn-OrdemCompraConsulta" name="btn-OrdemCompraConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <input type="text" id="txtListaOrdemCompra" class="form-group col-lg-9 col-12 input-default focus form-control" placeholder="Lista de Ordem de Compra" disabled>
                    <button class="btn bg-danger" id="btn-limpa-OrdemCompra" name="btn-limpa-OrdemCompra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div> 
              </div>             

              <div class="row">
                <div class="col-12" id="Fornecedor">
                  <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornecedor">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Fornecedor" name="btn-Fornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Fornecedor" name="btn-limpa-Fornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>   
              
              <div class="row">
                <div class="col-6" id="Usuario">
                  <label data-error="wrong" data-success="right" for="txtUsuario">Usuário </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtUsuario" name="txtUsuario" class="form-control" placeholder="Usuário">  
                  </div>
                </div>
                <div class="col-6" id="Status">
                  <label data-error="wrong" data-success="right" for="txtStatus">Status </label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtStatus" name="txtStatus" class="form-control" placeholder="Status">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Status" name="btn-Status" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Status" name="btn-limpa-Status" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>              

            </div>

            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>             
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../../footer.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.243.6.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/sisplan.js?versao=3.243.6.1"></script>
  <script src="utils/funcoes.js?versao=3.243.6.1"></script>
  <script src="utils/cookies.js?versao=3.243.6.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.243.6.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/driver.min.js?versao=3.243.6.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="config.js?versao=3.243.6.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ORDEM_COMPRA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/ordem_compra/acesso_ordem_compra/acesso_ordem_compra.js?versao=3.243.6.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>