$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma ordem de compra.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as ordens de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaOrdemCompra',
        popover: {
          title: 'Tabela Ordem Compra',
          description: 'Aqui estão os dados das ordens de compra cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

async function validaAlteraOrdemCompra(sNumero) {
  const dadosSelect = {
    tabela: 'CO_ITEN',
    camposSelect: ['CO_ITEN.NUMERO'],
    leftJoin: [{ tabela: 'COMPRA', condicao: 'COMPRA.NUMERO   = CO_ITEN.NUMERO' }],
    where: [`CO_ITEN.NUMERO = '${sNumero}' AND CO_ITEN.SITUACAO <> 'B' AND COMPRA.EMP_ID = ${getCookie('emp_id')}`]
  };
  const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
  if (!retornoSelect) {
    return;
  }
  if (retornoSelect.length > 0) {
    return true;
  }
  return false;
};

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORDEM_COMPRA");

  addFuncoesBotoes();
  await consultaOrdemCompra();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOrdemCompra();
  });

  $('#txtOrdemCompraConsulta').on('blur', function () {
    let OrdemCompra = $('#txtOrdemCompraConsulta').val();
    if (OrdemCompra.includes("[")) {
      OrdemCompra = pegaChave($('#txtOrdemCompraConsulta'));
    } else {
      OrdemCompra = $('#txtOrdemCompraConsulta').val();
    }
    OrdemCompra = OrdemCompra.replace('\w', '');
    const listaOrdemCompra = $('#txtListaOrdemCompra').val();
    if (OrdemCompra == '') {
      return;
    }
    $('#txtListaOrdemCompra').val((listaOrdemCompra == '') ? `'${OrdemCompra}'` : `${listaOrdemCompra},'${OrdemCompra}'`);
    $('#txtOrdemCompraConsulta').val('');
    $('#txtOrdemCompraConsulta').focus();
  });

  $('#txtOrdemCompraConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtOrdemCompraConsulta').trigger('blur');
      $('#txtOrdemCompraConsulta').focus();
    }
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "ordem_compra/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();
      if (await validaAlteraOrdemCompra(data[0])) {
        window.location.href = `ordem_compra/${btoa(data[0])}`;
      } else {
        msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-imprimirItem', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/acesso_ordem_compra?`;

      const filtros = retornaFiltros(`'${data[0]}'`);
      const ordem = `&TELA_ORDENACAO=acesso_ordem_compra&ORDEM_ORDENACAO=1`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrdemCompraA');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrdemCompraA');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  retornaHintRelatorio('btnImprimir','RelOrdemCompraA')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/acesso_ordem_compra?`;

        const filtros = retornaFiltros();
        const ordem = `&TELA_ORDENACAO=acesso_ordem_compra&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelOrdemCompraA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelOrdemCompraA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaOrdemCompra').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaOrdemCompra').DataTable().row($(this)).data();
      if (await validaAlteraOrdemCompra(data[0])) {
        window.location.href = `ordem_compra/${btoa(data[0])}`;
      } else {
        msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOrdemCompra').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaOrdemCompra").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $("#tabelaOrdemCompra").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaOrdemCompra').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'ORDEM_COMPRA');
  })

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" id="btn-imprimirItem">Imprimir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
      '</div>';

    retornaHintRelatorio('btn-imprimirItem','RelOrdemCompraA')
    return retorno;
  };


  function retornaFiltros(sNumero = '') {
    const numero = $('#txtListaOrdemCompra').val();
    const codFor = pegaChave('#txtFornecedor');
    const usuario = pegaValor('#txtUsuario');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();
    const empid = getCookie('emp_id');
    const status = pegaChave('#txtStatus');

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&CODFOR=${codFor}` +
      `&USUARIOCADASTRO=${usuario}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&EMP_ID=${empid}` +
      `&STATUS=${status}`;

    return filtros;
  };

  async function consultaOrdemCompra() {
    try {
      $.LoadingOverlay("show");
      let where = '';
      where = ` AND COMPRA.EMP_ID = ${getCookie('emp_id')}`;
      where += pegaChave('#txtListaOrdemCompra') != '' ? ` AND COMPRA.NUMERO IN (${$('#txtListaOrdemCompra').val()})` : '';
      where += pegaChave('#txtFornecedor') != '' ? ` AND COMPRA.CODFOR = '${pegaChave('#txtFornecedor')}'` : '';
      where += pegaValor('#txtUsuario') != '' ? ` AND COMPRA.USUARIO = '${pegaValor('#txtUsuario')}'` : '';
      where += pegaChave('#txtStatus') != '' ? ` AND COMPRA.STATUS = '${pegaChave('#txtStatus')}'` : '';

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and COMPRA.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and COMPRA.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }

      $("#tabelaOrdemCompra").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{ "tabela":"COMPRA", "camposSelect":["COMPRA.NUMERO", "ENTIDADE.NOME"], 
                    "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = COMPRA.CODFOR"}],                                 
                    "where": ["1=1 ${where}"]}`,
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const response = await requisicao('DELETE', '/sisplan/ordem_compra/v1/ordem_compra?', `NUMERO=${encodeURIComponent(valorLinha[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  function addFuncoesBotoes() {
    $('#btn-limpa-OrdemCompra').on('click', function () {
      $('#txtListaOrdemCompra').val('');
    });

    $("#btn-OrdemCompraConsulta").pesquisa_serverside(["#txtOrdemCompraConsulta"], ["NUMERO"], ["CODFOR"], `{"tabela":"COMPRA", "camposSelect":[ "NUMERO", "CODFOR" ]}`, "Pesquisa Ordem Compra");

    $("#txtFornecedor").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"]}`);
    $("#txtStatus").autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"]}`);
    $("#btn-Fornecedor").pesquisa_serverside(["#txtFornecedor"], ["CODIGO"], ["NOME"], `{"tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ]}`, "Pesquisa Fornecedor");
    $("#btn-Status").pesquisa_serverside(["#txtStatus"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Status");
    $('#btn-limpa-Fornecedor').on('click', function () { $('#txtFornecedor').val(''); });
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val(''); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtOrdemCompraConsulta').val('');
      $('#txtListaOrdemCompra').val('');
      $('#txtFornecedor').val('');
      $("#txtDataEmiDe").val("1200-01-01");
      $("#txtDataEmiAte").val("2500-12-01");
      $("#txtUsuario").val('');
      $('#txtStatus').val('');
    });
  };

});