$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([{
      element: '#formcard1',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDesc',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#selectMovimentacaoEstoque',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDepositoSaida',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtQualidade',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDepositoEntrada',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtTipoMovimentacao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnVoltar',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a tela de consulta.',
        position: 'left'
      }
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a operação fiscal.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {


  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('OPERACAOFISCAL', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/operacaofiscal`;
  });

  $(document).ready(function () {

    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtDesc: {
          required: true,
        },
        selectMovimentacaoEstoque: {
          required: true,
        },
        txtQualidade: {
          required: true,
        },
        txtTipoMovimentacao: {
          required: true,
        }
      },
      messages: {
        txtDesc: {
          required: "Informe uma descrição válido."
        },
        selectMovimentacaoEstoque: {
          required: "Selecione uma opção."
        },
        txtQualidade: {
          required: "Informe uma qualidade válida."
        },
        txtTipoMovimentacao: {
          required: "Informe uma movimentação válida."
        }
      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });

    $('.radio-group .radio').click(function () {
      $(this).parent().find('.radio').removeClass('selected');
      $(this).addClass('selected');
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $('#txtCodigo').prop('disabled', true);

  $('#txtDepositoSaida').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnDepositoSaida').pesquisa('#txtDepositoSaida', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Depósito', 'deposito');
  $('#btnADepositoSaida').on('click', function () {
    $('#txtDepositoSaida').val('');
  });

  $('#txtDepositoEntrada').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnDepositoEntrada').pesquisa('#txtDepositoEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Depósito', 'deposito');
  $('#btnADepositoEntrada').on('click', function () {
    $('#txtDepositoEntrada').val('');
  });

  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"tabqul", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnQualidade').pesquisa('#txtQualidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabqul", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Qualidade', 'tabqul');
  $('#btnAQualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#txtTipoMovimentacao').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnTipoMovimentacao').pesquisa('#txtTipoMovimentacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabbai", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Tipo de Movimentação', 'tabbai');
  $('#btnATipoMovimentacao').on('click', function () {
    $('#txtTipoMovimentacao').val('');
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let operacaofiscal = parametros[parametros.length - 1];

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('OPERACAOFISCAL', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/operacaofiscal`;
  });

  if (operacaofiscal != '' && operacaofiscal != 'create') {

    // if (await liberarRegistro('OPERACAOFISCAL', operacaofiscal) == false) {
    //     window.location.href = '../operacaofiscal';
    // } else {

    try {
      $.LoadingOverlay("show");

      try {
        let response1 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
          `JSON={ "tabela":"oper_fiscal", 
                            "camposSelect":["codigo", "descricao", "mov_est", "deposito_saida", "deposito_entrada", "qualidade", "tipo_mov", "tipo", "presenca", "tp_frete"], 
                            "where": ["codigo = '${operacaofiscal}'"]}`, null);

        if (!response1) {
          return;
        }
        let jsonStr = await response1.json();
        if (response1.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
        $('#txtDesc').val(jsonStr.RESULT[0][0].DESCRICAO);
        $('#selectMovimentacaoEstoque').val(jsonStr.RESULT[0][0].MOV_EST);
        $('#rgPresenca').val(jsonStr.RESULT[0][0].PRESENCA).change();
        $('#txtTipoFrete').val(jsonStr.RESULT[0][0].TP_FRETE).change();

        if (jsonStr.RESULT[0][0].TIPO == 'E') {
          $('#radioEntrada').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].TIPO == 'S') {
          $('#radioSaida').prop('checked', true);
        }

        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"tabbai", 
                            "camposSelect":["descricao"], 
                            "where": ["codigo = '${jsonStr.RESULT[0][0].TIPO_MOV}'"]}`, null);

          let jsonString = await response.json();

          insereValor('#txtTipoMovimentacao', jsonStr.RESULT[0][0].TIPO_MOV, jsonString.RESULT[0][0].DESCRICAO);

        } catch (error) {
          console.error(error);
        }

        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"tabqul", 
                            "camposSelect":["descricao"], 
                            "where": ["codigo = '${jsonStr.RESULT[0][0].QUALIDADE}'"]}`, null);

          let jsonString = await response.json();

          insereValor('#txtQualidade', jsonStr.RESULT[0][0].QUALIDADE, jsonString.RESULT[0][0].DESCRICAO);

        } catch (error) {
          console.error(error);
        }

        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"deposito", 
                            "camposSelect":["descricao"], 
                            "where": ["codigo = '${jsonStr.RESULT[0][0].DEPOSITO_SAIDA}'"]}`, null);

          let jsonString = await response.json();

          insereValor('#txtDepositoSaida', jsonStr.RESULT[0][0].DEPOSITO_SAIDA, jsonString.RESULT[0][0].DESCRICAO);

        } catch (error) {
          console.error(error);
        }

        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"deposito", 
                            "camposSelect":["descricao"], 
                            "where": ["codigo = '${jsonStr.RESULT[0][0].DEPOSITO_ENTRADA}'"]}`, null);

          let jsonString = await response.json();

          insereValor('#txtDepositoEntrada', jsonStr.RESULT[0][0].DEPOSITO_ENTRADA, jsonString.RESULT[0][0].DESCRICAO);

        } catch (error) {
          console.error(error);
        }

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados:`);
      }

    } finally {
      $.LoadingOverlay('hide');
    }
    // }
  };


  $("#gravar").click(
    async function () {
      try {
        $.LoadingOverlay("show");

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
          try {
            let operacaofiscalClasse = {};

            operacaofiscalClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('OPER_FISCAL', 'OPER_FISCAL', 'CODIGO', 0) : $('#txtCodigo').val();
            operacaofiscalClasse.DESCRICAO = $('#txtDesc').val();
            operacaofiscalClasse.MOV_EST = $('#selectMovimentacaoEstoque').val();
            operacaofiscalClasse.DEPOSITO_SAIDA = pegaChave('#txtDepositoSaida', operacaofiscalClasse.DEPOSITO_SAIDA);
            operacaofiscalClasse.DEPOSITO_ENTRADA = pegaChave('#txtDepositoEntrada', operacaofiscalClasse.DEPOSITO_ENTRADA);
            operacaofiscalClasse.QUALIDADE = pegaChave('#txtQualidade', operacaofiscalClasse.QUALIDADE);
            operacaofiscalClasse.TIPO_MOV = pegaChave('#txtTipoMovimentacao', operacaofiscalClasse.TIPO_MOV);
            operacaofiscalClasse.PRESENCA = $('#rgPresenca').val();
            operacaofiscalClasse.TP_FRETE = $("#txtTipoFrete").val();

            if ($('#radioEntrada').prop('checked')) {
              operacaofiscalClasse.TIPO = 'E';
              if ($('#txtDepositoEntrada').val() == '') {
                msgAlerta('Tipo entrada selecionado, precisa preencher o Depósito entrada!');
                return;
              }
            }
            if ($('#radioSaida').prop('checked')) {
              operacaofiscalClasse.TIPO = 'S';
              if ($('#txtDepositoSaida').val() == '') {
                msgAlerta('Tipo saída selecionado, precisa preencher o Depósito saída!');
                return;
              }
            }

            let response = await requisicao('POST', '/Sisplan/Cadastros/v1/OperacaoFiscal?', `JSON=${encodeURIComponent(JSON.stringify(operacaofiscalClasse))}`, null);

            if (!response) {
              return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return;
            }
            toastr.success(
              `Cadastro efetuado com sucesso!
                        Operação: ${operacaofiscalClasse.CODIGO}`,
              'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/operacaofiscal`;
              }
            }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          } catch (error) {
            console.error(error);
            msgErro(`Não foi possível gravar os dados da operacao fiscal`);
          }
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    });
});