async function avancarPag() {
    if ($("#txtCodigo").val() == '') {
        $("#txtCodigo").val(' ');
    }
    if ($("#txtDesc").val() == '') {
        $("#txtDesc").val(' ');
    }
    if ($("#selectSaiEnt").val() == '') {
        $("#selectSaiEnt").val(1);
    }
    if ($("#selectTipo").val() == '') {
        $("#selectTipo").val('V');
    }
    if ($("#selectGeraDup").val() == '') {
        $("#selectGeraDup").val('S');
    }
    if ($("#selectNf").val() == '') {
        $("#selectNf").val(1);
    }
    if ($("#txtAliquota").val() == '') {
        $("#txtAliquota").val('0');
    }

}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'gravar')) {
                    $('.driver-next-btn').on('click', location.reload());
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'configuracao') {
                    $('#voltar3').trigger('click');
                }
                if (Element.node.id == 'formcard1') {
                    $('.driver-close-btn').on('click', location.reload());
                };
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#selectSaiEnt',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#selectTipo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#selectGeraDup',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#selectNf',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtAliquota',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#configuracao',
            popover: {
                title: 'Configurações da Natureza',
                description: 'Aqui você selecionará algumas configurações.',
                position: 'top'
            }
        },
        {
            element: "#voltar3",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a aba geral.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a natureza.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtAliquota').blur(function () {
        if ($('#txtAliquota').val() == '0.00') {
            $('#txtAliquota').val('0');
        }
    });

    $('#txtPercAjuste').blur(function () {
        if ($('#txtPercAjuste').val() == '0.00') {
            $('#txtPercAjuste').val('0');
        }
    });

    $('#txtAliquota').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPercAjuste').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPercReducao').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPercDife').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtAliquota').change(async function () {
        if ($('#txtAliquota').val() == '') {
            $('#txtAliquota').val('0.00');
        }
    });

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('NATUREZA', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/natureza`;
    });

    $('#tabela-empAcesso').on('click', 'td', function () {
        selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
    });

    $(document).ready(function () {

        let currentFs; let nextFs; let previousFs; // fieldsets
        let opacity;

        $(".next").click(function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            $("#msform").validate().element("#selectTipo");
            $("#msform").validate().element("#selectGeraDup");
            $("#msform").validate().element("#selectNf");

            if (!$("#msform").validate().element("#selectTipo") ||
                !$("#msform").validate().element("#selectGeraDup") ||
                !$("#msform").validate().element("#selectNf")) {
                erros += 1;
            }

            if (erros == 0) {

                currentFs = $(this).parent();
                nextFs = $(this).parent().next();

                $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0
                }, {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            'display': 'none',
                            'position': 'relative'
                        });
                        nextFs.css({
                            'opacity': opacity
                        });
                    },
                    duration: 600
                });
                $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);
            }
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDesc: {
                    required: true,
                },
                selectSaiEnt: {
                    required: true,
                },
                selectTipo: {
                    required: true,
                },
                selectGeraDup: {
                    required: true,
                },
                selectNf: {
                    required: true,
                },
                txtAliquota: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDesc: {
                    required: "Informe uma descrição válida."
                },
                selectSaiEnt: {
                    required: "Selecione uma opção."
                },
                selectTipo: {
                    required: "Selecione uma opção."
                },
                selectGeraDup: {
                    required: "Selecione uma opção."
                },
                selectNf: {
                    required: "Selecione uma opção."
                },
                txtAliquota: {
                    required: "Informe uma alíquota válida."
                }

            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $(".previous").click(function () {

            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();
            $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
            previousFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#txtCstIcms').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstPis').autocompleta(1, `JSON={ "tabela":"TABPIS", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpi').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstCofins').autocompleta(1, `JSON={ "tabela":"TABCOFINS", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNcm').autocompleta(1, `JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCsosn').autocompleta(1, `JSON={ "tabela":"TABCSOSN", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEnqIpi').autocompleta(1, `JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContabilizacao').autocompleta(1, `JSON={ "tabela":"NAT_CONTA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#btnCstIcms').pesquisa('#txtCstIcms', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'tabtri');
    $('#btnACstIcms').on('click', function () {
        $('#txtCstIcms').val('');
    });
    $('#btnCstPis').pesquisa('#txtCstPis', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPIS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST PIS', 'TABPIS');
    $('#btnACstPis').on('click', function () {
        $('#txtCstPis').val('');
    });
    $('#btnCstIpi').pesquisa('#txtCstIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST IPI', 'TABIPI');
    $('#btnACstIpi').on('click', function () {
        $('#txtCstIpi').val('');
    });
    $('#btnCstCofins').pesquisa('#txtCstCofins', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABCOFINS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST COFINS', 'TABCOFINS');
    $('#btnACstCofins').on('click', function () {
        $('#txtCstCofins').val('');
    });
    $('#btnNcm').pesquisa('#txtNcm', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa NCM', 'TABFIS');
    $('#btnANcm').on('click', function () {
        $('#txtNcm').val('');
    });
    $('#btnCsosn').pesquisa('#txtCsosn', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABCSOSN", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CSOSN', 'TABCSOSN');
    $('#btnACsosn').on('click', function () {
        $('#txtCsosn').val('');
    });
    $('#btnEnqIpi').pesquisa('#txtEnqIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Enquadramento IPI', 'ENQUADRA');
    $('#btnAEnqIpi').on('click', function () {
        $('#txtEnqIpi').val('');
    });
    $('#btnConsultaContabil').pesquisa('#txtContabilizacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NAT_CONTA", "camposSelect":[ "codigo", "descricao", "conta_c", "conta_d", "tipo"]}`, 'Pesquisa Contabilização', 'NAT_CONTA');
    $('#btnLimpaConsultaContabil').on('click', function () {
        $('#txtContabilizacao').val('');
    });

    $('#tabela-empAcesso').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollY: '300px',
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let achaNatureza = queryString.indexOf('natureza/') + 9; // + 8 porque é a soma do "receber/""
    let natureza = queryString.substr(achaNatureza, queryString.length);
    if (natureza != "create") {
        natureza = atob(natureza);
    }

    await preencheEmpresas();

    let numero = natureza;

    let naturezaDuplicada = String(localStorage.getItem('naturezaDuplicada')).replace('null','')

    localStorage.removeItem('naturezaDuplicada')

    if (natureza != '' && natureza != 'create' && naturezaDuplicada == '') {

        if (await liberarRegistro('NATUREZA', natureza) == false) {
            window.location.href = '../natureza';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"natureza", 
                    "camposSelect":["natureza", "descricao", "aliquota", "perc_ajus_icms", "perc_reduz", "perc_dif", "mensagem"
                                   ,"tp_base", "tipo", "dupli", "tp_nat", "finalidade_nfe", "icms", "ipi"
                                   , "clatrib", "clapis", "claipi", "clacofins", "clafis", "csosn", "enquadra"
                                   , "ativo", "NAO_GERA_DIFAL", "FORCA_VENDA", "BAIXAR_PEDIDO", "PIS_COFINS", "SUBST_TRIB"
                                   , "MOV_EST", "FCI", "INF_IMPORTACAO", "LAUDO", "FICHA_SEGURANCA", "PERC_ICMS_RET_IND"
                                   , "ROMANEIO", "DESC_ICMS_BASEPIS", "BLOQ_PISCOFINS", "BLOQ_SERVRET", "OBRIGA_OC", "OBRIGA_NOTAREF"
                                   , "OBRIGA_LOTE", "OBRIGA_VOLUME", "CONTR_ESTOQ_TERC", "GERA_RET_SPED", "PRECO_SUGERIDO", "APLICA_DESC"
                                   , "ICMS_DENTRO", "OBRIGA_RETINDUS", "CONTA_ORDEM", "COD_BENEF", "NAT_CONT"
                                ], 
                    "where": ["natureza = '${natureza}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    if (jsonStr.RESULT[0][0].CONTA_ORDEM == 'S') {
                        $('#checkObrigarClienteConta').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].OBRIGA_RETINDUS == 'S') {
                        $('#checkObrigaroAssociarRetorno').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].ICMS_DENTRO == 'S') {
                        $('#checkCalculoIcmsDifal').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].APLICA_DESC == 'S') {
                        $('#checkAplicaDesc').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].PRECO_SUGERIDO == 'S') {
                        $('#checkConsPrecoSug').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].GERA_RET_SPED == 'S') {
                        $('#checkRegEspTrib').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].CONTR_ESTOQ_TERC == 'S') {
                        $('#checkControleEstTerc').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].OBRIGA_VOLUME == 'S') {
                        $('#checkObrigarInfVol').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].OBRIGA_LOTE == 'S') {
                        $('#checkObrigarInfLote').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].OBRIGA_NOTAREF == 'S') {
                        $('#checkObrigarInfNota').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].OBRIGA_OC == 'S') {
                        $('#checkObrigarOrdemCompra').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].BLOQ_SERVRET == 'S') {
                        $('#checkBloqAbaServ').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].BLOQ_PISCOFINS == 'S') {
                        $('#checkBloqAbaGeral').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].DESC_ICMS_BASEPIS == 'S') {
                        $('#checkDescIcmsBase').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].ROMANEIO == 'S') {
                        $('#checkRomaneio').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].PERC_ICMS_RET_IND == 'S') {
                        $('#checkManterPercIcms').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].FICHA_SEGURANCA == 'S') {
                        $('#checkFichaSeguranca').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].LAUDO == 'S') {
                        $('#checkLaudoTec').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].INF_IMPORTACAO == 'S') {
                        $('#checkInfoImpor').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].FCI == 'S') {
                        $('#checkFci').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].MOV_EST == 'S') {
                        $('#checkMovEstoque').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].SUBST_TRIB == 'S') {
                        $('#checkSubstituicaoTrib').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].PIS_COFINS == 'S') {
                        $('#checkPisCofins').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].BAIXAR_PEDIDO == 'S') {
                        $('#checkBaixarPedido').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].FORCA_VENDA == 'S') {
                        $('#checkForcaDeVendas').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].NAO_GERA_DIFAL == 'S') {
                        $('#checkNaoGeraDifal').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].ICMS == 1) {
                        $('#radioBaseIcms').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].ICMS == 2) {
                        $('#radioIsentaIcms').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].ICMS == 3) {
                        $('#radioOutraIcms').prop('checked', true);
                    }

                    if (jsonStr.RESULT[0][0].IPI == 1) {
                        $('#radioBaseIpi').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].IPI == 2) {
                        $('#radioIsentaIpi').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].IPI == 3) {
                        $('#radioOutraIpi').prop('checked', true);
                    }

                    $('#txtCodigo').attr('readonly', true);

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].NATUREZA);
                    $('#txtDesc').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtMsg').val(jsonStr.RESULT[0][0].MENSAGEM);

                    if (jsonStr.RESULT[0][0].ALIQUOTA != 0) {
                        $('#txtAliquota').val(jsonStr.RESULT[0][0].ALIQUOTA);
                    };
                    if (jsonStr.RESULT[0][0].PERC_AJUS_ICMS != 0) {
                        $('#txtPercAjuste').val(jsonStr.RESULT[0][0].PERC_AJUS_ICMS);
                    };
                    $('#txtPercReducao').val(jsonStr.RESULT[0][0].PERC_REDUZ);
                    $('#txtPercDife').val(jsonStr.RESULT[0][0].PERC_DIF);

                    $('#selectSaiEnt').val(jsonStr.RESULT[0][0].TP_BASE);
                    $('#selectTipo').val(jsonStr.RESULT[0][0].TIPO);
                    $('#selectGeraDup').val(jsonStr.RESULT[0][0].DUPLI);
                    $('#selectTipoNat').val(jsonStr.RESULT[0][0].TP_NAT);
                    $('#selectNf').val(jsonStr.RESULT[0][0].FINALIDADE_NFE);
                    $('#txtCod_Benef').val(jsonStr.RESULT[0][0].COD_BENEF);
                    $('#txtContabilizacao').val(jsonStr.RESULT[0][0].NAT_CONT)

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"ENQUADRA", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].ENQUADRA}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtEnqIpi', jsonStr.RESULT[0][0].ENQUADRA, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"TABCSOSN", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CSOSN}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtCsosn', jsonStr.RESULT[0][0].CSOSN, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"TABFIS", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CLAFIS}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtNcm', jsonStr.RESULT[0][0].CLAFIS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"TABCOFINS", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CLACOFINS}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtCstCofins', jsonStr.RESULT[0][0].CLACOFINS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"TABIPI", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CLAIPI}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtCstIpi', jsonStr.RESULT[0][0].CLAIPI, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"TABPIS", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CLAPIS}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtCstPis', jsonStr.RESULT[0][0].CLAPIS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"TABTRI", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].CLATRIB}'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtCstIcms', jsonStr.RESULT[0][0].CLATRIB, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"EMP_VALOR", 
                        "camposSelect":["emp_id"], 
                        "where": ["VALOR = '${natureza}' and TABELA = 'NATUREZA' and CAMPO = 'NATUREZA'"]}`, null);

                        if (!responseOperadora) {
                            return;
                        }
                        let jsonStrOperadora = await responseOperadora.json();
                        if (responseOperadora.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }

                        jsonStrOperadora.RESULT[0].map((empRegra) => {
                            $('#tabela-empAcesso').DataTable().rows().data().map((empresa, index) => {
                                if (empRegra.EMP_ID == empresa[1].split(' - ')[0]) {
                                    $($('.checkEmpresa')[index]).prop('checked', true);
                                    $($("table#tabela-empAcesso tr")[index + 1]).addClass("selected");
                                }
                            });
                        });

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        let responseNatCont = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"NAT_CONTA", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].NAT_CONT}'"]}`, null);

                        if (!responseNatCont) {
                            return;
                        }
                        let jsonStrNatCont = await responseNatCont.json();
                        if (responseNatCont.status != 200) {
                            msgErro(jsonStrNatCont.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtContabilizacao', jsonStr.RESULT[0][0].NAT_CONT, jsonStrNatCont.RESULT[0][0].DESCRICAO);

                    } catch (error) {
                        console.error(error);
                    }


                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da natureza: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    } else if (natureza == 'create' && naturezaDuplicada != ''){
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"natureza", 
                "camposSelect":["natureza", "descricao", "aliquota", "perc_ajus_icms", "perc_reduz", "perc_dif", "mensagem"
                               ,"tp_base", "tipo", "dupli", "tp_nat", "finalidade_nfe", "icms", "ipi"
                               , "clatrib", "clapis", "claipi", "clacofins", "clafis", "csosn", "enquadra"
                               , "ativo", "NAO_GERA_DIFAL", "FORCA_VENDA", "BAIXAR_PEDIDO", "PIS_COFINS", "SUBST_TRIB"
                               , "MOV_EST", "FCI", "INF_IMPORTACAO", "LAUDO", "FICHA_SEGURANCA", "PERC_ICMS_RET_IND"
                               , "ROMANEIO", "DESC_ICMS_BASEPIS", "BLOQ_PISCOFINS", "BLOQ_SERVRET", "OBRIGA_OC", "OBRIGA_NOTAREF"
                               , "OBRIGA_LOTE", "OBRIGA_VOLUME", "CONTR_ESTOQ_TERC", "GERA_RET_SPED", "PRECO_SUGERIDO", "APLICA_DESC"
                               , "ICMS_DENTRO", "OBRIGA_RETINDUS", "CONTA_ORDEM", "COD_BENEF", "NAT_CONT"
                            ], 
                "where": ["natureza = '${naturezaDuplicada}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                if (jsonStr.RESULT[0][0].CONTA_ORDEM == 'S') {
                    $('#checkObrigarClienteConta').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].OBRIGA_RETINDUS == 'S') {
                    $('#checkObrigaroAssociarRetorno').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].ICMS_DENTRO == 'S') {
                    $('#checkCalculoIcmsDifal').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].APLICA_DESC == 'S') {
                    $('#checkAplicaDesc').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].PRECO_SUGERIDO == 'S') {
                    $('#checkConsPrecoSug').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].GERA_RET_SPED == 'S') {
                    $('#checkRegEspTrib').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].CONTR_ESTOQ_TERC == 'S') {
                    $('#checkControleEstTerc').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].OBRIGA_VOLUME == 'S') {
                    $('#checkObrigarInfVol').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].OBRIGA_LOTE == 'S') {
                    $('#checkObrigarInfLote').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].OBRIGA_NOTAREF == 'S') {
                    $('#checkObrigarInfNota').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].OBRIGA_OC == 'S') {
                    $('#checkObrigarOrdemCompra').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].BLOQ_SERVRET == 'S') {
                    $('#checkBloqAbaServ').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].BLOQ_PISCOFINS == 'S') {
                    $('#checkBloqAbaGeral').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].DESC_ICMS_BASEPIS == 'S') {
                    $('#checkDescIcmsBase').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].ROMANEIO == 'S') {
                    $('#checkRomaneio').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].PERC_ICMS_RET_IND == 'S') {
                    $('#checkManterPercIcms').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].FICHA_SEGURANCA == 'S') {
                    $('#checkFichaSeguranca').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].LAUDO == 'S') {
                    $('#checkLaudoTec').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].INF_IMPORTACAO == 'S') {
                    $('#checkInfoImpor').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].FCI == 'S') {
                    $('#checkFci').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].MOV_EST == 'S') {
                    $('#checkMovEstoque').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].SUBST_TRIB == 'S') {
                    $('#checkSubstituicaoTrib').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].PIS_COFINS == 'S') {
                    $('#checkPisCofins').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].BAIXAR_PEDIDO == 'S') {
                    $('#checkBaixarPedido').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].FORCA_VENDA == 'S') {
                    $('#checkForcaDeVendas').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].NAO_GERA_DIFAL == 'S') {
                    $('#checkNaoGeraDifal').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                    $('#checkAtivo').prop('checked', true);
                }

                if (jsonStr.RESULT[0][0].ICMS == 1) {
                    $('#radioBaseIcms').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].ICMS == 2) {
                    $('#radioIsentaIcms').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].ICMS == 3) {
                    $('#radioOutraIcms').prop('checked', true);
                }

                if (jsonStr.RESULT[0][0].IPI == 1) {
                    $('#radioBaseIpi').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].IPI == 2) {
                    $('#radioIsentaIpi').prop('checked', true);
                }
                if (jsonStr.RESULT[0][0].IPI == 3) {
                    $('#radioOutraIpi').prop('checked', true);
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].NATUREZA);
                $('#txtDesc').val(jsonStr.RESULT[0][0].DESCRICAO);
                $('#txtMsg').val(jsonStr.RESULT[0][0].MENSAGEM);

                if (jsonStr.RESULT[0][0].ALIQUOTA != 0) {
                    $('#txtAliquota').val(jsonStr.RESULT[0][0].ALIQUOTA);
                };
                if (jsonStr.RESULT[0][0].PERC_AJUS_ICMS != 0) {
                    $('#txtPercAjuste').val(jsonStr.RESULT[0][0].PERC_AJUS_ICMS);
                };
                $('#txtPercReducao').val(jsonStr.RESULT[0][0].PERC_REDUZ);
                $('#txtPercDife').val(jsonStr.RESULT[0][0].PERC_DIF);

                $('#selectSaiEnt').val(jsonStr.RESULT[0][0].TP_BASE);
                $('#selectTipo').val(jsonStr.RESULT[0][0].TIPO);
                $('#selectGeraDup').val(jsonStr.RESULT[0][0].DUPLI);
                $('#selectTipoNat').val(jsonStr.RESULT[0][0].TP_NAT);
                $('#selectNf').val(jsonStr.RESULT[0][0].FINALIDADE_NFE);
                $('#txtCod_Benef').val(jsonStr.RESULT[0][0].COD_BENEF);
                $('#txtContabilizacao').val(jsonStr.RESULT[0][0].NAT_CONT)

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ENQUADRA", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].ENQUADRA}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtEnqIpi', jsonStr.RESULT[0][0].ENQUADRA, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABCSOSN", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CSOSN}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtCsosn', jsonStr.RESULT[0][0].CSOSN, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABFIS", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CLAFIS}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtNcm', jsonStr.RESULT[0][0].CLAFIS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABCOFINS", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CLACOFINS}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtCstCofins', jsonStr.RESULT[0][0].CLACOFINS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CLAIPI}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtCstIpi', jsonStr.RESULT[0][0].CLAIPI, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABPIS", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CLAPIS}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtCstPis', jsonStr.RESULT[0][0].CLAPIS, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABTRI", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CLATRIB}'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtCstIcms', jsonStr.RESULT[0][0].CLATRIB, jsonStrOperadora.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"EMP_VALOR", 
                    "camposSelect":["emp_id"], 
                    "where": ["VALOR = '${natureza}' and TABELA = 'NATUREZA' and CAMPO = 'NATUREZA'"]}`, null);

                    if (!responseOperadora) {
                        return;
                    }
                    let jsonStrOperadora = await responseOperadora.json();
                    if (responseOperadora.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }

                    jsonStrOperadora.RESULT[0].map((empRegra) => {
                        $('#tabela-empAcesso').DataTable().rows().data().map((empresa, index) => {
                            if (empRegra.EMP_ID == empresa[1].split(' - ')[0]) {
                                $($('.checkEmpresa')[index]).prop('checked', true);
                                $($("table#tabela-empAcesso tr")[index + 1]).addClass("selected");
                            }
                        });
                    });

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseNatCont = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"NAT_CONTA", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].NAT_CONT}'"]}`, null);

                    if (!responseNatCont) {
                        return;
                    }
                    let jsonStrNatCont = await responseNatCont.json();
                    if (responseNatCont.status != 200) {
                        msgErro(jsonStrNatCont.RESULT[0].mensagem);
                        return;
                    }

                    insereValor('#txtContabilizacao', jsonStr.RESULT[0][0].NAT_CONT, jsonStrNatCont.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try{
                    $('#txtCodigo').focus()
                } catch(err){
                    console.error(err)
                }

                $('.checkEmpresa').trigger('click');
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da natureza: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    } else {
        $('.checkEmpresa').trigger('click');
    }

    $('#txtCodigo').change(async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"natureza", 
                "camposSelect":["natureza"], 
                "where": ["natureza = '${$('#txtCodigo').val()}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (jsonStr.RESULT[0].length > 0) {
                    msgAlerta('Natureza já cadastrada.');
                    $('#txtCodigo').val('');
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#txtCodigo').on('blur', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"natureza", 
                "camposSelect":["natureza"], 
                "where": ["natureza = '${$('#txtCodigo').val()}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (jsonStr.RESULT[0].length > 0) {
                    msgAlerta('Natureza já cadastrada.');
                    $('#txtCodigo').val('');
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function preencheEmpresas() {
        let dataSet = await RetornaEmpresas();
        $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
        for (let i = 0; i < dataSet.length; i++) {
            const empresa = dataSet[i];
            $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_ID} - ${empresa.EMP_NOME} - ${empresa.EMP_PAT}`]).draw(false);
        }
    }

    async function RetornaEmpresas() {
        let _url = `/sisplan/funcoes/v1/pesquisa?`;
        let _params = `JSON={"tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME", "REPLACE(EMP_PAT, '_', '') EMP_PAT"], "where": null}`;

        try {
            let response = await requisicao('GET', _url, _params, null);

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as empresas.');
            return '';
        }
    }

    function botaoSelecionarGrid() {
        return '<div class="form-check icheck-primary">' +
            '<input type="checkbox" class="align-self-center checkEmpresa" value""><label></label>' +
            '</div>';
    };

    $("#gravar").click(

        async function () {

            try {
                $.LoadingOverlay("show");

                let naturezaClasse = {};

                naturezaClasse.NATUREZA = $('#txtCodigo').val();
                naturezaClasse.DESCRICAO = $('#txtDesc').val();
                naturezaClasse.ALIQUOTA = $('#txtAliquota').val();
                naturezaClasse.PERC_AJUS_ICMS = $('#txtPercAjuste').val();
                naturezaClasse.PERC_REDUZ = $('#txtPercReducao').val();
                naturezaClasse.PERC_DIF = $('#txtPercDife').val();
                naturezaClasse.MENSAGEM = $('#txtMsg').val();
                naturezaClasse.TP_BASE = $('#selectSaiEnt').val();
                naturezaClasse.TIPO = $('#selectTipo').val();
                naturezaClasse.DUPLI = $('#selectGeraDup').val();
                naturezaClasse.TP_NAT = $('#selectTipoNat').val();
                naturezaClasse.FINALIDADE_NFE = $('#selectNf').val();
                

                if ($('#radioBaseIcms').prop('checked')) {
                    naturezaClasse.ICMS = '1';
                }
                if ($('#radioIsentaIcms').prop('checked')) {
                    naturezaClasse.ICMS = '2';
                }
                if ($('#radioOutraIcms').prop('checked')) {
                    naturezaClasse.ICMS = '3';
                }
                if ($('#radioBaseIpi').prop('checked')) {
                    naturezaClasse.IPI = '1';
                }
                if ($('#radioIsentaIpi').prop('checked')) {
                    naturezaClasse.IPI = '2';
                }
                if ($('#radioOutraIpi').prop('checked')) {
                    naturezaClasse.IPI = '3';
                }

                naturezaClasse.CLATRIB = pegaChave($('#txtCstIcms').val(), naturezaClasse.CLATRIB);
                naturezaClasse.CLAPIS = pegaChave($('#txtCstPis').val(), naturezaClasse.CLAPIS);
                naturezaClasse.CLAIPI = pegaChave($('#txtCstIpi').val(), naturezaClasse.CLAIPI);
                naturezaClasse.CLACOFINS = pegaChave($('#txtCstCofins').val(), naturezaClasse.CLACOFINS);
                naturezaClasse.CLAFIS = pegaChave($('#txtNcm').val(), naturezaClasse.CLAFIS);
                naturezaClasse.CSOSN = pegaChave($('#txtCsosn').val(), naturezaClasse.CSOSN);
                naturezaClasse.ENQUADRA = pegaChave($('#txtEnqIpi').val(), naturezaClasse.ENQUADRA);
                naturezaClasse.NAT_CONT = pegaChave($('#txtContabilizacao').val(), natureza.NAT_CONT);
                naturezaClasse.COD_BENEF = $('#txtCod_Benef').val();

                if ($('#checkAtivo').prop('checked')) {
                    naturezaClasse.ATIVO = 'S';
                } else {
                    naturezaClasse.ATIVO = 'N';
                }
                if ($('#checkNaoGeraDifal').prop('checked')) {
                    naturezaClasse.NAO_GERA_DIFAL = 'S';
                } else {
                    naturezaClasse.NAO_GERA_DIFAL = 'N';
                }
                if ($('#checkForcaDeVendas').prop('checked')) {
                    naturezaClasse.FORCA_VENDA = 'S';
                } else {
                    naturezaClasse.FORCA_VENDA = 'N';
                }
                if ($('#checkBaixarPedido').prop('checked')) {
                    naturezaClasse.BAIXAR_PEDIDO = 'S';
                } else {
                    naturezaClasse.BAIXAR_PEDIDO = 'N';
                }
                if ($('#checkPisCofins').prop('checked')) {
                    naturezaClasse.PIS_COFINS = 'S';
                } else {
                    naturezaClasse.PIS_COFINS = 'N';
                }
                if ($('#checkSubstituicaoTrib').prop('checked')) {
                    naturezaClasse.SUBST_TRIB = 'S';
                } else {
                    naturezaClasse.SUBST_TRIB = 'N';
                }
                if ($('#checkMovEstoque').prop('checked')) {
                    naturezaClasse.MOV_EST = 'S';
                } else {
                    naturezaClasse.MOV_EST = 'N';
                }
                if ($('#checkFci').prop('checked')) {
                    naturezaClasse.FCI = 'S';
                } else {
                    naturezaClasse.FCI = 'N';
                }
                if ($('#checkInfoImpor').prop('checked')) {
                    naturezaClasse.INF_IMPORTACAO = 'S';
                } else {
                    naturezaClasse.INF_IMPORTACAO = 'N';
                }
                if ($('#checkLaudoTec').prop('checked')) {
                    naturezaClasse.LAUDO = 'S';
                } else {
                    naturezaClasse.LAUDO = 'N';
                }
                if ($('#checkFichaSeguranca').prop('checked')) {
                    naturezaClasse.FICHA_SEGURANCA = 'S';
                } else {
                    naturezaClasse.FICHA_SEGURANCA = 'N';
                }
                if ($('#checkManterPercIcms').prop('checked')) {
                    naturezaClasse.PERC_ICMS_RET_IND = 'S';
                } else {
                    naturezaClasse.PERC_ICMS_RET_IND = 'N';
                }
                if ($('#checkRomaneio').prop('checked')) {
                    naturezaClasse.ROMANEIO = 'S';
                } else {
                    naturezaClasse.ROMANEIO = 'N';
                }
                if ($('#checkDescIcmsBase').prop('checked')) {
                    naturezaClasse.DESC_ICMS_BASEPIS = 'S';
                } else {
                    naturezaClasse.DESC_ICMS_BASEPIS = 'N';
                }
                if ($('#checkBloqAbaGeral').prop('checked')) {
                    naturezaClasse.BLOQ_PISCOFINS = 'S';
                } else {
                    naturezaClasse.BLOQ_PISCOFINS = 'N';
                }
                if ($('#checkBloqAbaServ').prop('checked')) {
                    naturezaClasse.BLOQ_SERVRET = 'S';
                } else {
                    naturezaClasse.BLOQ_SERVRET = 'N';
                }
                if ($('#checkObrigarOrdemCompra').prop('checked')) {
                    naturezaClasse.OBRIGA_OC = 'S';
                } else {
                    naturezaClasse.OBRIGA_OC = 'N';
                }
                if ($('#checkObrigarInfNota').prop('checked')) {
                    naturezaClasse.OBRIGA_NOTAREF = 'S';
                } else {
                    naturezaClasse.OBRIGA_NOTAREF = 'N';
                }
                if ($('#checkObrigarInfLote').prop('checked')) {
                    naturezaClasse.OBRIGA_LOTE = 'S';
                } else {
                    naturezaClasse.OBRIGA_LOTE = 'N';
                }
                if ($('#checkObrigarInfVol').prop('checked')) {
                    naturezaClasse.OBRIGA_VOLUME = 'S';
                } else {
                    naturezaClasse.OBRIGA_VOLUME = 'N';
                }
                if ($('#checkControleEstTerc').prop('checked')) {
                    naturezaClasse.CONTR_ESTOQ_TERC = 'S';
                } else {
                    naturezaClasse.CONTR_ESTOQ_TERC = 'N';
                }
                if ($('#checkRegEspTrib').prop('checked')) {
                    naturezaClasse.GERA_RET_SPED = 'S';
                } else {
                    naturezaClasse.GERA_RET_SPED = 'N';
                }
                if ($('#checkConsPrecoSug').prop('checked')) {
                    naturezaClasse.PRECO_SUGERIDO = 'S';
                } else {
                    naturezaClasse.PRECO_SUGERIDO = 'N';
                }
                if ($('#checkAplicaDesc').prop('checked')) {
                    naturezaClasse.APLICA_DESC = 'S';
                } else {
                    naturezaClasse.APLICA_DESC = 'N';
                }
                if ($('#checkCalculoIcmsDifal').prop('checked')) {
                    naturezaClasse.ICMS_DENTRO = 'S';
                } else {
                    naturezaClasse.ICMS_DENTRO = 'N';
                }
                if ($('#checkObrigaroAssociarRetorno').prop('checked')) {
                    naturezaClasse.OBRIGA_RETINDUS = 'S';
                } else {
                    naturezaClasse.OBRIGA_RETINDUS = 'N';
                }
                if ($('#checkObrigarClienteConta').prop('checked')) {
                    naturezaClasse.CONTA_ORDEM = 'S';
                } else {
                    naturezaClasse.CONTA_ORDEM = 'N';
                }

                let empresas = [];
                for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
                    let dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
                    empresas.push(dados[1].split(' - ')[0]);
                };

                naturezaClasse.EMPRESAS = empresas;

                let response = await requisicao('POST', '/Sisplan/Cadastros/v1/natureza?', `JSON=${encodeURIComponent(JSON.stringify(naturezaClasse))}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    `Cadastro da natureza: ${naturezaClasse.NATUREZA} efetuado com sucesso!`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/natureza`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da natureza: ${error}`);
            }
        });
});