$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir os dados consultados.",
          position: "right",
        },
      },
      {
        element: "#tabelaOrdemProducao",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das ordens de produção consultadas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("MOVIMENTACAOFACCAO");
  MontaPesquisa();

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.movimentacaoFaccao == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, movimentacaoFaccao: ['EMPRESA'] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#btnLimpaOrdemProducao').trigger('click');
    $('#btnLimpaProduto').trigger('click');
    $('#btnLimpaCliente').trigger('click');
    $('#btnLimpaPedido').trigger('click');
    $('#txtDataSaidaIni').val('1200-01-01');
    $('#txtDataSaidaFim').val('2500-12-31');
    $('#txtDataRetornoIni').val('1200-01-01');
    $('#txtDataRetornoFim').val('2500-12-31');
    $('#txtStatus').val('1');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaOrdemProducao').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.movimentacaoFaccao ?? ['EMPRESA']);
  })

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, movimentacaoFaccao: novasColunas }))

      $('#tabelaOrdemProducao').DataTable().columns().visible(true);

      $('#tabelaOrdemProducao').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  async function consultaOrdemProducao() {
    $.LoadingOverlay("show");
    try {
      if ($.fn.DataTable.isDataTable('#tabelaOrdemProducao')) {
        $('#tabelaOrdemProducao').DataTable().destroy();
        $('#tabelaOrdemProducao').empty();
      }
      const url = '/sisplan/movimentacaofaccao/v1/movimentacaofaccao?';
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, filtros, null, 50000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      const colunasItens = jsonStr.length > 0 ? Object.entries(jsonStr[0]).map(item => ({
        title: item[0],
        data: item[0]
      })) : [];

      $('#tabelaOrdemProducao').DataTable({
        // destroy: true,
        // lengthChange: false,
        // serverside: true,
        search: false,
        filter: false,
        order: [],
        sort: true,
        destroy: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr,
        "columns": colunasItens,        
        autoWidth: true,
        "colReorder": true,
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        },
        {
          "type": 'date-br',
          "targets": [3, 4, 5],
          "render": function (data) {
            if (data != undefined) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            } else {
              return ''
            }
          }
        }]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      $('#tabelaOrdemProducao_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaOrdemProducao_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const filtros = await retornaFiltros();
        const url = `/sisplan/movimentacaofaccao/v1/movimentacaofaccao?`;

        await exportaCSV(url, filtros, false, null, 'Relatório da aba acesso da movimentação de facção', '#tabelaOrdemProducao');
      })

      $('#tabelaOrdemProducao').DataTable().columns().every(function () {
        if ((colunasInvisiveis.movimentacaoFaccao).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function consultaOrdemProducaoParaEstornar() {
    try {
      if ($.fn.DataTable.isDataTable('#tabelaEstornar')) {
        $('#tabelaEstornar').DataTable().destroy();
        $('#tabelaEstornar').empty();
      }
      $('#panelDeposito').addClass('d-none')
      const url = '/sisplan/movimentacaofaccao/v1/estornomovimentofaccao?';
      const filtros = await retornaFiltrosEstorno();
      const response = await requisicao('GET', url, filtros, 50000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!');
        $("#labelSelecionarTodos").addClass("d-none");
        return;
      } else {
        $("#checkSelecionarTodos").prop("checked", false);
        $("#labelSelecionarTodos").removeClass("d-none");
      }

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const dataSetCols = []
      
      const keys = Object.keys(jsonStr[0]);
      dataSetCols.push({
        'title': 'SEL',
        'data': 'SEL',
        'width': '15px'
      })

      for (let k in keys) {
        dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
        });
      };

      jsonStr.forEach((item, i) => {
        item.SEL = `<div class="icheck-primary d-inline">
        <input type="checkbox" id="checkEstorno${i}" class="campoSelEstorno">
        <label for="checkEstorno${i}"></label>
        </div>`
      });

      $('#tabelaEstornar').DataTable({
        search: false,
        filter: false,
        order: [],
        sort: true,
        destroy: true,
        paging: false,
        info: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr,
        "columns": dataSetCols,        
        autoWidth: true,
        "colReorder": true,
      });

      $("#tabelaEstornar").off("click", ".campoSelEstorno");
      $('#tabelaEstornar').on('click','.campoSelEstorno', function () {
        const registro = $('#tabelaEstornar').DataTable().row($(this).closest('tr')).data();
        if ($(this).prop('checked') == true) {
          $(this).closest("tr").addClass("selected");
          $(this).addClass("selected");
          if (registro.ESTOQUE == "S") {
            $("#panelDeposito").removeClass("d-none");
          }
        } else {
          $(this).closest("tr").removeClass("selected");
          validaOFMovimentaEstoque() ? "" : $("#panelDeposito").addClass("d-none");
        }
      })

    } catch (error) {
      console.error(error);
    }
  }

  $('#btnEstornarMovto').on('click', async function(){
    msgAlerta("Tem certeza que deseja estornar os movimentos selecionados!", async () => { 
      $.LoadingOverlay("show");    
      try {
        await estornarMovimento();
      } finally {
        $.LoadingOverlay("hide");
      }
      });
  })

  $('#selectParte').on('change', async function (){
    $.LoadingOverlay('show');
    try {
      await consultaOrdemProducaoParaEstornar();
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function estornarMovimento() {
    const registros = $.extend(true, [], $("#tabelaEstornar").DataTable().rows().data().toArray());
    try {

      ajustaPropsRegistros(registros);

      if (!validaRegistrosSelecionados(registros)) {
        throw msgAlerta("Nenhum registro selecionado!");
      }

      const obj = {
        NUMERO: $("#txtNumeroTitle").text(),
        PARTE: $("#txtEstornarParte").val(),
        TIPO: pegaChave("#txtEstornarTipoMov"), 
        DEPOSITO: pegaChave("#txtEstornarDeposito"), 
        MOTIVO: $("#selectMotivo option:selected").text(), 
        ITENS: registros
      }

      const url = '/estornofaccao?';
      const response = await requisicao('POST', url, '', JSON.stringify(obj), 900000);

      if (!response) {
        msgAlerta("Não foi possível estornar o movimento.");
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }
      criaMensagemSucesso("Estorno concluído com sucesso.", async () => { await consultaOrdemProducaoParaEstornar(); });
      
    } catch (error) {
      console.error(error);
    }
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Movimentar" id="btnMovimentar">Movimentar</button>  ' +
      '    <button class="dropdown-item" type="button" title="Estornar" id="btnEstornar">Estornar</button>  ' +
      '</div>';
    return retorno;
  };

  $('#tabelaOrdemProducao').on('click', '#btnMovimentar', async function () {
    await movimentarSetor(this);
  });

  $('#tabelaOrdemProducao').on('click', '#btnEstornar', async function () {
    $.LoadingOverlay('show')
    try{
      const ordemProd = $('#tabelaOrdemProducao').DataTable().row($(this).parents('tr')).data();
      await iniciaModalEstornar(ordemProd);
      $('#modalEstornar').modal('show');
    } finally{
      $.LoadingOverlay('hide')
    }
  });

  $('#btnConsultarEstorno').on('click', async function(){
    $.LoadingOverlay('show');
    try {
      await consultaOrdemProducaoParaEstornar();
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#tabelaOrdemProducao').on('dblclick', 'tr', async function () {
    await movimentarSetor(this);
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOrdemProducao();
  });
  
  await setorUsuario();
  $('#btnConsultar').trigger('click');

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      const filtros = await retornaFiltros();
      const url = `/sisplan/impressao/v1/relacessomovimentacaofaccao?${filtros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAMovimentacaoFaccao');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RelAMovimentacaoFaccao');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#modalEstornar").on("shown.bs.modal", function () {
    $(".scrollOrdemFaccao").scrollTop($(".scrollOrdemFaccao").prop("scrollHeight"));
  })

  $("#txtOFEstorno").on("focusout", async function () {
    if ($(this).val() != "") {
      const ordemProd = {};
      ordemProd.NUMERO = pegaChave(this);
      const codigoProduto = await buscaValor('OF1', 'CODIGO', 'NUMERO', ordemProd.NUMERO);
      ordemProd.CODIGO = codigoProduto.CODIGO;
      const descricaoProduto = await buscaValor('PRODUTO', 'DESCRICAO', 'CODIGO', codigoProduto.CODIGO);
      ordemProd.DESCRICAO = descricaoProduto.DESCRICAO;
      limpaFiltrosOrdemFaccaoEstornar();
      await iniciaModalEstornar(ordemProd);
    }
  })

  $("#checkSelecionarTodos").on("click", function () {
    if ($(this).prop("checked")) {
      $('.campoSelEstorno:not(:checked)').trigger("click");
      $("#checkSelecionarTodosSetor").prop('checked', false);
      $("#checkSelecionarTodosCor").prop('checked', false);
    } else {
      $('.campoSelEstorno:checked').trigger("click");
    }
  })
  
  $("#checkSelecionarTodosSetor").on("click", function () {
    if ($(this).prop("checked")) {
      const qtde = $('#tabelaEstornar').DataTable().rows('.selected').count();

      if (qtde != 1) {
        msgAlerta('Necessário conter apenas um registro selecionado para usar essa opção.');
        $(this).prop('checked', false);
        return;
      }

      const registro = $("#tabelaEstornar").DataTable().rows(".selected").data().toArray();
      const tabela = $("#tabelaEstornar").DataTable().data().toArray();

      tabela.forEach((item, index) => {
        if (item.SETOR == registro[0].SETOR) {
          $(`#checkEstorno${index}`).prop('checked', true);
          $(`#checkEstorno${index}`).closest("tr").addClass("selected");
        }
      });
      
      $("#checkSelecionarTodos").prop('checked', false);
      $("#checkSelecionarTodosCor").prop('checked', false);
    } else {
      const registro = $("#tabelaEstornar").DataTable().data().toArray();
      registro.forEach((item, index) => {
        $(`#checkEstorno${index}`).prop('checked', false);
        $(`#checkEstorno${index}`).closest("tr").removeClass("selected");
      });
    }
  })
  
  $("#checkSelecionarTodosCor").on("click", function () {
    if ($(this).prop("checked")) {
      const qtde = $('#tabelaEstornar').DataTable().rows('.selected').count();
      
      if (qtde != 1) {
        msgAlerta('Necessário conter apenas um registro selecionado para usar essa opção.');
        $(this).prop('checked', false);
        return;
      }
      
      const registro = $("#tabelaEstornar").DataTable().rows(".selected").data().toArray();
      const tabela = $("#tabelaEstornar").DataTable().data().toArray();
      
      tabela.forEach((item, index) => {
        if (item.COR == registro[0].COR) {
          $(`#checkEstorno${index}`).prop('checked', true);
          $(`#checkEstorno${index}`).closest("tr").addClass("selected");
        }
      });
      $("#checkSelecionarTodosSetor").prop('checked', false);
      $("#checkSelecionarTodos").prop('checked', false);
    } else {
      const registro = $("#tabelaEstornar").DataTable().data().toArray();
      registro.forEach((item, index) => {
        $(`#checkEstorno${index}`).prop('checked', false);
        $(`#checkEstorno${index}`).closest("tr").removeClass("selected");
      });
    }
  })

  function MontaPesquisa() {
    componenteFiltro('ordemProducao', true);
    componenteFiltro('produto', true);
    componenteFiltro('cliente', true);
    componenteFiltro('pedido', true);
    componenteFiltro('setor', true);
  }

  async function preencheParte(numero) {
    $('#selectParte').empty();
    const pesquisaParam = {
      tabela: 'FACCAO',
      camposSelect: ['DISTINCT FACCAO.PARTE', 'TIPO_APL.DESCRICAO'],
      where: [`FACCAO.NUMERO = '${numero}'`],
      innerJoin: [{ tabela: "TIPO_APL", condicao: "TIPO_APL.CODIGO = FACCAO.PARTE" }],
      orderby: ["FACCAO.PARTE"]
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length > 0) {
      jsonStr.forEach(parte => {
        let objeto = {
          id: parte.PARTE,
          text: `[${parte.PARTE}] - ${parte.DESCRICAO}`
        }
        const newOption = new Option(objeto.text, objeto.id, true, false);
        $('#selectParte').append(newOption);
      });
      }
  
  }

  function montaPesquisaEstornar(numero){
    $('#txtOFEstorno').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":["NUMERO CHAVE, CODIGO DESCRICAO"], "where": []}`);
    $('#txtEstornarCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
    $('#txtEstornarTam').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, FAIXA DESCRICAO"], "where": []}`);
    $('#txtEstornarFaccao').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": []}`);
    $('#txtEstornarSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
    $('#txtEstornarMov').pesquisa_variosServerside(1, `{ "tabela":"FACCAO", "camposSelect":[ "MOV", "NUMERO"], "where": ["NUMERO = '${numero}'"], "groupby": ["MOV", "NUMERO"]}`, 'MOV', 'NUMERO');
    $('#txtEstornarDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
    $('#txtEstornarTipoMov').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
    
    $('#btnOFEstorno').pesquisa_serverside(['#txtOFEstorno'], ['NUMERO'], ['CODIGO'], '{"tabela":"OF1", "camposSelect":[ "NUMERO", "CODIGO"], "where": null}', 'Pesquisa de Ordem de Facção');
    $('#btnEstornarCor').pesquisa('#txtEstornarCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cor', 'CADCOR');
    $('#btnEstornarTam').pesquisa('#txtEstornarTam', 'TAM', 'FAIXA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"], "where": null}`, 'Pesquisa de Tamanho', 'TABTAM');
    $('#btnEstornarFaccao').pesquisa('#txtEstornarFaccao', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Facção', 'ENTIDADE');
    $('#btnEstornarSetor').pesquisa('#txtEstornarSetor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Setor', 'CADFLUXO');
    $('#btnEstornarMov').pesquisa_serversideSel('#txtEstornarMov', `{ "tabela":"FACCAO", "camposSelect":[ "MOV", "NUMERO"], "where": ["NUMERO = '${numero}'"], "groupby": ["MOV", "NUMERO"]}`, 'Pesquisa de Movimento');
    $('#btnEstornarDeposito').pesquisa('#txtEstornarDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Depósito', 'DEPOSITO');
    $('#btnEstornarTipoMov').pesquisa('#txtEstornarTipoMov', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Tipo de Baixa', 'TABBAI');
  }

  $("#btnLimpaOFEstorno").on('click', function () {
    $('#txtOFEstorno').val('');
  });

  $("#btnLimpaEstornarMov").on('click', function () {
    $('#txtEstornarMov').empty().trigger('change');
  });

  $("#btnLimpaEstornarCor").on('click', function () {
    $('#txtEstornarCor').val('');
  });

  $("#btnLimpaEstornarTam").on('click', function () {
    $('#txtEstornarTam').val('');
  });

  $("#btnLimpaEstornarFaccao").on('click', function () {
    $('#txtEstornarFaccao').val('');
  });

  $("#btnLimpaEstornarSetor").on('click', function () {
    $('#txtEstornarSetor').val('');
  });

  $("#btnLimpaEstornarDeposito").on('click', function () {
    $('#txtEstornarDeposito').val('');
  });

  $("#btnLimpaEstornarTipoMov").on('click', function () {
    $('#txtEstornarTipoMov').val('');
  });

  async function retornaFiltros() {
    const dtSaidaDe = $('#txtDataSaidaIni').val();
    const dtSaidaAte = $('#txtDataSaidaFim').val();
    const dtRetornoDe = $('#txtDataSaidaFim').val();
    const dtRetornoAte = $('#txtDataSaidaFim').val();
    const dtCadastroDe = $('#txtDataCadastroIni').val();
    const dtCadastroAte = $('#txtDataCadastroFim').val();
    const numero = await formataListas($('#txtOrdemProducao').val().toString());
    const produto = await formataListas($('#txtProduto').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    const pedido = await formataListas($('#txtPedido').val().toString());
    const setor = await formataListas($('#txtSetor').val().toString());
    const status = $('#txtStatus').val() == 1 ? 'S' : 'N';
    const retorno = `DT_SAIDA_DE=${dtSaidaDe}` +
      `&DT_SAIDA_ATE=${dtSaidaAte}` +
      `&DT_RETORNO_DE=${dtRetornoDe}` +
      `&DT_RETORNO_ATE=${dtRetornoAte}` +
      `&DT_CADASTRO_DE=${dtCadastroDe}` +
      `&DT_CADASTRO_ATE=${dtCadastroAte}` +
      `&NUMERO=${numero}` +
      `&PRODUTO=${produto}` +
      `&CLIENTE=${cliente}` +
      `&PEDIDO=${pedido}` +
      `&SETOR=${setor}`+
      `&PENDENTE=${status}`;

    return retorno;
  }

  async function retornaFiltrosEstorno() {
    const numero = $('#txtNumeroTitle').text();
    const produto = pegaChave('#txtEstornarProduto');
    const cor = pegaChave('#txtEstornarCor');
    const tam = pegaChave('#txtEstornarTam');
    const faccao = pegaChave('#txtEstornarFaccao');
    const setor = pegaChave('#txtEstornarSetor');
    const movimento = await formataListas($('#txtEstornarMov').val().toString());
    const parte = $('#selectParte').val();
    
    const retorno = `&NUMERO=${numero}` +
      `&PRODUTO=${produto}` +
      `&COR=${cor}` +
      `&TAM=${tam}` +
      `&FACCAO=${faccao}` +
      `&SETOR=${setor}` +
      `&MOVIMENTO=${movimento}` +
      `&PARTE=${parte}`; 

    return retorno;
  }

  async function movimentarSetor(registro) {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOrdemProducao').DataTable().row($(registro).parents('tr')).data();
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `movimentacaofaccao/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para movimentar!");
    }
  }

  function ajustaPropsRegistros(registros) {
    registros.forEach((objeto, i) => {
      if ($(`#checkEstorno${i}`).prop("checked")){
        objeto.SEL = "S";
      } else {
        objeto.SEL = "N";
      }
      objeto.MOVANT = objeto.MOV_ANT;
      objeto.MOVKIT = objeto.MOV_KIT;
      objeto.IDANT = objeto.ID_ANT;
      objeto.CODCLIANT = objeto.CODCLI_ANT;
      objeto.DTLAN = objeto.DT_LAN;
      objeto.DESCCOR = objeto.DESC_COR;
      objeto.DESCSETOR = objeto.DESC_SETOR;
      objeto.SETORDEST = objeto.SETOR_DEST;
      objeto.QTORIG = objeto.QT_ORIG;
      objeto.QUANT2 = objeto.QUANT_2;
      objeto.QUANTI = objeto.QUANT_I;
      objeto.QUANTF = objeto.QUANT_F;
      objeto.DTPAGTO = objeto.DT_PAGTO;
      objeto.CODIGOTROCADO = objeto.CODIGO_TROCADO;
      objeto.LANCTOKIT = objeto.LANCTO_KIT;
      objeto.ESTOQUEPARTE = objeto.ESTOQUE_PARTE;
      objeto.OBRIGAMOTIVO = objeto.OBRIGA_MOTIVO;
      objeto.EXISTEFACCAO3 = objeto.EXISTE_FAC3;
      objeto.REPROPEND = objeto.REPRO_PEND;
      objeto.CODIGO2PRODUTO = objeto.CODIGO2_PRODUTO;
      objeto.IDANTFACCAO = objeto.ID_ANT_FACCAO;
  
      delete objeto.MOV_ANT;
      delete objeto.MOV_KIT;
      delete objeto.ID_ANT;
      delete objeto.CODCLI_ANT;
      delete objeto.DT_LAN;
      delete objeto.DESC_COR;
      delete objeto.DESC_SETOR;
      delete objeto.SETOR_DEST;
      delete objeto.QT_ORIG;
      delete objeto.QUANT_2;
      delete objeto.QUANT_I;
      delete objeto.QUANT_F;
      delete objeto.DT_PAGTO;
      delete objeto.CODIGO_TROCADO;
      delete objeto.LANCTO_KIT;
      delete objeto.ESTOQUE_PARTE;
      delete objeto.OBRIGA_MOTIVO;
      delete objeto.EXISTE_FAC3;
      delete objeto.REPRO_PEND;
      delete objeto.CODIGO2_PRODUTO;
      delete objeto.ID_ANT_FACCAO;
    })

  }

  async function preencheMotivos() {
    try {
      
      const pesquisa = {
        tabela: 'MENSAGEM',
        camposSelect: ['CODMEN', 'DESCRICAO'],
        where: ['((TIPO = 0) OR (TIPO = 1))']
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
  
      if (jsonStr.length > 0) {
        $('#selectMotivo').empty();
        jsonStr.forEach(mensagem => {
          const objeto = {
            id: mensagem.CODMEN,
            text: `${mensagem.DESCRICAO}`
          }
          const newOption = new Option(objeto.text, objeto.id, true, false);
          $('#selectMotivo').append(newOption);
        });
      } 

    } catch (error) {
      console.error(error);
    }
  }

  async function iniciaModalEstornar(ordemProd) {
    $('#txtNumeroTitle').text(ordemProd.NUMERO);
    insereValor("#txtOFEstorno", ordemProd.NUMERO, ordemProd.CODIGO);
    limpaFiltrosOrdemFaccaoEstornar();
    insereValor('#txtEstornarProduto', ordemProd.CODIGO, ordemProd.DESCRICAO);
    montaPesquisaEstornar(ordemProd.NUMERO);
    await preencheParte(ordemProd.NUMERO);
    await preencheMotivos();
    await consultaOrdemProducaoParaEstornar();
  }

  function validaOFMovimentaEstoque() {
    const registros = $("#tabelaEstornar").DataTable().data().toArray();
    for (let i = 0; i < registros.length; i++) {
      if ($(`#checkEstorno${i}`).prop("checked") && registros[i].ESTOQUE == "S") {
        return true;
      }
    }
    return false;
  }

  function limpaFiltrosOrdemFaccaoEstornar() {
    $("#txtEstornarCor").val("");
    $("#txtEstornarTam").val("");
    $("#txtEstornarFaccao").val("");
    $("#txtEstornarSetor").val("");
    $("#txtEstornarMov").empty().trigger("change");
    $("#txtEstornarDeposito").val("");
    $("#txtEstornarTipoMov").val("");
  }

  function validaRegistrosSelecionados(registros) {
    for (let i = 0; i < registros.length; i++) {
      if (registros[i].SEL == "S") {
        return true;
      }
    }
    return false;
  }

  async function setorUsuario() {
    try {
      const responseUsuario = await requisicao(
        "GET", 
        "/sisplan/funcoes/v1/pesquisa?", 
        `JSON={
          "tabela": "ACESSO_USUARIOS", 
          "camposSelect": ["SETORES"], 
          "where": ["CODIGO = '${getCookie('cod_usuario')}'"]
        }`
      );
  
      if (!responseUsuario) {
          return;
      }
  
      const jsonUsuario = await responseUsuario.json();
      if (responseUsuario.status != 200) {
          msgAlerta(jsonUsuario.RESULT[0].mensagem);
          return;
      }
  
      if (jsonUsuario.RESULT[0][0].SETORES != '') {
        const responseSetores = await requisicao(
          "GET", 
          "/sisplan/funcoes/v1/pesquisa?", 
          `JSON={
            "tabela": "CADFLUXO", 
            "camposSelect": ["CODIGO", "DESCRICAO"], 
            "where": ["CODIGO IN (${jsonUsuario.RESULT[0][0].SETORES})"]
          }`
        );
    
        if (!responseSetores) {
            return;
        }
    
        const jsonSetores = await responseSetores.json();
        if (responseSetores.status != 200) {
            msgAlerta(jsonSetores.RESULT[0].mensagem);
            return;
        }
  
        await insereValorPesquisaVarios('txtSetor', 'CODIGO', 'DESCRICAO', jsonSetores.RESULT[0]);
      }      
    } catch (error) {
      console.log(error)  
    }
  }

});