$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtConta",
        popover: {
          title: "Conta",
          description: "Conta referente ao cadastro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Campos Obrigatórios",
          description: "Adicionamos aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a carteira.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#txtBanco").autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
  $("#btnBanco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, "Pesquisa Conta", "CADBAN");
  $("#btnLimpaBanco").on("click", function () {
    $("#txtBanco").val("");
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      },
      txtDias: {
        required: true,
      },
      txtBanco: {
        required: true,
      }
    },
    messages: {
      txtCodigo: {
        required: "Insira um código.",
      },
      txtDescricao: {
        required: "Insira uma descrição.",
      },
      txtDias: {
        required: "Insira os dias.",
      },
      txtBanco: {
        required: "Informe umum banco.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/modalidade_pagamento`;
  });

  // const page = $(window.location.href.split('/')).get(-1);

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let page = parametros[parametros.length - 1];

  if (page != "" && page != "create") {
    const resultadopage = page.split('&');
    await carregaDados(resultadopage[0], resultadopage[1]);
    $("#txtCodigo, #txtBanco, #btnBanco, #btnLimpaBanco").prop("disabled", true);
  }

  // await carregaDados();
  async function carregaDados(codigo, banco) {
    try {
      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"MODA_PAGTO", "camposSelect":["CODIGO", "DESCRICAO", "BANCO", "DIAS"],
        "where": ["CODIGO = '${codigo}' AND BANCO = '${banco}'"]}`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
      $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
      $('#txtDias').val(jsonStr.RESULT[0][0].DIAS);

      nomeBanco = await buscaValor("CADBAN", "NOME_BANCO", "BANCO", jsonStr.RESULT[0][0].BANCO);
      insereValor("#txtBanco", jsonStr.RESULT[0][0].BANCO, nomeBanco.NOME_BANCO);
    }
    finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {
      const mPagto = {
        CODIGO: pegaValor('#txtCodigo'),
        DESCRICAO: pegaValor('#txtDescricao'),
        DIAS: pegaValor('#txtDias'),
        BANCO: pegaChave('#txtBanco'),
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/modalidadepagamento?', `JSON=${encodeURIComponent(JSON.stringify(mPagto))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/modalidade_pagamento` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

});
