$(document).ready(async function () {
  $("#tutorial").on("click", function () {
    $(document).ready(async function () {
      function RotinaCliqueAvancar(componente) {
        currentFs = $(componente).parent();
        nextFs = $(componente).parent().next();

        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate(
          {
            opacity: 0,
          },
          {
            step(now) {
              opacity = 1 - now;

              currentFs.css({
                display: "none",
                position: "relative",
              });
              nextFs.css({
                opacity,
              });
            },
            duration: 600,
          }
        );
      }
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        animate: true,
        onNext: (Element) => {
          if (Element.node.id == "avancar1") {
            RotinaCliqueAvancar($("#avancar1"));
          }
          if (Element.node.id == "gravar") {
            $(".driver-next-btn").on("click", location.reload());
          }
        },
        onPrevious: (Element) => {
          if (Element.node.id == "configuracao") {
            $("#voltar3").trigger("click");
          }
          if (Element.node.id == "formcard1") {
            $(".driver-close-btn").on("click", location.reload());
          }
        },
      });

      driver.defineSteps([
        {
          element: "#formcard1",
          popover: {
            title: "Dados Gerais",
            description: "Aqui estão os campos disponíveis para o cadastro.",
            position: "top",
          },
        },
        {
          element: "#avancar1",
          popover: {
            title: "Botão Avançar",
            description: "Clique aqui para ir para a próxima aba.",
            position: "left",
          },
        },
        {
          element: "#configuracao",
          popover: {
            title: "Itens",
            description: "Aqui você adicionará os itens a serem movimentados",
            position: "top",
          },
        },
        {
          element: "#voltar3",
          popover: {
            title: "Botão Voltar",
            description:
              "Ao clicar nesse botão você retorna para a aba Configurações.",
            position: "left",
          },
        },
        {
          element: "#btnGravar",
          popover: {
            title: "Botão Gravar",
            description:
              "Clique aqui para gravar e efetuar a transferência de depósito.",
            position: "left",
          },
        },
        {
          element: "#btnSair",
          popover: {
            title: "Botão Sair",
            description: "Clique aqui para sair da tela",
            position: "left",
          },
        },
      ]);
      driver.start();
    });
  });
  function RotinaCliqueAvancar(componente) {
    currentFs = $(componente).parent();
    nextFs = $(componente).parent().next();

    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

    nextFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            display: "none",
            position: "relative",
          });
          nextFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  }
  $("#txtQuantidadeBipada").val(0);
  $("#txtNumero").focus();
  let currentFs;
  let nextFs;
  let previousFs;
  let opacity;

  $(".next").click(function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    // $("#msform").validate().element("#txtNumero");
    // $("#msform").validate().element("#txtFuncionario");
    // $("#msform").validate().element("#txtDepOrigem");

    if (
      !$("#msform").validate().element("#txtNumero") ||
      !$("#msform").validate().element("#txtFuncionario") ||
      !$("#msform").validate().element("#txtDepOrigem")
    ) {
      erros += 1;
    }

    if (erros == 0) {
      RotinaCliqueAvancar(this);
    }
  });

  $(".previous").click(function () {
    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  $("#btnSair").on("click", function () {
    msgAlerta(
      `Tem certeza que deseja sair? Os dados não gravados serão perdidos.`,
      async function () {
        await deletaArquivo("JsonMatTransferenciaDeposito");
        window.location.reload();
      }
    );
  });

  $("#msform").validate({
    ignore: "",
    rules: {
      txtNumero: {
        required: true,
      },
      txtFuncionario: {
        required: true,
      },
      txtDepOrigem: {
        required: true,
      },
      txtDepDestino: {
        required: true,
      },
      txtTipoMov: {
        required: true,
      },
    },
    messages: {
      txtNumero: {
        required: "Informe um número de transferência",
      },
      txtFuncionario: {
        required: "Informe um funcionário.",
      },
      txtDepOrigem: {
        required: "Informe um depósito",
      },
      txtDepDestino: {
        required: "Informe um depósito.",
      },
      txtTipoMov: {
        required: "Informe um tipo de movimento.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".submit").click(function () {
    return false;
  });

  await carregaValoresPadroes();
  CriaTabela("#tabelaItens", [6, 7, 8, 9], [], [4, 5]);
  CriaTabela("#tabelaItensGravados", [6, 7], [9], [5]);
  $("#txtFuncionario").autocompleta(1, `JSON={"tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $("#txtDepOrigem").autocompleta(1, `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $("#txtDepDestino").autocompleta(1, `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $("#txtTipoMov").autocompleta(1, `JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $("#txtMaterial").autocompleta(3, `JSON={"tabela": "MATERIAL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtMaterial"));
  $("#txtCor").autocompleta(1, `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtCor"));
  $("#txtQualidade").autocompleta(1, `JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, [], [], [], () => habilitaProximoCampo("#txtQualidade"));
  $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"MAT_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, LANCAMENTO DESCRICAO"], "where": ["MAT_MOV.OPERACAO = 'E'"]}`, [], [], []);
  $("#txtLocalOrigem").autocompleta(1, `JSON={"tabela": "CAD_LOC_ESTOQ", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`);
  $("#txtLocalDestino").autocompleta(1, `JSON={"tabela": "CAD_LOC_ESTOQ", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`);


  $("#btnFuncionario").pesquisa_array(["#txtFuncionario"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`, "Pesquisa Funcionário", "pessoal");
  $("#btnDepOrigem").pesquisa_array(["#txtDepOrigem"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, "Pesquisa Deposito", "deposito");
  $("#btnDepDestino").pesquisa_array(["#txtDepDestino"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, "Pesquisa Deposito", "deposito");

  $("#btnLocalOrigem").pesquisa_array(["#txtLocalOrigem"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CAD_LOC_ESTOQ", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, "Pesquisa Local Estoque", "cad_loc_estoq");
  $("#btnLocalDestino").pesquisa_array(["#txtLocalDestino"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CAD_LOC_ESTOQ", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, "Pesquisa Local Estoque", "cad_loc_estoq");

  $("#btnTipoMov").pesquisa_array(["#txtTipoMov"], ["CHAVE"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABBAI", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}`, "Pesquisa Tipo Movimento", "tabbai");
  $("#btnMaterial").pesquisa_array(["#txtMaterial"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MATERIAL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}', "Pesquisa Material", "MATERIAL", () => habilitaProximoCampo("#txtMaterial"));
  $("#btnCor").pesquisa_array(["#txtCor"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}', "Pesquisa Cor", "cadcor", () => habilitaProximoCampo("#txtCor"));
  $("#btnQualidade").pesquisa_array(["#txtQualidade"], ["CHAVE"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TABQUL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO"], "where": null}', "Pesquisa Qualidade", "tabqul", () => habilitaProximoCampo("#txtQualidade"));
  $("#btnDocumento").pesquisa("#txtDocumento", "NUM_DOCTO", "LANCAMENTO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_MOV", "camposSelect":[ "DISTINCT NUM_DOCTO", "LANCAMENTO","DT_MVTO" ], "where": ["MAT_MOV.OPERACAO = 'E'"]}`, "Pesquisa Documento", "MAT_MOV");

  $("#btnLimparFuncionario").on("click", function () {
    $("#txtFuncionario").val("");
  });

  $("#btnLimparDepositoDestino").on("click", function () {
    $("#txtDepDestino").val("");
  });

  $("#btnLimparLocalositoOrigem").on("click", function () {
    $("#txtLocalOrigem").val("");
  });

  $("#btnLimparLocalDestino").on("click", function () {
    $("#txtLocalDestino").val("");
  });

  $("#btnLimparDepositoOrigem").on("click", function () {
    $("#txtDepOrigem").val("");
  });

  $("#btnLimparTipoMov").on("click", function () {
    $("#txtTipoMov").val("");
  });

  $('#btnLimpaDocumento').on('click', function () {
    $('#txtDocumento').val('');
  });

  $("#txtMaterial").on("blur", function () {
    $("#txtCor").autocompleta(
      1,
      `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [MAT_ITEN] WHERE CODIGO='${pegaChave(
        "#txtMaterial"
      )}')"]}`,
      [],
      [],
      [],
      () => habilitaProximoCampo("#txtCor")
    );
    $("#btnCor").pesquisa_array(
      ["#txtCor"],
      ["CHAVE"],
      ["DESCRICAO"],
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [MAT_ITEN] WHERE CODIGO='${pegaChave(
        "#txtMaterial"
      )}')"]}`,
      "Pesquisa Cor",
      "cadcor",
      () => habilitaProximoCampo("#txtCor")
    );

    rotinaSaidaCor();
  });

  function habilitaProximoCampo(campoAtual) {
    const listaCampos = [
      "#txtMaterial",
      "#txtCor",
      "#txtLote",
      "#txtQualidade",
      "#btn-adicionar",
    ];
    const indiceEncontrado = listaCampos.findIndex(
      (campo) => campo === campoAtual
    );

    listaCampos.forEach((campo, index) => {
      if (index <= indiceEncontrado) {
        $(listaCampos[index + 1]).prop("disabled", false);
      } else {
        $(listaCampos[index + 1]).prop("disabled", true);
      }
    });
  }

  $("#txtMaterial").on("change", function () {
    habilitaProximoCampo("#txtMaterial");
  });

  $("#txtCor").on("change", function () {
    habilitaProximoCampo("#txtCor");
  });

  $("#txtLote").on("change", function () {
    habilitaProximoCampo("#txtLote");
  });

  $("#txtQualidade").on("change", function () {
    habilitaProximoCampo("#txtQualidade");
  });

  function rotinaSaidaMaterial() { }

  function rotinaSaidaCor() {
    $("#txtCor").on("blur", function () {
      const sCodigo = `'${pegaChave("#txtMaterial")}'`;
      const sCor = `'${pegaChave("#txtCor")}'`;
      const sDeposito = `'${pegaChave("#txtDepOrigem")}'`;
      $("#txtLote").autocompleta(
        1,
        `JSON={"tabela": "MAT_ITEN", "camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["CODIGO = ${sCodigo} AND COR = ${sCor} AND DEPOSITO = ${sDeposito}"]}`,
        [],
        [],
        [],
        () => habilitaProximoCampo("#txtLote")
      );
      $("#btnLote").pesquisa_array(
        ["#txtLote"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MAT_ITEN", "camposSelect": ["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["CODIGO = ${sCodigo} AND COR = ${sCor} AND DEPOSITO = ${sDeposito}"]}`,
        "Pesquisa Lote",
        "MAT_ITEN",
        () => habilitaProximoCampo("#txtLote")
      );
    });

  }

  function rotinaSaidaLote() { }

  function rotinaSaidaQualidade() { }

  $("#btn-adicionar").on("keypress", async function () {
    $("#btn-adicionar").trigger("click");
  });

  function limpaCampos() {
    $("#txtMaterial").val("");
    $("#txtCor").val("");
    $("#txtLote").val("");
    $("#txtQualidade").val("");
    $("#txtBarra").val("");
  }

  $("#txtNumero").on("blur", async function () {
    try {
      $.LoadingOverlay("show");
      const lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
      insereValor('#txtLancamento', lancamento);
      if ($(this).val() == "") {
        const docto = await RetornaProximo("DOCTO", "MAT_MOV", "NUM_DOCTO", "6");
        $("#tabelaItensGravados").DataTable().clear().draw(false);
        insereValor("#txtNumero", docto);
        $(this).attr("disabled", $(this).val() != "");
      } else {
        carregaItensMovimentados();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function carregaItensMovimentados() {
    try {
      const documento = $("#txtNumero").val();
      const tipoBanco = await retornaDatabase();

      let subStringObservacao = '';

      if (tipoBanco == 'FIREBIRD') {
        subStringObservacao = `AND SUBSTRING(MAT_MOV.OBS FROM 1 FOR 9) <> 'ESTORNADO'`;
      } else if (tipoBanco == 'SQLSERVER') {
        subStringObservacao = `AND SUBSTRING(MAT_MOV.OBS, 1, 9) <> 'ESTORNADO'`;
      } else if (tipoBanco == 'ORACLE') {
        subStringObservacao = `AND SUBSTR(MAT_MOV.OBS, 1, 9) <> 'ESTORNADO'`;
      }

      const dadosSelect = {
        camposSelect: [
          `'' AS SEL`,
          "MAT_MOV.CODIGO",
          "MATERIAL.DESCRICAO",
          "MAT_MOV.COR",
          "CADCOR.DESCRICAO DESC_COR",
          "MAT_MOV.LOTE",
          "MAT_MOV.QUALIDADE",
          "SUM(MAT_MOV.QTDE) QTDE",
          "MAT_MOV.LANCAMENTO",
          "MAT_MOV.DT_MOVTO",
        ],
        tabela: "MAT_MOV",
        leftJoin: [
          {
            tabela: "MATERIAL",
            condicao: "MATERIAL.CODIGO = MAT_MOV.CODIGO",
          },
          {
            tabela: "CADCOR",
            condicao: "CADCOR.COR = MAT_MOV.COR",
          },
        ],
        where: [`MAT_MOV.NUM_DOCTO = '${documento}' AND OPERACAO='E' ${subStringObservacao}`],
        groupBy: [
          "MAT_MOV.CODIGO, MATERIAL.DESCRICAO",
          "MAT_MOV.COR",
          "CADCOR.DESCRICAO",
          "MAT_MOV.LOTE",
          "MAT_MOV.QUALIDADE",
          "MAT_MOV.LANCAMENTO",
          "MAT_MOV.DT_MOVTO",
        ],
      };

      $("#tabelaItensGravados").DataTable().clear().draw(false);
      const listaItens = await retornaJsonPesquisaPadrao(
        JSON.stringify(dadosSelect)
      );

      listaItens.forEach((item, i) => {
        const dados = [
          item.SEL = `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check${i}" class="campoSel">
          <label for="check${i}"></label>
          </div>`,
          item.CODIGO,
          item.DESCRICAO,
          item.COR,
          item.DESC_COR,
          item.QTDE,
          item.LOTE,
          item.QUALIDADE,
          item.LANCAMENTO,
          item.DT_MOVTO
        ];
        $('#check_todos').prop('checked', false);
        $("#tabelaItensGravados").DataTable().row.add(dados).draw(false);
      });
    } finally {
      $(".itens_gravados").removeClass("d-none");
      $('#btnEstornar').removeClass('d-none');
    }

    $('.campoSel').on('change', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
      $('#check_todos').prop('checked', $('.campoSel').length == $('.selecionado').length);
    });

  }

  async function adicionaRegistroGrid() {
    const barra = $("#txtBarra").val();
    const codigoCorLote = barra.split('*');
    const codigo = pegaChave("#txtMaterial");
    const cor = pegaChave("#txtCor");
    const lote = pegaChave("#txtLote");
    const qual = pegaChave("#txtQualidade");
    const deposito = pegaChave("#txtDepOrigem");
    const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
    const qtde = pegaValor('#txtQuantidade') > 0 ? parseFloat(pegaValor('#txtQuantidade')) : 1;
    const where =
      barra === ""
        ? [
          `MAT_ITEN.CODIGO = '${codigo}' AND MAT_ITEN.COR = '${cor}' AND MAT_ITEN.LOTE = '${lote}' AND MAT_ITEN.QUALIDADE = '${qual}' AND MAT_ITEN.DEPOSITO = '${deposito}'`,
        ]
        : [
          `(MAT_ITEN.BARRA = '${barra}') AND MAT_ITEN.DEPOSITO=${deposito}`,
        ];

    let dadosSelect = {
      camposSelect: [
        "MAT_ITEN.CODIGO",
        "MATERIAL.DESCRICAO",
        "MAT_ITEN.COR",
        "CADCOR.DESCRICAO DESC_COR",
        "MAT_ITEN.LOTE",
        "MAT_ITEN.QUALIDADE",
        "MAT_ITEN.LARGURA",
        "MAT_ITEN.GRAMATURA",
        "SUM(MAT_ITEN.QTDE) QTDE",
      ],
      tabela: "MAT_ITEN",
      leftJoin: [
        {
          tabela: "MATERIAL",
          condicao: "MATERIAL.CODIGO = MAT_ITEN.CODIGO",
        },
        {
          tabela: "CADCOR",
          condicao: "CADCOR.COR = MAT_ITEN.COR",
        },
      ],
      where,
      groupBy: [
        "MAT_ITEN.CODIGO, MATERIAL.DESCRICAO",
        "MAT_ITEN.COR",
        "CADCOR.DESCRICAO",
        "MAT_ITEN.LOTE",
        "MAT_ITEN.QUALIDADE",
        "MAT_ITEN.LARGURA",
        "MAT_ITEN.GRAMATURA"
      ],
      having: ["SUM(MAT_ITEN.QTDE) > 0"],
    };

    let retornoSelect = await retornaJsonPesquisaPadrao(
      JSON.stringify(dadosSelect)
    );
    if (!retornoSelect) {
      if (codigoCorLote.length == 3) {
        dadosSelect = retornaSQLCodigoCorLote(codigoCorLote, deposito);
        retornoSelect = await retornaJsonPesquisaPadrao(
          JSON.stringify(dadosSelect)
        );

        if (!retornoSelect) {
          msgAlerta("Material não encontrado, verifique");
          return;
        }
      } else {
        msgAlerta("Material não encontrado, verifique");
        return;
      }
    }
    if (retornoSelect.length === 0) {
      if (codigoCorLote.length == 3) {
        dadosSelect = retornaSQLCodigoCorLote(codigoCorLote, deposito);
        retornoSelect = await retornaJsonPesquisaPadrao(
          JSON.stringify(dadosSelect)
        );

        if (retornoSelect.length === 0) {
          msgAlerta("Material não encontrado ou sem estoque disponível, verifique");
          return;
        }
      } else {
        msgAlerta("Material não encontrado ou sem estoque disponível, verifique");
        return;
      }
    }

    const total = $("#tabelaItens").DataTable().data().length;

    const dados = [
      retornoSelect[0].CODIGO,
      retornoSelect[0].DESCRICAO,
      retornoSelect[0].COR,
      retornoSelect[0].DESC_COR,
      retornoSelect[0].QTDE,
      qtde,
      retornoSelect[0].LOTE,
      retornoSelect[0].QUALIDADE,
      retornoSelect[0].LARGURA,
      retornoSelect[0].GRAMATURA
    ];

    if (dados[4] === 0) {
      msgAlerta("Quantidade em estoque insuficiente, verifique");
      return;
    }

    const indexItem = $("#tabelaItens")
      .DataTable()
      .data()
      .toArray()
      .findIndex(
        (item) =>
          item[0] === dados[0] && item[2] === dados[2]
      );
    if (indexItem == -1 && estornaQuantidade == 'true' && codigo == '') {
      msgAlerta('Nenhum item para estornar!');
    } else if (indexItem === -1) {
      $("#tabelaItens").DataTable().row.add(dados).draw(false);
      $(`#tabelaItens tbody tr:eq(${total})`).click();
    } else {
      let data = $("#tabelaItens").DataTable().row(indexItem).data();
      const quant = estornaQuantidade == 'true' && codigo == '' ? data[5] - dados[5] : data[5] + dados[5];

      if (data[4] < quant) {
        msgAlerta("Quantidade excedida, verifique");
        return;
      }

      if (quant == 0) {
        $('#tabelaItens').DataTable().row(indexItem).remove().draw(false);
        VerificaQuantidadeBipada();
        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonMatTransferenciaDeposito', jsonarquivo);
        return;
      }

      data[5] = quant;
      $('#tabelaItens').DataTable().row(indexItem).data(data).draw(false);

      $($("#tabelaItens tbody tr")[indexItem]).click();
      $(".dataTables_scrollBody").scrollTo(
        $("#tabelaItens tbody tr").eq(indexItem),
        200
      );

    }

    $("#tabelaItens").DataTable().columns.adjust().draw(false);
    VerificaQuantidadeBipada();
    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo('JsonMatTransferenciaDeposito', jsonarquivo);
    $('#txtQuantidade').val('1');
  }

  async function montaJsonObjeto() {
    const dados = $("#tabelaItens").DataTable().data().toArray();
    const lista = dados
      .map((item) => {
        return {
          codigo: item[0],
          cor: item[2],
          local: pegaChave("#txtLocalOrigem"),
          deposito: pegaChave("#txtDepOrigem"),
          qtde: item[5],
          num_docto: $("#txtNumero").val(),
          qualidade: item[7],
          lote: item[6],
          unidade: "",
          cliente: "",
          descricao: "",
          tipo: pegaChave('#txtTipoMov'),
          obs: ` Funcionario: ${pegaChave(
            "#txtFuncionario"
          )} ${pegaDescricao("#txtFuncionario")}`,
          funcionario: pegaChave('#txtFuncionario'),
          tp_mov: "MN",
          largura: item[8],
          gramatura: item[9]
        };
      })
      .filter((item) => item.qtde > 0);
    return lista;
  }

  $("#btnGravar").on("click", async function () {
    try {
      $.LoadingOverlay('show');
      $('#btnGravar').prop('disabled', true);
      try {
        const listaMateriais = await montaJsonObjeto();
        if (listaMateriais.length === 0) {
          msgErro("Nenhum item a ser movimentado, verifique");
          return;
        }
        const objeto = {
          materiais: listaMateriais,
        };

        let localDestino = pegaChave("#txtLocalDestino") === '' ? '0' : pegaChave("#txtLocalDestino");


        const depositoDestino = pegaChave("#txtDepDestino");
        let lancamento = $('#txtLancamento').val();
        const response = await requisicao(
          "POST",
          "/Sisplan/Estoque/V1/transferenciaestoquematerial?",
          "",
          `JSON=${encodeURIComponent(
            JSON.stringify(objeto)
          )}&DEPOSITO_DESTINO=${depositoDestino}&LANCAMENTO=${lancamento}&LOCAL_DESTINO=${localDestino}`,
          300000);

        if (!response) {
          return "";
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return "";
        }
        await carregaItensMovimentados();
        lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtLancamento', lancamento);
        $("#tabelaItens").DataTable().clear().draw(false);
        $("#txtQuantidadeBipada").val(0);
        await deletaArquivo('JsonMatTransferenciaDeposito');
      } catch (error) {
        console.error(error);
        msgErro("Não foi possível gravar os dados");
        return "";
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#btnGravar').prop('disabled', false);
    }
  });

  $('#btnEstornar').on('click', async function () {
    msgAlerta('Deseja realmente estornar a movimentação?', estornaMovimentacao);
  });

  async function estornaMovimentacao() {
    try {
      $.LoadingOverlay('show');
      try {

        const selecionados = $('.selecionado');

        if (selecionados.length == 0) {
          msgAlerta('Nenhum material selecionado para estornar, verifique!');
          return;
        }

        let materiaisEstorno = [{}];

        for (let i = 0; i < selecionados.length; i++) {
          const id = selecionados[i].id.substr(5, selecionados[i].id.length);
          const data = $('#tabelaItensGravados').DataTable().row(id).data();
          materiaisEstorno[i] = {
            CODIGO: data[1],
            COR: data[3],
            LOTE: data[6],
            QUALIDADE: data[7],
            LANCAMENTO: data[8],
            NUM_DOCTO: $('#txtNumero').val()
          }
        }

        const objeto = {
          materiais: materiaisEstorno
        }

        const response = await requisicao('POST', '/Sisplan/Estoque/V1/estornatransdepmat?', '', `MATERIAIS_ESTORNO=${encodeURIComponent(JSON.stringify(objeto))}&LOCAL_DESTINO=${pegaChave("#txtLocalDestino")}`, 300000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        carregaItensMovimentados();
        $('#check_todos').prop('checked', false);
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível estornar o movimento');
        return;
      }
    } finally {
      $('.itens_gravados').addClass('d-none');
      $('#btnEstornar').addClass('d-none');
      $.LoadingOverlay('hide');
    }
  }

  async function VerificaQuantidadeBipada() {
    let QuantidadeBipada = 0;
    const tabelaItens = $("#tabelaItens").DataTable().data();
    for (let i = 0; i < tabelaItens.length; i++) {
      QuantidadeBipada =
        parseFloat(QuantidadeBipada) +
        parseFloat(tabelaItens[i][5]);
    }
    $("#txtQuantidadeBipada").val(QuantidadeBipada);
  }

  $("#txtBarra").on("keydown", async function (event) {
    if (event.key == "Enter") {
      $("#txtBarra").trigger("blur");
      $("#txtBarra").focus();
    }
  });

  $("#btn-adicionar").on("click", async function () {
    adicionaRegistroGrid();
    limpaCampos();
    habilitaProximoCampo("#txtMaterial");
    $("#txtMaterial").focus();
  });

  $("#txtBarra").on("blur", async function () {
    if ($(this).val() !== "") {
      adicionaRegistroGrid();
      limpaCampos();
      $("#txtBarra").focus();
    }
  });

  rotinaSaidaMaterial();
  rotinaSaidaCor();
  rotinaSaidaLote();
  rotinaSaidaQualidade();

  retornaHintRelatorio('btnImprimir','transferencia_deposito_mat')

  $("#btnImprimir").on("click", async function () {
    const DadosGravados = $("#tabelaItensGravados").DataTable().data();
    if (DadosGravados.length > 0) {
      ImprimirRelatorio();
    } else {
      msgAlerta('Necessário gravar alguma informação antes de imprimir os dados.');
    }
  });

  async function ImprimirRelatorio() {
    const url = `/sisplan/impressao/v1/imprimirtransferenciadepositomaterial?`;
    const documento = $('#txtNumero').val();
    const params = `DOCUMENTO=${documento}`;
    const response = await requisicao("GET", url, params, null);
    const arquivo = await response.text();

    if (arquivo != undefined) {
      window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
      await limparRelatorios();
    }
  }

  function CriaTabela(sSeletor, colunasInvisiveis = [], colunasData = [], colunasDireita = []) {
    $(sSeletor).DataTable({
      autoWidth: false,
      destroy: true,
      order: false,
      filter: false,
      paginate: false,
      key: "true",
      columnDefs: [
        {
          targets: colunasInvisiveis,
          visible: false,
        },
        {
          targets: colunasDireita,
          "className": 'pr-4 text-right'
        },
        {
          render: render = function (data, type, row) {
            let isIE = function () {
              if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
                return true;
              }
              return false;

            };
            if (isIE()) {
              x = data.slice(0, 10).split('-');
              return `${x[2]}/${x[1]}/${x[0]}`;
            }
            x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;

          },
          targets: colunasData,
        },
      ],
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar (geral): ",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
    });

    $(`${sSeletor} tbody`).on("click", "tr", async function () {
      $(`${sSeletor} tbody tr td`)[0].click();
      $(`${sSeletor} tbody tr.selected`).removeClass("selected");
      $(this).addClass("selected");
    });

  }

  try {
    const response = await carregaArquivo('JsonMatTransferenciaDeposito');
    if (response.status === 200) {
      const jsonStr = await response.json();
      insereValor("#txtFuncionario", jsonStr.funcionario.split("] - ")[0].substr(1), jsonStr.funcionario.split("] - ")[1]);
      insereValor("#txtDepOrigem", jsonStr.depositoOrig.split("] - ")[0].substr(1), jsonStr.depositoOrig.split("] - ")[1]);
      insereValor("#txtDepDestino", jsonStr.depositoDest.split("] - ")[0].substr(1), jsonStr.depositoDest.split("] - ")[1]);
      insereValor("#txtTipoMov", jsonStr.tipoMovimento.split("] - ")[0].substr(1), jsonStr.tipoMovimento.split("] - ")[1]);

      for (let i = 0; i < jsonStr.itens.length; i++) {
        jsonStr.itens[i].estoque = await buscaQuantidadeEstoque(jsonStr.itens[i], pegaChave('#txtDepOrigem'));
      }

      jsonStr.itens.forEach((item) => {
        $("#tabelaItens")
          .DataTable()
          .row.add([
            item.codigo,
            item.descricao,
            item.cor,
            item.descCor,
            item.estoque,
            item.qtde,
            item.lote,
            item.qualidade,
            item.largura,
            item.gramatura
          ])
          .draw(false);
      });

      VerificaQuantidadeBipada();
      msgAlerta("Carregado dados não salvos, verifique.");
    }
  } catch (error) {
    console.log(error);
  }

  function montaJsonItens() {
    const itensDataTable = $("#tabelaItens").DataTable().data().toArray();
    const itens = itensDataTable.map((itemDT, i) => {
      const item = {
        codigo: itemDT[0],
        descricao: itemDT[1],
        cor: itemDT[2],
        descCor: itemDT[3],
        estoque: itemDT[4],
        qtde: itemDT[5],
        lote: itemDT[6],
        qualidade: itemDT[7],
        largura: itemDT[8],
        gramatura: itemDT[9]
      };
      return item;
    });
    return itens;
  }

  function montaJsonArquivo() {
    const importacao = {
      numero: $("#txtNumero").val(),
      funcionario: $("#txtFuncionario").val(),
      depositoOrig: $("#txtDepOrigem").val(),
      depositoDest: $("#txtDepDestino").val(),
      tipoMovimento: $("#txtTipoMov").val(),
      itens: montaJsonItens(),
    };
    return importacao;
  }

  async function buscaQuantidadeEstoque(material, deposito) {
    try {

      const dadosSelect = {
        camposSelect: ["MAT_ITEN.QTDE"],
        tabela: "MAT_ITEN",
        where: [`MAT_ITEN.CODIGO = '${material.codigo}' AND MAT_ITEN.COR = '${material.cor}' AND MAT_ITEN.LOTE = '${material.lote}' AND MAT_ITEN.DEPOSITO = ${deposito}`],
      };

      const quantidade = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

      return quantidade[0].QTDE;

    } catch (error) {
      console.log(error);
    }

  }

  $('#btnMenosOuMais').on('click', function () {
    const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
    $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
    $('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
    $('#txtBarra').focus();
    $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
    if (estaComoEstorno) {
      $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
    } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
  });

  $('#check_todos').on('change', function () {
    $('.campoSel').prop('checked', $('#check_todos').prop('checked'));
    if ($('#check_todos').prop('checked')) {
      $('.campoSel').addClass('selecionado');

    } else {
      $('.campoSel').removeClass('selecionado');

    }
  });

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'TRANSF_DEPOSITO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'FUNCIONARIO_MAT': {
          if (item.VALOR != '') {
            insereValor('#txtFuncionario', item.VALOR, {tabela: 'PESSOAL', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: item.VALOR});
          }
          break;
        }
        case 'DEPOSITO_ORIGEM_MAT': {
          if (item.VALOR != '') {
            insereValor('#txtDepOrigem', item.VALOR, {tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
          }
          break;
        }
        case 'DEPOSITO_DEST_MAT': {
          if (item.VALOR != '') {
            insereValor('#txtDepDestino', item.VALOR, {tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
          }
          break;
        }
        case 'TIPO_MOVTO_MAT': {
          if (item.VALOR != '') {
            insereValor('#txtTipoMov', item.VALOR, {tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
          }
          break;
        }
      }
    });
  };

  function retornaSQLCodigoCorLote(codigoCorLote, deposito) {
    const where = [`MAT_ITEN.CODIGO = '${codigoCorLote[0]}' AND MAT_ITEN.COR = '${codigoCorLote[1]}' AND MAT_ITEN.LOTE = '${codigoCorLote[2]}' AND MAT_ITEN.DEPOSITO = '${deposito}'`]

    const dadosSelect = {
      camposSelect: [
        "MAT_ITEN.CODIGO",
        "MATERIAL.DESCRICAO",
        "MAT_ITEN.COR",
        "CADCOR.DESCRICAO DESC_COR",
        "MAT_ITEN.LOTE",
        "MAT_ITEN.QUALIDADE",
        "MAT_ITEN.LARGURA",
        "MAT_ITEN.GRAMATURA",
        "SUM(MAT_ITEN.QTDE) QTDE",
      ],
      tabela: "MAT_ITEN",
      leftJoin: [
        {
          tabela: "MATERIAL",
          condicao: "MATERIAL.CODIGO = MAT_ITEN.CODIGO",
        },
        {
          tabela: "CADCOR",
          condicao: "CADCOR.COR = MAT_ITEN.COR",
        },
      ],
      where,
      groupBy: [
        "MAT_ITEN.CODIGO, MATERIAL.DESCRICAO",
        "MAT_ITEN.COR",
        "CADCOR.DESCRICAO",
        "MAT_ITEN.LOTE",
        "MAT_ITEN.QUALIDADE",
        "MAT_ITEN.LARGURA",
        "MAT_ITEN.GRAMATURA",
      ],
      having: ["SUM(MAT_ITEN.QTDE) > 0"],
    };

    return dadosSelect;
  }

});
