$(document).ready(async function () {

  await setarDataAtual('txtDataDe');
  await setarDataAtual('txtDataAte');
  await buscaValoresPadroes();

  $('#tabela-movimentados').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
    columnDefs: [
      {
        "targets": [4],
        "className": 'pr-4 text-right'
      }
    ]
  });

  let data = new Date();
  $('#txtDataMovimentoEntrada').val(`${data.getUTCFullYear()}-${String(data.getUTCMonth() + 1).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`);

  $('#txtFuncionarioEntradaMat').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnFuncionarioEntradaMat').pesquisa_array(['#txtFuncionarioEntradaMat'], ['CODIGO'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Funcionário', 'PESSOAL');
  $('#btnLimpaFuncionarioEntradaMat').on('click', function () {
    $('#txtFuncionarioEntradaMat').val('');
  });

  $('#txtTipoEntradaMat').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnTipoEntradaMat').pesquisa_array(['#txtTipoEntradaMat'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Entrada', 'TABBAI');
  $('#btnLimpaTipoEntradaMat').on('click', function () {
    $('#txtTipoEntradaMat').val('');
  });

  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');
  $('#btnLimpaQualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#txtMaterialEntrada').autocompleta(3, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnMaterialEntrada').pesquisa_array(['#txtMaterialEntrada'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Material', 'MATERIAL');
  $('#btnLimpaMaterialEntrada').on('click', function () {
    $('#txtMaterialEntrada').val('');
  });

  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ],"where": null}', 'Pesquisa Cor', 'CADCOR');
  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });
  // $('#btnLimpaLote').on('click', function () {
  //   $('#txtLote').val('');
  // });


  $('#txtMaterialEntrada').on('blur', function () {
    // $('#txtCor').off();
    $('#txtCor').unbind('autocompleta');
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], []);
    $('#btnCor').off();
    $('#btnCor').unbind('pesquisa_array');
    $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');

    $('#txtCor').on('blur', function () {
      const codigoMaterial = pegaChave('#txtMaterialEntrada');
      const codigoCor = pegaChave('#txtCor');

      // $('#txtLote').off();
      // $('#txtLote').unbind('autocompleta');
      // $('#txtLote').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["LOTE CHAVE", "LOTE DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}'"] }`, [], [], []);
      // $('#btnLote').off();
      // $('#btnLote').unbind('pesquisa_array');
      // $('#btnLote').pesquisa_array(['#txtLote'], ['LOTE'], ['LOTE'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.LOTE" ], "where": ["MAT_ITEN.CODIGO = '${codigoMaterial}' AND MAT_ITEN.COR = '${codigoCor}'"]}`, 'Pesquisa Lote', 'MAT_ITEN');
    });
  });

  let input = document.querySelector("#UnidadeMedidaMat");
  input.disabled = true;

  function montaObjetoMovimentacao() {
    const objetoMaterial = {
      NUM_DOCTO: $('#txtDocumento').val(),
      DT_MOVTO: $('#txtDataMovimentoEntrada').val(),
      CODCRE: pegaChave('#txtFuncionarioEntradaMat'),
      TP_MOV: pegaChave('#txtTipoEntradaMat'),
      CODIGO: pegaChave('#txtMaterialEntrada'),
      QUALIDADE: pegaChave('#txtQualidade'),
      COR: pegaChave('#txtCor'),
      LOTE: $('#txtLote').val() == '' ? '000000' : $('#txtLote').val(),
      DEPOSITO: pegaChave('#txtDeposito'),
      QTDE: parseFloat($('#txtQuantidade').val()),
      PRECO: parseFloat($('#txtPreco').val()),
      TIPO: 'MN',
    };
    return objetoMaterial;
  }

  async function buscaValoresPadroes() {
    $.LoadingOverlay('show');
    try {

      const classValores = { POSICAO: '0' };
      const response = await requisicao('POST', '/sisplan/valorespadroes/v1/buscar?', '', JSON.stringify(classValores), null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      insereValor('#txtTipoEntradaMat', jsonStr.tipoSaida);
      insereValor('#txtQualidade', jsonStr.qualidade);
      insereValor('#txtDeposito', jsonStr.deposito);
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function gravarMovimentacao(EstProd) {
    try {
      const url = '/sisplan/estoque/v1/movimentaestoquematerial?';
      const sLancto = $('#txtLancamento').val();
      const params = `JSON=${encodeURIComponent(JSON.stringify(EstProd))}&LANCTO=${sLancto}&TIPO=ENTRADA`;
      const response = await requisicao('POST', url, '', params, 30000);
      const codigo = pegaChave('#txtMaterialEntrada');
      const codigoDesc = pegaDescricao('#txtMaterialEntrada');
      const cor = pegaChave('#txtCor');
      const corDesc = pegaDescricao('#txtCor');
      const lote = $('#txtLote').val() == '' ? '000000' : $('#txtLote').val();
      const qtde = $('#txtQuantidade').val();
      const unidade = $('#UnidadeMedidaMat').val();

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      $('#tabela-movimentados').DataTable().row.add([codigo, codigoDesc, cor, corDesc, qtde, unidade, lote]).draw(false);

      toastr.success(
        'Movimentação efetuada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          LimpaCampos();
          setTimeout(() => { $('#txtMaterialEntrada').focus(); }, 200);
        }
      }
      ).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
    }
  }

  retornaHintRelatorio('Imprimir','movimentacao_material')

  $('#Imprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#tabela-movimentados').DataTable().rows().count() != 0) {
          let url = `/sisplan/impressao/v1/movmaterial?`;
          const tipoItem = 'M';
          const docto = $('#txtDocumento').val();
          const tipoMov = 'E';
          const bImprimeAutomatico = await verificaImprimirAutomatico('MovimentacaoMaterial');
          let arquivo = await GeraRelatorio(`${url}NUM_DOCTO=${docto}&TIPOITEM=${tipoItem}&TIPOMOV=${tipoMov}&`, 'GET', 100000, false, 'MovimentacaoMaterial');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } else {
          msgAlerta('Não há itens para serem imprimidos!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtMaterialEntrada').on('blur', async function () {
    try {
      const codigo = pegaChave('#txtMaterialEntrada');
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela":"MAT_ITEN", "camposSelect":[ "MATERIAL.CODIGO", "MATERIAL.DESCRICAO","MATERIAL.UNIDADE", "CADCOR.COR", "CADCOR.DESCRICAO AS DESCCOR", "MATERIAL.PRECO", "MAT_ITEN.QTDE", "MAT_ITEN.QUALIDADE", "TABQUL.DESCRICAO DESCQUALIDADE"], "leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_ITEN.CODIGO = MATERIAL.CODIGO " },{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR " },{ "tabela" : "TABQUL", "condicao" : "MAT_ITEN.QUALIDADE = TABQUL.CODIGO " }],"where": ["MATERIAL.CODIGO = '${codigo}'"]}`;
      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      insereValor('#txtQualidade', jsonStr.RESULT[0][0].QUALIDADE, jsonStr.RESULT[0][0].DESCQUALIDADE);
      $('#UnidadeMedidaMat').val(jsonStr.RESULT[0][0].UNIDADE);
      $('#txtPreco').val(jsonStr.RESULT[0][0].PRECO);

    } catch (error) {
      console.error(error);
    }
  });

  $('#txtDocumento').on('blur', async function () {
    try {
      let lancto;
      if ($(this).val() == '') {
        $.LoadingOverlay("show");
        let docto = await RetornaDoctoELancto('DOCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        lancto = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtDocumento', docto);
        insereValor('#txtLancamento', lancto);
        $(this).attr('disabled', $(this).val() != '');
      } else {
        lancto = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
        insereValor('#txtLancamento', lancto);
        $(this).attr('disabled', $(this).val() != '');
        let dataSet = await RetornaMovimentados($(this).val());
        $('#tabela-movimentados').DataTable().rows().remove().draw(false);
        for (let i = 0; i < dataSet.length; i++) {
          const item = dataSet[i];
          $('#tabela-movimentados').DataTable().row.add([item.CODIGO, item.DESCRICAO, item.COR, item.DESC_COR, item.QUANTIDADE, item.UNIDADE, item.LOTE]).draw(false);
        }
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#limpar_mov').on('click', function () {
    LimpaCampos();
    limpaValor('#txtDocumento');
    $('#txtDocumento').attr('disabled', false);
    $('#tabela-movimentados').DataTable().rows().remove().draw(false);
    $('#txtDocumento').focus();
  });

  $('#msform').validate({
    ignore: "",
    rules: {
      txtDocumento: {
        required: true,
      },
      txtFuncionarioSaidaMat: {
        required: true,
      },
      txtTipoBaixa: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtMaterialSaida: {
        required: true,
      },
      txtCor: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtQuantidade: {
        required: true,
      },
      txtPreco: {
        required: true,
      }
    },
    messages: {
      txtDocumento: {
        required: "Gere um documento para continuar."
      },
      txtFuncionarioSaidaMat: {
        required: "Informe um funcionário para continuar."
      },
      txtTipoBaixa: {
        required: "Informe um tipo de baixa para continuar."
      },
      txtQualidade: {
        required: "Informe uma qualidade para continuar."
      },
      txtMaterialSaida: {
        required: "Informe um material para continuar."
      },
      txtCor: {
        required: "Informe uma cor para continuar."
      },
      txtDeposito: {
        required: "Informe um deposito para continuar."
      },
      txtQuantidade: {
        required: "Informe uma quantidade válida para continuar."
      },
      txtPreco: {
        required: "Informe um preço válido para continuar."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }

  });

  $('#confirmar_mov').on('click', async function () {
    try {
      $('#confirmar_mov').prop('disabled', true);
      $.LoadingOverlay('show');
      try {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
          if (parseFloat($('#txtQuantidade').val()) <= 0) {
            msgErro('Não há quantidade para o material informado, verifique.');
            return;
          }

          if (parseFloat($('#txtQuantidade').val()) > (parseFloat($('#txtEstoque').val()))) {
            msgErro('Quantidade maior que o estoque, verifique.');
            return;
          }

          const objetoMovimentacao = montaObjetoMovimentacao();
          await gravarMovimentacao(objetoMovimentacao);
        }
      } catch (error) {
        console.error(error);
      }

    } finally {
      $('#confirmar_mov').prop('disabled', false);
      $.LoadingOverlay('hide');
    }
  });

  async function RetornaMovimentados(sDocto) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;
      const params = `JSON={"tabela": "MAT_MOV", "camposSelect": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO DESC_COR", "SUM(MAT_MOV.QTDE) QUANTIDADE", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"leftjoin": [{ "tabela" : "MATERIAL", "condicao" : "MAT_MOV.CODIGO = MATERIAL.CODIGO" }, { "tabela" : "CADCOR", "condicao" : "CADCOR.COR = MAT_MOV.COR" }],"groupby": ["MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO", "MATERIAL.UNIDADE", "MAT_MOV.LOTE"],"where": ["MAT_MOV.NUM_DOCTO = '${sDocto}' AND MAT_MOV.OPERACAO = 'E' "], "orderby": ["MAT_MOV.CODIGO", "MAT_MOV.COR"]}`;
      const response = await requisicao('GET', url, params, null);

      if (!response) {
        return '';
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      return jsonStr.RESULT[0];

    } catch (error) {
      console.error(error);
    }
  }

  function LimpaCampos() {
    limpaValor('#txtTipoEntradaMat');
    limpaValor('#txtQualidade');
    limpaValor('#txtLote');
    limpaValor('#UnidadeMedidaMat');
    limpaValor('#txtDeposito');
    limpaValor('#txtMaterialEntrada');
    limpaValor('#txtCor');
    limpaValor('#txtPreco');
  }

  const driver = new Driver({
    doneBtnText: 'Sair',
    closeBtnText: 'Fechar',
    nextBtnText: 'Próximo',
    prevBtnText: 'Anterior',
    allowClose: false,
    animate: true,
  });
  driver.defineSteps([{
    element: '#campostour',
    popover: {
      title: 'Dados Gerais',
      description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
      position: 'top'
    }
  },
  {
    element: '#txtDocumento',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtDataMovimentoEntrada',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtFuncionarioEntradaMat',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtTipoEntradaMat',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQualidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtMaterialEntrada',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtCor',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtLote',
    popover: {
      title: 'Número do lote',
      description: 'Se não informado irá levar o lote padrão 000000',
      position: 'top'
    }
  },
  {
    element: '#txtDeposito',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtQuantidade',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#txtPreco',
    popover: {
      title: 'Campos Obrigatórios',
      description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
      position: 'top'
    }
  },
  {
    element: '#limpar_mov',
    popover: {
      title: 'Botão Limpar',
      description: 'Clique aqui para limpar os campos.',
      position: 'left'
    }
  },
  {
    element: '#confirmar_mov',
    popover: {
      title: 'Botão Gravar',
      description: 'Clique aqui para gravar a movimentação.',
      position: 'left'
    }
  }
  ]);

  $('#tutorial').on('click', function () {
    driver.start();
  });

});



