$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar a ordem de compra a ser liberada.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de ordens de compra.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear as ordens de compra selecionadas.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  addPesquisaAutocompleta();

  retornaHintRelatorio('btnImprimir', 'relliberacaopedido')

  $('#btnImprimir').on('click', async function () {
    // if (!validaClique()) {
    //   msgAlerta('Necessário preencher os campos funcionário e status para continuar.')
    //   return;
    // }
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirliberacaopedido?`;
        const filtros = retornaFiltros(true);
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelLiberacaoPedido');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 480000, false, 'RelLiberacaoPedido');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await gerarLogImpressao();
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      limpaDados();
      $.LoadingOverlay('hide');
    }
  });

  async function gerarLogImpressao(){
    let pedidos = []
    $('#tabelaPedidos').DataTable().rows().every(function (){
      let item = this.data()

      pedidos.push(item.NUMERO)
    })

    for(let i = 0; i < pedidos.length; i++){
      await rotinaGeraLog('LIBERACAOEXPEDICAO', pedidos[i], `Funcionario: ${pegaChave('#txtFuncionario')} - ${pegaDescricao('#txtFuncionario')} fez a impressão do pedido: ${pedidos[i]} com o status: ${pegaChave('#txtStatus')} - ${pegaDescricao('#txtStatus')}`, 'Inclusão')
    }
  }

  $('#btnConsultar').on('click', async function () {
    // if (!validaClique()) {
    //   msgAlerta('Necessário preencher os campos funcionário e status para continuar.')
    //   return;
    // }
    try {
      $.LoadingOverlay('show');
      let dataSetCols = [];
      const url = '/sisplan/impressao/v1/consultaliberacaopedido?';
      const filtros = retornaFiltros();

      const response = await requisicao('GET', url, filtros, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        limpaDados();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      criaDataTablePadrao('#tabelaPedidos', false, false, false, false, true, false, '400px', jsonStr, dataSetCols, [4], [3]);

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  // function validaClique() {
  //   if ((pegaValor('#txtStatus') == '') || (pegaValor('#txtFuncionario') == '')) {
  //     return false;
  //   }
  //   return true;
  // }

  function limpaDados() {
    $('#txtFuncionario').val('');
    $('#txtStatus').val('');
    $('#txtPedido').val('');
    $('#txtTpVenda').val('');
    if ($.fn.DataTable.isDataTable("#tabelaPedidos")) {
      $("#tabelaPedidos").DataTable().rows().remove().draw();
    }
  }

  function retornaFiltros(bImprimir = false) {
    let arrPedidos = '';
    if (bImprimir) {
      $('#tabelaPedidos').DataTable().rows().data().map(item => { arrPedidos == '' ? arrPedidos += "'" + item.NUMERO + "'" : arrPedidos += ",'" + item.NUMERO + "'" });
    }
    const retorno =
      `QTDE=${pegaValor('#selectQuantidade')}` +
      `&STATUS=${pegaChave('#txtStatus')}` +
      `&TRANSPORTADORA=${pegaChave('#txtTransportadora')}` +
      `&FUNCIONARIO=${pegaDescricao('#txtFuncionario')}` +
      `&CODFUNCIONARIO=${pegaChave('#txtFuncionario')}` +
      `&PEDIDO=${pegaChave('#txtPedido')}` +
      `&TPVENDA=${pegaChave('#txtTpVenda')}` +
      `&IMPRESSO=${isChecked('#checkImpresso') ? 'S' : 'N'}` +
      `&EMP_ID=${getCookie('emp_id')}` +
      `&PEDIDOS=${arrPedidos}`
    return retorno;
  }

  function addPesquisaAutocompleta() {
    $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
    $('#btn-Funcionario').pesquisa('#txtFuncionario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Usuário', 'ACESSO_USUARIOS');
    $('#btn-limpa-Funcionario').on('click', function () { $('#txtFuncionario').val(''); });

    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val(''); });

    $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO chave", "NOME DESCRICAO"], "where": null}`);
    $('#btn-Transportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
    $('#btn-limpa-Transportadora').on('click', function () { $('#txtTransportadora').val(''); });

    $('#txtTpVenda').autocompleta(1, `JSON={ "tabela":"TIPO", "camposSelect":[ "ID_TIPO chave", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-TpVenda').pesquisa('#txtTpVenda', 'ID_TIPO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO"]}`, 'Pesquisa Tipo de Venda', 'TIPO');
    $('#btn-limpa-TpVenda').on('click', function () { $('#txtTpVenda').val(''); });

    $('#btn-Pedido').pesquisa_serverside(
      ['#txtPedido', '#txtDeposito'],
      ['PEDIDO.NUMERO', 'PEDIDO.CODCLI'],
      ['ENTIDADE.NOME', 'PEDIDO.PED_CLI'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"}
        ],
        "where": null
       }`,
      'Pesquisa Pedido'
    );
    $('#btn-limpa-Pedido').on('click', function () { $('#txtPedido').val(''); });
  }

  const data = await buscaValor('TABPADRAO', 'VALOR', `TABELA = 'LIBERACAO_EXPEDICAO' AND CAMPO`, 'STATUS');
  if (data) {
    insereValor('#txtStatus', data.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.VALOR });
  }
});