<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Manutencao Inventario</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.243.6.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.243.6.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.243.6.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.243.6.1">
  <style>
    #tabelaInventario td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    /* #tabelaInventario td {
      padding: 0 !important;
      padding-left: 10px !important;
    } */

    .divBtnOpcoes {
      align-items: center;
      align-self: center;
      flex-direction: row;
      margin-top: auto;
    }

    .ArredondaBordas {
      border-radius: 5px;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Manutenção Inventário</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">
                
                <li class="breadcrumb-item active">Manutenção Inventário</li>
              </ol> -->
            </div>
          </div>
        </div>
        <div class="container-fluid" id="tabelaInventarioForne">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btn-filtros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btn-incluir"><span class="fa fa-plus"></span> Incluir</button>
              <button class="btn btn-success btn-sisp" id="btnImprimir" title="Imprimir os dados filtrados">
                <i class="fas fa-print"></i> Imprimir
              </button>
            </div>
            <div class="col-sm-12 table-responsive card-body">

              <h5>Lista de Inventários</h5>
              <table id="tabelaInventario" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Tipo
                    </th>
                    <th class="th-sm">Chave
                    </th>
                    <th class="th-sm">Lançamento
                    </th>
                    <th class="th-sm">Código
                    </th>
                    <th class="th-sm">Descrição
                    </th>
                    <th class="th-sm">Tamanho
                    </th>
                    <th class="th-sm">Cor
                    </th>
                    <th class="th-sm">Setor
                    </th>
                    <th class="th-sm">QTDE
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="modal" id="modal-filtros">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h4 class="modal-title">Filtros
                  <label style="font-size: 60%" class="container escondeRadio">Produto 
                    <input type="radio" checked="checked" id="radioProduto" name="tipoFat">
                    <span class="checkmark"></span>
                  </label>
                  <!-- <label style="font-size: 60%; margin-left: -2.5%" class="container escondeRadio">Material 
                    <input type="radio" id="radioMaterial" name="tipoFat">
                    <span class="checkmark"></span>
                  </label> -->
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body" id="modal-conteudo">
                <form id="msform2" name="msform2">
                  <div class="row">
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="dtCadastroDe">Cadastro de: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" value="1200-01-01" id="dtCadastroDe" name="dtCadastroDe" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-12 m-6 form-group">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="dtCadastroAte">Até: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" class="input-default focus form-control" value="2500-12-31" id="dtCadastroAte" name="dtCadastroAte" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <label data-error="wrong" data-success="right" for="txtLancamentoPesquisa">Lançamento</label>
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtLancamentoPesquisa" name="txtLancamentoPesquisa" class="form-control" placeholder="Lançamento">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-limpa-lancamento" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <label data-error="wrong" data-success="right" id="lblProduto" for="txtProduto">Código</label>
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-produto-filtro" name="btn-produto-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-produto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <label data-error="wrong" data-success="right" for="txtDeposito">Depósito</label>
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Deposito">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-deposito-filtro" name="btn-deposito-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <label data-error="wrong" data-success="right" for="txtSetor">Setor</label>
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtSetor" name="txtSetor" class="form-control" placeholder="Setor">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-setor-filtro" name="btn-setor-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-setor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-12">
                      <label data-error="wrong" data-success="right" for="txtCor">Cor</label>
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" class="form-control" placeholder="Cor">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-cor-filtro" name="btn-cor-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-cor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
              <div class="modal-footer">
                <div class="row">
                  <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                  <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <section class="content">
    <div class="modal fade" id="modal-manutencao">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h4 id="modal-itens-title" class="modal-title">Manutenção</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-9">
                <label data-error="wrong" data-success="right" for="txtLancamentoEditar">Lançamento</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtLancamentoEditar" name="txtLancamentoEditar" class="form-control" placeholder="Gerado Automaticamente" disabled="">
                  <div class="input-group-append">
                  </div>
                </div>
              </div>
              <div class="col-3">
                <label data-error="wrong" data-success="right" for="txtChaveEditar">Chave</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtChaveEditar" name="txtChaveEditar" class="form-control" placeholder="Gerado Automaticamente" disabled="">
                  <div class="input-group-append">
                  </div>
                </div>
              </div>
              <div class="col-6">
                <label data-error="wrong" data-success="right" for="txtProdutoEditar">Código</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtProdutoEditar" name="txtProdutoEditar" class="form-control" placeholder="Código">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-produto-filtro-editar" name="btn-produto-filtro-editar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-produto-editar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-6">
                <label data-error="wrong" data-success="right" for="txtDepositoEditar">Depósito</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtDepositoEditar" name="txtDepositoEditar" class="form-control" placeholder="Deposito">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-deposito-filtro-editar" name="btn-deposito-filtro-editar" data-button="absolute" type="button" disabled=""><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-deposito-editar" type="button" disabled=""><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-6">
                <label data-error="wrong" data-success="right" for="txtSetorEditar">Setor</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtSetorEditar" name="txtSetorEditar" class="form-control" placeholder="Setor">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-setor-filtro-editar" name="btn-setor-filtro-editar" data-button="absolute" type="button" disabled=""><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-setor-editar" type="button" disabled=""><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-2">
                <label data-error="wrong" data-success="right" for="txtUnEditar">UN.</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtUnEditar" name="txtUnEditar" class="form-control" placeholder="UN." disabled="">
                  <div class="input-group-append">
                  </div>
                </div>
              </div>
              <div class="col-4">
                <label>Posse</label>
                <select id="txtPosseEditar" class="input-default focus custom-select">
                  <option value="" selected disabled>Selecione uma opção</option>
                  <option value="0">Não informado
                  </option>
                  <option value="1">Mercadoria de propriedade do informante e em seu poder</option>
                  <option value="2">Mercadoria de propriedade do informante e em poder de terceiros</option>
                  <option value="3">Mercadoria de propriedade de terceiros em poder do informante</option>
                </select>
              </div>
              <div class="col-4">
                <label data-error="wrong" data-success="right" for="txtCorEditar">Cor</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCorEditar" name="txtCorEditar" class="form-control" placeholder="Cor">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-cor-filtro-editar" name="btn-cor-filtro-editar" data-button="absolute" type="button" disabled=""><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-cor-editar" type="button" disabled=""><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-4">
                <label data-error="wrong" data-success="right" for="txtQualidadeEditar">Qualidade</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtQualidadeEditar" name="txtQualidadeEditar" class="form-control" placeholder="Qualidade" disabled="">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-qualidade-filtro-editar" name="btn-qualidade-filtro-editar" data-button="absolute" type="button" disabled=""><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-qualidade-editar" type="button" disabled=""><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-4">
                <label data-error="wrong" data-success="right" for="txtCnpjEditar">CNPJ.</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCnpjEditar" name="txtCnpjEditar" class="form-control" placeholder="CNPJ" disabled="">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-cnpj-filtro-editar" name="btn-cnpj-filtro-editar" data-button="absolute" type="button" disabled=""><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-cnpj-editar" type="button" disabled=""><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-4">
                <label data-error="wrong" data-success="right" for="txtDataEditar">Data</label>
                <div class="input-group">
                  <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataEditar" name="txtDataEditar" class="form-control" placeholder="Data">
                  <div class="input-group-append">
                  </div>
                </div>
              </div>
              <div class="col-4">
                <label data-error="wrong" data-success="right" for="txtTamaEditar">Tamanho</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtTamEditar" name="txtTamEditar" class="form-control" placeholder="Tamanho">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-tam-filtro-editar" name="btn-tam-filtro-editar" data-button="absolute" type="button" disabled=""><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-tam-editar" type="button" disabled=""><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-4">
                <label data-error="wrong" data-success="right" for="txtLoteEditar">Lote</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtLoteEditar" name="txtLoteEditar" class="form-control" placeholder="Lote">
                  <div class="input-group-append">
                  </div>
                </div>
              </div>
              <div class="col-3">
                <label data-error="wrong" data-success="right" for="txtQtdeEditar">Quant.</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control; ArredondaBordas" id="txtQtdeEditar" name="txtQtdeEditar" class="form-control" placeholder="Quant.">
                  <div class="input-group-append">
                    <!-- <button class="btn bg-danger" id="btn-qtde-filtro-editar" name="btn-qtde-filtro-editar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-qtde-editar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button> -->
                  </div>
                </div>
              </div>
              <div class="col-3">
                <label data-error="wrong" data-success="right" for="txtPrecoEditar">Preço</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control; ArredondaBordas" id="txtPrecoEditar" name="txtPrecoEditar" class="form-control" placeholder="Preço">
                  <div class="input-group-append">
                    <!-- <button class="btn bg-danger" id="btn-qtde-filtro-editar" name="btn-qtde-filtro-editar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-qtde-editar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button> -->
                  </div>
                </div>
              </div>
              <div class="col-3">
                <label data-error="wrong" data-success="right" for="txtPrecoCorEditar">Preço Cor</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control; ArredondaBordas" id="txtPrecoCorEditar" name="txtPrecoCorEditar" class="form-control" placeholder="Preco Cor">
                  <div class="input-group-append">
                    <!-- <button class="btn bg-danger" id="btn-qtde-filtro-editar" name="btn-qtde-filtro-editar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-qtde-editar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button> -->
                  </div>
                </div>
              </div>
              <div class="col-3">
                <label data-error="wrong" data-success="right" for="txtPrecoDivEditar">Preço Div.</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control; ArredondaBordas" id="txtPrecoDivEditar" name="txtPrecoDivEditar" class="form-control" placeholder="Preco Div">
                  <div class="input-group-append">
                    <!-- <button class="btn bg-danger" id="btn-qtde-filtro-editar" name="btn-qtde-filtro-editar" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-qtde-editar" type="button"><i class="m-0 p-0 fas fa-trash"></i></button> -->
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-between">
            <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
            <button id="confirmar-dados" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
            <button id="confirmar-dadosincluir" type="button" class="btn bg-gradient-success btn-sisp d-none">Confirmar</button>
          </div>
        </div>
      </div>
    </div>
    <input type="text" class="d-none" id="txtLinhaEditada">

  </section>

  <?php
  include_once('../../../footer.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.243.6.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/sisplan.js?versao=3.243.6.1"></script>
  <script src="utils/funcoes.js?versao=3.243.6.1"></script>
  <script src="utils/cookies.js?versao=3.243.6.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.243.6.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/driver.min.js?versao=3.243.6.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="config.js?versao=3.243.6.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('MANUTENCAOINVENTARIO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/inventario/manutencaoinventario/manutencaoinventario.js?versao=3.243.6.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>