<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Inventário Material</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.243.6.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.243.6.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.243.6.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.243.6.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


</head>
<style>
  #msform {
    text-align: start;
    position: relative;
  }

  .card {
    box-shadow: none !important;
    border-radius: 0 !important;
    margin-bottom: 0 !important;
  }

  .card-header {
    box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
  }

  .card-body {
    margin-left: 0px !important;
    padding-left: 1.25rem !important;
    padding-top: 0px;
    padding-bottom: 0px;
    padding-right: 1.25rem !important;
  }

  .header-content-page .title-page,
  .title-content-page .title,
  .title-page {
    font-size: 20px;
    line-height: normal;
    font-weight: 500;
    color: #343a40;
    margin: 0;
    font-family: Roboto, Arial, sans-serif;
  }

  .form-group {
    margin-bottom: 0.2rem;
  }

  .border-Field {
    border: 1px groove #ddd !important;
    padding: 0 1.0em 1.0em 1.0em !important;
    margin: 0 0 1.0em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
  }

  .border-Field .textoBorda {
    font-size: 1.1em !important;
    text-align: left !important;
    width: auto;
    padding: 0 10px;
    border-bottom: none;
  }
</style>


<body class="hold-transition sidebar-mini layout-fixed">

  <script type="text/javascript" src="config.js"></script>
  <main class="wrapper">

    <?php
    include_once('../../../menu.php');
    ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h3 class="col-mb=2"></h3>
            </div>
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">

                <li class="breadcrumb-item active">Inventário Materiais</li>
              </ol> -->
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <div class="card" style="height:auto;">
                <div class="card-header bg-dark">
                  <div class="row flex">
                    <h4 class="text-white">Inventário Materiais </h4>
                    <button title="Tutorial" class="btn btn-info btn-sm ml-2" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </div>
                </div>
                <fieldset>
                  <div class="card-body" style="padding-left: 0rem!important; padding-right: 0rem!important;">
                    <form id="msform" name="msform">
                      <div class="card card-body" style="padding-top: 10px;">
                        <div class="row" style="min-height: 150px;">
                          <div class="col-md-7 col-12">
                            <div class="col-12">
                              <div class="row">
                                <div class="col-md-6 col-12 form-group" id="QualidadeInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtQualidade">Qualidade *</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtQualidade" name="txtQualidade" class="form-control" placeholder="Qualidade">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Qualidade" name="btn-Qualidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Qualidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-6 col-12">
                                  <label for="txtData">Data *</label>
                                  <div class="relative">
                                    <input type="date" max="2500-12-31" value="" class="input-default focus form-control validate" id="txtData">
                                  </div>
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-md-6 col-12 form-group" id="DepositoInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtDeposito">Depósito *</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Depósito">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Deposito" name="btn-Deposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-6 col-12 form-group" id="SetorInfoTour">
                                  <label data-error="wrong" data-success="right" for="txtSetor">Setor *</label>
                                  <div class="input-group">
                                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSetor" name="txtSetor" class="form-control" placeholder="Setor">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Setor" name="btn-Setor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Setor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-12 col-12 form-group d-none" id="materialDivPrincipal">
                                  <label data-error="wrong" data-success="right" for="txtMaterial">Material *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default form-control focus" id="txtMaterial" name="txtMaterial" class="form-control" placeholder="Material">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Material" name="btn-Material" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Material" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-6 col-12 form-group d-none" style="margin-bottom: 15px" id="corPrincipal">
                                  <label data-error="wrong" data-success="right" for="txtCor">Cor *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default form-control focus" id="txtCor" name="txtCor" class="form-control" placeholder="Cor">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-Cor" name="btn-Cor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-Cor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-md-6 col-12 form-group d-none" style="margin-bottom: 15px" id="qtdePrincipal">
                                  <label data-error="wrong" data-success="right" for="txtQtde">Qtde *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default form-control focus" id="txtQtde" name="txtQtde" class="form-control" placeholder="Qtde">
                                  </div>
                                </div>
                              </div>
                              <div class="row" style="margin-bottom: 15px" id="barraPrincipal">
                                <div class="col-md-12 col-12">
                                  <label for="txtBarra">Barra *</label>
                                  <div class="relative">
                                    <input type="text" class="input-default focus form-control" id="txtBarra" name="txtBarra">
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="col-md-5 col-12">
                            <div class="col-md-12 col-12" id="pesos">
                              <fieldset class="border-Field">
                                <legend class="textoBorda">Quando peso for zerado buscar</legend>
                                <div>
                                  <div class="form-check">
                                    <input class="form-check-input pesos focus" name="radioPeso" value="0" type="radio" id="checkQtdeOrg"> <label for="checkQtdeOrg">Quantidade original estoque</label>
                                  </div>
                                  <div class="form-check">
                                    <input class="form-check-input pesos focus" name="radioPeso" value="1" type="radio" id="checkUltMov"> <label for="checkUltMov">Última movimentação de entrada</label>
                                  </div>
                                </div>
                              </fieldset>
                            </div>
                            <div class="col-md-6 col-12" id="tipos">
                              <fieldset class="border-Field">
                                <legend class="textoBorda">Tipo</legend>
                                <div>
                                  <div class="form-check">
                                    <input class="form-check-input barras focus" name="radioBarras" value="0" type="radio" id="checkBarra"> <label for="checkBarra">Barra</label>
                                  </div>
                                  <div class="form-check">
                                    <input class="form-check-input barras focus" name="radioBarras" value="1" type="radio" id="checkManual"> <label for="checkManual">Manual</label>
                                  </div>
                                </div>
                              </fieldset>
                            </div>
                            <fieldset class="border-Field col-md-6 col-12" id="opcoes">
                              <legend class="textoBorda">Opções</legend>
                              <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="checkBarraPorLote"> <label for="checkBarraPorLote">Barra por Lote</label>
                              </div>
                            </fieldset>
                            <div class="row col-md-6 col-12 form-group d-none" style="margin-top: 7px; margin-left: 8px;" id="btnAdd">
                              <input type="button" class="btn btn-sm btn-primary ml-2 focus" id="btn-adicionar" style="font-size: 120%;" value="Adicionar">
                            </div>
                          </div>
                        </div>
                        <div class="row">
                          <div class="table-responsive">
                            <table id="tabelaInventarioMaterial" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <td>CODIGO</td>
                                  <td>DESCRICAO</td>
                                  <td>UNIDADE</td>
                                  <td>COR</td>
                                  <td>LOTE</td>
                                  <td>QTDE</td>
                                  <td>PRECO</td>
                                  <td>VALOR</td>
                                  <td>DEPOSITO</td>
                                  <td>POSSE</td>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                      <button type="button" id="btnGravar" style="font-size:15px; margin-right: 10px;" class="btn btn-danger btn-sisp action-button">Gravar</button>
                      <button type="button" id="btnCancelar" style="font-size:15px;" class="btn btn-success btn-sisp action-button-previous">Cancelar</button>
                    </form>
                  </div>
                </fieldset>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modalCadPeso" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h4 id="modalCadPeso-titulo" class="modal-title">Inventário de Materiais</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-12">
                <div class="group-default form-group">
                  <label data-error="wrong" data-success="right" for="txtPrecoManual">Informe o peso do rolo:</label>
                  <input type="number" min=0 placeholder="Peso" class="input-default" id="txtPesoManual" name="txtPesoManual">
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <div class="col-sm-12">
                <button type="button" id="btn_confirmar_peso" class="btn btn-danger"> Confirmar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <input type="text" class="d-none" id="ultimoCodigo">

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php
    include_once('../../../footer.php');
    ?>
    <?php include_once('../../../menu_fiscal.php'); ?>
  </main>

  <script src="plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.243.6.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.243.6.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.243.6.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.243.6.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.243.6.1"></script>
  <script src="dist/js/sisplan.js?versao=3.243.6.1"></script>
  <script src="utils/funcoes.js?versao=3.243.6.1"></script>
  <script src="utils/cookies.js?versao=3.243.6.1"></script>
  <script src="dist/js/driver.min.js?versao=3.243.6.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      sArquivo = `${BASE_URI}/pages/inventario/inventarioMat/inventarioMat.js?versao=3.243.6.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      const temAcesso = await temAcessoTela('INVENTARIOMAT');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>