$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#txtQualidade',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtData',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtDeposito',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtSetor',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtBarra',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#tipos',
        popover: {
          title: 'Tipo',
          description: 'Aqui você define qual tipo de quer usar.',
          position: 'top'
        }
      },
      {
        element: '#opcoes',
        popover: {
          title: 'Opções',
          description: 'Aqui você pode selecionar algumas opções.',
          position: 'top'
        }
      },
      {
        element: '#tabelaInventarioMaterial',
        popover: {
          title: 'Tabela Inventário de Material',
          description: 'Aqui ficam todos os dados dos itens que forem bipados.',
          position: 'top'
        }
      },
      {
        element: '#btnCancelar',
        popover: {
          title: 'Botão Cancelar',
          description: 'Ao clicar nesse botão você cancela todos os itens passados.',
          position: 'left'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gerar',
          description: 'Clique aqui para gerar o inventário.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  await setarDataAtual('txtData');

  $('#txtDeposito').autocompleta(1, 'JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#txtQualidade').autocompleta(1, 'JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#txtSetor').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#txtMaterial').autocompleta(1, 'JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#txtCor').autocompleta(1, 'JSON={ "tabela":"CADCOR", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');

  $('#btn-Deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Deposito', 'DEPOSITO');
  $('#btn-Qualidade').pesquisa('#txtQualidade', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Qualidade', 'TABQUL');
  $('#btn-Setor').pesquisa('#txtSetor', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Setor', 'CADFLUXO');
  $('#btn-Material').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Material', 'MATERIAL');
  $('#btn-Cor').pesquisa('#txtCor', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "CODIGO", "DESCRICAO"]}', 'Pesquisa Cor', 'CADCOR');

  $('#btn-limpa-Deposito').on('click', function () {
    $('#txtDeposito').val('');
  });
  $('#btn-limpa-Qualidade').on('click', function () {
    $('#txtQualidade').val('');
  });
  $('#btn-limpa-Setor').on('click', function () {
    $('#txtSetor').val('');
  });
  $('#btn-limpa-Material').on('click', function () {
    $('#txtMaterial').val('');
  });
  $('#btn-limpa-Cor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#txtMaterial').on('blur', function () {
    // $('#txtCor').off();
    $('#txtCor').unbind('autocompleta');
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btn-Cor').off();
    $('#btn-Cor').unbind('pesquisa');
    $('#btn-Cor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
  });

  let inputBarras = $('.barras');
  inputBarras.on('click', function () {
    inputBarras.get().forEach(function (ev) {
      let event = ev;
      event.checked = ev == this && this.checked;
    }, this);
  });

  $('#tabelaInventarioMaterial').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: false,
    destroy: true,
    columnDefs: [
      {
        "render": function (data) {
          return parseFloat(data).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          })
        },
        "targets": [6, 7],
        "className": 'pr-4 text-right'
      },
      {
        "targets": [5],
        "className": 'pr-4 text-right'
      }
    ],
  });

  $("#checkBarra").attr("checked", true);
  $("#checkQtdeOrg").attr("checked", true);
  $("#txtQtde").val(1);
  $('#txtQualidade').val('[1] - PRIMEIRA');

  $('#btnAddCondicao').on('keypress', function () {
    $('#btnAddCondicao').trigger('click');
  });

  $('#btn-adicionar').on('keypress', function () {
    $('#btn-adicionar').trigger('click');
  });

  $('#txtSetor').on("focus", function () {
    let that = $(this);
    setTimeout(function () {
      that.select();
    }, 1)
  }).on('keydown', function (e) {
    if ((e.key == 'Tab') || (e.key == 'Enter')) {
      e.preventDefault();
      $('#txtBarra').focus();
      $('#txtBarra').click();
    }
  });

  $('#txtQtde').on("focus", function () {
    let that = $(this);
    setTimeout(function () {
      that.select();
    }, 1)
  }).on('keydown', function (e) {
    if ((e.key == 'Tab') || (e.key == 'Enter')) {
      e.preventDefault();
      $('#btn-adicionar').focus();
      // $('#txtBarra').click();
    }
  });

  // $('#txtBarra').on('change', async function () {
  //   // $('#txtBarra').focus();
  // });

  $('#tipos').on('change', async function () {
    if ($('#checkManual').prop('checked')) {
      $('#barraPrincipal').addClass('d-none');
      $('#materialDivPrincipal').removeClass('d-none');
      $('#corPrincipal').removeClass('d-none');
      $('#qtdePrincipal').removeClass('d-none');
      $('#btnAdd').removeClass('d-none');
    }
    if ($('#checkBarra').prop('checked')) {
      $('#barraPrincipal').removeClass('d-none');
      $('#materialDivPrincipal').addClass('d-none');
      $('#corPrincipal').addClass('d-none');
      $('#qtdePrincipal').addClass('d-none');
      $('#btnAdd').addClass('d-none');
    }
  });

  $('#btnGravar').on('click', async function () {
    try {
      $('#btnGravar').prop('disabled', true);
      $.LoadingOverlay("show");
      try {

        if ($('#txtSetor').val() == '') {
          msgAlerta('Setor não informado ou inválido!');
        }

        if ($('#txtData').val() == '') {
          msgAlerta('Data não informada ou inválida!');
        }

        for (let i = 0; i < $('#tabelaGerarInventarioLoja').DataTable().rows().count(); i++) {
          const dados = $('#tabelaGerarInventarioLoja').DataTable().row(i).data();
          const dadosValidacao = dados[5];
          const saoIguais = dadosValidacao === 0
          if (saoIguais) {
            $('#tabelaGerarInventarioLoja').DataTable().row(i).data(dados).remove().draw(false);
          }
        }

        let objetoInventario = await preencheJson();

        const response = await requisicao('POST', '/sisplan/inventario/v1/inventariomat?', `JSON=${encodeURIComponent(JSON.stringify(objetoInventario))}`, null);
        if (!response) {
          return;
        }

        if (response.status != 200) {
          const jsonInventario = await response.json();
          msgErro(jsonInventario.mensagem);
          return;
        }
        toastr.success(
          'Cadastro efetuado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        limpaCampos();
      } catch (error) {
        console.error(error);
      }
    } finally {
      $('#btnGravar').prop('disabled', false);
      $.LoadingOverlay("hide");
    }

    await deletaArquivo('JsonInventarioMaterial');
  });

  function limpaCampos() {
    $('#tabelaInventarioMaterial').DataTable().clear().draw(false);
    $('#txtQualidade').val('[1] - PRIMEIRA');
    $('#txtDeposito').val('');
    $('#txtSetor').val('');
    $('#txtQtde').val(1);
    $('#txtBarra').val('');
    $('#txtMaterial').val('');
    $('#txtCor').val('');
    if ($('#checkManual').prop('checked')) {
      $("#checkBarra").attr("checked", true);
    }
    if ($('#checkBarraPorLote').prop('checked')) {
      $("#checkBarraPorLote").prop("checked", false);
    }
    if ($('#checkControlaPeca').prop('checked')) {
      $("#checkControlaPeca").prop("checked", false);
    }
  }

  $('#modalCadPeso').on('shown.bs.modal', function () {
    $('#txtPesoManual').val('');
    $('#txtPesoManual').focus();
  });

  $('#btnCancelar').on('click', async function () {
    msgAlerta('Deseja realmente cancelar os itens passados?', cancelaItens);
    await deletaArquivo('JsonInventarioMaterial');

  });

  async function cancelaItens() {
    $('#tabelaInventarioMaterial').DataTable().clear().draw(false);

    const data = new Date();
    await rotinaGeraLog('INVENTARIO MATERIAL', data.toLocaleDateString(), 'INVENTARIO CANCELADO MATERIAL- BOTAO CANCELAR SELECIONADO', 'Exclusão');

  }

  $('#btn-adicionar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#txtQualidade').val() === '') {
          msgAlerta('Qualidade inválida ou não informada!');
          return;
        }
        if ($('#txtDeposito').val() === '') {
          msgAlerta('Depósito inválido ou não informado!');
          return;
        }
        if ($('#txtMaterial').val() != '') {
          if ($('#txtCor').val() != '') {
            if ($('#txtQtde').val() != '') {
              if ($('#txtQtde').val() == 0) {
                msgAlerta('Quantidade não informada ou igual a zero. Impossível Continuar!');
                return;
              }

              const url = '/sisplan/funcoes/v1/pesquisa?';
              const qualidade = `AND MAT_ITEN.QUALIDADE = '${pegaChave(('#txtQualidade'))}'`;
              const deposito = `AND MAT_ITEN.DEPOSITO = '${pegaChave(('#txtDeposito'))}'`;
              const codigo = `AND MAT_ITEN.CODIGO = '${pegaChave(('#txtMaterial'))}'`;
              const cor = `AND MAT_ITEN.COR = '${pegaChave(('#txtCor'))}'`;

              const responseDeposito = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["DEPOSITO", "BARRA", "LOTE"], "where":["1=1 ${codigo} ${deposito}"]}`, null);

              if (!responseDeposito) {
                return;
              }

              const jsonInventarioDeposito = await responseDeposito.json();
              if (responseDeposito.status != 200) {
                msgErro(jsonInventarioDeposito.mensagem);
                return;
              }

              if (jsonInventarioDeposito.RESULT[0].length == 0) {
                msgAlerta('Material não está no depósito que está sendo inventariado. Impossível continuar!');
                return;
              }

              const response = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.CODIGO", "MATERIAL.DESCRICAO AS DESCRICAO", "MATERIAL.UNIDADE", "MAT_ITEN.COR", "MAT_ITEN.LOTE", "MATERIAL.POSSE", "MAT_ITEN.DEPOSITO", "MAT_ITEN.QUALIDADE", "PRECO_MED"], 
              "leftjoin": [{"tabela" : "MATERIAL", "condicao" : "MATERIAL.CODIGO = MAT_ITEN.CODIGO"}],
              "where":["1=1 ${codigo} ${deposito} ${cor} ${qualidade}"]}`, null);

              if (!response) {
                return;
              }
              const jsonInventario = await response.json();
              if (response.status != 200) {
                msgErro(jsonInventario.mensagem);
                return;
              }

              jsonInventario.RESULT[0][0].POSSE == 0 ? jsonInventario.RESULT[0][0].POSSE = '0 - Não informado' : jsonInventario.RESULT[0][0].POSSE == 1 ? jsonInventario.RESULT[0][0].POSSE = '1 - Mercadoria de propriedade do informante e em seu poder' : jsonInventario.RESULT[0][0].POSSE == 2 ? jsonInventario.RESULT[0][0].POSSE = '2 - Mercadoria de propriedade do informante em poder de terceiros' : jsonInventario.RESULT[0][0].POSSE == 3 ? jsonInventario.RESULT[0][0].POSSE = '3 - Mercadoria de propriedade de terceiros em poder do informante' : '';

              const jsonFormatado = jsonInventario.RESULT[0][0]

              await preencheObjetoLinhaNova(jsonFormatado);
              $('#txtMaterial').val('');
              $('#txtCor').val('');
              $('#txtQtde').val(1);
            } else {
              msgAlerta('Quantidade não informada ou igual a zero. Impossível Continuar!');
            }
          } else {
            msgAlerta('Cor inexistente ou não informada. Impossível continuar!');
          }
        } else {
          msgAlerta('Material inexistente ou não informado. Impossível continuar!');
        }
      } catch (error) {
        msgErro('Erro ao buscar item.');
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }

    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo('JsonInventarioMaterial', jsonarquivo);
  });

  async function validaLoteDepositoMaterial(barra, codigo, deposito) {
    try {
      const url = '/sisplan/funcoes/v1/pesquisa?';
      const barraPorLoteCheck = $('#checkBarraPorLote').is(':checked');
      const responseLote = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["LOTE"], "where":["LOTE = '${barra}'"]}`, null);

      if (!responseLote) {
        return true;
      }

      const jsonInventarioLote = await responseLote.json();
      if (responseLote.status != 200) {
        msgErro(jsonInventarioLote.mensagem);
        return true;
      }

      if (jsonInventarioLote.RESULT[0].length > 0 && (!barraPorLoteCheck)) {
        msgAlerta('Marque a opção Barra por Lote para fazer o inventário pelo Lote.');
        return true;
      }

      const responseCodigo = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["CODIGO"], "where":["CODIGO = '${barra}'"]}`, null);

      if (!responseCodigo) {
        return true;
      }

      const jsonInventarioCodigo = await responseCodigo.json();
      if (responseCodigo.status != 200) {
        msgErro(jsonInventarioCodigo.mensagem);
        return true;
      }

      if (jsonInventarioCodigo.RESULT[0].length > 0) {
        msgAlerta('Material Existente! Use a Opção Tipo Manual Para Fazer o Inventário Pelo Código de Material.');
        $('#txtBarra').val('');
        return true;
      }

      const responseBarraLote = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["BARRA", "LOTE"], "where":["1=1 ${codigo}"]}`, null);

      if (!responseBarraLote) {
        return true;
      }

      const jsonInventarioBarraLote = await responseBarraLote.json();
      if (responseBarraLote.status != 200) {
        msgErro(jsonInventarioBarraLote.mensagem);
        return true;
      }

      if (jsonInventarioBarraLote.RESULT[0].length == 0) {
        msgAlerta('Barra/Lote do Material Inexistente!');
        return true;
      }

      const responseDeposito = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["DEPOSITO", "BARRA", "LOTE"], "where":["1=1 ${codigo} ${deposito}"]}`, null);

      if (!responseDeposito) {
        return true;
      }

      const jsonInventarioDeposito = await responseDeposito.json();
      if (responseDeposito.status != 200) {
        msgErro(jsonInventarioDeposito.mensagem);
        return true;
      }

      if (jsonInventarioDeposito.RESULT[0].length == 0) {
        msgAlerta('Material não está no depósito que está sendo inventariado. Impossível continuar!');
        return true;
      }
      return false;

    } catch (error) {
      msgErro('Erro ao validar Lote/Depósito/Material.');
      console.error(error);
    }
  }

  $('#txtBarra').on('blur', async function () {
    if ($('#txtBarra').val() != '') {
      const barra = $('#txtBarra').val();
      $('#ultimoCodigo').val(barra);
      if ($('#txtDeposito').val() != '') {
        if ($('#txtQualidade').val() != '') {
          try {
            $.LoadingOverlay('show');
            try {
              const qualidade = `AND MAT_ITEN.QUALIDADE = '${pegaChave(('#txtQualidade'))}'`;
              const deposito = `AND MAT_ITEN.DEPOSITO = '${pegaChave(('#txtDeposito'))}'`;
              const codigo = $('#checkBarraPorLote').prop('checked') ? `AND LOTE = '${barra}'` : `AND BARRA = '${barra}'`;
              const url = '/sisplan/funcoes/v1/pesquisa?';

              const naoPassouNaValidacao = await validaLoteDepositoMaterial(barra, codigo, deposito);
              if (naoPassouNaValidacao) {
                return;
              }

              const response = await requisicao('GET', url, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.CODIGO", "MATERIAL.DESCRICAO AS DESCRICAO", "MATERIAL.UNIDADE", "MAT_ITEN.COR", "MAT_ITEN.LOTE", "MAT_ITEN.BARRA", "MATERIAL.POSSE", "MAT_ITEN.DEPOSITO", "MAT_ITEN.QUALIDADE", "MAT_ITEN.QTDE", "MAT_ITEN.QTDE_ORIG", "MAT_ITEN.PRECO_MED"], 
              "leftjoin": [{"tabela" : "MATERIAL", "condicao" : "MATERIAL.CODIGO = MAT_ITEN.CODIGO"}],
              "where":["1=1 ${codigo} ${deposito} ${qualidade}"]}`, null);

              if (!response) {
                return;
              }
              const jsonInventario = await response.json();
              if (response.status != 200) {
                msgErro(jsonInventario.mensagem);
                return;
              }

              if (jsonInventario.RESULT[0].length == 0) {
                msgAlerta('Material não encontrado!')
                return;
              }

              jsonInventario.RESULT[0][0].POSSE == 0 ? jsonInventario.RESULT[0][0].POSSE = '0 - Não informado' : jsonInventario.RESULT[0][0].POSSE == 1 ? jsonInventario.RESULT[0][0].POSSE = '1 - Mercadoria de propriedade do informante e em seu poder' : jsonInventario.RESULT[0][0].POSSE == 2 ? jsonInventario.RESULT[0][0].POSSE = '2 - Mercadoria de propriedade do informante em poder de terceiros' : jsonInventario.RESULT[0][0].POSSE == 3 ? jsonInventario.RESULT[0][0].POSSE = '3 - Mercadoria de propriedade de terceiros em poder do informante' : '';

              const peso = jsonInventario.RESULT[0][0].QTDE === null ? '' : jsonInventario.RESULT[0][0].QTDE;
              const qtdeOrig = jsonInventario.RESULT[0][0].QTDE_ORIG === null ? '' : jsonInventario.RESULT[0][0].QTDE_ORIG;
              const objetoValidaPeso = jsonInventario.RESULT[0][0]

              const rotinaPreencheObjeto = async (objeto) => {
                const jsonFormatado = objeto;
                await preencheObjetoLinhaNova(jsonFormatado);
                $('#txtBarra').val('');
                $('#txtBarra').focus();
              }

              if (peso == 0 || peso == '') {
                if ($('#checkQtdeOrg').prop('checked') && (qtdeOrig !== 0) && (qtdeOrig !== '')) {
                  jsonInventario.RESULT[0][0].QTDE = jsonInventario.RESULT[0][0].QTDE_ORIG
                } else if ($('#checkQtdeOrg').prop('checked') && (qtdeOrig === 0 || qtdeOrig === '')) {
                  $('#modalCadPeso').modal('show');
                  abrirModalPeso(jsonInventario.RESULT[0][0], rotinaPreencheObjeto);
                  return;
                }
                if ($('#checkUltMov').prop('checked')) {
                  const url2 = '/sisplan/inventario/v1/validacodinventariomaterial?';
                  const responsePeso = await requisicao('GET', url2, `JSON=${encodeURIComponent(JSON.stringify(objetoValidaPeso))}`);
                  if (!responsePeso) {
                    return;
                  }
                  const jsonInventarioPeso = await responsePeso.json();
                  if (responsePeso.status != 200) {
                    msgErro(jsonInventarioPeso.mensagem);
                    return;
                  }
                  if (jsonInventarioPeso[0].PESO != 0 && jsonInventarioPeso[0].PESO != '') {
                    jsonInventario.RESULT[0][0].QTDE = jsonInventarioPeso[0].PESO
                  } else {
                    $('#modalCadPeso').modal('show');
                    abrirModalPeso(jsonInventario.RESULT[0][0], rotinaPreencheObjeto);
                    return;
                  }
                }
              }

              await rotinaPreencheObjeto(jsonInventario.RESULT[0][0]);

            } catch (error) {
              msgErro('Erro ao buscar item.');
              console.error(error);
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        } else {
          msgAlerta('Qualidade inválida ou não informada!');
        }
      } else {
        msgAlerta('Depósito inválido ou não informado!');
      }
    }
    const jsonarquivo = montaJsonArquivo();
    await salvaArquivo('JsonInventarioMaterial', jsonarquivo);
  });

  function abrirModalPeso(objetoAtual, callback) {
    $('#btn_confirmar_peso').unbind('click');
    $('#btn_confirmar_peso').on('click', async function () {
      const peso = $('#txtPesoManual').val();
      if (peso == '') {
        peso = 0;
      }
      objetoAtual.QTDE = peso;
      if (callback) {
        $('#modalCadPeso').modal('hide');
        await callback(objetoAtual);
      }
    });
  }

  async function preencheObjetoLinhaNova(objeto) {
    try {
      const qtdeLinhas = $('#tabelaInventarioMaterial').DataTable().rows().count();
      const qtde = $('#txtQtde').val()

      if ($('#checkBarra').prop('checked')) {
        barraLote = objeto.LOTE
        sLoteValidacao = objeto.LOTE;

        const valor = objeto.PRECO_MED * objeto.QTDE
        const novaLinha = [objeto.CODIGO, objeto.DESCRICAO, objeto.UNIDADE, objeto.COR, barraLote, objeto.QTDE, objeto.PRECO_MED, valor, objeto.DEPOSITO, objeto.POSSE];

        if (qtdeLinhas > 0) {
          for (let i = 0; i < $('#tabelaInventarioMaterial').DataTable().rows().count(); i++) {
            const dados = $('#tabelaInventarioMaterial').DataTable().row(i).data();
            const loteTabela = dados[4];
            const saoIguais = loteTabela == sLoteValidacao
            if (saoIguais) {
              msgAlerta('Lote já cadastrado. Favor verifique!');
              return;
            }
          }
          $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);
          return;
        }
        $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);
      }

      if ($('#checkManual').prop('checked')) {
        const valor = objeto.PRECO_MED * qtde
        const novaLinha = [objeto.CODIGO, objeto.DESCRICAO, objeto.UNIDADE, objeto.COR, objeto.LOTE, qtde, objeto.PRECO_MED, valor, objeto.DEPOSITO, objeto.POSSE];
        $('#tabelaInventarioMaterial').DataTable().row.add(novaLinha).draw(false);
      }
    } catch (error) {
      msgErro('Erro ao retornar a linha.');
    }
  }

  async function preencheJson() {
    let jsonInventario = []

    for (let i = 0; i < $('#tabelaInventarioMaterial').DataTable().rows().count(); i++) {
      let objetoInventario = {}
      const dados = $('#tabelaInventarioMaterial').DataTable().row(i).data();

      objetoInventario.CODIGO = dados[0];
      objetoInventario.COR = dados[3];
      objetoInventario.DEPOSITO = dados[8];
      objetoInventario.DESCRICAO = dados[1];
      objetoInventario.DT_MES = `${$('#txtData').val()}T00:00:00Z`;
      objetoInventario.UNIDADE = dados[2];
      objetoInventario.LOTE = dados[4];
      objetoInventario.CODSETOR = pegaChave($('#txtSetor').val());
      objetoInventario.POSSE = dados[9].substr(0, 1);
      objetoInventario.PRECO = dados[6];
      objetoInventario.QUALIDADE = pegaChave($('#txtQualidade').val());
      objetoInventario.QTDE = dados[5];
      objetoInventario.VALOR = dados[6];

      jsonInventario.push(objetoInventario);
    }

    const retorno = {
      Inventarios: jsonInventario
    }
    return retorno;
  }

  try {
    const response = await carregaArquivo('JsonInventarioMaterial');
    if (response.status === 200) {
      const jsonStr = await response.json();
      insereValor("#txtQualidade", jsonStr.qualidade.split("] - ")[0].substr(1), jsonStr.qualidade.split("] - ")[1]);
      insereValor("#txtData", jsonStr.data);
      insereValor("#txtDeposito", jsonStr.deposito.split("] - ")[0].substr(1), jsonStr.deposito.split("] - ")[1]);
      insereValor("#txtSetor", jsonStr.setor.split("] - ")[0].substr(1), jsonStr.setor.split("] - ")[1]);
      jsonStr.itens.forEach((item) => {
        $("#tabelaInventarioMaterial")
          .DataTable()
          .row.add([
            item.codigo,
            item.descricao,
            item.unidade,
            item.cor,
            item.lote,
            item.qtde,
            item.preco,
            item.valor,
            item.deposito,
            item.posse,
          ])
          .draw(false);
      });
      msgAlerta("Carregado dados não salvos, verifique.");
    }
  } catch (error) {
    console.log(error);
  }

  function montaJsonItens() {
    const itensDataTable = $("#tabelaInventarioMaterial").DataTable().data().toArray();
    const itens = itensDataTable.map((itemDT) => {
      const item = {
        codigo: itemDT[0],
        descricao: itemDT[1],
        unidade: itemDT[2],
        cor: itemDT[3],
        lote: itemDT[4],
        qtde: itemDT[5],
        preco: itemDT[6],
        valor: itemDT[7],
        deposito: itemDT[8],
        posse: itemDT[9],
      };
      return item;
    });
    return itens;
  }

  function montaJsonArquivo() {
    const importacao = {
      qualidade: $("#txtQualidade").val(),
      data: $("#txtData").val(),
      deposito: $("#txtDeposito").val(),
      setor: $("#txtSetor").val(),
      itens: montaJsonItens(),
    };
    return importacao;
  }
});