$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#campostuto',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Código',
        description: 'O campo de código é preenchido automaticamente após gravar o registro.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Neste campo adicionamos a descrição para o grupo cliente.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o Grupo de Cliente.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('GRUPOCLIENTE', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/grupocliente`;
  });

  $(document).ready(function () {

    $('#txtCodigo').prop('disabled', true);

    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida."
        },
      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });

    $('.radio-group .radio').click(function () {
      $(this).parent().find('.radio').removeClass('selected');
      $(this).addClass('selected');
    });

    $(".submit").click(function () {
      return false;
    });
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let grupocliente = parametros[parametros.length - 1];

  if (grupocliente != '' && grupocliente != 'create') {

    if (await liberarRegistro('GRUPOCLIENTE', grupocliente) == false) {
      window.location.href = '../grupocliente';
    } else {

      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"GRUPO_CLI", 
                  "camposSelect":["CODIGO", "DESCRICAO"], 
                  "where": ["CODIGO = '${grupocliente}'"]}`, null);

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
          $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do grupo: ${error}`);
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  };

  $('#btnGravar').on('click', async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let grupoClienteClasse = {};

        grupoClienteClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('GRUPO_CLI', 'GRUPO_CLI', 'CODIGO', 3) : $('#txtCodigo').val();
        grupoClienteClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();

        let response = await requisicao('POST', '/Sisplan/Cadastros/v1/grupocliente?', `JSON=${encodeURIComponent(JSON.stringify(grupoClienteClasse))}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr.success(
          `Cadastro efetuado com sucesso!
                      Grupo de cliente: ${grupoClienteClasse.CODIGO}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/grupocliente`;
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });

      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do grupo: ${error}`);
      }
    }

  });

});