<?php include_once('../../config.php') ?>
<?php
$hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);
?>


<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Impressão NFE</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
  <!-- Ionicons -->
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css?versao=3.243.6.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/adminlte.min.css?versao=3.243.6.1">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.243.6.1">
  <!-- Daterange picker -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/custom.css?versao=3.243.6.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/sisplan.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/dataTables.bootstrap4.min.css?versao=3.243.6.1" />
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.243.6.1">
  <link rel="shortcut icon" href="<?php echo BASE_URI; ?>/favicon.ico">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/select.bootstrap.min.css?versao=3.243.6.1">
  <!-- Google Font: Source Sans Pro -->
  <!-- AutoComplete -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/jquery-ui.css?versao=3.243.6.1">

  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/driver.min.css?versao=3.243.6.1" />

  <style>
    .ui-autocomplete-loading {
      background: white url("<?php echo BASE_URI; ?>/dist/img/ui-anim_basic_16x16.gif") center center no-repeat;
    }

    .dropdown-toggle::after {
      display: inline-block;
      margin-left: 0.300cm;
      vertical-align: 0.255em;
      content: "";
      border-top: 0.3em solid;
      border-right: 0.3em solid transparent;
      border-bottom: 0;
      border-left: 0.3em solid transparent;
    }

    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    .botoesMenu {
      height: 100%;
      padding-left: auto;
      padding-right: auto;
      color: white !important;
      min-width: 150px;
      font-weight: bold;
      margin-left: -4px !important;
      font-size: 1rem !important;
      background-color: #343a40;
      cursor: pointer !important;
    }

    .visible {
      visibility: hidden
    }

    .opcoesImpressao {
      border-top: 0px;
      background-color: transparent !important;
      color: #869099;
      padding: 1rem;
    }
  </style>
  <!-- Toastr -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.css">

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 row flex">
              <h4 class="m-0 text-dark">Envio e Impressão de NF-e</h4>
              <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <!-- <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">Faturamento</li>
                <li class="breadcrumb-item active">Impressão NF-e</li>
              </ol> -->
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">

        <div class="card">
          <div class="card-body">
            <div class="container-fluid p-2">
              <div class="row pb-2">
                <div class="col-sm-12 d-flex justify-content-between">
                  <div>
                    <button id="btn-filtros" class="btn btn-success btn-sisp" type="button" data-toggle="modal" data-target="#modal-filtros">
                      <span class="fas fa-filter"></span> Filtros
                    </button>
                    <button id="btnConfig" class=" btn btn-danger text-white btn-sisp">
                      <span class="fas fa-cogs"></span> Config.
                    </button>
                    <button id="btnInutilizar" class=" btn btn-danger text-white btn-sisp">
                      <span class="fas fa-arrow-up"></span> Inutilizar
                    </button>
                    <button id="btnGNRE" class=" btn btn-danger text-white btn-sisp" disabled hidden>
                      <span class="fas fa-cogs"></span> Gerar GNRE
                    </button>
                  </div>
                  <div>
                    <p id="txtVencimentoCertificadoDigital" style="color: red; padding-top: 3.1%; "></p>
                  </div>
                  <div style="padding-top: .6%">
                    <span id="txtAmbiente" style="color: red"></span>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-sm-12">
                  <h5>Notas Fiscais</h5>
                </div>
                <div class="col-sm-12 table-responsive">
                  <table id="tabelaNotas" class="table table-sm table-select table-hover" width="100%">
                    <!-- <thead>
                    </thead> -->
                    <!-- <tbody>
                    </tbody> -->
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="content">
        <div class="modal fade" id="modal-itens">
          <div class="modal-dialog modal-xl">
            <div class="modal-content">
              <div class="modal-header">
                <h4 id="modal-itens-title" class="modal-title">Itens da Nota</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>

              <nav>
                <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none;">
                  <a class="nav-link abaLink active" id="tabCapaNota" data-toggle="tab" href="#divCapaNota" role="tab" aria-controls="divCapaNota" aria-selected="true">Capa da nota</a>
                  <a class="nav-link abaLink" id="tabItens" data-toggle="tab" href="#divItens" role="tab" aria-controls="divItens" aria-selected="false">Itens</a>
                  <a class="nav-link abaLink" id="tabReferenciar" data-toggle="tab" href="#divReferenciar" role="tab" aria-controls="divReferenciar" aria-selected="true">Referenciar</a>
                </div>
              </nav>

              <div class="card-body" style="height: auto;">
                <div class="card" id="tourAlteraDadosNota">
                  <!-- <div class="modal-body" style="height: 57vh"> -->
                  <div class="tab-content" id="nav-tabContent">

                    <div class="tab-pane fade show active" id="divCapaNota" role="tabpanel" aria-labelledby="tabCapaNota">
                      <div class="modal-body" style="height: 50vh;">
                        <div class="row">
                          <div class="col-sm-3">
                            <div class="group-default form-group">
                              <label for="txtAlterarFatura">Fatura:</label>
                              <input type="text" placeholder="Fatura" class="form-control input-default" id="txtAlterarFatura" name="txtAlterarFatura" readonly>
                            </div>
                          </div>
                          <div class="col-sm-3">
                            <div class="group-default form-group">
                              <label for="txtAlterarSerie">Série:</label>
                              <input type="text" placeholder="Serie" class=" form-control input-default" id="txtAlterarSerie" name="txtAlterarSerie" readonly>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="group-default form-group">
                              <label for="txtClienteNota">Cliente:</label>
                              <input type="text" placeholder="Serie" class=" form-control input-default" id="txtClienteNota" name="txtClienteNota" readonly>
                            </div>
                          </div>
                          <div class="col-lg-4 col-12 form-group">
                            <label data-error="wrong" data-success="right" for="dtEmissao">Data de emissão: </label>
                            <div class="relative">
                              <div class="input-group">
                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissao" name="dtEmissao" class="form-control">
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-4 col-12 form-group">
                            <label data-error="wrong" data-success="right" for="dtSaida">Data de saída: </label>
                            <div class="relative">
                              <div class="input-group">
                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtSaida" name="dtSaida" class="form-control">
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-4 col-12 form-group">
                            <label data-error="wrong" data-success="right" for="txtPresenca">Presença:</label>
                            <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgPresenca" class="custom-select focus">
                              <option value="">Selecionar presença</option>
                              <option value="0">0 - Não se aplica (por exemplo, Nota Fiscal
                                complementar ou de ajuste)</option>
                              <option value="1">1 - Operação presencial</option>
                              <option value="2">2 - Operação não presencial, pela Internet
                              </option>
                              <option value="3">3 - Operação não presencial, Teleatendimento
                              </option>
                              <option value="4">4 - NFC-e em operação com entrega a domicílio
                              </option>
                              <option value="5">5 - Operação presencial, fora do estabelecimento
                              </option>
                              <option value="9">9 - Operação não presencial, outros</option>
                            </select>
                          </div>
                          <div class="col-lg-4 col-4 form-group">
                            <label for="alteraTransportadora">Transportadora:</label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtAlteraTransportadora" name="txtPais" class="form-control" placeholder="Transportadora">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-transportadora-filtro" name="btn-transportadora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-transportadora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-4  col-4 form-group">
                            <label data-error="wrong" data-success="right" for="txtEnderecoEntrega">Endereço entrega</label>
                            <div class="input-group">
                              <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="dropdown" class="custom-select focus">
                                <option value="" class="active">Selecione o endereço</option>
                                <option value="0" id="enderecoPadrao" title="Endereço Padrão">Padrão</option>
                                <option value="1" id="enderecoEntrega" title="Endereço de Entrega">Entrega</option>
                                <option value="2" id="enderecoCobranca" title="Endereço de Cobrança">Cobrança</option>
                                <option value="4" id="enderecoEmpresa" title="Endereço de Empresa">Empresa</option>
                              </select>
                            </div>
                          </div>
                          <div class="col-lg-4 col-4 form-group">
                            <label data-error="wrong" data-success="right" for="rgTransportador">Frete por Conta</label>
                            <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgTransportador" class="custom-select focus">
                              <option value="">Selecione uma opção</option>
                              <option value="0">0 - Contratação do Frete por conta do Remetente (CIF)</option>
                              <option value="1">1 - Contratação do Frete por conta do Destinatário (FOB)</option>
                              <option value="2">2 - Contratação do Frete por conta de Terceiros</option>
                              <option value="3">3 - Transporte Próprio por conta do Remetente</option>
                              <option value="4">4 - Transporte Próprio por conta do Destinatário</option>
                              <option value="8">8 - Por Conta do Destinatário na NF</option>
                              <option selected value="9">9 - Sem Ocorrência de Transporte</option>
                            </select>
                          </div>
                          <div class="col-lg-6 col-6 m-6 form-group">
                            <label for="txtAlteraIntermed">Intermediador:</label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtAlteraIntermed" name="txtPais" class="form-control" placeholder="Intermediador">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-Intermed-filtro" name="btn-Intermed" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-Intermed" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-6 col-6 m-6 form-group">
                            <label for="txtEmbarque">UF/Local Embarque:</label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtEmbarque" name="txtPais" class="form-control" placeholder="UF/Local Embarque">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-Embarque" name="btn-Embarque" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                <button class="btn bg-danger" id="btn-limpa-Embarque" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-lg-6 col-6 m-6 form-group">
                            <label for="txtCodigoRastreio">Código de Rastreio:</label>
                            <div class="input-group">
                              <input type="text" class="input-default focus form-control" id="txtCodigoRastreio" name="txtCodigoRastreio" class="form-control" placeholder="Código de Rastreio">
                              <div class="input-group-append">
                                <button class="btn bg-danger" id="btn-limpa-codigo-rastreio" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-6" style="margin-top: 35px">
                            <input type="checkbox" id="consumidorFinal"> <label for="consumidorFinal">Consumidor Final</label>     
                            <input type="checkbox" id="gerarDifal"> <label for="gerarDifal">Gerar Difal</label>
                          </div>
                          <div class="col-lg-12  col-12 form-group">
                            <label data-error="wrong" data-success="right" for="txtDados">Dados Adicionais</label>
                            <textarea style="resize: none" id="txtDados" placeholder="Dados adicionais" class="input-default focus form-control" rows="4"></textarea>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-sm-12">
                            <input type="text" placeholder="Nota" class="d-none" id="txtNotaItens" name="txtNotaItens" readonly>
                            <input type="text" placeholder="Serie" class="d-none" id="txtSerieItens" name="txtSerieItens" readonly>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="tab-pane fade show active" id="divItens" role="tabpanel" aria-labelledby="tabItens">
                      <div class="modal-body" style="height: 50vh;">
                        <div class="row pt-2">
                          <div class="col-sm-12 table-responsive" style="height: 50vh;">
                            <h3>Itens da nota</h3>
                            <table id="tabelaItens" style="width:100%" class="table table-sm table-select table-hover" width="100%">
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="tab-pane fade" id="divReferenciar" role="tabpanel" aria-labelledby="tabReferenciar">
                      <div class="modal-body" style="height: 50vh;">
                        <div class="row pt-2">
                          <div class="col-lg-12">
                            <div class="row">
                              <div class="col-sm-6">
                                <label class="labelGeral" for="divOperacaoRef" data-error="wrong" data-success="right">Operação</label>
                                <div id="divOperacaoRef" class="checkboxMoeda" style="margin-top: -.5%">
                                  <label class="container">Entrada/Aquisição
                                    <input type="radio" checked="checked" value="E" id="radioEntradaAquisicao" name="operacaoRef">
                                    <span class="checkmark"></span>
                                  </label>
                                  <label class="container">Saída/Prestação
                                    <input type="radio" id="radioSaidaPrestacao" value="S" name="operacaoRef">
                                    <span class="checkmark"></span>
                                  </label>
                                </div>
                              </div>
                              <div class="col-sm-6">
                                <label class="labelGeral" for="divEmitenteRef" data-error="wrong" data-success="right">Emitente</label>
                                <div id="divEmitenteRef" class="checkboxMoeda" style="margin-top: -.5%">
                                  <label class="container">Emissão Própria
                                    <input type="radio" checked="checked" value="0" id="radioEmissaoPropria" name="emitenteRef">
                                    <span class="checkmark"></span>
                                  </label>
                                  <label class="container">Terceiros
                                    <input type="radio" id="radioTerceirosRef" value="1" name="emitenteRef">
                                    <span class="checkmark"></span>
                                  </label>
                                </div>
                              </div>
                              <div class="col-lg-6 col-6 form-group" style="margin-top: 13px;">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtModeloDocto">Modelo de Docto *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtModeloDocto" name="txtModeloDocto" class="form-control" placeholder="Modelo de Docto">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnModeloDocto" name="btnModeloDocto" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnAModeloDocto" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-6 col-6 form-group" style="margin-top: 13px;" id="divInfCompl">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtInfCompl">Inf. Compl. *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtInfCompl" name="txtInfCompl" class="form-control" placeholder="Inf. Compl.">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnInfCompl" name="btnInfCompl" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnAInfCompl" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-6 col-6 form-group d-none" style="margin-top: 13px;" id="divSeqEcf">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtSeqEcf">Seq. do ECF *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtSeqEcf" name="txtSeqEcf" class="form-control" placeholder="Seq. do ECF">
                                </div>
                              </div>
                              <div class="col-lg-12 col-12 form-group" id="divNotaRef">
                                <div class="row">
                                  <div class="col-lg-2" style="margin-top: 25px;">
                                    <button class="btn btn-sm btn-danger" title="Referenciar por nota" id="btnReferenciarPorNota">Nota</button>
                                    <button class="btn btn-sm btn-danger" title="Referenciar por chave" id="btnReferenciarPorChave">Chave</button>
                                  </div>
                                  <div class="col-lg-10" id="divRefNota">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtNotaRef">Nota *</label>
                                    <div class="input-group">
                                      <input type="text" disabled class="input-default focus form-control" id="txtNotaRef" name="txtNotaRef" class="form-control" placeholder="Nota">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btnNotaRef" name="btnNotaRef" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btnANotaRef" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-lg-7 d-none" id="divRefChave">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtChaveRef">Chave *</label>
                                    <input type="text" class="input-default focus form-control" maxlength="44" id="txtChaveRef" name="txtChaveRef" class="form-control" placeholder="Chave">
                                  </div>
                                  <div class="col-lg-3 d-none" id="divRefData">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtDataRef">Data Emissão *</label>
                                    <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataRef" name="txtDataRef">
                                  </div>
                                  <div class="col-lg-3 d-none" id="divRefValorNota">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorNota">Valor Nota *</label>
                                    <input type="text" class="input-default focus form-control" id="txtValorNota" name="txtValorNota">
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-12 col-12 form-group d-none" id="divNumCoo">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNumCoo">Num. COO. *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtNumCoo" name="txtNumCoo" class="form-control" placeholder="Num. COO.">
                                </div>
                              </div>
                              <div class="col-lg-6 col-6 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorRef">Valor</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtValorRef" name="txtValorRef" class="form-control" placeholder="Valor">
                                </div>
                              </div>
                              <div class="col-lg-6 col-6 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtPesoRef">Peso</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtPesoRef" name="txtPesoRef" class="form-control" placeholder="Peso">
                                </div>
                              </div>
                              <div class="col-lg-12 form-group">
                                <button class="btn bg-danger btn-block" id="btnAddNotaRef" name="btnAddNotaRef" data-button="absolute" type="button">
                                  <label class="m-0 p-0">Adicionar</label>
                                </button>
                              </div>
                              <input type="text" class="d-none" id="txtDataNotaRef" name="txtDataNotaRef">
                              <input type="text" class="d-none" id="txtCodcliNotaRef" name="txtCodcliNotaRef">
                              <input type="text" class="d-none" id="txtChaveNotaRef" name="txtChaveNotaRef">
                              <input type="text" class="d-none" id="txtValorNotaRef" name="txtValorNotaRef">
                            </div>
                          </div>
                          <div class="col-lg-12">
                            <table id="tabelaNotasRef" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <th class="th-sm">Fatura</th>
                                  <th class="th-sm">Serie</th>
                                  <th class="th-sm">Codcli</th>
                                  <th class="th-sm">Emissão</th>
                                  <th class="th-sm">Ind_Oper</th>
                                  <th class="th-sm">Ind_Emit</th>
                                  <th class="th-sm">Tipo_Doc</th>
                                  <th class="th-sm">Codref</th>
                                  <th class="th-sm">Peso</th>
                                  <th class="th-sm">Valor</th>
                                  <th class="th-sm">Valor_Nota</th>
                                  <th class="th-sm">Num. COO.</th>
                                  <th class="th-sm">Seq. ECF</th>
                                  <th class="th-sm">Ações</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>
                  <!-- </div> -->
                </div>
              </div>
              <div class="modal-footer justify-content-between">
                <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
                <button id="confirmar_dados" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
              </div>
            </div>
            <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>
    </div>
    <!-- /.modal-dialog -->
  </div>
  <div class="modal fade" id="modal-inutilizar">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modal-inutilizar-title" class="modal-title">Inutilizar Numerações</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-sm-2">
              <div class="group-default form-group">
                <label for="txtNotaSerie">Série:</label>
                <input type="number" placeholder="Série" id="txtNotaSerie" name="txtNotaSerie" class="input-default focus form-control">
              </div>
            </div>
            <div class="col-sm-5">
              <div class="group-default form-group">
                <label for="txtNotaIni">Numeração Inicial:</label>
                <div class="relative">
                  <input type="number" class="input-default focus form-control validate" id="txtNotaIni" name="txtNotaIni">
                </div>
              </div>
            </div>
            <div class="col-sm-5">
              <div class="group-default form-group">
                <label for="txtNotaFim">Numeração Final:</label>
                <div class="relative">
                  <input type="number" class="input-default focus form-control validate" id="txtNotaFim" name="txtNotaFim">
                </div>
              </div>
            </div>
            <div class="col-sm-12">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtJustificativa">Justificativa</label>
                <textarea type="textarea" style="resize: none; padding-top: .7%" placeholder="Justificativa" class="input-default focus form-control validate" id="txtJustificativa" name="txtJustificativa" required="required" rows="5"></textarea>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button id="btn-confirmar-inutilizacao" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
          <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <div class="modal fade" id="modal-cce">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modal-inutilizar-title" class="modal-title">Carta de Correção</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-sm-2">
              <div class="group-default form-group">
                <label for="txtFaturaCce">Fatura</label>
                <input type="text" readonly id="txtFaturaCce" name="txtFaturaCce" class="input-default focus form-control">
              </div>
            </div>
            <div class="col-sm-2">
              <div class="group-default form-group">
                <label for="txtSerieCce">Série</label>
                <div class="relative">
                  <input type="text" readonly class="input-default focus form-control validate" id="txtSerieCce" name="txtSerieCce">
                </div>
              </div>
            </div>
            <div class="col-sm-6">
              <div class="group-default form-group">
                <label for="txtChaveCce">Chave NFE</label>
                <div class="relative">
                  <input type="text" readonly class="input-default focus form-control validate" id="txtChaveCce" name="txtChaveCce">
                </div>
              </div>
            </div>
            <div class="col-sm-2">
              <div class="group-default form-group">
                <label for="txtSequencia">Sequência</label>
                <div class="relative">
                  <input type="text" readonly class="input-default focus form-control validate" id="txtSequencia" value="1" name="txtSequencia">
                </div>
              </div>
            </div>
            <div class="col-sm-12">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtJustificativaCce">Justificativa</label>
                <textarea type="textarea" style="resize: none; padding-top: .7%" placeholder="
            Condição de Uso: 
                        Somente a última carta de correção é válida, substituindo qualquer outra CCe emitida para a NFe, com no máximo 20 CCe por nota.
                        A Carta de Correção é disciplinada pelo parágrafo 1o-A do art. 7o do Convênio S/N, de 15 de dezembro de 1970 e pode ser 
                        utilizada para regularização de erro ocorrido na emissão de documento fiscal, desde que o erro não esteja relacionado com: I - as 
                        variáveis que determinam o valor do imposto tais como: base de cálculo, alíquota, diferença de preço, quantidade, valor da 
                        operação ou da prestação; II - a correção de dados cadastrais que implique mudança do remetente ou do destinatário; III - a data 
                        de emissão ou de saída.
                        
        " class="input-default focus form-control validate" id="txtJustificativaCce" name="txtJustificativaCce" required="required" rows="10"></textarea>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button id="btnGerarCce" type="button" class="btn bg-gradient-success btn-sisp">Gerar</button>
          <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <div class="modal fade" id="modal-cancelamento">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modal-cancelamento-title" class="modal-title">Cancelar NF-e</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-sm-6">
              <div class="group-default form-group">
                <label for="txtCancFatura">Fatura:</label>
                <div class="relative">
                  <input type="number" class="input-default focus form-control validate" id="txtCancFatura" name="txtCancFatura" readonly>
                </div>
              </div>
            </div>
            <div class="col-sm-6">
              <div class="group-default form-group">
                <label for="txtCancSerie">Série:</label>
                <div class="relative">
                  <input type="number" class="input-default focus form-control validate" id="txtCancSerie" name="txtCancSerie" readonly>
                </div>
              </div>
            </div>
            <div class="col-sm-12" id="justificativaCancelamento">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtCancJustificativa">Justificativa</label>
                <textarea type="textarea" style="resize: none; padding-top: .7%" placeholder="Justificativa" class="input-default focus form-control validate" id="txtCancJustificativa" name="txtCancJustificativa" required="required" rows="5"></textarea>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button id="btn-confirmar-cancelamento" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
          <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>

  <div class="modal fade" id="modal-config">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modal-Configuração-title" class="modal-title">Configurações Nota Fiscal Eletrônica - NFE</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="collapse show" id="nfe">
            <div class="card card-body">
              <div class="row">
                <div class="col-6">
                  <label for="txtVersao">
                    Versão
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtVersao">
                  </div>
                </div>
                <div class="col-6">
                  <label for="txtAmbiente">Ambiente</label>
                  <select id="txtAmbiente" class="input-default focus custom-select">
                    <option value="1">Produção</option>
                    <option value="2">Homologação</option>
                  </select>
                </div>
              </div>
              <div class="row">
                <div class="col-12">
                  <label for="txtDiretorioLog">
                    Diretorio Log
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtDiretorioLog">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-6">
                  <label for="txtTimeZone">
                    TimeZone
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtTimeZone">
                  </div>
                </div>
                <div class="col-6">
                  <label for="txtTimeOut">
                    TimeOut
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtTimeOut">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-6">
                  <label for="txtMetodo">
                    Método
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtMetodo">
                  </div>
                </div>
                <div class="col-6">
                  <label for="txtServidorRadar">
                    Servidor Radar
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtServidorRadar">
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-6">
                  <label for="txtRecursoRadar">
                    Recurso Radar
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtRecursoRadar">
                  </div>
                </div>
                <div class="col-6">
                  <label for="txtTimeOutRadar">
                    TimeOut Radar
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtTimeOutRadar">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer float-right">
          <button id="btnConfirmarConfigNFE" type="button" class="btn bg-gradient-danger btn-sisp">Gravar INI</button>
        </div>
      </div>
    </div>
  </div>

  </section>
  <!-- /.content -->
  </div>
  <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Filtros</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-lg-6 col-12">
              <div class="row">
                <div class="col-6">
                  <div class="group-default form-group">
                    <label for="dtIni">Data De:</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" value="<?php echo (date('Y-m')); ?>-01" class="input-default focus form-control validate" id="txtDataDe" name="txtDataDe">
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <div class="group-default form-group">
                    <label for="dtFim">Data Até:</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" value="<?php echo (date('Y-m-d')); ?>" class="input-default focus form-control validate" id="txtDataAte" name="txtDataAte">
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtCliente">Cliente</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNota">Fatura</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNota" name="txtNota" class="form-control" placeholder="Fatura">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-nota" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-nota" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-12">
              <div class="form-group clearfix">
                <h6>Status: </h6>
                <div class="icheck-primary">
                  <input type="radio" id="radioPrimary1" value="0" name="rg_status" checked>
                  <label for="radioPrimary1">Todas
                  </label>
                </div>
                <div class="icheck-primary">
                  <input type="radio" id="radioPrimary2" value="1" name="rg_status">
                  <label for="radioPrimary2">Impressa
                  </label>
                </div>
                <div class="icheck-primary">
                  <input type="radio" id="radioPrimary3" value="2" name="rg_status">
                  <label for="radioPrimary3">Não Impressa</label>
                </div>
                <div class="icheck-primary">
                  <input type="radio" id="radioPrimary4" value="3" name="rg_status">
                  <label for="radioPrimary4">Canceladas
                  </label>
                </div>
                <div class="icheck-primary">
                  <input type="radio" id="radioPrimary5" value="4" name="rg_status">
                  <label for="radioPrimary5">Denegadas
                  </label>
                </div>
              </div>
            </div>
            <div class="col-lg-3 col-12">
              <div class="form-group clearfix">
                <h6>Protocolo: </h6>
                <div class="icheck-primary">
                  <input type="radio" id="radioProtocolo1" value="0" name="rg_protocolo" checked>
                  <label for="radioProtocolo1">Todas
                  </label>
                </div>
                <div class="icheck-primary">
                  <input type="radio" id="radioProtocolo2" value="1" name="rg_protocolo">
                  <label for="radioProtocolo2">Com Protocolo
                  </label>
                </div>
                <div class="icheck-primary">
                  <input type="radio" id="radioProtocolo3" value="2" name="rg_protocolo">
                  <label for="radioProtocolo3">Sem Protocolo</label>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar
              Filtros</button>     
            <button id="btn-consultar" class="btn btn-primary btn-sisp" type="button">
              <span class="fas fa-search"></span> Consultar
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.content-wrapper -->
  <div class="opcoesImpressao">
    <div class="row">
      <div class="col-12">
        <div id="dadosnota" class="row">
          <div class="col-xl-1">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtNumeroNF">Numero</label>
              <div class="relative">
                <input type="text" placeholder="Numero NF" class="input-default focus form-control validate" id="txtNumeroNF" name="txtNumeroNF" readonly>
              </div>
            </div>
          </div>
          <div class="col-xl-1">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtSerieNF">Série NF</label>
              <div class="relative">
                <input type="text" placeholder="Série NF" class="input-default focus form-control validate" id="txtSerieNF" name="txtSerieNF" readonly>
              </div>
            </div>
          </div>
          <div class="col-xl-2">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtEmissaoNF">Emissão</label>
              <div class="relative">
                <input type="text" placeholder="Emissão" class="input-default focus form-control validate" id="txtEmissaoNF" name="txtEmissaoNF" readonly>
              </div>
            </div>
          </div>
          <div class="col-xl-3">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtChaveNF">Chave</label>
              <div class="relative">
                <input type="text" placeholder="Chave" class="input-default focus form-control validate" id="txtChaveNF" name="txtChaveNF" readonly>
              </div>
            </div>
          </div>
          <div class="col-xl-2">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtReciboNF">Recibo</label>
              <div class="relative">
                <input type="text" placeholder="Recibo" class="input-default focus form-control validate" id="txtReciboNF" name="txtReciboNF" readonly>
              </div>
            </div>
          </div>
          <div class="col-xl-2">
            <div class="group-default form-group">
              <label data-error="wrong" data-success="right" for="txtProtocoloNF">Protocolo</label>
              <div class="relative">
                <input type="text" placeholder="Protocolo" class="input-default focus form-control validate" id="txtProtocoloNF" name="txtProtocoloNF" readonly>
              </div>
            </div>
          </div>
          <div class="col-xl-1">
            <label for="txtFinalidade">Finalidade</label>
            <select id="txtFinalidade" class="input-default focus custom-select">
              <option value="0">Normal</option>
              <option value="1">Complemento</option>
              <option value="2">Ajuste</option>
              <option value="3">Devolução de Mercadoria</option>
            </select>
          </div>
        </div>
      </div>
      <div class="col-12 text-center">
        <div class="btn-group flex-wrap btn-group-justified btn-group-lg" role="group" aria-label="Basic example">
          <button id="btnGerar" class="btn btn-secondary text-white btn-sisp botoesMenu">
            <span class="fas fa-cogs pr-1"></span> Gerar
          </button>
          <button id="btnImprimir" class="btn btn-secondary text-white btn-sisp botoesMenu dropdown-toggle">
            <span class="fas fa-print pr-1" style="color: white!important"></span> Imprimir</button>
          <div class="dropdown-menu" style="margin-left: 135px; top: -146px;" id="dropdown-menu">
            <button id="btnImprimirCCe" class="dropdown-item" href="">Imprimir CCe</button>
            <button id="btnImprimirNFeSimplificada" class="dropdown-item" href="">Imprimir NFe Simplificada</button>
            <button id="btnImprimirNFe" class="dropdown-item" href="">Imprimir NFe</button>
            <button id="btnImprimirBoleto" class="dropdown-item" href="">Imprimir Boleto</button>
            <button id="btnImprimirMinuta" class="dropdown-item" href="">Imprimir Minuta</button>
          </div>
          <button id="btnCancelar" class=" btn btn-secondary text-white btn-sisp botoesMenu">
            <span class="fas fa-ban pr-1"></span> Cancelar</button>
          <button id="btnExcluir" class=" btn btn-secondary text-white btn-sisp botoesMenu">
            <span class="fas fa-trash pr-1"></span> Excluir</button>
          <button id="btnCce" class="btn btn-secondary text-white btn-sisp botoesMenu">
            <span class="fas fa-envelope-open-text pr-1"></span> CCe
          </button>
          <button id="btnConsultar" class="btn btn-secondary text-white btn-sisp botoesMenu">
            <span class="fas fa-search pr-1"></span> Consultar
          </button>
          <button id="btnVisualizar" class="btn btn-secondary text-white btn-sisp botoesMenu dropdown-toggle">
            <span class="fas fa-print pr-1" style="color: white!important"></span>Visualizar</button>
          <div class="dropdown-menu" style="margin-left: 869px; top: -84px;" id="dropdownVisualizar">
            <button id="btnVisualizarXML" class="dropdown-item" href="">Visualizar XML</button>
            <button id="btnBaixarXML" class="dropdown-item" href="">Baixar XML</button>
          </div>
          <button id="btnEmail" class=" btn btn-secondary text-white btn-sisp botoesMenu">
            <span class="fas fa-envelope pr-1"></span> Enviar Email
          </button>
        </div>

      </div>
    </div>
  </div>
  <?php
  include_once('../../footer.php');
  ?>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <script src="<?php echo BASE_URI; ?>/plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>

  <!-- jQuery UI 1.11.4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-ui/jquery-ui.min.js"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>
  <!-- Bootstrap 4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
  <!-- AdminLTE App -->
  <script src="<?php echo BASE_URI; ?>/dist/js/adminlte.min.js?versao=3.243.6.1"></script>

  <script src="<?php echo BASE_URI; ?>/dist/js/sisplan.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/utils/funcoes.js?versao=3.243.6.1"></script>
  <!-- SweetAlert2 -->
  <script src="<?php echo BASE_URI; ?>/plugins/sweetalert2/sweetalert2.min.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/requisicoes.js?versao"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/sum().js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/utils/cookies.js?versao=3.243.6.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.maskMoney.min.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/pages/loja/js/rotinas.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/dataTables.keyTable.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/driver.min.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/config.js?versao=3.243.6.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/FileSaver.min.js?versao=3.243.6.1""></script>
  <script>
    $('#tutorial').on('click', function() {
      $(document).ready(async function() {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
              title: 'Botão Filtros',
              description: 'Clique nesse botão para filtrar sua consulta.',
              position: 'bottom'
            }
          },
          {
            element: '#btnInutilizar',
            popover: {
              title: 'Botão Inutilizar',
              description: 'Clique nesse botão para inutilizar uma nota fiscal.',
              position: 'bottom'
            }
          },
          {
            element: '#tabelaNotas_wrapper',
            popover: {
              title: 'Notas Fiscais',
              description: 'Aqui ficam as notas fiscais filtradas.',
              position: 'top'
            }
          },
          {
            element: '#dadosnota',
            popover: {
              title: 'Dados da Nota',
              description: 'Aqui ficam os dados da nota que está selecionada.',
              position: 'top'
            }
          },
          {
            element: '#btnGerar',
            popover: {
              title: 'Botão Gerar',
              description: 'Clique aqui para gerar a nota fiscal selecionada.',
              position: 'top'
            }
          },
          {
            element: '#btnImprimir',
            popover: {
              title: 'Botão Imprimir',
              description: 'Clique aqui para imprimir a nota fiscal selecionada.',
              position: 'top'
            }
          },
          {
            element: '#btnCancelar',
            popover: {
              title: 'Botão Cancelar',
              description: 'Clique aqui para cancelar a nota fiscal selecionada.',
              position: 'top'
            }
          },
          {
            element: '#btnExcluir',
            popover: {
              title: 'Botão Excluir',
              description: 'Clique aqui para excluir a nota fiscal selecionada.',
              position: 'top'
            }
          },
          {
            element: '#btnVisualizar',
            popover: {
              title: 'Botão Visualizar',
              description: 'Clique aqui para visualizar ou baixar o XML da nota fiscal selecionada.',
              position: 'top'
            }
          },

        ]);
        //inicio tour 

        driver.start();

        const activeElement = driver.getHighlightedElement();
        // inicior tuor
        //final
      });
    });


    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = "<?php echo BASE_URI; ?>/login"
        return;
      }

      const temAcesso = await temAcessoTela('IMPRESSAO_NFE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, "<?php echo BASE_URI; ?>");
        return;
      }

      const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2) == '1';
      const pedeSenhaCancelaNota = await CopiaParametro("FATURAMENTO", 8);

      try {
        let response = await requisicao('GET', '/sisplan/funcoes/v1/retornaambiente?', '');
        if (!response) {
          return;
        }
        let jsonStr = await response.json();

        if (jsonStr.mensagem == '1') {
          $("#txtAmbiente").css("color", "green");
          $("#txtAmbiente")[0].textContent = "AMBIENTE: PRODUÇÃO";
        } else {
          $("#txtAmbiente").css("color", "red");
          $("#txtAmbiente")[0].textContent = "AMBIENTE: HOMOLOGAÇÃO";
        }
      } catch (error) {
        console.error(error);
      }

      var estaNaArqLocal = true;
      try {
        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
          `JSON={ "tabela":"arqlocal", 
                "camposSelect":["arquivo"], 
                "where": ["arquivo = 'NOTA_001'"]}`, null);

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        estaNaArqLocal = jsonStr.RESULT[0].length > 0 ? true : false;
      } catch (error) {
        console.error(error);
      }

      await vencimentoCertificado();

      $('#btnConfig').on('click', async function() {
        try {
          const url = '/sisplan/nfe/v1/buscarininfe?';
          const params = '';
          const response = await requisicao('GET', url, params, null);

          const jsonIni = await response.json();
          if (response.status != 200) {
            console.log(jsonIni.RESULT[0][0].mensagem);
            return;
          }
          $('#txtVersao').val(jsonIni.versao);
          $('#txtDiretorioLog').val(jsonIni.diretorioLog);
          $('#txtTimeZone').val(jsonIni.timeZone);
          $('#txtTimeOut').val(jsonIni.timeOut);
          $('#txtMetodo').val(jsonIni.metodo);
          $('#txtServidorRadar').val(jsonIni.servidorRadar);
          $('#txtRecursoRadar').val(jsonIni.recursoRadar);
          $('#txtTimeOutRadar').val(jsonIni.timeOutRadar);



          if (jsonIni.ambiente == '2') {
            $('#txtAmbiente').val('2');
          } else {
            $('#txtAmbiente').val('1');
          }
        } finally {
          $('#modal-config').modal('show');
        }
      });

      $('#btnConfirmarConfigNFE').on('click', async function() {
        try {
          const params = '';
          const NFE = {
            versao: $('#txtVersao').val(),
            ambiente: $('#txtAmbiente').val(),
            diretorioLog: $('#txtDiretorioLog').val(),
            timeZone: $('#txtTimeZone').val(),
            timeOut: $('#txtTimeOut').val(),
            metodo: $('#txtMetodo').val(),
            servidorRadar: $('#txtServidorRadar').val(),
            recursoRadar: $('#txtRecursoRadar').val(),
            timeOutRadar: $('#txtTimeOutRadar').val()
          };
          const url = '/sisplan/nfe/v1/gravarininfe?';
          const response = await requisicao('POST', url, params, JSON.stringify(NFE), 15000);
          console.log(response);


          if (response.status == 200) {
            toastr.success(
              'Configuração gravada com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                  $('#modal-config').modal('hide');
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          } else {
            return;
          }
        } finally {
          $('#modal-config').modal('hide');
        }
      });

      $('#btnLimparFiltros').on('click', async function() {
        $('#txtDataDe').val('1899-01-01');
        $('#txtDataAte').val('2500-01-01');
        $('#txtCliente').val('');
        $('#txtNota').val('');
        $('#radioPrimary1').prop('checked', true);
        $('#radioProtocolo1').prop('checked', true);
      });

      $('#txtNumeroNF').attr('disabled', 'disabled');
      $('#txtSerieNF').attr('disabled', 'disabled');
      $('#txtEmissaoNF').attr('disabled', 'disabled');
      $('#txtChaveNF').attr('disabled', 'disabled');
      $('#txtReciboNF').attr('disabled', 'disabled');
      $('#txtProtocoloNF').attr('disabled', 'disabled');

      $('input[name=rg_status]:checked').on('change', function() {
        $('#btn-consultar').trigger('click');
      });
      $('input[name=rg_protocolo]:checked').on('change', function() {
        $('#btn-consultar').trigger('click');
      });

      var tabelaNotas = $('#tabelaNotas').DataTable({
        paging: true,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        key: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        }
      });



      // se precionar enter executa duplo click
      // keytable.event.action(null, null, function(node) {
      //   $(node).click();
      // });

      var tabelaItens = $('#tabelaItens').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        }
      });

      async function RetornaSerieNF() {
        var _url = `/sisplan/funcoes/v1/pesquisa?`;
        var arrVencimentos = [];
        try {
          var response = await requisicao('GET', _url,
            `JSON={ "tabela":"empresa", "camposSelect":["emp_serienf"], "where": ["emp_id = ${getCookie('emp_id')}"] }`,
            null);

          if (!response) {
            return;
          }

          var jsonStr = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }
          if (jsonStr['RESULT'][0][0].EMP_SERIENF != '') {
            var serie = jsonStr['RESULT'][0][0].EMP_SERIENF;
          } else {
            var serie = '1';
          }
          return serie;
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar os dados do produto.');
        }
      }

      async function buscaItens(sFatura, sSerie) {
        var _url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
          var response = await requisicao('GET', _url,
            `JSON={ "tabela":"notaiten", "camposSelect":[ "notaiten.codigo", "notaiten.descricao", "notaiten.cor", "cadcor.descricao desc_cor", 
              "notaiten.tamanho", "notaiten.qtde", "notaiten.preco", "notaiten.valor", "notaiten.natureza", "notaiten.ordem", "notaiten.cla_fis", "notaiten.cla_trib", "notaiten.cla_csosn",
              "notaiten.cla_ipi", "notaiten.cla_pis", "notaiten.cla_cofins", "notaiten.enquadra"], "leftjoin": [{"tabela":"cadcor", "condicao":"cadcor.cor = notaiten.cor"}], "where": ["notaiten.fatura = '${sFatura}' and notaiten.serie = '${sSerie}'"] }`,
            null);

          if (!response) {
            return;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          return jsonStr;
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar os itens da nota');
        }
      }

      async function buscaDadosNota(sFatura, sSerie) {
        var _url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
          var response = await requisicao('GET', _url,
            `JSON={ 
              "tabela":"NOTA", 
              "camposSelect":[  "NOTA.CONS_FINAL", "NOTA.GERAR_DIFAL", "NOTA.IND_PRES", "NOTA.INTERMED", "ENTIDADE.NOME NOME_INTERMED", "NOTA.TRANSPORT", "TABTRAN.NOME", "NOTA.DT_EMISSAO", 
                                "NOTA.DT_SAIDA", "UF_EMBARQUE", "LOCAL_EMBARQUE", "NOTA.COD_RASTREIO", "NOTA.MENSAGEM", "NOTA.CIF"
                              ], 
              "leftjoin": [
                {"tabela":"TABTRAN", "condicao":"tabtran.codigo = nota.transport"},
                {"tabela":"ENTIDADE", "condicao":"ENTIDADE.CODCLI = NOTA.INTERMED"}
              ], 
              "where": ["NOTA.fatura = '${sFatura}' and NOTA.serie = '${sSerie}'"] 
            }`,
            null);

          if (!response) {
            return;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          return jsonStr;
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar as notas fiscais');
        }
      }

      async function buscaNotasRef(sFatura, sSerie) {
        const pesquisaParam = {
          tabela: 'NOTA_REF',
          camposSelect: [
            'NOTA_REF', 'SERIE_REF', 'CODCLI_REF', 'DATA_REF', 'IND_OPER', 'IND_EMIT', 'TIPO_FISCAL_REF', 
            'COD_REF', 'PESO', 'VALOR', 'NUM_COO', 'SEQ_ECF', 'CHAVE_NFE'
          ],
          where: [`NOTA = '${sFatura}' AND SERIE = '${sSerie}'`]
        }
        return await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      }

      function retornaBotaoOpcoes(data) {
        return '<div style="text-align:left;"> ' +
          '   <div> ' +
          '    <button class="btn btn-info btn-sm" id="btn-mostrar-itens" type="button"> ' +
          '   ' + data + ' ' +
          '    </button> ' +
          '  </div>' +
          '</div>';
      }

      $("#btn-cliente").pesquisa_serverside(
        ["#txtCliente", "#txtCNPJ"],
        ["CODCLI", "CNPJ"],
        ["NOME", "CNPJ"],
        `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`,
        "Pesquisa Cliente"
      );
      $('#txtCliente').autocompleta(3,
        `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
      $('#btn-limpa-cliente').on('click', function() {
        $('#txtCliente').val('');
      });

      $("#btn-nota").pesquisa_serverside(
        ["#txtNota", "#txtaaaaaa"],
        ["FATURA", "DT_EMISSAO"],
        ["SERIE", "DT_EMISSAO"],
        `{"tabela":"nota", "camposSelect":[ "FATURA", "SERIE", "DT_EMISSAO" ], "where": ["EMP_ID = ${getCookie("emp_id")}"]}`,
        "Pesquisa Nota"
      );
      $('#txtNota').autocompleta(3,
        `JSON={ "tabela":"NOTA", "camposSelect":["FATURA CHAVE, SERIE DESCRICAO"], "where": ["EMP_ID = ${getCookie("emp_id")}"] }`);
      $('#btn-limpa-nota').on('click', function() {
        $('#txtNota').val('');
      });

      $('#txtAlteraTransportadora').autocompleta(3,
        `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`);
      $('#btn-transportadora-filtro').pesquisa('#txtAlteraTransportadora', 'CODIGO', 'NOME',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME"], "where": null}',
        'Pesquisa Transportadora', 'tabtran');
      $('#btn-limpa-transportadora').on('click', function() {
        $('#txtAlteraTransportadora').val('');
      });

      $("#txtAlteraIntermed").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
      $("#btn-Intermed-filtro").pesquisa_serverside(["#txtAlteraIntermed"], ["CODCLI"], ["NOME"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Intermediador");
      $("#btn-limpa-Intermed").on("click", function() {
        $("#txtAlteraIntermed").val("");
      });

      $("#txtEmbarque").autocompleta(1, `JSON={ "tabela":"DESEMBARACO", "camposSelect":["UF CHAVE, DESCRICAO"], "where": null }`);
      $("#btn-Embarque").pesquisa_serverside(["#txtEmbarque"], ["UF"], ["DESCRICAO"], `{"tabela":"DESEMBARACO", "camposSelect":[ "UF", "DESCRICAO" ], "where": null}`, "Pesquisa Embarque");
      $("#btn-limpa-Embarque").on("click", function() {
        $("#txtEmbarque").val("");
      });

      $("#txtValorRef").maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
      });
      $("#txtPesoRef").maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
      });

      $("#tabelaNotasRef").DataTable({
        paging: false,
        filter: false,
        info: true,
        order: true,
        destroy: true,
        language: {
          sEmptyTable: "Nenhuma nota adicionada",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhuma nota adicionada",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            "targets": [8, 9, 10],
            "className": 'pr-4 text-right'
          }
        ]
      });

      $("#txtModeloDocto").autocompleta(
        1,
        `JSON={ "tabela":"TIPO_FISCAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
      );
      $("#btnModeloDocto").pesquisa(
        "#txtModeloDocto",
        "CODIGO",
        "DESCRICAO",
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}',
        "Pesquisa Tipo Docto",
        "TIPO_FISCAL"
      );
      $("#btnAModeloDocto").on("click", function () {
        $("#txtModeloDocto").val("");
        $("#txtModeloDocto").trigger("blur");
      });

      $("#txtInfCompl").autocompleta(
        1,
        `JSON={ "tabela":"TABREF", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`
      );
      $("#btnInfCompl").pesquisa(
        "#txtInfCompl",
        "CODIGO",
        "DESCRICAO",
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABREF", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}',
        "Pesquisa Tipo Docto",
        "TABREF"
      );
      $("#btnAInfCompl").on("click", function () {
        $("#txtInfCompl").val("");
      });

      $("#radioEmissaoPropria, #radioTerceirosRef").on("change", function () {
        $("#txtNotaRef").val("");
        $('#btnNotaRef').unbind();
        if ($("#radioEmissaoPropria").prop("checked")) {
          $('#btnNotaRef').pesquisa_serverside(
            ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
            ['NOTA.FATURA', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
            ['NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
            `{"tabela":"NOTA", 
              "camposSelect":[ "NOTA.FATURA", "NOTA.SERIE", "NOTA.DT_EMISSAO", "NOTA.VALOR", ""NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"], 
              "leftjoin": [ 
                {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}
              ],
              "where": ["NOTA.EMP_ID = ${getCookie('emp_id')}"]
            }`,
            'Pesquisa Nota',
          );
        } else {
          $('#btnNotaRef').pesquisa_serverside(
            ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtValorNotaRef'],
            ['NOTA_ENTRA.NOTAFISCAL', 'NOTA_ENTRA.DT_EMISSAO', 'NOTA_ENTRA.CREDOR', 'NOTA_ENTRA.VALOR'],
            ['NOTA_ENTRA.SERIE', 'NOTA_ENTRA.DT_EMISSAO', 'NOTA_ENTRA.CREDOR', 'NOTA_ENTRA.VALOR'],
            `{"tabela":"NOTA_ENTRA", 
              "camposSelect":["NOTA_ENTRA.NOTAFISCAL", "NOTA_ENTRA.SERIE", "NOTA_ENTRA.DT_EMISSAO", "NOTA_ENTRA.VALOR", "NOTA_ENTRA.CREDOR", "ENTIDADE.NOME"], 
              "leftjoin": [ 
                {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA_ENTRA.CREDOR"}
              ],
              "where": ["NOTA_ENTRA.EMP_ID = ${getCookie('emp_id')}"]
            }`,
            'Pesquisa Nota',
          );
        }
        $('#txtModeloDocto').trigger('blur');
      });

      $("#txtModeloDocto").on("blur", function () {
        if (isChecked('#radioTerceirosRef')) {
          return;
        }

        if (["2B", "2C", "2D", "37"].includes(pegaChave("#txtModeloDocto"))) {
          $("#divNotaRef").addClass("d-none");
          $("#divInfCompl").addClass("d-none");

          $("#divNumCoo").removeClass("d-none");
          $("#divSeqEcf").removeClass("d-none");

          $("#txtDataNotaRef").val("[1899-01-01] - 1899-01-01");

        } else {
          $("#divNotaRef").removeClass("d-none");
          $("#divInfCompl").removeClass("d-none");

          $("#divNumCoo").addClass("d-none");
          $("#divSeqEcf").addClass("d-none");

          $("#txtNumCoo").val("");
          $("#txtSeqEcf").val("");

          $('#btnNotaRef').unbind();
          if (pegaChave("#txtModeloDocto") == '65') {
            $('#btnNotaRef').pesquisa_serverside(
              ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
              ['NOTA_NFCE.FATURA', 'NOTA_NFCE.DT_EMISSAO', 'NOTA_NFCE.CODCLI', 'NOTA_NFCE.CHAVE_NFCE', 'NOTA_NFCE.VALOR'],
              ['NOTA_NFCE.SERIE', 'NOTA_NFCE.DT_EMISSAO', 'NOTA_NFCE.CODCLI', 'NOTA_NFCE.CHAVE_NFCE', 'NOTA_NFCE.VALOR'],
              `{"tabela":"NOTA_NFCE", 
                "camposSelect":[ "NOTA_NFCE.FATURA", "NOTA_NFCE.SERIE", "NOTA_NFCE.DT_EMISSAO", "NOTA_NFCE.VALOR", "NOTA_NFCE.CODCLI", "ENTIDADE.NOME", "NOTA_NFCE.CHAVE_NFCE"], 
                "leftjoin": [ 
                  {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA_NFCE.CODCLI"}
                ],
                "where": ["NOTA_NFCE.EMP_ID = ${getCookie('emp_id')}"]
              }`,
              'Pesquisa NFCE',
            );

          } else if (pegaChave("#txtModeloDocto") == '59') {
            $('#btnNotaRef').pesquisa_serverside(
              ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
              ['CFE.FATURA', 'CFE.DT_EMISSAO', 'CFE.CODCLI', 'CFE.CHAVE_CFE', 'CFE.VALOR'],
              ['CFE.SERIE_SAT', 'CFE.DT_EMISSAO', 'CFE.CODCLI', 'CFE.CHAVE_CFE', 'CFE.VALOR'],
              `{"tabela":"CFE", 
                "camposSelect":[ "CFE.FATURA", "CFE.SERIE_SAT", "CFE.DT_EMISSAO", "CFE.VALOR", "CFE.CODCLI", "ENTIDADE.NOME", "CFE.CHAVE_CFE"], 
                "leftjoin": [ 
                  {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = CFE.CODCLI"}
                ],
                "where": ["CFE.EMP_ID = ${getCookie('emp_id')}"]
              }`,
              'Pesquisa CFE',
            );

          } else {
            $('#btnNotaRef').pesquisa_serverside(
              ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
              ['NOTA.FATURA', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
              ['NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
              `{"tabela":"NOTA", 
                "camposSelect":[ "NOTA.FATURA", "NOTA.SERIE", "NOTA.DT_EMISSAO", "NOTA.VALOR", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"], 
                "leftjoin": [ 
                  {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}
                ],
                "where": ["NOTA.EMP_ID = ${getCookie('emp_id')}"]
              }`,
              'Pesquisa Nota',
            );
          }
        }
      });

      $("#btnReferenciarPorNota").on("click", function () {
        $("#divRefNota").removeClass("d-none");
        $("#divRefChave").addClass("d-none");
        $("#divRefData").addClass("d-none");
      });

      $("#btnReferenciarPorChave").on("click", function () {
        $("#divRefNota").addClass("d-none");
        $("#divRefChave").removeClass("d-none");
        $("#divRefData").removeClass("d-none");
      });

      $("#btnAddNotaRef").click(async function () {
        if (
          (($("#txtNotaRef").val() == "" && $("#txtChaveRef").val() == "") ||
            $("#txtModeloDocto").val() == "" ||
            $("#txtInfCompl").val() == "") &&
          !["2B", "2C", "2D", "37"].includes(pegaChave("#txtModeloDocto"))
        ) {
          msgAlerta("Campos obrigatórios não informados, favor verificar.");
          return;
        }
        if (
          ($("#txtNumCoo").val() == "" || $("#txtSeqEcf").val() == "") &&
          ["2B", "2C", "2D", "37"].includes(pegaChave("#txtModeloDocto"))
        ) {
          msgAlerta("Campos obrigatórios não informados, favor verificar.");
          return;
        }
        await addNotaRef();
        limpaCamposNotaRef();
      });

      async function addNotaRef() {
        const chave = $("#txtChaveRef").val() == '' ? pegaChave('#txtChaveNotaRef') : $("#txtChaveRef").val();
        let fatura = pegaChave("#txtNotaRef");
        const serie = pegaDescricao("#txtNotaRef");
        const codcli = pegaChave("#txtCodcliNotaRef");
        const emissao = (!$('#divRefData').hasClass('d-none') && (pegaValor('#txtDataRef') != '')) ? (pegaValor('#txtDataRef').split('-')[2] + '/' + pegaValor('#txtDataRef').split('-')[1] + '/' + pegaValor('#txtDataRef').split('-')[0]) : pegaChave("#txtDataNotaRef").slice(0, 10);
        const indoper = $("#radioEntradaAquisicao").is(":checked") ? "0" : "1";
        const indemit = $("#radioEmissaoPropria").is(":checked") ? "0" : "1";
        const tipodoc = pegaChave("#txtModeloDocto");
        const codref = pegaChave("#txtInfCompl");
        const peso = $("#txtPesoRef").val() == "" ? "0.00" : $("#txtPesoRef").val();
        const valor = $("#txtValorRef").val() == "" ? "0.00" : $("#txtValorRef").val();
        const numCoo = $("#txtNumCoo").val();
        const seqEcf = $("#txtSeqEcf").val();
        const valorNf = $("#txtValorNotaRef").val() == "" ? "0.00" : pegaChave("#txtValorNotaRef");

        if ((tipodoc == '55') && (indemit == '0')) {
          fatura = await retornaFaturaSemEmpId(fatura, serie);
        }

        if (emissao == '') {
          msgAlerta('Data de emissão não informada, verifique!');
          return;
        }

        const notaJaAdicionada = $("#tabelaNotasRef").DataTable().data().toArray().filter(notas => notas[13] == chave).length > 0;

        if (notaJaAdicionada) {
          msgAlerta('Nota já adicionada, verifique.');
          return;
        }

        $("#tabelaNotasRef")
          .DataTable()
          .row.add([
            fatura,
            serie,
            codcli,
            emissao,
            indoper,
            indemit,
            tipodoc,
            codref,
            peso,
            valor,
            parseFloat(valorNf).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }),
            numCoo,
            seqEcf,
            retornaBotaoExcluirNota(),
            chave,
          ])
          .draw(false);
      }

      async function retornaFaturaSemEmpId(sFatura, sSerie) {
        if (estaNaArqLocal == "") {
          await validaArqLocal();
        }

        if (estaNaArqLocal == true) {
          sFatura = sFatura.substring(0, sFatura.length - getCookie('emp_id').length)
        }

        if (await buscaValor('EMPRESA', 'EMP_CONTR_SERIE', 'EMP_ID', getCookie('emp_id')) == 'S') {
          sFatura = sFatura.substring(0, sFatura.length - sSerie.length);
        }

        return sFatura;
      };

      async function validaArqLocal() {
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"arqlocal", 
                "camposSelect":["arquivo"], 
                "where": ["arquivo = 'NOTA_001'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }
          estaNaArqLocal = jsonStr.RESULT[0].length > 0;
        } catch (error) {
          console.error(error);
        }
      };

      function retornaBotaoExcluirNota() {
        return (
          '<div style="text-align:center;"> ' +
          '   <button class="btn btn-info btn-sm" id="btnExcluirNotaRef" type="button"> ' +
          "      Excluir" +
          "   </button> " +
          "</div>"
        );
      }

      function limpaCamposNotaRef() {
        $("#txtNotaRef").val("");
        // $("#txtModeloDocto").val("");
        // $("#txtInfCompl").val("");
        $("#txtPesoRef").val("");
        $("#txtValorRef").val("");
        $("#txtNumCoo").val("");
        $("#txtSeqEcf").val("");
        $("#txtChaveRef").val("");
        $("#txtDataRef").val("");
        $("#txtModeloDocto").trigger("blur");
        $("#txtDataNotaRef").val("");
        $("#txtChaveNotaRef").val("");
      }

      $("#tabelaNotasRef").on("click", "#btnExcluirNotaRef", async function () {
        let table = $("#tabelaNotasRef").DataTable();
        table.row($(this).parents("tr")).remove().draw(false);
      });

      $('#btnImprimirNFe').on('click', async function() {
        let fatura;
        if (estaNaArqLocal) {
          fatura = $('#txtNumeroNF').val() + getCookie('emp_id');
        } else {
          fatura = $('#txtNumeroNF').val();
        }
        let serie = $('#txtSerieNF').val();
        if (fatura == '') {
          msgAlerta('Nenhuma nota selecionada, impossível continuar.');
          return;
        }
        var url = `/sisplan/nfe/v1/imprimirnfe?FATURA=${fatura}&SERIE=${serie}`;
        try {
          $.LoadingOverlay("show");
          try {
            const bImprimeAutomatico = await verificaImprimirAutomatico('NFE');
            var arquivo = await GeraRelatorio(url + '&', 'PUT', 15000, false, 'NFE');
            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open('<?php echo BASE_URI; ?>/relatorios_api/pdf/' + arquivo, '_blank');
              }
              await limparRelatorios();
            }
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
          $('#btn-consultar').trigger('click');
          $('#dropdown-menu').removeClass("show");
        }
      });

      $('#btnImprimirBoleto').on('click', async function() {
        await imprimirBoleto();
      });

      async function imprimirBoleto(transmitir = 'N') {
        let fatura;
        if (estaNaArqLocal) {
          fatura = $('#txtNumeroNF').val() + getCookie('emp_id');
        } else {
          fatura = $('#txtNumeroNF').val();
        }
        let serie = $('#txtSerieNF').val();

        if ((fatura == '') || (fatura.length < 6)) {
          msgAlerta('Nenhuma nota selecionada, impossível continuar.');
          return;
        }
        var url = `/sisplan/impressao/v1/imprimirboletofat?FATURA=${fatura}&TRANSMITIR=${transmitir}&EMAIL=N`;
        try {
          $.LoadingOverlay("show");
          try {
            const bImprimeAutomatico = await verificaImprimirAutomatico('NFEBoleto');
            var arquivo = await GeraRelatorio(url + '&', 'GET', 1000000, false, 'NFEBoleto');
            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open('<?php echo BASE_URI; ?>/relatorios_api/pdf/' + arquivo, '_blank');
              }
              await limparRelatorios();
            }
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
          $('#dropdown-menu').removeClass("show");
        }
      }

      $('#btnImprimirMinuta').on('click', () => {
        parent.document.querySelector('#menu_impressao_minuta .nav-link').click();
      })
      
      retornaHintRelatorio('btnImprimirNFeSimplificada','DanfeSimplificado')
      retornaHintRelatorio('btnImprimirCCe','Eventos')
      retornaHintRelatorio('btnImprimirNFe','Danfe')
      retornaHintRelatorio('btnImprimirBoleto','WFatBol + NUMERO DO BANCO')
      $('#btnImprimirNFeSimplificada').on('click', async function() {
        let fatura;
        if (estaNaArqLocal) {
          fatura = $('#txtNumeroNF').val() + getCookie('emp_id');
        } else {
          fatura = $('#txtNumeroNF').val();
        }
        let serie = $('#txtSerieNF').val();
        if (fatura == '') {
          msgAlerta('Nenhuma nota selecionada, impossível continuar.');
          return;
        }
        var url = `/sisplan/nfe/v1/imprimirnfesimplificada?FATURA=${fatura}&SERIE=${serie}`;
        try {
          $.LoadingOverlay("show");
          try {
            const bImprimeAutomatico = await verificaImprimirAutomatico('NFESimplificada');
            var arquivo = await GeraRelatorio(url + '&', 'PUT', 15000, false, 'NFESimplificada');
            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open('<?php echo BASE_URI; ?>/relatorios_api/pdf/' + arquivo, '_blank');
              }
              await limparRelatorios();
            }
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
          $('#btn-consultar').trigger('click');
          $('#dropdown-menu').removeClass("show");
        }
      });

      $('#btnImprimir').on('click', async function() {
        if ($("#dropdown-menu")[0].classList[1] != "show") {
          $('#dropdown-menu').addClass("show");
        } else {
          $('#dropdown-menu').removeClass("show");
        }
      });


      $('#btnImprimirCCe').on('click', async function() {
        let fatura;
        if (estaNaArqLocal) {
          fatura = $('#txtNumeroNF').val() + getCookie('emp_id');
        } else {
          fatura = $('#txtNumeroNF').val();
        }
        let serie = $('#txtSerieNF').val();
        let chave = $('#txtChaveNF').val();
        if (fatura == '') {
          msgAlerta('Nenhuma nota selecionada, impossível continuar.');
          return;
        }
        try {
          var response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"NOTA_CCE", "camposSelect":["sequencia"], 
                  "where": ["fatura = '${fatura}' and serie = '${serie}'"],
                  "orderby": ["sequencia desc"]}`, null)
          var jsonStr = await response.json();
          if (jsonStr.RESULT[0].length == 0) {
            msgAlerta('Nenhuma CCe gerada para essa nota.')
          } else {
            var url =
              `/Sisplan/NFE/v1/EmitirCCe?CHAVE=${chave}&FATURA=${fatura}&SERIE=${serie}&SEQUENCIA=${String(jsonStr.RESULT[0][0].SEQUENCIA)}`;
            try {
              $.LoadingOverlay("show");
              var arquivo = await GeraRelatorio(url + '&', 'GET', 15000, false);
              if (arquivo != undefined) {
                window.open('<?php echo BASE_URI; ?>/relatorios_api/pdf/' + arquivo, '_blank');
                await limparRelatorios();
              }
            } finally {
              $.LoadingOverlay("hide");
              $('#dropdown-menu').removeClass("show");
            }
          }
        } catch (error) {
          console.error(error);
        }
      });

      $('#btnCancelar').on('click', async function() {
        var tr = $('#tabelaNotas tr.selected')[0];
        var data = $('#tabelaNotas').DataTable().row($(tr)).data();
        const fatura = estaNaArqLocal ? data[1] : $('#txtNumeroNF').val();

        const inicio = new Date(data[3].split('/')[2]+'-'+data[3].split('/')[1]+'-'+data[3].split('/')[0]);
        const diferencaEmDias = Math.ceil(Math.abs(new Date() - inicio) / (1000 * 60 * 60 * 24)) - 1;
        
        if ((pedeSenhaCancelaNota != '0') && (data[7] != '') && (diferencaEmDias > 0)) {
          if (pedeSenhaCancelaNota == '1') {
            await senhaSupervisor('Nota gerada há mais de 24h, necessário informar senha de supervisor.', async () => {
              await cancelaNota();
            });
          } else if ((pedeSenhaCancelaNota == '2') && diferencaEmDias >= 2) {
            await senhaSupervisor('Nota gerada há mais de 48h, necessário informar senha de supervisor.', async () => {
              await cancelaNota();
            });
          }
        } else {
          await cancelaNota();
        }
      });

      async function cancelaNota() {
        try {
          var tr = $('#tabelaNotas tr.selected')[0];
          var data = $('#tabelaNotas').DataTable().row($(tr)).data();
          const fatura = estaNaArqLocal ? data[1] : $('#txtNumeroNF').val();

          $('#txtCancFatura').val($('#txtNumeroNF').val());
          $('#txtCancSerie').val(data[2]);

          var response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"nota", "camposSelect":["protocolo_nfe"], 
            "where": ["fatura = '${fatura}' and serie = '${data[2]}'"]}`,
            null)
          var jsonStr = await response.json();
          if (jsonStr['RESULT'][0][0].PROTOCOLO_NFE == '') {
            $('#justificativaCancelamento').addClass('d-none');
          } else {
            $('#justificativaCancelamento').removeClass('d-none');
          }

          if (data[0] == 'C') {
            msgAlerta('Esta nota fiscal já está cancelada. Impossível continuar.');
            return;
          }

          if (data[0] == 'D') {
            msgAlerta(
              'A NFe foi DENEGADA. Não pode ser cancelada no SEFAZ. Somente será cancelado as duplicatas, voltar o pedido e estoque se houver!'
            );
          }
          $('#modal-cancelamento').modal('show');
        } catch (error) {
          console.error(error);
          msgAlerta('Erro ao cancelar NFe.');
        }
      }

      $('#btnCce').on('click', async function() {
        try {
          var tr = $('#tabelaNotas tr.selected')[0];
          var data = $('#tabelaNotas').DataTable().row($(tr)).data();
          if (data[7] == '') {
            msgAlerta('Nota não transmitida, impossível fazer uma carta de correção.')
            return
          }
          $('#txtFaturaCce').val($('#txtNumeroNF').val());
          $('#txtSerieCce').val(data[2]);
          $('#txtChaveCce').val(data[7]);

          var responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"nota_cce", "camposSelect":["sequencia"], 
                    "where": ["fatura = '${data[1]}'"]}`, null);
          var jsonStr = await responseOperadora.json();

          $('#txtSequencia').val(jsonStr['RESULT'][0].length + 1);

          $('#modal-cce').modal('show');
        } catch (error) {
          console.error(error);
          msgAlerta('Selecione uma nota para fazer a carta de correção.')
        }
      });

      $('#btnGerarCce').on('click', async function() {
        if (estaNaArqLocal) {
          var fatura = $('#txtFaturaCce').val() + getCookie('emp_id');
        } else {
          var fatura = $('#txtFaturaCce').val();
        }
        var serie = $('#txtSerieCce').val();
        var justificativa = $('#txtJustificativaCce').val();
        var chave = $('#txtChaveCce').val();
        if (fatura && serie && justificativa && chave != '') {
          try {
            $.LoadingOverlay("show");

            var _url = '/Sisplan/NFE/v1/EmitirCCe?';
            var _params = `MENSAGEM=${justificativa}&FATURA=${fatura}&SERIE=${serie}&CHAVE=${chave}&CERTA3=${usaCertificadoA3 ? '1' : '0'}`;
            try {
              var response = await requisicao('POST', _url, _params, null, 60000);

              if (!response) {
                msgErro('Erro ao gerar CCe');
                return;
              }

              if (response.status != 200) {
                var jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
              }

              if (usaCertificadoA3) {
                const retornoCce = await response.json();
                const empClasse = await retornaInformacaoEmpresa();

                // TRANSMITE API LOCAL
                const responseLocal = await requisicao_ecf('POST', '/nfe/cce?', `CLASSEEMPRESA=${JSON.stringify(empClasse)}`, JSON.stringify(retornoCce), 120000);
                if (responseLocal.status != 200) {
                  const mensagemErro = await responseLocal.text();
                  msgErro(mensagemErro);
                  return;
                }
                const retornoCceLocal = await responseLocal.json();

                // FINALIZA TRANSMISSÃO NA API WEB
                const reponseApiWeb = await requisicao(
                  'POST',
                  '/sisplan/nfe/v1/finalizacce?',
                  '',
                  JSON.stringify(retornoCceLocal),
                  60000
                );
                if (!response) {
                  return;
                }
                if (reponseApiWeb.status != 200) {
                  const mensagemRetorno = await reponseApiWeb.json();
                  msgErro(mensagemRetorno.mensagem);
                  return;
                }
              }

              try {
                $.LoadingOverlay("show");
                const responseEmail = await requisicao('POST', '/sisplan/nfe/v1/enviaremailcce?', `FATURA=${fatura}&SERIE=${serie}&SEQUENCIA=${$('#txtSequencia').val()}&CHAVE=${chave}&CODUSUARIO=${getCookie('cod_usuario')}`, null, 300000);
                if (!responseEmail) {
                  return;
                }
                
                if (responseEmail.status == 200) {
                  const jsonStrEmail = await responseEmail.json();
                  await msgSucesso(jsonStrEmail.mensagem);
                }
                
              } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
              }

              await criaMensagemSucesso('Carta de correção gerada com sucesso!', () => {
                window.location.reload();
              });

              toastr.success(
                'Carta de correção gerada com sucesso!',
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden: function() {
                    window.location.reload();
                  }
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });
            } finally {
              $.LoadingOverlay("hide");
            }

          } catch (error) {
            $.LoadingOverlay("hide");
            console.error(error);
          }
        } else {
          msgAlerta('Campos devem ser preenchidos.')
        }
      });

      $('#btn-confirmar-cancelamento').on('click', async function() {

        $.LoadingOverlay("show");
        try {
          const fatura = estaNaArqLocal ? $('#txtCancFatura').val() + getCookie('emp_id') : $('#txtCancFatura').val();
          const serie = $('#txtCancSerie').val();
          const justificativa = $('#txtCancJustificativa').val();
          const chave = $('#txtChaveNF').val();

          if (usaCertificadoA3 && (chave != '')) {
            const empClasse = await retornaInformacaoEmpresa();

            // PRIMEIRO PASSO
            //    CONSULTA NA API LOCAL
            let responseLocal = await requisicao_ecf('POST', '/nfe/consultar?', `CHAVE=${chave}`, JSON.stringify(empClasse), 60000);
            if (!responseLocal) {
              return;
            }
            if (responseLocal.status != 200) {
              let mensagemErro = await responseLocal.text();
              msgErro(mensagemErro);
              return;
            }
            let xmlConsulta = await responseLocal.json();

            //    INICIA CANCELAMENTO API WEB
            let reponseApiWeb = await requisicao('PUT', '/sisplan/nfe/v1/cancelarnfe?', `FATURA=${fatura}&SERIE=${serie}&JUSTIFICATIVA=${justificativa}&CERTA3=${usaCertificadoA3 && chave != '' ? 'true' : 'false'}&PASSO2=false`, xmlConsulta.xml, 60000);
            if (!reponseApiWeb) {
              return;
            }
            let jsonApiWeb = await reponseApiWeb.json();
            if (reponseApiWeb.status != 200) {
              msgErro(jsonApiWeb.mensagem);
              return;
            }

            //    CANCELA API LOCAL (SEFAZ)
            responseLocal = await requisicao_ecf('POST', '/nfe/cancelar?', `CLASSEEMPRESA=${JSON.stringify(empClasse)}`, JSON.stringify(jsonApiWeb), 60000);
            if (!responseLocal) {
              return;
            }
            if (responseLocal.status != 200) {
              mensagemErro = await responseLocal.text();
              msgErro(mensagemErro);
              return;
            }
            xmlConsulta = await responseLocal.json();

            // SEGUNDO PASSO
            //    FINALIZA CANCELAMENTO API WEB
            reponseApiWeb = await requisicao('PUT', '/sisplan/nfe/v1/cancelarnfe?', `FATURA=${fatura}&SERIE=${serie}&JUSTIFICATIVA=${justificativa}&CERTA3=true&PASSO2=true`, xmlConsulta.xml, 60000);
            if (!reponseApiWeb) {
              return;
            }
            if (reponseApiWeb.status != 200) {
              jsonApiWeb = await reponseApiWeb.json();
              msgErro(jsonApiWeb.mensagem);
              return;
            }

          } else {
            const _url = '/Sisplan/NFE/v1/CancelarNFE?';
            const _params = `FATURA=${fatura}&SERIE=${serie}&JUSTIFICATIVA=${justificativa}&CERTA3=false&PASSO2=false`;
            try {
              const response = await requisicao('PUT', _url, _params, '', 60000);
              if (!response) {
                msgErro('Erro ao cancelar NF-e');
                return;
              }
              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
              }
            } catch (error) {
              console.error(error);
            }
          }

          toastr.success(
            'Cancelamento efetuado com sucesso!',
            'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden: function() {
                window.location.reload();
              }
            }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });

        } finally {
          $('#txtCancJustificativa').val('');
          $.LoadingOverlay("hide");
        }

      });

      async function retornaInformacaoEmpresa() {
        try {
          let url = `/sisplan/funcoes/v1/pesquisa?`;
          let response = await requisicao('GET', url, `JSON={ 
            "tabela":"empresa", 
            "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert", "emp_crt", "emp_cnpj"], 
            "where": ["emp_id = ${getCookie('emp_id')}"] 
          }`, null);
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }
          return jsonStr.RESULT[0][0];
        } catch (error) {
          console.error(error);
          msgErro('Erro ao retornar dados da empresa, Erro: ');
        }
      }

      async function retornaLoteNfe() {
        try {
          const url = `/sisplan/nfe/v1/finalizanfe?`;
          const response = await requisicao('GET', url, '', null);
          if (!response) {
            return;
          }
          const lote = await response.text();
          if (response.status != 200) {
            return;
          }
          return lote;
        } catch (error) {
          console.error(error);
        }
      }

      $('#btnGerar').on('click', async function() {
        $.LoadingOverlay("show");
        try {
          const tr = $('#tabelaNotas tr.selected')[0];
          if (tr == undefined) {
            msgAlerta('Selecione uma nota para gerar.');
            return;
          }
          const data = $('#tabelaNotas').DataTable().row($(tr)).data();

          const fatura = estaNaArqLocal ? data[1] : $('#txtNumeroNF').val();

          const serie = data[2];
          const justificativa = '';
          const tipo = 0;
          const finalidade = pegaValor('#txtFinalidade');
          const _url = '/sisplan/nfe/v1/gerarnfe?';
          const _params = `SERIE=${serie}&FATURA=${fatura}&FINALIDADE=${finalidade}&JUSTIFICATIVA=${justificativa}&TIPO_TRANSMISSAO=${tipo}&CERTA3=${usaCertificadoA3 ? '1' : '0'}`;
          const response = await requisicao('POST', _url, _params, null, 60000);

          if (response.status != 200) {
            const jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return;
          }

          if (usaCertificadoA3 && (response.status == 200)) {
            const xml = await response.text();
            const loteNfe = await retornaLoteNfe();
            const empClasse = await retornaInformacaoEmpresa();

            // TRANSMITE NA API LOCAL
            const responseLocal = await requisicao_ecf('POST', '/nfe/gerar?', `CLASSEEMPRESA=${JSON.stringify(empClasse)}&LOTE=${loteNfe}`, xml, 120000);
            if (responseLocal.status != 200) {
              const mensagemErro = await responseLocal.text();
              msgErro(mensagemErro);
              return;
            }
            const retornoNota = await responseLocal.json();

            // FINALIZA TRANSMISSÃO NA API WEB
            const reponseApiWeb = await requisicao(
              'POST',
              '/sisplan/nfe/v1/finalizanfe?',
              `FATURA=${fatura}&SERIE=${serie}&TIPO_TRANSMISSAO=${0}`,
              JSON.stringify(retornoNota),
              60000
            );
            if (!response) {
              return;
            }
            if (reponseApiWeb.status != 200) {
              const mensagemRetorno = await reponseApiWeb.json();
              msgErro(mensagemRetorno.mensagem);
              return;
            }
          }

          await criaMensagemSucesso('NF-e gerada com sucesso!', async () => {
            await imprimirBoleto('S');
            const bEmail = await CopiaParametro("FATURAMENTO", 7) == '1';
            if (bEmail) {
              await enviaEmail();
            }
            $('#btn-consultar').trigger('click');
            $('#btnImprimirNFe').trigger('click');
          });

        } catch (error) {
          console.error(error);
          msgErro('Erro ao gerar NF-e. ' + error);
          $.LoadingOverlay("hide");
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#btn-confirmar-inutilizacao').on('click', async function() {
        try {
          $.LoadingOverlay("show");

          var _url = '/Sisplan/NFE/v1/InutilizarNFE?';
          var serie = $('#txtNotaSerie').val();
          var inicio = $('#txtNotaIni').val();
          var final = $('#txtNotaFim').val();
          var justificativa = $('#txtJustificativa').val();
          var _params = `SERIE=${serie}&NF_INICIO=${inicio}&NF_FIM=${final}&JUSTIFICATIVA=${justificativa}`;
          try {
            var response = await requisicao('PUT', _url, _params, null);

            if (!response) {
              msgErro('Erro ao Inutilizar NFE');
              return;
            }

            if (response.status != 200) {
              var jsonStr = await response.json();
              msgErro(jsonStr.mensagem);
              return;
            }

            toastr.success(
              'Inutilização efetuada com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: function() {
                  $('#modal-inutilizar').modal('hide');
                  $('#btn-consultar').trigger('click');
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#btnExcluir').on('click', async function() {
        try {
          try {
            if ($('#txtProtocoloNF').val() != '') {
              msgAlerta('Nota não pode ser excluída, pois consta no SEFAZ como autorizada ou cancelada.');
              return;
            }
            $.LoadingOverlay("show");
            var tr = $('#tabelaNotas tr.selected')[0];
            var data = $('#tabelaNotas').DataTable().row($(tr)).data();
            if (data[0] != 'C') {
              msgAlerta('Nota precisa ser cancelada primeiro.');
              return;
            };
            var nota = new Object();
            if (estaNaArqLocal) {
              nota.FATURA = data[1];
            } else {
              nota.FATURA = $('#txtNumeroNF').val();
            }
            nota.SERIE = data[2];
            var _url = '/Sisplan/NFE/v1/Faturamento?';
            var response = await requisicao('DELETE', _url,
              `JSON=${encodeURIComponent(JSON.stringify(nota))}`, null);

            if (!response) {
              msgErro('Erro ao Excluir NFE');
              return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return;
            }

            toastr.success(
              'Exclusão efetuada com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: function() {
                  window.location.reload()
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });
          } finally {
            $.LoadingOverlay("hide");
          }
        } catch (error) {
          console.error(error);
          msgAlerta('Selecione uma nota para excluir.')
        }
      });

      // $('#btnConfirmarAlteracaoNota').on('click', async function() {
      //   const sFatura = $('#txtAlterarFatura').val();
      //   const sSerie = $('#txtAlterarSerie').val();
      //   if ((sFatura != '') && (sSerie != '')) {
      //     await AlteraDadosNota(sFatura, sSerie, []);
      //   }
      // });

      $('#confirmar_dados').on('click', async function() {
        try {
          try {
            const codigoRastreio = $("#txtCodigoRastreio").val();
            const fatura = $("#modal-itens").prop("fatura");
            const serie = $("#txtAlterarSerie").val();
            if ($('#txtProtocoloNF').val() != '') {
              if ($("#txtCodigoRastreio").prop("codigo-old") != codigoRastreio) {
                await atualizaCodigoRastreio(codigoRastreio, fatura, serie);
                return;
              }
              msgErro('Nota Fiscal transmitida, impossível alterar dados.');
              return;
            }
            $.LoadingOverlay("show");
            if ($('#txtProtocoloNF').val() == '') {
              var arrItens = [];
              for (let index = 0; index < $('#tabelaItens').DataTable().rows().count(); index++) {
                const dados = $('#tabelaItens').DataTable().row(index).data();
                const natureza = $($('.campoNatureza')[index]).val();
                const ncm = $($('.campoNCM')[index]).val();
                const cstIcms = $($('.campoCSTICMS')[index]).val();
                const csosn = $($('.campoCSOSN')[index]).val();
                const cstIpi = $($('.campoCSTIPI')[index]).val();
                const cstPis = $($('.campoCSTPIS')[index]).val();
                const cstCofins = $($('.campoCSTCOFINS')[index]).val();
                const ipiEnquadra = $($('.campoEnquadra')[index]).val();
                var item = new Object();
                item.FATURA = estaNaArqLocal ? $('#txtNotaItens').val() + getCookie('emp_id') : $('#txtNotaItens').val();
                item.SERIE = $('#txtSerieItens').val();
                item.CODIGO = dados.CODIGO;
                item.COR = dados.COR;
                item.TAMANHO = dados.TAMANHO;
                item.ORDEM = dados.ORDEM;
                item.NATUREZA = natureza;
                item.CLAFIS = ncm;
                item.CLATRIB = cstIcms;
                item.CLACSOSN = csosn;
                item.CLAIPI = cstIpi;
                item.CLAPIS = cstPis;
                item.CLACOFINS = cstCofins;
                item.ENQUADRA = ipiEnquadra;
                arrItens.push(item);
              }
              const sFatura = $('#txtAlterarFatura').val();
              const sSerie = $('#txtAlterarSerie').val();
              const indPresenca = $('#rgPresenca').val();
              const sTransportadora = pegaChave('#txtAlteraTransportadora');

              if ($('#dtEmissao').val() == '') {
                await setarDataAtual('dtEmissao');
              }

              if ($('#dtSaida').val() == '') {
                await setarDataAtual('dtSaida');
              }

              const dtEmissao = $('#dtEmissao').val();
              const dtSaida = $('#dtSaida').val();
              const sIntermed = pegaChave('#txtAlteraIntermed');
              const sUfEmb = pegaChave('#txtEmbarque');
              const sLocalEmb = pegaDescricao('#txtEmbarque');
              const sCodigoRastreio = $('#txtCodigoRastreio').val();
              const sMensagem = $('#txtDados').val();

              let arrNotasRef = [];
              $("#tabelaNotasRef").DataTable().rows().data().map((nota) => {
                const notaRef = {
                  NOTA_REF: nota[0],
                  SERIE_REF: nota[1],
                  CODCLI_REF: nota[2],
                  DATA_REF: `${nota[3].split('/').length > 1 ? nota[3].split('/')[2] + '-' + nota[3].split('/')[1] + '-' + nota[3].split('/')[0] : nota[3]}T00:00:00Z`,
                  IND_OPER: nota[4],
                  IND_EMIT: nota[5],
                  TIPO_FISCAL_REF: nota[6],
                  COD_REF: nota[7],
                  PESO: nota[8],
                  VALOR: nota[9],
                  NUM_COO: nota[11],
                  SEQ_ECF: nota[12],
                  CHAVE_NFE: nota[14],
                };
                arrNotasRef.push(notaRef);
              });

              if ((sFatura != '') && (sSerie != '')) {
                await AlteraDadosNota(sFatura, sSerie, indPresenca, arrItens, sTransportadora, dtEmissao, dtSaida, sIntermed, sUfEmb, sLocalEmb, sCodigoRastreio, sMensagem, arrNotasRef, pegaChave('#txtClienteNota'));
              }
              toastr.success(
                'Alteração efetuada com sucesso!',
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning',
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden: function() {
                    $('#modal-itens').modal('hide');
                    $('#btn-consultar').trigger('click');
                  }
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });
            } else {
              $('#modal-itens').modal('hide');
            }
          } finally {
            $.LoadingOverlay("hide");
          }

        } catch (error) {

        }
      });

      $('#btnEmail').on('click', async function() {
        const tr = $('#tabelaNotas tr.selected')[0];
        if (tr == undefined) {
          msgAlerta('Selecione uma nota para enviar e-mail.')
          return;
        }
        await enviaEmail();
      });

      async function enviaEmail() {
        const fatura = $('#txtNumeroNF').val() != '' ? (estaNaArqLocal == true ? ($('#txtNumeroNF').val() + getCookie('emp_id')) : $('#txtNumeroNF').val()) : '';
        const serie = $('#txtSerieNF').val();
        const url = '/sisplan/nfe/v1/enviaremail?';
        try {
          try {
            $.LoadingOverlay("show");
            const response = await requisicao('POST', url, `FATURA=${fatura}&SERIE=${serie}&CODUSUARIO=${getCookie('cod_usuario')}`, null, 300000);
            if (!response) {
              return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.mensagem)
              return;
            }
            await msgSucesso(jsonStr.mensagem);
          } catch (error) {
            console.error(error);
            msgErro('Erro ao enviar e-mail');
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      $('#btnInutilizar').on('click', async function() {
        var serie = await RetornaSerieNF();
        $('#txtNotaSerie').val(serie);
        $('#modal-inutilizar').modal('show');
      });

      $('#btnGNRE').on('click', async function() {
        window.location.href = `gnre/${btoa($('#txtChaveNF').val())}`;
      });

      $('#btnConsultar').on('click', async function() {
        const fatura = $('#txtNumeroNF').val() != '' ? (estaNaArqLocal == true ? ($('#txtNumeroNF').val() + getCookie('emp_id')) : $('#txtNumeroNF').val()) : '';
        const serie = $('#txtSerieNF').val();
        const chave = $('#txtChaveNF').val();
        const protocolo = $('#txtProtocoloNF').val();
        const _url = `/sisplan/nfe/v1/consultanfe?`;

        if (fatura == '') {
          msgAlerta('Favor selecionar uma nota para consultar.');
          return;
        }
        if (chave == '') {
          msgAlerta('Nota não gerada, impossível consultar.');
          return;
        }

        try {
          if (usaCertificadoA3) {
            // CONSULTA NA API LOCAL
            const empClasse = await retornaInformacaoEmpresa();
            const responseLocal = await requisicao_ecf('POST', '/nfe/consultar?', `CHAVE=${chave}`, JSON.stringify(empClasse), 60000);
            if (!responseLocal) {
              return;
            }
            if (responseLocal.status != 200) {
              const mensagemErro = await responseLocal.text();
              msgErro(mensagemErro);
              return;
            }
            const jsonRetorno = await responseLocal.json();

            // FINALIZA CONSULTA NA API WEB
            const reponseApiWeb = await requisicao(
              'POST',
              '/sisplan/nfe/v1/finalizaconsultanfe?',
              `FATURA=${fatura}&SERIE=${serie}&PROTOCOLO=${protocolo}`,
              JSON.stringify(jsonRetorno),
              60000
            );
            if (!reponseApiWeb) {
              return;
            }
            const jsonApiWeb = await reponseApiWeb.json();
            if (reponseApiWeb.status != 200) {
              msgErro(jsonApiWeb.mensagem);
              return;
            }
            msgAlerta(jsonApiWeb.mensagem);

          } else {

            const response = await requisicao('POST', _url, `FATURA=${fatura}&SERIE=${serie}&CHAVE=${chave}&PROTOCOLO=${protocolo}`, null);
            if (!response) {
              return;
            }
            const jsonStr = await response.json()
            if (response.status != 200) {
              msgErro(jsonStr.mensagem)
              return;
            }
            await msgAlerta(jsonStr.mensagem);

          }

          $('#btn-consultar').trigger('click');

        } catch (error) {
          console.error(error);
        }
      });

      $('#btn-consultar').on('click', async function() {
        try {
          $.LoadingOverlay("show");

          let emp_id = getCookie('emp_id');
          let sDataIni = "'" + $('#txtDataDe').val() + "'";
          let sDataFim = "'" + $('#txtDataAte').val() + "'";
          let impresso = '';
          let protocolo = '';
          let sCodCli = pegaChave('#txtCliente');
          let camposSelect = '';
          let colunas = [];
          const tipoBase = await retornaDatabase();

          if (sCodCli != '') {
            sCodCli = " and nota.codcli = '" + sCodCli + "'";
          }
          let sFatura = pegaChave('#txtNota');
          if (sFatura != '') {
            sFatura = " and nota.fatura = '" + sFatura + "'";
          }
          switch ($('input[name=rg_status]:checked').val()) {
            case '1': {
              impresso = 'S';
              break;
            }
            case '2': {
              impresso = 'N';
              break;
            }
            case '3': {
              impresso = 'C';
              break;
            }
            case '4': {
              impresso = 'D';
              break;
            }
            default:
              impresso = '';
              break;
          }

          switch ($('input[name=rg_protocolo]:checked').val()) {
            case '1': {
              protocolo = "and ((nota.PROTOCOLO_NFE IS NOT NULL) AND (nota.PROTOCOLO_NFE <> ''))";
              break;
            }
            case '2': {
              protocolo = "and ((nota.PROTOCOLO_NFE IS NULL) OR (nota.PROTOCOLO_NFE = ''))";
              break;
            }
            default:
              protocolo = '';
              break;
          }

          if (impresso != '') {
            impresso = 'and nota.impresso =' + "'" + impresso + "'";
          }

          camposSelect = `["NOTA.IMPRESSO", "NOTA.FATURA", "NOTA.SERIE", "NOTA.DT_EMISSAO", "NOTA.CODCLI",
          "ENTIDADE.NOME", "${tipoBase == "POSTGRES" ? "CAST(NOTA.VALOR AS TEXT)" : "REPLACE(NOTA.VALOR, ',', '.')"}", 
          "NOTA.CHAVE_NFE", "NOTA.PROTOCOLO_NFE", "NOTA.EMISSAO_NFE", "NOTA.RECIBO_NFE", "'' OPCOES"]`;

          colunas = ["IMPRESSO", "FATURA", "SERIE", "DT_EMISSAO", "CODCLI", "NOME",
            "VALOR", "CHAVE_NFE", "PROTOCOLO_NFE", "EMISSAO_NFE", "RECIBO_NFE", "IMPRESSO"
          ];

          const ligacaoTabelaEntidade = `{"tabela": "ENTIDADE","condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}`;

          const ajaxData = {
            "EMPRESA": getCookie('empresa'),
            "JSON": `{"tabela":"NOTA", "camposSelect": ${camposSelect}, "leftJoin": [${ligacaoTabelaEntidade}], "where": ["(NOTA.dt_emissao >= ${sDataIni} and NOTA.dt_emissao <= ${sDataFim}) and nota.emp_id = ${emp_id} ${impresso} ${protocolo} ${sFatura} ${sCodCli}"], "orderby": ["nota.fatura desc"]}`,
            "CLIENTE": 'N',
          };

          let dataSetCols = [];

          for (let i = 0; i < colunas.length; i++) {
            dataSetCols.push({
              'title': colunas[i],
              'data': i
            });
          }


          let tabelaNotas = $('#tabelaNotas').DataTable({
            paging: true,
            lengthChange: false,
            filter: false,
            info: true,
            order: true,
            autowidth: true,
            destroy: true,
            serverSide: true,
            processing: true,
            ajax: {
              url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
              type: "GET",
              headers: {
                'Authorization': BASIC_AUTH
              },
              data: ajaxData,
            },
            "columnDefs": [{
                "targets": [8, 9, 10, 11],
                "visible": false
              },
              {
                targets: [1],
                render: function(data, type, row) {
                  return retornaBotaoOpcoes(data);
                },
              },
              {
                render(data) {
                  if (estaNaArqLocal) {
                    return data.substr(0, (data.length - getCookie('emp_id').length));
                  } else {
                    return data;
                  }
                },
                targets: 1,
              },
              {
                render(data) {
                  return parseFloat(data).toLocaleString("pt-br", {
                    style: "currency",
                    currency: "BRL",
                  });
                },
                targets: [6],
                "className": 'pr-4 text-right'
              }
            ],
            "language": {
              "sEmptyTable": "Nenhum registro encontrado",
              "sInfo": "_TOTAL_ registros",
              "sInfoEmpty": " 0 registros",
              "sInfoFiltered": "(Filtrados de _MAX_ registros)",
              "sInfoPostFix": "",
              "sInfoThousands": ".",
              "sLengthMenu": "_MENU_ resultados",
              "sLoadingRecords": "Carregando...",
              "sProcessing": "Processando...",
              "sZeroRecords": "Nenhum registro encontrado",
              "sSearch": "Pesquisar",
              "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
              },
              "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
              }
            },
            columns: dataSetCols
          });

          $('#tabelaNotas tbody').unbind('click');
          $('#tabelaNotas tbody').on('click', 'tr', async function() {
            if ($(this).hasClass('selected')) {
              $(this).removeClass('selected');
            } else {
              $('#tabelaNotas').DataTable().$('tr.selected').removeClass('selected');
              $(this).addClass('selected');
              if ($('#tabelaNotas').DataTable().rows().count() == 0) {
                $('#txtNumeroNF').val('');
                $('#txtSerieNF').val('');
                $('#txtEmissaoNF').val('');
                $('#txtProtocoloNF').val('');
                $('#txtReciboNF').val('');
                $('#txtChaveNF').val('');
                $("#btnGNRE").attr("disabled", true);
              } else {
                var data = $('#tabelaNotas').DataTable().row($(this)).data();
                const fatura = estaNaArqLocal ? data[1].substr(0, (data[1].length - getCookie('emp_id').length)) : data[1];
                $('#txtNumeroNF').val(fatura);
                $('#txtSerieNF').val(data[2]);
                $('#txtEmissaoNF').val(data[3]);
                $('#txtProtocoloNF').val(data[8]);
                $('#txtReciboNF').val(data[10]);
                $('#txtChaveNF').val(data[7]);
                await buscaFinalidade(data[1], data[2]);
                await validaGNRE(data[1], data[2]);
              }
            }
          });
        } finally {
          $.LoadingOverlay("hide");
          $('#modal-filtros').modal('hide');

          setTimeout(() => {
            if ($('#tabelaNotas').DataTable().rows().count() > 0) {
              $($('#tabelaNotas tbody tr')[0]).trigger('click');
            } else {
              $('#txtNumeroNF').val('');
              $('#txtSerieNF').val('');
              $('#txtEmissaoNF').val('');
              $('#txtProtocoloNF').val('');
              $('#txtReciboNF').val('');
              $('#txtChaveNF').val('');
            }
          }, 500);

        }
      });
      //   $('#btn-consultar').trigger('click');
      $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
        $.fn.dataTable.tables({
          visible: true,
          api: true
        }).columns.adjust();
      });

      async function validaGNRE(sFatura, sSerie) {
        if ((($('#txtChaveNF').val() != '') && ($('#txtEmissaoNF').val() != '')) && (($('#txtProtocoloNF').val() != '') || ($('#txtReciboNF').val() != ''))) {
          const url = `/sisplan/funcoes/v1/pesquisa?`;
          const json = `JSON={ "tabela":"NOTA", "camposSelect":[ "NOTA.GERAR_DIFAL", "NOTA.CONS_FINAL", "NOTA.VAL_SUBST", "EMPRESA.EMP_ESTADO", "CIDADE.COD_UF"], 
                                       "innerjoin": [{ "tabela": "EMPRESA", "condicao": "EMPRESA.EMP_ID = NOTA.EMP_ID" },
                                                     { "tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI" }], 
                                       "leftjoin": [{ "tabela": "CADCEP", "condicao": "CADCEP.CEP = ENTIDADE.CEP" },
                                                    { "tabela": "CIDADE", "condicao": " CIDADE.CODIGO = CADCEP.CODMUN" }], 
                                       "where": ["NOTA.FATURA = '${sFatura}' AND NOTA.SERIE = '${sSerie}'"] }`;
          try {
            var response = await requisicao('GET', url, json, null);

            if (!response) {
              $("#btnGNRE").attr("disabled", true);
              return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
              $("#btnGNRE").attr("disabled", true);
              return;
            }

            if ((jsonStr.RESULT[0][0].EMP_ESTADO != jsonStr.RESULT[0][0].COD_UF) &&
              ((jsonStr.RESULT[0][0].GERAR_DIFAL == 'Sim') && (jsonStr.RESULT[0][0].CONS_FINAL == 'Sim')) ||
              (jsonStr.RESULT[0][0].VAL_SUBST > 0)) {
              $("#btnGNRE").removeAttr("disabled");
            } else {
              $("#btnGNRE").attr("disabled", true);
            }
          } catch (error) {
            console.error(error);
            $("#btnGNRE").attr("disabled", true);
          }
        } else {
          $("#btnGNRE").attr("disabled", true);
        }
      };

      async function buscaFinalidade(sFatura, sSerie) {
        const pesquisaParam = {
          tabela: "NOTA",
          camposSelect: [ "NATUREZA.FINALIDADE_NFE" ],
          leftJoin: [ { tabela: 'NATUREZA', condicao: `NOTA.NATUREZA = NATUREZA.NATUREZA` } ],
          where: [`NOTA.FATURA = '${sFatura}' AND NOTA.SERIE ='${sSerie}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length == 0) {
          return;
        }

        $('#txtFinalidade').val(jsonStr[0].FINALIDADE_NFE - 1).change();
      };

      $('#btn-limpa-codigo-rastreio').on('click', function () {
        $('#txtCodigoRastreio').val('');
      });

      async function AlteraDadosNota(sFatura, sSerie, indPresenca, arrItens, sTransportadora, dtEmissao, dtSaida, sIntermed, sUfEmb, sLocalEmb, sCodigoRastreio, sMensagem, arrNotasRef, sCodcli) {
        try {
          try {
            let cons_final = '';
            let gerar_difal = '';

            if ($('#consumidorFinal').prop('checked')) {
              cons_final = 'Sim';
            } else {
              cons_final = 'Nao';
            }

            if ($('#gerarDifal').prop('checked')) {
              gerar_difal = 'Sim';
            } else {
              gerar_difal = 'Nao';
            }

            const nota = {};
            nota.fatura = estaNaArqLocal ? sFatura + getCookie('emp_id') : sFatura;
            nota.serie = sSerie;
            nota.consumidorfinal = cons_final;
            nota.gerardifal = gerar_difal;
            nota.indpresenca = indPresenca;
            nota.itens = arrItens;
            nota.transportadora = sTransportadora;
            nota.intermed = sIntermed;
            nota.dtEmissao = `${dtEmissao}T00:00:00Z`;
            nota.dtSaida = `${dtSaida}T00:00:00Z`;
            nota.uf_embarque = sUfEmb;
            nota.local_embarque = sLocalEmb;
            nota.codigo_rastreio = sCodigoRastreio;
            nota.MENSAGEM = sMensagem;
            nota.NOTASREF = arrNotasRef;
            nota.CODCLI = sCodcli;
            nota.CIF = $('#rgTransportador').val();

            const nomeEntrega = $("#dropdown").find(":selected").text();

            if (nomeEntrega == "Padrão") {
              nota.CLI_CEP = $("#enderecoPadrao").attr("data-cep");
              nota.CLI_END = $("#enderecoPadrao").attr("data-endereco");
              nota.CLI_BAIRRO = $("#enderecoPadrao").attr("data-bairro");
              nota.CLI_NUM = $("#enderecoPadrao").attr("data-numero");
              nota.CLI_COMPL = $("#enderecoPadrao").attr("data-complemento");
              nota.CLI_ENT_NOME = pegaDescricao('#txtClienteNota');
            } else if (nomeEntrega == "Entrega") {
              nota.CLI_CEP = $("#enderecoEntrega").attr("data-cep");
              nota.CLI_END = $("#enderecoEntrega").attr("data-endereco");
              nota.CLI_BAIRRO = $("#enderecoEntrega").attr("data-bairro");
              nota.CLI_NUM = $("#enderecoEntrega").attr("data-numero");
              nota.CLI_COMPL = $("#enderecoEntrega").attr("data-complemento");
              nota.CLI_ENT_NOME = pegaDescricao('#txtClienteNota');
            } else if (nomeEntrega == "Cobrança") {
              nota.CLI_CEP = $("#enderecoCobranca").attr("data-cep");
              nota.CLI_END = $("#enderecoCobranca").attr("data-endereco");
              nota.CLI_BAIRRO = $("#enderecoCobranca").attr("data-bairro");
              nota.CLI_NUM = $("#enderecoCobranca").attr("data-numero");
              nota.CLI_COMPL = $("#enderecoCobranca").attr("data-complemento");
              nota.CLI_ENT_NOME = pegaDescricao('#txtClienteNota');
            } else if (nomeEntrega == "Empresa") {
              nota.CLI_CEP = $("#enderecoEmpresa").attr("data-cep");
              nota.CLI_END = $("#enderecoEmpresa").attr("data-endereco");
              nota.CLI_BAIRRO = $("#enderecoEmpresa").attr("data-bairro");
              nota.CLI_NUM = $("#enderecoEmpresa").attr("data-numero");
              nota.CLI_COMPL = $("#enderecoEmpresa").attr("data-complemento");
              nota.CLI_ENT_NOME = getCookie('g_nome_empresa_logada').split(getCookie('empresa').replace('_', '') + ' - ')[1];
            }

            var response = await requisicao('POST', '/Sisplan/NFe/v1/AlterarNFE?',
              '', `NOTA=${encodeURIComponent(JSON.stringify(nota))}`,
              30000);

            if (!response) {
              return;
            };

            var jsonStr = await response.json();
            if (response.status != 200) {
              $.LoadingOverlay("hide");
              msgErro(jsonStr.mensagem);
              return;
            }

          } catch (error) {
            console.error(error);
          }
        } finally {
          $("#dropdown").val("").change();
          $.LoadingOverlay("hide");
        }
      }

      $('#tabelaNotas').on('click', '#btn-alterar-dados', async function() {
        try {
          try {
            event.preventDefault();
            if ($('#txtChaveNF').val() != '') {
              msgErro('Nota Fiscal transmitida, impossível alterar dados.');
              return;
            }
            $.LoadingOverlay("show");
            const tr = this.closest('tr');
            const data = $('#tabelaNotas').DataTable().row($(tr)).data();
            const fatura = estaNaArqLocal ? data[1] : $('#txtNumeroNF').val();
            $('#txtAlterarFatura').val($('#txtNumeroNF').val());
            $('#txtAlterarSerie').val(data[2]);
            const dados = await buscaDadosNota(fatura, data[2]);
            $('#consumidorFinal').prop('checked', dados["RESULT"][0][0].CONS_FINAL == 'Sim');
            $('#gerarDifal').prop('checked', dados["RESULT"][0][0].GERAR_DIFAL == 'Sim');
            $('#modal-alterar-dados').modal('show');
          } catch (error) {
            msgErro('Erro ao buscar dados da nota');
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $("#dropdown").on("change", async function() {
        const enderecoSelecionado = $(
          `#dropdown > option[value=${$(this).val()}]`
        ).prop("title");
        $(this).prop("title", enderecoSelecionado);
      });

      async function criarToolTipCliente(cliente) {
        const pesquisaParam = {
          tabela: "ENTIDADE",
          camposSelect: [
            "ENTIDADE.CEP",
            "ENTIDADE.ENDERECO",
            "ENTIDADE.BAIRRO",
            "ENTIDADE.NUMERO",
            "ENTIDADE.COMPLEMENTO",
            "ENTIDADE.CEP_ENT",
            "ENTIDADE.END_ENT",
            "ENTIDADE.BAIRRO_ENT",
            "ENTIDADE.NUM_ENT",
            "ENTIDADE.COMP_ENT",
            "ENTIDADE.CEP_COB",
            "ENTIDADE.END_COB",
            "ENTIDADE.BAIRRO_COB",
            "ENTIDADE.NUM_COB",
            "ENTIDADE.COMP_COB",
          ],
          where: [`ENTIDADE.CODCLI = '${cliente}'`],
        };
        const pesquisaEmpresaParam = {
          tabela: "EMPRESA",
          camposSelect: [
            "EMP_NUMERO",
            "EMP_BAIRRO",
            "EMP_CIDADE",
            "EMP_ENDERECO",
            "EMP_CEP",
            "EMP_ESTADO",
            "EMP_COMPL_CONT",
          ],
          where: [`EMP_ID = '${getCookie('emp_id')}'`],
        };

        const enderecoEmpresa = await retornaJsonPesquisaPadrao(
          JSON.stringify(pesquisaEmpresaParam)
        );


        const jsonStr = await retornaJsonPesquisaPadrao(
          JSON.stringify(pesquisaParam)
        );

        if (jsonStr[0].CEP == '') {
          return;
        }

        const cidade = await buscaCidade(jsonStr[0].CEP);
        const cidadeEnt = await buscaCidade(jsonStr[0].CEP_ENT);
        const cidadeCob = await buscaCidade(jsonStr[0].CEP_COB);

        $(`#enderecoPadrao`).attr("data-cep", jsonStr[0].CEP);
        $(`#enderecoPadrao`).attr("data-endereco", jsonStr[0].ENDERECO);
        $(`#enderecoPadrao`).attr("data-bairro", jsonStr[0].BAIRRO);
        $(`#enderecoPadrao`).attr("data-numero", jsonStr[0].NUMERO);
        $(`#enderecoPadrao`).attr("data-cidade", cidade.NOME);
        $(`#enderecoPadrao`).attr("data-cod_uf", cidade.COD_UF);
        $(`#enderecoPadrao`).attr("data-complemento", jsonStr[0].COMPLEMENTO);

        $(`#enderecoEntrega`).attr("data-cep", jsonStr[0].CEP_ENT);
        $(`#enderecoEntrega`).attr("data-endereco", jsonStr[0].END_ENT);
        $(`#enderecoEntrega`).attr("data-bairro", jsonStr[0].BAIRRO_ENT);
        $(`#enderecoEntrega`).attr("data-numero", jsonStr[0].NUM_ENT);
        $(`#enderecoEntrega`).attr("data-cidade", cidadeEnt.NOME);
        $(`#enderecoEntrega`).attr("data-cod_uf", cidadeEnt.COD_UF);
        $(`#enderecoEntrega`).attr("data-complemento", jsonStr[0].COMP_ENT);

        $(`#enderecoCobranca`).attr("data-cep", jsonStr[0].CEP_COB);
        $(`#enderecoCobranca`).attr("data-endereco", jsonStr[0].END_COB);
        $(`#enderecoCobranca`).attr("data-bairro", jsonStr[0].BAIRRO_COB);
        $(`#enderecoCobranca`).attr("data-numero", jsonStr[0].NUM_COB);
        $(`#enderecoCobranca`).attr("data-cidade", cidadeCob.NOME);
        $(`#enderecoCobranca`).attr("data-cod_uf", cidadeCob.COD_UF);
        $(`#enderecoCobranca`).attr("data-complemento", jsonStr[0].COMP_COB);

        $(`#enderecoEmpresa`).attr("data-cep", enderecoEmpresa[0].EMP_CEP);
        $(`#enderecoEmpresa`).attr("data-endereco", enderecoEmpresa[0].EMP_ENDERECO);
        $(`#enderecoEmpresa`).attr("data-bairro", enderecoEmpresa[0].EMP_BAIRRO);
        $(`#enderecoEmpresa`).attr("data-numero", enderecoEmpresa[0].EMP_NUMERO);
        $(`#enderecoEmpresa`).attr("data-cidade", enderecoEmpresa[0].EMP_CIDADE);
        $(`#enderecoEmpresa`).attr("data-cod_uf", enderecoEmpresa[0].EMP_ESTADO);
        $(`#enderecoEmpresa`).attr("data-complemento", enderecoEmpresa[0].EMP_COMPL_CONT);

        $(`#enderecoPadrao`).prop(
          "title",
          `CEP: ${jsonStr[0].CEP} \n` +
          `ENDEREÇO: ${jsonStr[0].ENDERECO} \n` +
          `BAIRRO: ${jsonStr[0].BAIRRO} \n` +
          `NUMERO: ${jsonStr[0].NUMERO} \n` +
          `CIDADE: ${cidade.NOME} \n` +
          `UF: ${cidade.COD_UF} \n` +
          `COMPLEMENTO: ${jsonStr[0].COMPLEMENTO}`
        );
        $(`#enderecoEntrega`).prop(
          "title",
          `CEP: ${jsonStr[0].CEP_ENT} \n` +
          `ENDEREÇO: ${jsonStr[0].END_ENT} \n` +
          `BAIRRO: ${jsonStr[0].BAIRRO_ENT} \n` +
          `NUMERO: ${jsonStr[0].NUM_ENT} \n` +
          `CIDADE: ${cidadeEnt.NOME} \n` +
          `UF: ${cidadeEnt.COD_UF} \n` +
          `COMPLEMENTO: ${jsonStr[0].COMP_ENT}`
        );
        $(`#enderecoCobranca`).prop(
          "title",
          `CEP: ${jsonStr[0].CEP_COB} \n` +
          `ENDEREÇO: ${jsonStr[0].END_COB} \n` +
          `BAIRRO: ${jsonStr[0].BAIRRO_COB} \n` +
          `NUMERO: ${jsonStr[0].NUM_COB} \n` +
          `CIDADE: ${cidadeCob.NOME} \n` +
          `UF: ${cidadeCob.COD_UF} \n` +
          `COMPLEMENTO: ${jsonStr[0].COMP_COB}`
        );

        $(`#enderecoEmpresa`).prop(
          "title",
          `CEP: ${enderecoEmpresa[0].EMP_CEP} \n` +
          `ENDEREÇO: ${enderecoEmpresa[0].EMP_ENDERECO} \n` +
          `BAIRRO: ${enderecoEmpresa[0].EMP_BAIRRO} \n` +
          `NUMERO: ${enderecoEmpresa[0].EMP_NUMERO} \n` +
          `CIDADE: ${enderecoEmpresa[0].EMP_CIDADE} \n` +
          `UF: ${enderecoEmpresa[0].EMP_ESTADO} \n` +
          `COMPLEMENTO: ${enderecoEmpresa[0].EMP_COMPL_CONT}`
        );
      };

      async function buscaCidade(cep) {
        const pesquisaCodMun = {
          tabela: "CADCEP",
          camposSelect: ["CADCEP.CODMUN"],
          where: [`CADCEP.CEP = '${cep}'`],
        };

        const getCodMun = await retornaJsonPesquisaPadrao(
          JSON.stringify(pesquisaCodMun)
        );

        const pesquisaCidade = {
          tabela: "CIDADE",
          camposSelect: ["CIDADE.NOME, CIDADE.COD_UF"],
          where: [`CIDADE.CODIGO = '${getCodMun[0].CODMUN}'`],
        };

        const getCidade = await retornaJsonPesquisaPadrao(
          JSON.stringify(pesquisaCidade)
        );
        return getCidade[0];
      };

      $('#tabelaNotas').on('click', '#btn-mostrar-itens', async function() {
        try {
          event.preventDefault();
          $.LoadingOverlay("show");
          var tr = this.closest('tr');
          var data = $('#tabelaNotas').DataTable().row($(tr)).data();
          const fatura = estaNaArqLocal ? data[1] : $('#txtNumeroNF').val();
          var dados = await buscaItens(fatura, data[2]);
          $('#txtNotaItens').val($('#txtNumeroNF').val());
          $('#txtSerieItens').val(data[2]);
          $('#modal-itens-title').html('Dados da nota: ' + fatura);
          $("#modal-itens").prop("fatura", fatura);
          var dataSetCols = [];
          var keys = Object.keys(dados["RESULT"][0][0]);
          for (var k in keys) {
            dataSetCols.push({
              'title': keys[k],
              'data': keys[k]
            });

            $('#dtEmissao').val('');
            $('#dtSaida').val('');
            $('#txtAlteraTransportadora').val('');
            $('#txtAlteraIntermed').val('');
            $('#rgPresenca').val('');
          }
          var array_colunas_invisiveis = [9];
          var dadosEmpresa = await retornaInformacaoEmpresa()
          if (dadosEmpresa.EMP_CRT != 1) {
            array_colunas_invisiveis = [9, 12]
          } else {
            array_colunas_invisiveis = [9, 11]
          }

          // "notaiten.natureza", "notaiten.ordem", "notaiten.cla_fis", "notaiten.cla_trib","notaiten.cla_ipi", "notaiten.cla_pis", "notaiten.cla_cofins", "notaiten.cla_csosn"
          dataSetCols[8].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="Natureza" id="natureza_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoNatureza" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[10].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="NCM" id="ncm_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoNCM" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[11].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="CST ICMS" id="icms_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoCSTICMS" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[12].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="CSOSN" id="csosn_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoCSOSN" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[13].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="CST IPI" id="ipi_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoCSTIPI" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[14].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="CST PIS" id="pis_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoCSTPIS" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[15].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="CST COFINS" id="cofins_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoCSTCOFINS" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          dataSetCols[16].render = function(data, type, row, meta) {
            return '<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input type="text" placeholder="Enquadra. IPI" id="enquadra_col_' + [meta.row] + '_row_' + [meta.col] +
              '" readonly class="input-default focus form-control validate campoEnquadra" value="' +
              data + '"> ' +
              '</div>' +
              '</div>';
          }

          let decimais = parseInt(await CopiaParametro("SISTEMA", 1)) + 2;
          if (isNaN(decimais)) {
            decimais = 2;
          }

          tabelaItens = $('#tabelaItens').DataTable({
            paging: false,
            filter: false,
            info: true,
            order: true,
            destroy: true,
            "language": {
              "sEmptyTable": "Nenhum registro encontrado",
              "sInfo": "_TOTAL_ registros",
              "sInfoEmpty": " 0 registros",
              "sInfoFiltered": "(Filtrados de _MAX_ registros)",
              "sInfoPostFix": "",
              "sInfoThousands": ".",
              "sLengthMenu": "_MENU_ resultados",
              "sLoadingRecords": "Carregando...",
              "sProcessing": "Processando...",
              "sZeroRecords": "Nenhum registro encontrado",
              "sSearch": "Pesquisar",
              "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
              },
              "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
              }
            },
            "data": dados["RESULT"][0],
            "columns": dataSetCols,
            "columnDefs": [{
                "targets": array_colunas_invisiveis,
                "visible": false
              },
              {
                render(data) {
                  return parseFloat(data).toLocaleString("pt-br", {
                    style: "currency",
                    currency: "BRL"
                  });
                },
                targets: [7],
                "className": 'pr-4 text-right'
              },
              {
                render(data) {
                  return parseFloat(data).toLocaleString("pt-br", {
                    style: "currency",
                    currency: "BRL",
                    maximumFractionDigits: decimais,
                    minimumFractionDigits: decimais
                  });
                },
                targets: [6],
                "className": 'pr-4 text-right'
              },
              {
                targets: [5],
                "className": 'pr-4 text-right'
              }
            ],
          });

          if ($('#txtProtocoloNF').val() == '') {
            for (let i = 0; i < $('.campoNatureza').length; i++) {
              $('#natureza_col_' + i + '_row_8').pesquisa('#natureza_col_' + i + '_row_8', 'NATUREZA',
                'NATUREZA',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":["natureza"], "where": ["tipo = ${"'V'"} and tp_base = '1'"]}`,
                'Pesquisa Natureza', 'natureza', 'S');
            }

            for (let i = 0; i < $('.campoNCM').length; i++) {
              $('#ncm_col_' + i + '_row_10').pesquisa('#ncm_col_' + i + '_row_10', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabfis", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa NCM', 'TABFIS', 'S');
            }

            for (let i = 0; i < $('.campoCSTICMS').length; i++) {
              $('#icms_col_' + i + '_row_11').pesquisa('#icms_col_' + i + '_row_11', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtri", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa CST ICMS', 'tabtri', 'S');
            }

            for (let i = 0; i < $('.campoCSOSN').length; i++) {
              $('#csosn_col_' + i + '_row_12').pesquisa('#csosn_col_' + i + '_row_12', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabcsosn", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa CSOSN', 'tabcsosn', 'S');
            }

            for (let i = 0; i < $('.campoCSTIPI').length; i++) {
              $('#ipi_col_' + i + '_row_13').pesquisa('#ipi_col_' + i + '_row_13', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabipi", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa CST IPI', 'tabipi', 'S');
            }

            for (let i = 0; i < $('.campoCSTPIS').length; i++) {
              $('#pis_col_' + i + '_row_14').pesquisa('#pis_col_' + i + '_row_14', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabpis", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa CST PIS', 'tabpis', 'S');
            }

            for (let i = 0; i < $('.campoCSTCOFINS').length; i++) {
              $('#cofins_col_' + i + '_row_15').pesquisa('#cofins_col_' + i + '_row_15', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabcofins", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa CST COFINS', 'tabcofins', 'S');
            }

            for (let i = 0; i < $('.campoEnquadra').length; i++) {
              $('#enquadra_col_' + i + '_row_16').pesquisa('#enquadra_col_' + i + '_row_16', 'CODIGO',
                'CODIGO',
                `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"enquadra", "camposSelect":["codigo", "descricao"]}`,
                'Pesquisa Enquadramento', 'enquadra', 'S');
            }
          }
          $('#txtAlterarFatura').val($('#txtNumeroNF').val());
          $('#txtAlterarSerie').val(data[2]);
          insereValor('#txtClienteNota', data[4], data[5]);
          const dadosNota = await buscaDadosNota(fatura, data[2]);
          insereValor('#txtEmbarque', dadosNota.RESULT[0][0].UF_EMBARQUE, dadosNota.RESULT[0][0].LOCAL_EMBARQUE);
          insereValor('#txtAlteraTransportadora', dadosNota.RESULT[0][0].TRANSPORT, dadosNota.RESULT[0][0].NOME);
          insereValor('#txtAlteraIntermed', dadosNota.RESULT[0][0].INTERMED, dadosNota.RESULT[0][0].NOME_INTERMED);
          $('#dtEmissao').val(moment(dadosNota.RESULT[0][0].DT_EMISSAO).format('YYYY-MM-DD'));
          $('#dtSaida').val(moment(dadosNota.RESULT[0][0].DT_SAIDA).format('YYYY-MM-DD'));
          $('#consumidorFinal').prop('checked', dadosNota["RESULT"][0][0].CONS_FINAL == 'Sim');
          $('#gerarDifal').prop('checked', dadosNota["RESULT"][0][0].GERAR_DIFAL == 'Sim');
          $('#rgPresenca').val(dadosNota["RESULT"][0][0].IND_PRES).change();
          $('#rgTransportador').val(dadosNota["RESULT"][0][0].CIF).change();
          $('#txtCodigoRastreio').val(dadosNota.RESULT[0][0].COD_RASTREIO);
          $("#txtCodigoRastreio").prop("codigo-old", dadosNota.RESULT[0][0].COD_RASTREIO);
          $('#txtDados').val(dadosNota.RESULT[0][0].MENSAGEM);
          await criarToolTipCliente(data[4]);
          if ($("#txtProtocoloNF").val() != "") {
            ajustaCamposModalItens(true);
          } else {
            ajustaCamposModalItens(false);
          }
          $("#dropdown").trigger("change");
          $("#dropdown").val("").change();
          $('#modal-itens').modal('show');

          $("#tabelaNotasRef").DataTable().clear().draw();
          const notasRef = await buscaNotasRef(fatura, data[2]);
          notasRef.map(nota => {
            $("#tabelaNotasRef").DataTable().row.add([
                nota.NOTA_REF,
                nota.SERIE_REF,
                nota.CODCLI_REF,
                nota.DATA_REF != '' ? `${nota.DATA_REF.split('-')[2]}/${nota.DATA_REF.split('-')[1]}/${nota.DATA_REF.split('-')[0]}` : '30/12/1899',
                nota.IND_OPER,
                nota.IND_EMIT,
                nota.TIPO_FISCAL_REF,
                nota.COD_REF,
                nota.PESO,
                nota.VALOR,
                parseFloat(data[6]).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }),
                nota.NUM_COO,
                nota.SEQ_ECF,
                retornaBotaoExcluirNota(),
                nota.CHAVE_NFE
              ]).draw(false);
          });

        } finally {
          $.LoadingOverlay("hide");
        }
        $('#tabItens').trigger('click');
      });

      $('#btn-consultar').trigger('click');


      $('#btnVisualizar').on('click', async function() {
        if ($("#dropdownVisualizar")[0].classList[1] != "show") {
          $('#dropdownVisualizar').addClass("show");
        } else {
          $('#dropdownVisualizar').removeClass("show");
        }
      });

      $("#btnVisualizarXML").on("click", async function() {
          $.LoadingOverlay("show");
          const faturaNFE = $("#txtNumeroNF").val();
          const chaveNFE = $("#txtChaveNF").val();
          const protocoloNFE = $("#txtProtocoloNF").val();
        try {
          
          if (faturaNFE == "") {
            msgAlerta("Nenhuma nota selecionada, para realizar a ação é necessário selecionar uma nota.");
            return;
          }
          
          if (chaveNFE == "") {
            msgAlerta("Nota selecionada não possui chave, verifique.");
            return;
          }

          if (protocoloNFE == "") {
            msgAlerta("Nota fiscal não transmitida, deseja visualizar o pré XML?", async () => { await visualizarXML(chaveNFE) });
          } else {
            await visualizarXML(chaveNFE, protocoloNFE);
          }

        } finally {
          $.LoadingOverlay("hide");
          $('#dropdownVisualizar').removeClass("show");
        }
      })

      $("#btnBaixarXML").on("click", async function() {
        $.LoadingOverlay("show");
        const faturaNFE = $("#txtNumeroNF").val();
        const chaveNFE = $("#txtChaveNF").val();
        const protocoloNFE = $("#txtProtocoloNF").val();
        try {
          if (faturaNFE == "") {
            msgAlerta("Nenhuma nota selecionada, para realizar a ação é necessário selecionar uma nota.");
            return;
          }

          if (chaveNFE == "") {
            msgAlerta("Nota selecionada não possui chave, verifique.");
            return;
          }

          if (protocoloNFE == "") {
            msgAlerta("Nota fiscal não transmitida, deseja baixar o pré XML?", async () => { await baixarXML(chaveNFE) });
          } else {
            await baixarXML(chaveNFE, protocoloNFE);
          }

        } finally {
          $.LoadingOverlay("hide");
          $('#dropdownVisualizar').removeClass("show");
        }
      })

      async function visualizarXML(chave, protocolo = "") {
        try {
          const url = '/sisplan/nfe/v1/visualizarxml?';
          const params = `CHAVE_NFE=${chave}&PROTOCOLO=${protocolo}`;
          const response = await requisicao('GET', url, params, '', 180000);

          if (!response) {
            msgAlerta("Não foi possível realizar a ação.");
            return;
          }

          if (response.status != 200) {
            const jsonStr = await response.json();
            msgAlerta(jsonStr.mensagem);
            return;
          }

          window.open(`${BASE_URI}/XMLtemp/XMLVisualizar.xml`, "_blank");

        } catch (error) {
          console.log(error);
        }
      }

      async function baixarXML(chave, protocolo = "") {
        try {
          const url = '/sisplan/nfe/v1/retornaXML?';
          const params = `CHAVE_NFE=${chave}&PROTOCOLO=${protocolo}`;
          const response = await requisicao('GET', url, params, '', 180000);

          if (!response) {
            msgAlerta("Não foi possível realizar a ação.");
            return;
          }

          if (response.status != 200) {
            const jsonStr = await response.json();
            msgAlerta(jsonStr.mensagem);
            return;
          }

          const xml = await response.text();

          if (xml != '') {
            const file = new Blob([xml], {type: "text/xml"});
            const fileName = `NFe${chave}.xml`;
            saveAs(file, fileName);
          } else {
            msgAlerta('XML não encontrado!');
            return;
          }

        } catch (error) {
          console.log(error);
        }
      }

      function ajustaCamposModalItens(bloqueia) {
        $(".campoNatureza").prop("disabled", bloqueia);
        $(".campoNCM").prop("disabled", bloqueia);
        $(".campoCSTICMS").prop("disabled", bloqueia);
        $(".campoCSTIPI").prop("disabled", bloqueia);
        $(".campoCSTPIS").prop("disabled", bloqueia);
        $(".campoCSTCOFINS").prop("disabled", bloqueia);
        $(".campoEnquadra").prop("disabled", bloqueia);
        $("#dtEmissao").prop("disabled", bloqueia);
        $("#dtSaida").prop("disabled", bloqueia);
        $("#rgPresenca").prop("disabled", bloqueia);
        $("#txtAlteraTransportadora").prop("disabled", bloqueia);
        $("#btn-transportadora-filtro").prop("disabled", bloqueia);
        $("#btn-limpa-transportadora").prop("disabled", bloqueia);
        $("#dropdown").prop("disabled", bloqueia);
        $("#txtAlteraIntermed").prop("disabled", bloqueia);
        $("#btn-Intermed-filtro").prop("disabled", bloqueia);
        $("#btn-limpa-Intermed").prop("disabled", bloqueia);
        $("#txtEmbarque").prop("disabled", bloqueia);
        $("#btn-Embarque").prop("disabled", bloqueia);
        $("#btn-limpa-Embarque").prop("disabled", bloqueia);
        $("#consumidorFinal").prop("disabled", bloqueia);
        $("#gerarDifal").prop("disabled", bloqueia);
        $("#txtDados").prop("disabled", bloqueia);
        $("#rgTransportador").prop("disabled", bloqueia);
      }

      async function atualizaCodigoRastreio(codigoRastreio, fatura, serie) {
          const url = '/sisplan/nfe/v1/atualizacodigorastreio?';
          const params = `CODIGO_RASTREIO=${codigoRastreio}&FATURA=${fatura}&SERIE=${serie}&EMP_ID=${getCookie('emp_id')}`;
          const response = await requisicao('PUT', url, params, '', 120000);

        if (!response) {
          msgAlerta("Não foi possível atualizar o código de ratreio, tente novamente!");
          return;
        }

        if (response.status != 200) {
          msgAlerta("Não foi possível atualizar o código de ratreio, tente novamente!");
          return;
        }

        $("#txtCodigoRastreio").prop("codigo-old", codigoRastreio);
        criaMensagemSucesso("Código de rastreio atualizado com sucesso!");

      }

    });
  </script>

</body>

</html>