$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoGrupoMaterial',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um grupo.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaGrupoProduto',
                popover: {
                    title: 'Tabela Grupos',
                    description: 'Aqui estão os dados dos Grupos cadastrados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("FACLANCA");

    componenteFiltro('produto', false, false);
    componenteFiltro('cliente', false, false, 'Entidade');
    componenteFiltro('setor', false, false);

    $('#btnConsultar').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            await buscaDados();
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    })

    async function buscaDados() {
        try {
            let filtros = await retornaFiltros();

            const response = await requisicao('GET', '/sisplan/faclanca/v1/buscadados?', `JSON=${encodeURIComponent(JSON.stringify(filtros))}`, '', 600000);
            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            criaTabela(jsonStr);

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }

    async function retornaFiltros() {
        return {
            LANCTO_DE: $('#dtLancamentoDe').val(),
            LANCTO_ATE: $('#dtLancamentoAte').val(),
            VENCTO_DE: $('#dtVencimentoAte').val(),
            VENCTO_ATE: $('#dtVencimentoAte').val(),
            PAGTO_DE: $('#dtPagamentoAte').val(),
            PAGTO_ATE: $('#dtPagamentoAte').val(),
            PAGOS: $('[name="rdPagos"]:checked').val(),
            PRODUTO: pegaChave($('#txtProduto')),
            TERCEIRO: pegaChave($('#txtEntidade')),
            SETOR: pegaChave($('#txtSetor')),
            OBS: $('#txtObs').val(),
            DESCRICAO: $('#txtDescricao').val(),
            LANCTO: $('#txtLancamento').val(),
            NUMERO: $('#txtNumero').val()
        }
    }

    function criaTabela(data) {
        if ($.fn.DataTable.isDataTable('#tabelaDados')) {
            $('#tabelaDados').DataTable().destroy();
            $('#tabelaDados').empty();
        }

        let cols = [{
            data: 'LANCAMENTO',
            title: 'Lançamento'
        },
        {
            data: 'NUMERO',
            title: 'Número'
        },
        {
            data: 'SETOR',
            title: 'Setor'
        },
        {
            data: 'DESC_SETOR',
            title: 'Desc. Setor'
        },
        {
            data: 'CODIGO',
            title: 'Código'
        },
        {
            data: 'DESCRICAO',
            title: 'Descrição'
        },
        {
            data: 'CODCLI',
            title: 'Codcli'
        },
        {
            data: 'NOME',
            title: 'Nome'
        },
        {
            data: 'QUANT',
            title: 'Quant'
        },
        {
            data: 'PRECO',
            title: 'Preço'
        },
        {
            data: 'VALOR',
            title: 'Valor'
        },
        {
            data: 'DT_LAN',
            title: 'Lançamento'
        },
        {
            data: 'DT_PAGO',
            title: 'Pagamento'
        },
        {
            data: 'PAGO',
            title: 'Pago'
        },
        {
            data: 'OBS',
            title: 'Obs'
        },
        {
            data: 'DT_INI',
            title: 'Data Ini'
        },
        {
            data: 'DT_FIM',
            title: 'Data Fim'
        }];

        $("#tabelaDados").DataTable({
            order: false,
            sort: true,
            paging: true,
            destroy: true,
            lengthChange: true,
            searching: true,
            info: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            data: data,
            columns: cols,
            columnDefs: [
                {
                    targets: [0],
                    render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                },
                {
                    targets: [9, 10],
                    render: function (data) {
                        if (!data) {
                            return '0,00'
                        }                        
                        return parseFloat(data).toLocaleString("pt-br", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2,
                        });
                    },
                },
                {
                    targets: [11, 12],
                    type: "date-br",
                    render(data) {
                        if (!data) {
                            return '';
                        }
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                },
            ]
        });

        $('#modal-filtros').modal('hide');
    }

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '       <button class="dropdown-item" id="btn-alterar">Alterar</button> ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button> ' +
            '       <button class="dropdown-item" id="btn-duplicar">Duplicar</button> ' +
            '</div>';
        return retorno;
    }

    $('#tabelaDados').on('click', '#btn-alterar', function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
                window.location.href = `faclanca/${data.LANCAMENTO}`;
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaDados').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Tem certeza que deseja excluir esse registro?', () => { }, () => { }, async () => {
                let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(linha) {
        $.LoadingOverlay('show');
        try {
            try {
                let response = await requisicao("DELETE", "/sisplan/faclanca/v1/excluir?", `&LANCTO=${linha.LANCAMENTO}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
            } catch (e) {
                msgErro(`Não foi possível excluir o registro: ${e}`);
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    $('#btnIncluir').on('click', function () {
        $.LoadingOverlay('show');
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                $.LoadingOverlay('show');
                try {
                    window.location.href = `faclanca/create`;
                } finally {
                    $.LoadingOverlay('hide');
                }
            } else {
                msgAlertaSemConfirmacao("Sem permissão para incluir!");
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

});