$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros..",
          position: "right",
        },
      },
      {
        element: "#btnNovaExp",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar uma expedição.",
          position: "right",
        },
      },
      {
        element: "#tabelaClientesForne",
        popover: {
          title: "Tabela Caixas",
          description: "Aqui estão as caixas expedidas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {

  await setarDataAtual('txtDataIni', 1);

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });


  $('#txtCaixa').on('change', async function () {
    let caixa = $('#txtCaixa').val();

    if (caixa == '') {
      return;
    }

    if (pegaChave('#txtCaixa').length > 1) {
      caixa = pegaChave('#txtCaixa');
    }

    const pesquisaParam = {
      tabela: 'PEDIDO3',
      camposSelect: ['PEDIDO3.CAIXA', 'ENTIDADE.NOME'],
      leftJoin: [
        { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PEDIDO3.NUMERO' },
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }
      ],
      where: [`PEDIDO3.CAIXA = '${caixa}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum pedido encontrado');
      $('#txtCaixa').val('');
      $('#txtCaixa').focus();
    }

    insereValor('#txtCaixa', caixa, jsonStr[0].NOME);
  });


  $('#btnCaixa').pesquisa_serverside(
    ['#txtCaixa'],
    ['PEDIDO3.CAIXA'],
    ['ENTIDADE.NOME'],
    `{
      "tabela":"PEDIDO3", 
      "camposSelect":["PEDIDO3.CAIXA", "ENTIDADE.NOME"], 
      "leftjoin": [
        {"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"},
        {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
      ],
      "groupby": ["PEDIDO3.CAIXA", "ENTIDADE.NOME"]
    }`,
    'Pesquisa Caixa'
  );

  $('#btnACaixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#txtPedido').on('change', async function () {
    let pedido = $('#txtPedido').val();

    if (pedido == '') {
      return;
    }

    if (pegaChave('#txtPedido').length > 1) {
      pedido = pegaChave('#txtPedido');
    }

    const pesquisaParam = {
      tabela: 'PEDIDO',
      camposSelect: ['ENTIDADE.NOME'],
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }],
      where: [`PEDIDO.NUMERO = '${pedido}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum pedido encontrado');
      $('#txtPedido').val('');
      $('#txtPedido').focus();
    }

    insereValor('#txtPedido', pedido, jsonStr[0].NOME);
  });

  $('#btnPedido').pesquisa_serverside(
    ['#txtPedido'],
    ['PEDIDO3.NUMERO'],
    ['ENTIDADE.NOME'],
    `{
    "tabela":"PEDIDO3", 
    "camposSelect":["PEDIDO3.NUMERO", "ENTIDADE.NOME"], 
    "leftjoin": [
      {"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"},
      {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
    ],
    "groupby": ["PEDIDO3.NUMERO", "ENTIDADE.NOME"]
  }`,
    'Pesquisa Pedido'
  );

  $('#btnAPedido').on('click', function () {
    $('#txtPedido').val('');
  });


  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>       ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '   </div>'
    );
  }

  await consultaExp();

  $("#btnConsultar").on("click", async function () {
    await consultaExp();
    $("#modal-filtros").modal("hide");
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtCaixa').val('');
    $('#txtPedido').val('');
    $('#txtDataIni').val('');
  });

  async function consultaExp() {
    $.LoadingOverlay('show');
    try {
      let params = '1 = 1';
      params += pegaChave('#txtCaixa') != '' ? ` AND PEDIDO3.CAIXA = '${pegaChave('#txtCaixa')}'` : '';
      params += pegaChave('#txtPedido') != '' ? ` AND PEDIDO3.NUMERO = '${pegaChave('#txtPedido')}'` : '';
      params += $('#txtDataIni').val() != '' ? ` AND PEDIDO3.DATA >= '${$('#txtDataIni').val()}'` : '';

      $('#tabelaExpedidos').DataTable({
        destroy: true,
        info: false,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{
              "tabela":"PEDIDO3", 
              "camposSelect":["PEDIDO3.CAIXA", "ENTIDADE.NOME"], 
              "leftjoin": [
                {"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"},
                {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
              ],
              "groupby": ["PEDIDO3.CAIXA", "ENTIDADE.NOME"],
              "where": ["${params}"]
            }`
          },
        },
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        columnDefs: [
          {
            targets: -1,
            data: null,
            className: 'tdBtnOpcoes',
            defaultContent: retornaBotaoOpcoes(),
          },
        ],
      });
      $("input[type='search']").focus();
      $.LoadingOverlay('hide');
    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    }
  };

  $('#tabelaExpedidos').on('click', '#btn-editar', async function () {
    const data = $('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data();

    if (await validaCaixa(data[0])) {
      msgAlerta('Expedição possui reserva ou quantidade total já faturada, impossível editar.\nDeseja visualizar a caixa?', () => { window.location.href = `expedicao_mat/${btoa([data[0], false])}` });
      return;
    } else {
      window.location.href = `expedicao_mat/${btoa([data[0], true])}`;
    }
  });

  $("#tabelaExpedidos").on("dblclick", "tr", async function () {
    const data = $('#tabelaExpedidos').DataTable().row($(this)).data();

    if (await validaCaixa(data[0])) {
      msgAlerta('Expedição possui reserva ou quantidade total já faturada, impossível editar.\nDeseja visualizar a caixa?', () => { window.location.href = `expedicao_mat/${btoa([data[0], false])}` });
      return;
    } else {
      window.location.href = `expedicao_mat/${btoa([data[0], true])}`;
    }
  });

  $('#tabelaExpedidos').on('click', '#btn-excluir', async function () {

    const data = $('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data();
    if (await validaCaixaFaturada(data[0])) {
      msgAlerta('Caixa já faturada, impossível excluir.');
      return;
    }

    msgAlerta('Você realmente deseja excluir essa expedição?', async () => {
      await excluiRegistro(data[0]);
    });
  });

  async function validaCaixa(sCaixa) {
    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: ['ID_RESERVA', 'QTDE'],
        where: [`CAIXA = '${sCaixa}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      let total = 0;

      jsonStr.map((item) => {
        total += item.QTDE
      });

      if (jsonStr[0].ID_RESERVA > 0) {
        return true;
      }
      if (total == 0) {
        return true;
      }
      return false;

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function excluiRegistro(sCaixa) {

    const response = await requisicao('DELETE', '/expedicao?', `CAIXA=${sCaixa}`);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.mensagem.mensagem);
      return;
    }

    criaMensagemSucesso('Expedição excluída com sucesso.', () => { window.location.reload(); });
  };

  async function validaCaixaFaturada(sCaixa) {
    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: ['QTDE_F'],
        where: [`CAIXA = '${sCaixa}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      let total = 0;

      jsonStr.map((item) => {
        total += item.QTDE_F
      });

      if (total > 0) {
        return true;
      }
      return false;
    } finally {
      $.LoadingOverlay('hide');
    }
  }

});
