$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta das posições.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma posição.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir os dados.",
          position: "top",
        },
      },
      {
        element: "#tabelaDados",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das posições.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ESCENVIO");
  setaDatasMes();

  function setaDatasMes() {
    const { primeiroDia, ultimoDia } = pegaPrimeiroEUltimoDia();
    $('#dtEmissaoDe').val(primeiroDia);
    $('#dtEmissaoAte').val(ultimoDia);
  }

  function pegaPrimeiroEUltimoDia() {
    const hoje = new Date();
    const primeiroDia = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
    const ultimoDia = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);

    const formatDate = (date) => {
      const ano = date.getFullYear();
      const mes = String(date.getMonth() + 1).padStart(2, '0');
      const dia = String(date.getDate()).padStart(2, '0');
      return `${ano}-${mes}-${dia}`;
    };

    return {
      primeiroDia: formatDate(primeiroDia),
      ultimoDia: formatDate(ultimoDia)
    };
  }
  componenteFiltro('conta', true);
  componenteFiltro('fatura', true);
  componenteFiltro('cliente', true);
  componenteFiltro('endosso', true);
  componenteFiltro('cidade', true);
  componenteFiltro('moeda', true);
  componenteFiltro('grupoCli', true);

  $('#txtBordero').autocompleta(1, `JSON={ "tabela":"BORDERO", "camposSelect":[ "CARTEIRA CHAVE", "CONTA DESCRICAO"], "where": null}`);
  $('#btnBordero').pesquisa_serverside(['#txtBordero'], ['NUMERO'], ['CONTA'], '{"tabela":"BORDERO", "camposSelect":[ "NUMERO", "CARTEIRA", "CONTA"], "where": null}', 'Pesquisa de Bordero');
  $('#btnLimpaBordero').on('click', function () {
    $('#txtBordero').val('');
  });
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
  $('#btnBanco').pesquisa_serverside(['#txtBanco'], ['BANCO'], ['NOME_BANCO'], '{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"], "where": null}', 'Pesquisa de Banco');
  $('#btnLimpaBanco').on('click', function () {
    $('#txtBanco').val('');
  });
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnRepresentante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'REPRESEN');
  $('#btnLimpaRepresentante').on('click', function () {
    $('#txtRepresentante').val('');
  });
  $('#txtClasseGerencial').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnClasseGerencial').pesquisa('#txtClasseGerencial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
  $('#btnLimpaClasseGerencial').on('click', function () {
    $('#txtClasseGerencial').val('');
  });
  $('#txtUF').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnUF').pesquisa('#txtUF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa UF', 'UF');
  $('#btnLimpaUF').on('click', function () {
    $('#txtUF').val('');
  });
  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  //MODAL RECOMPRA
  $('#txtClasseGerencialRecompra').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnClasseGerencialRecompra').pesquisa('#txtClasseGerencialRecompra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
  $('#btnLimpaClasseGerencialRecompra').on('click', function () {
    $('#txtClasseGerencialRecompra').val('');
  });
  $('#txtContaDebito').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "AGENCIA CHAVE", "CONTA DESCRICAO"], "where": null}`);
  $('#btnContaDebito').pesquisa_serverside(['#txtContaDebito'], ['CONTA'], ['AGENCIA'], '{"tabela":"CADCONTA", "camposSelect":[ "AGENCIA", "CONTA", "BANCO"], "where": null}', 'Pesquisa de Conta');
  $('#btnLimpaContaDebito').on('click', function () {
    $('#txtContaDebito').val('');
  });
  $('#txtFornecedor').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnFornecedor').pesquisa_serverside(['#txtFornecedor'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": ["TIPO_ENTIDADE LIKE '[PERCENTUAL]F[PERCENTUAL]'"]}`, 'Pesquisa de Fornecedor');
  $('#btnLimpaFornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });

  limparFiltros(true);

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      // '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Recompra Título" id="btnRecompra">Recompra Título</button>     ' +
      '</div>';
    return retorno;
  };

  await buscaDados();

  $("#btnConsultar").on("click", async function () {
    await buscaDados();
    $("#modal-filtros").modal("hide");
  });

  $('#modalRecompraTitulo').on('show.bs.modal', function () {
    $('#txtValorJuros').attr('disabled', true);
    $('#dtCont').val(formataData(new Date()));

    $('#txtValorDiferencial').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
    $('#txtValorAntecipacao').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
    $('#txtValorJuros').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
    $('#txtValorSaldo').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });
  })

  $('#txtValorDe').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtValorAte').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#btnLimparFiltros').on('click', function () {
    setaDatasMes();
    $('#txtValorDe').val('0.0');
    $('#txtValorAte').val('0.0');
  });

  function calculaValorDiferencial() {
    const valorSaldo = TruncaDecimaisNova(2, $('#txtValorSaldo').val());
    const valorAntecipacao = $('#txtValorAntecipacao').val();
    const total = (valorSaldo - valorAntecipacao);

    $('#txtValorDiferencial').val(TruncaDecimaisNova(2, total));
  }

  $('#txtValorAntecipacao').on('blur', function () {
    calculaValorDiferencial();
  });

  async function buscaDadosCampos() {
    let rgTipo = $('#cbLoja').is(':checked') ? 0 : $('#cbAllDupl').is(':checked') ? 1 : $('#cbAllDuplLoja').is(':checked') ? 2 : 0;
    let rgBordero = $('#cbTodos').is(':checked') ? 0 : $('#cbSemBordero').is(':checked') ? 1 : $('#cbComNrBanco').is(':checked') ? 2 : 0;
    let rgStatusDupl = $('#cbDuplicata').is(':checked') ? 0 : $('#cbDuplicata').is(':checked') ? 1 : 0
    let todasEmpresas = $('#cbTodasEmpresas').is(':checked') ? 'S' : 'N'

    objeto = {
      emissaoDe: $('#dtEmissaoDe').val(),
      emissaoAte: $('#dtEmissaoAte').val(),
      vencimentoDe: $('#dtVencimentoDe').val(),
      vencimentoAte: $('#dtVencimentoAte').val(),
      emissaoBorderoDe: $('#dtEmissaoBorderoDe').val(),
      emissaoBorderoAte: $('#dtEmissaoBorderoAte').val(),
      cadInstrucaoDe: $('#dtCadInstrucaoDe').val(),
      cadInstrucaoAte: $('#dtCadInstrucaoAte').val(),
      codCli: await formataListas($('#txtCliente').val().toString()),
      grupoCli: await formataListas($('#txtGrupoCli').val().toString()),
      fatura: await formataListas($('#txtFatura').val().toString()),
      conta: await formataListas($('#txtConta').val().toString()),
      endosso: await formataListas($('#txtEndosso').val().toString()),
      cidade: await formataListas($('#txtCidade').val().toString()),
      moeda: await formataListas($('#txtMoeda').val().toString()),
      valorDe: $('#txtValorDe').val(),
      valorAte: $('#txtValorAte').val(),
      banco: $('#txtBanco').val(),
      codigoUF: $('#txtUF').val(),
      bordero: $('#txtBordero').val(),
      codRep: $('#txtRepresentante').val(),
      classe: $('#txtClasseGerencial').val(),
      todasEmpresas: todasEmpresas,
      rgTipo: rgTipo,
      rgBordero: rgBordero,
      rgStatusDupl: rgStatusDupl,
    }
    return objeto;
  }

  async function buscaDados() {
    if ($.fn.DataTable.isDataTable('#tabelaDados')) {
      $('#tabelaDados').DataTable().destroy();
      $('#tabelaDados').empty();
    };
    $.LoadingOverlay('show');
    try {
      const params = await buscaDadosCampos();

      const response = await requisicao('GET', `/sisplan/escenvio/V1/buscadadosacesso?`, `JSON=${JSON.stringify(params)}`, '', 90000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      const dataSetCols = [
        {
          data: 'sel',
          title: 'SEL'
        },
        {
          data: 'numero',
          title: 'Número'
        },
        {
          data: 'pedido',
          title: 'Pedido'
        },
        {
          data: 'cliente',
          title: 'Cliente'
        },
        {
          data: 'situacao',
          title: 'Situacao'
        },
        {
          data: 'dataEmissao',
          title: 'Data de Emissão'
        },
        {
          data: 'dataVencimento',
          title: 'Data de Vencimento'
        },
        {
          data: 'bordero',
          title: 'Bordero'
        },
        {
          data: 'banco',
          title: 'Banco'
        },
        {
          data: 'dataEnvio',
          title: 'Data de Envio'
        },
        {
          data: 'valorTitulo',
          title: 'Valor do Título'
        },
        {
          data: 'empresa',
          title: 'Empresa'
        },
        {
          data: 'numeroBanco',
          title: 'Nr. Banco'
        },
        {
          data: 'notaDenegada',
          title: 'Nota Denegada'
        },
        {
          data: 'valorNota',
          title: 'Valor da Nota'
        },
        {
          data: 'fatura',
          title: 'Fatura'
        },
        {
          data: 'emissaoBordero',
          title: 'Emissão do Bordero'
        },
        {
          data: 'grupoCliente',
          title: 'Grupo de Cliente'
        },
        {
          data: 'contaCheque',
          title: 'Conta Cheque'
        },
        {
          data: 'historico',
          title: 'Histórico'
        },
        {
          data: 'juros',
          title: 'Juros'
        },
        {
          data: 'descontos',
          title: 'Descontos'
        },
        {
          data: 'negociado',
          title: 'Negociado'
        },
        {
          data: 'empId',
          title: 'Emp_id'
        },
      ];

      dataSetCols[0].render = function (data, type, row, meta) {
        return `<div class="icheck-danger d-inline">
                  <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
              </div>`
      }

      $('#tabelaDados').DataTable({
        paging: true,
        filter: false,
        info: false,
        length: false,
        order: false,
        destroy: true,
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        data: jsonStr,
        columns: dataSetCols,
        columnDefs: [
          {
            targets: [5, 6, 9, 16], render: function (data, type, row) {
              if (type === 'display' || type === 'filter') {
                var date = new Date(data);
                var dia = date.getDate();
                var mes = date.getMonth() + 1;
                var ano = date.getFullYear();
                if (dia < 10) {
                  dia = '0' + dia;
                }
                if (mes < 10) {
                  mes = '0' + mes;
                }
                return dia + '/' + mes + '/' + ano;
              } else {
                return data;
              }
            }
          },
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
          {
            "targets": [22],
            "className": 'pr-4 text-right'
          },
          {
            "render": function (data) {
              if (data !== null && data !== undefined && !isNaN(data)) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              } else {
                return '0,00';
              }
            },
            "targets": [10, 14, 20, 21],
            "className": 'pr-4 text-right'
          }
        ],
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  let registrosSelecionados = []

  $('#tabelaDados').DataTable().on('click', ".campoSel", async function () {
    const dados = $('#tabelaDados').DataTable().row($(this).closest('tr')).data();
    if (!$(this).prop('checked')) {
      registrosSelecionados = registrosSelecionados.filter(cod => (cod.numero != dados.numero));
      $($(this).closest('tr')).removeClass('selected');
    } else {
      const indexJaExistente = registrosSelecionados.findIndex(index => dados.numero == index.numero);
      if (indexJaExistente == -1) {
        registrosSelecionados.push(dados);
      }
      $($(this).closest('tr')).addClass('selected');
    }
  });

  $('#tabelaDados').on('draw.dt', function () {
    const dados = $('#tabelaDados').DataTable().rows().data().toArray();
    if (registrosSelecionados.length > 0) {
      for (let j = 0; j < registrosSelecionados.length; j++) {
        for (let i = 0; i < dados.length; i++) {
          if (registrosSelecionados[j].numero == dados[i].numero) {
            $($(".campoSel")[i]).prop('checked', true);
            $($(".campoSel")[i].closest('tr')).addClass('selected');
          }
        }
      }
    }
  });

  $('#tabelaDados').on('click', '.campoSel', async function () {
    lineIsChecked = $('#tabelaDados').DataTable().rows((this).closest('tr')).data().toArray()[0].sel == 'N' ? true : false
    newValue = lineIsChecked ? 'S' : 'N'
    $('#tabelaDados').DataTable().rows((this).closest('tr')).data().toArray()[0].sel = newValue;
  });


  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $("#tabelaDados").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
      let chave = `${data[0]}-${data[2]}-${data[5]}-${data[7]}`;
      window.location.href = `escposicao/${chave}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaDados").on("click", "#btnRecompra", async function () {
    let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
    $('#txtNumeroRecompra').html(data.numero);
    let valorNovo = data.valorTitulo
    $('#txtValorSaldo').val(valorNovo);
    $('#modalRecompraTitulo').modal('show');
  });

  async function retornaFiltros() {
    const filtros = {
      emissaoDe: $('#dtEmissaoDe').val(),
      emissaoAte: $('#dtEmissaoAte').val(),
      vencimentoDe: $('#dtVencimentoDe').val(),
      vencimentoAte: $('#dtVencimentoAte').val(),
      emissaoBorderoDe: $('#dtEmissaoBorderoDe').val(),
      emissaoBorderoAte: $('#dtEmissaoBorderoAte').val(),
      cadInstrucaoDe: $('#dtCadInstrucaoDe').val(),
      cadInstrucaoAte: $('#dtCadInstrucaoAte').val(),
      cliente: await formataListas($('#txtCliente').val().toString()),
      representante: pegaChave('#txtRepresentante'),
      grupoCli: await formataListas($('#txtGrupoCli').val().toString()),
      fatura: await formataListas($('#txtFatura').val().toString()),
      conta: await formataListas($('#txtConta').val().toString()),
      endosso: await formataListas($('#txtEndosso').val().toString()),
      cidade: await formataListas($('#txtCidade').val().toString()),
      moeda: await formataListas($('#txtMoeda').val().toString()),
      valorDe: $('#txtValorDe').val(),
      valorAte: $('#txtValorAte').val(),
      banco: pegaChave('#txtBanco'),
      uf: pegaChave('#txtUF'),
      bordero: pegaChave('#txtBordero'),
      tipo: $('#cbLoja').is(':checked') ? '0' : $('#cbAllDupl').is(':checked') ? '1' : $('#cbAllDuplLoja').is(':checked') ? '2' : '2',
      duplicatas: $('#cbTodos').is(':checked') ? '0' : $('#cbSemBordero').is(':checked') ? '1' : $('#cbComNrBanco').is(':checked') ? '2' : '0',
      status: $('#cbDuplicata').is(':checked') ? '0' : $('#cbCheque').is(':checked') ? '1' : '0',
    }
    return filtros;
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/imprimirescenvio?';
        const filtros = await retornaFiltros();

        const params = `&EMISSAO_DE=${filtros.emissaoDe}` +
          `&EMISSAO_ATE=${filtros.emissaoAte}` +
          `&VENCIMENTO_DE=${filtros.vencimentoDe}` +
          `&VENCIMENTO_ATE=${filtros.vencimentoAte}` +
          `&EMISSAO_BORDERO_DE=${filtros.emissaoBorderoDe}` +
          `&EMISSAO_BORDERO_ATE=${filtros.emissaoBorderoAte}` +
          `&CAD_INSTRUICAO_DE=${filtros.cadInstrucaoDe}` +
          `&CAD_INSTRUCAO_ATE=${filtros.cadInstrucaoAte}` +
          `&CLIENTE=${filtros.cliente}` +
          `&REPRESENTANTE=${filtros.representante}` +
          `&GRUPO_CLI=${filtros.grupoCli}` +
          `&FATURA=${filtros.fatura}` +
          `&CONTA=${filtros.conta}` +
          `&ENDOSSO=${filtros.endosso}` +
          `&CIDADE=${filtros.cidade}` +
          `&MOEDA=${filtros.moeda}` +
          `&VALOR_DE=${filtros.valorDe}` +
          `&VALOR_ATE=${filtros.valorAte}` +
          `&BANCO=${filtros.banco}` +
          `&UF=${filtros.uf}` +
          `&BORDERO=${filtros.bordero}` +
          `&STATUS=${filtros.status}` +
          `&DUPLICATAS=${filtros.duplicatas}` +
          `&TIPO=${filtros.tipo}`;

        let arquivo = await GeraRelatorio(`${url + params}&`, 'GET', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#modalRecompraTitulo').on('hide.bs.modal', function () {
    $('#dtCont').val(formataData(new Date()));
    $('#txtValorJuros').val('0.00');
    $('#txtValorSaldo').val('');
    $('#txtClasseGerencialRecompra').val('');
    $('#txtContaDebito').val('');
    $('#txtFornecedor').val('');
    $('#txtValorAntecipacao').val('');
    $('#txtValorDiferencial').val('');
  });

  $('#btnConfirmar').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const conta = buscaValor('CADCONTA', 'CONTA', 'CONTA', pegaChave('#txtContaDebito'));

      if (!pegaChave('#txtContaDebito') || !conta) {
        throw msgAlerta('Conta não pode ser vazio');
      }

      let dadosRecompra = {
        numero: $('#txtNumeroRecompra').html(),
        dataCont: $('#dtCont').val(),
        juros: $('txtValorJuros').val(),
        saldo: $('#txtValorSaldo').val(),
        classeGerencial: pegaChave('#txtClasseGerencialRecompra'),
        contaDebito: pegaChave('#txtContaDebito'),
        forncedor: pegaChave('#txtFornecedor'),
        valorAntecipacao: $('#txtValorAntecipacao').val(),
        valorDiferencial: $('#txtValorDiferencial').val(),
      }

      let response = await requisicao('POST', '/Sisplan/escenvio/v1/recompratitulo?', `JSON=${encodeURIComponent(JSON.stringify(dadosRecompra))}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Cadastro efetuado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modalRecompraTitulo').modal('hide');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaDadosInputs() {
    const objeto = {
      bordero: pegaChave('#txtBordero')
    }
    return objeto;
  }

  $('#btnGravar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      let Envio = await buscaDadosTabela();
      let params = await buscaDadosInputs();

      // if (!$('#txtBordero').val()) {
      //   throw msgAlerta('Bordero não pode estar vazio, verifique!');
      // }
      if (Envio.length == 0) {
        throw msgAlerta('Nenhum título selecionado, verifique!');
      }

      body = {
        Envio: Envio
      }

      const response = await requisicao('POST', `/sisplan/escenvio/V1/gravaracesso?`, `PARAMS=${JSON.stringify(params)}`, JSON.stringify(body), 90000);

      if (!response) {
        return;
      };

      if (response.status != 200) {
        throw msgAlerta('Não foi possível gravar os títulos selecionados, verifique!')
      }

      toastr.success(
        `Títulos gravados com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/escenvio`
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaDadosTabela() {
    const objeto = registrosSelecionados.map((dados) => ({
      sel: dados.sel,
      numero: dados.numero,
      pedido: dados.pedido,
      cliente: dados.cliente,
      dataEmissao: dados.dataEmissao != '' ? dados.dataEmissao.split('/').reverse().join('-') : '1899-01-01',
      dataVencimento: dados.dataVencimento != '' ? dados.dataVencimento.split('/').reverse().join('-') : '1899-01-01',
      bordero: dados.bordero,
      banco: dados.banco,
      dataEnvio: dados.dataEnvio != '' ? dados.dataEnvio.split('/').reverse().join('-') : '1899-01-01',
      valorTitulo: dados.valorTitulo,
      empresa: dados.empresa,
      notaDenegada: dados.notaDenegada,
      fatura: dados.fatura,
      emissaoBordero: dados.emissaoBordero != '' ? dados.emissaoBordero.split('/').reverse().join('-') : '1899-01-01',
      grupoCliente: dados.grupoCliente,
      contaCheque: dados.contaCheque,
      historico: dados.historico,
      juros: dados.juros,
      descontos: dados.descontos,
      negociado: dados.negociado,
      empId: dados.empId,
      valorNota: dados.valorNota,
      situacao: dados.situacao,
      numeroBanco: dados.numeroBanco,
    }))
    return objeto;
  };

});
