<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Embarque</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.6.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.243.6.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" href="dist/css/custom.css?versao=3.243.6.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.243.6.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.243.6.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.243.6.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.243.6.1">
  <style>
    .radioSituacao {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      width: 100%;
      /* margin-left: -3%; */
      margin: auto;
      padding: .5%;
    }

    #tabelaEmbarque td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaEmbarque td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    ;
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Embarque</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
 
            </div>
          </div>
        </div>
        <div class="container-fluid" id="divTabelaEmbarque">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Notas</h5>
              <table id="tabelaEmbarque" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">FATURA</th>
                    <th class="th-sm">NUMERO</th>
                    <th class="th-sm">SERIE</th>
                    <th class="th-sm">SITUACAO</th>
                    <th class="th-sm">TRANSPORT</th>
                    <th class="th-sm">DT_CADASTRO</th>
                    <th class="th-sm">DT_FINALIZADO</th>
                    <!-- <th class="th-sm">Ações -->
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>

      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="col-sm-12 col-md-12" style="padding:0;">
                <label class="labelGeral" style="font-size: 116%;" for="divTipoNota" data-error="wrong" data-success="right">Operação</label>
                <div id="divTipoNota" class="radioSituacao" style="margin-top: -.5%">
                  <label class="container">Todos
                    <input type="radio" checked id="radioTodos" name="situacao">
                    <span class="checkmark"></span>
                  </label>
                  <label class="container">Pendentes
                    <input type="radio" value="1" id="radioPendentes" name="situacao">
                    <span class="checkmark"></span>
                  </label>
                  <label class="container">Faturados
                    <input type="radio" value="2" id="radioFaturados" name="situacao">
                    <span class="checkmark"></span>
                  </label>
                </div>
              </div>

              <div class="row " style="margin-top: 1.4%;">
                <div class="group-default form-group col-6">
                  <label for="txtDataCadDe">Data Cadastro De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataCadDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-6">
                  <label for="txtDataCadAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtDataCadAte" name="DataAte">
                  </div>
                </div>
                <!-- <div class="group-default form-group col-3">
                  <label for="txtDataFinalizacaoDe">Finalização De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataFinalizacaoDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFinalizacaoAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtDataFinalizacaoAte" name="DataAte">
                  </div>
                </div> -->
              </div>


              <div class="row">
                <div class="col-6" id="NotaConsulta">
                  <label data-error="wrong" data-success="right" for="txtNota">Nota: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNota" name="txtNota" class="form-control" placeholder="Nota">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Nota" name="btn-Nota" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Nota" name="btn-limpa-Nota" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>


                <div class="col-6" id="NumeroConsulta">
                  <label data-error="wrong" data-success="right" for="txtNumero">Número: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNumero" name="txtNumero" class="form-control" placeholder="Número">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Numero" name="btn-Numero" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Numero" name="btn-limpa-Numero" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-6" id="ClienteConsulta">
                  <label data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Cliente" name="btn-Cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Cliente" name="btn-limpa-Cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-6" id="TranporteConsulta">
                  <label data-error="wrong" data-success="right" for="txtTransporte">Transporte: </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTransporte" name="txtTransporte" class="form-control" placeholder="Transporte">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Transporte" name="btn-Transporte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Transporte" name="btn-limpa-Transporte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

            </div>

            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
  <?php
  include_once('../../../footer.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.243.6.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.243.6.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/sisplan.js?versao=3.243.6.1"></script>
  <script src="utils/funcoes.js?versao=3.243.6.1"></script>
  <script src="utils/cookies.js?versao=3.243.6.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.243.6.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.243.6.1"></script>
  <script src="dist/js/driver.min.js?versao=3.243.6.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.243.6.1"></script>

  <script type="text/javascript" src="dist/js/sum().js?versao=3.243.6.1"></script>
  <script type="text/javascript" src="config.js?versao=3.243.6.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('EMBARQUE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/embarque/acesso_embarque/acesso_embarque.js?versao=3.243.6.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>