/* eslint-disable camelcase */
$(document).ready(async function () {

    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('depositoCru', true);
    componenteFiltro('depositoFio', true);

    $('#txtPeriodo1').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('#txtPeriodo2').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);
    $('#txtPeriodo3').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null, "orderBy": ["PRAZO"]}`);



    async function retornaFiltros() {
        const result = {};
        result.materiais = (await formataListas($('#txtMaterial').val().toString()));
        result.cores = (await formataListas($('#txtCor').val().toString()));
        result.depositosCrus = (await formataListas($('#txtDepositoCru').val().toString()));
        result.depositosFios = (await formataListas($('#txtDepositoFio').val().toString()));
        result.periodo1 = pegaChave('#txtPeriodo1');
        result.periodo2 = pegaChave('#txtPeriodo2');
        result.periodo3 = pegaChave('#txtPeriodo3');
        return result;
    }


    async function montaDadosTecidos(dados) {
        try {
            const estaResumido = $('#cbResumido').prop('checked'); 
            const resumido = estaResumido ? 'd-none': '';
            const { id, id_cor, codigo, cor, descricao, desc_cor, estoque, pre_baixa, estoque_fix, periodos } = dados;
            const listaPeriodos = [];
            for (let i = 1; i < periodos.length; i++) {
                const periodoAtual = periodos[i];
                listaPeriodos.push(`<tr>` +
                    `<td>${periodoAtual.periodo}</td>` +
                    `<td>${periodoAtual.pendente_ot}</td>` +
                    `<td class="${resumido}">${periodoAtual.fixado_ob}</td>` +
                    `<td>${periodoAtual.emitido_ob}</td>` +
                    `<td>${periodoAtual.saldo_prog}</td>` +
                    `<td>${periodoAtual.a_emitir_ob}</td>` +
                    `<td>${periodoAtual.a_programar}</td>` +
                    `</tr>`);
            }

            const html = `<fieldset class="tecidos">` +
                `       <div class="card card-body">` +
                `           <div class="form-row">` +
                `               <div class="col-12 table-responsive">` +
                `                   <table id="tabelaTecidos" class="table table-sm table-select table-hover" width="100%" style="width: 100%;">` +
                `                        <thead >` +
                `                           <tr>` +
                `                               <th width="300px">Tecido</th>` +
                `                               <th width="250px">Cor</th>` +
                `                               <th width="300px">Descrição</th>` +
                `                               <th>Estoque</th>` +
                `                               <th class="${resumido}">Pré Baixa</th>` +
                `                               <th class="${resumido}">Estoque Fix.</th>` +
                `                               <th>Período</th>` +
                `                               <th>Pendente OT</th>` +
                `                               <th class="${resumido}">Fixado OB</th>` +
                `                               <th>Emitido OB</th>` +
                `                               <th>Saldo Prog.</th>` +
                `                               <th>A Emitir OB</th>` +
                `                               <th>A Programar</th>` +
                `                           </tr>` +
                `                       </thead>` +
                `                       <tbody style="background: var(--table-border)">` +
                `                           <tr>` +
                `                               <td rowspan="3">${codigo}</td>` +
                `                               <td rowspan="3">${cor} - ${desc_cor}</td>` +
                `                               <td rowspan="3">${descricao}</td>` +
                `                               <td rowspan="3">${estoque}</td>` +
                `                               <td rowspan="3" class="${resumido}">${pre_baixa}</td>` +
                `                               <td rowspan="3" class="${resumido}">${estoque_fix}</td>` +
                `                               <td>${periodos[0].periodo}</td>` +
                `                               <td>${periodos[0].pendente_ot}</td>` +
                `                               <td class="${resumido}">${periodos[0].fixado_ob}</td>` +
                `                               <td>${periodos[0].emitido_ob}</td>` +
                `                               <td>${periodos[0].saldo_prog}</td>` +
                `                               <td>${periodos[0].a_emitir_ob}</td>` +
                `                               <td>${periodos[0].a_programar}</td>` +
                `                           </tr>` +
                `                           ${listaPeriodos.toString().replaceAll('</tr>,<tr>', '</tr><tr>')}` +
                `                   </tbody>` +
                `                   </table>` +
                `               </div>` +
                `           </div>` +
                `       </div>` +
                `   </fieldset> `;

            $('#dados').append(`<div id="dados-${`${id}-${id_cor}`}" class="borda"></div>`);
            $(`#dados-${`${id}-${id_cor}`}`).html(html);

        } catch (e) {
            console.log(e);
            msgErro(`Não foi possível buscar os dados: ${e}`);
        }
    }
    async function montaDadosPrioridadeEFichaTecnica(dados) {
        if (!dados || dados.length == 0) {
            return;
        }

        const { id, id_cor, prioridades, ficha_tecnica } = dados;

        const dadosPrioridade = prioridades && prioridades.length > 0 ? prioridades.map(prio => (`<tr>` +
            ` <td>${prio.prioridade}</td>` +
            `<td>${prio.quantidade}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';
        const dadosFicha = ficha_tecnica && ficha_tecnica.length > 0 ? ficha_tecnica.map(ficha => (`<tr>` +
            `<td>${ficha.peso_cru}</td>` +
            `<td>${ficha.peso_acabado}</td>` +
            `<td>${ficha.quebra}</td>` +
            `<td>${ficha.programa}</td>` +
            `<td>${ficha.finura}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';
        const html = `<fieldset class="prioridade">` +
            `  <div class="card card-body">` +
            `      <div class="form-row">` +
            `          <div class="col-xl-6 col-12 table-responsive">` +
            `              <table id="tabelaPrioridade" class="table table-sm table-select table-hover" width="100%" style="width: 100%">` +
            `                  <thead style="background-color: inherit!important; color: inherit!important;">` +
            `                      <tr>` +
            `                          <th>Prioridade</th>` +
            `                          <th>Quantidade</th>` +
            `                      </tr>` +
            `                  </thead>` +
            `                  <tbody>` +
            `${dadosPrioridade}` +
            `                  </tbody>` +
            `              </table>` +
            `          </div>` +
            `          <div class="col-xl-6 col-12 table-responsive">` +
            `              <table id="tabelaFichaTecnica" class="table table-sm table-select table-hover" width="100%" style="width: 100%">` +
            `                  <thead style="background-color: inherit!important; color: inherit!important;">` +
            `                      <tr>` +
            `                          <th>Peso Cru</th>` +
            `                          <th>Peso Acabado</th>` +
            `                          <th>Quebra</th>` +
            `                          <th>Programa</th>` +
            `                          <th>Finura</th>` +
            `                      </tr>` +
            `                  </thead>` +
            `                  <tbody>` +
            `${dadosFicha}` +
            `                  </tbody>` +
            `              </table>` +
            `          </div>` +
            `      </div>` +
            `  </div>` +
            `</fieldset>`;
        $(`#dados-${`${id}-${id_cor}`}`).append(html);
    }
    async function montaDadosFiosEMaquinas(dados) {
        const { id, id_cor, fios, maquinas } = dados;

        const dadosFios = fios && fios.length > 0 ? fios.map(fio => (`<tr>` +
            `<td>${fio.codigo}</td>` +
            `<td>${`${fio.cor} - ${fio.desc_cor}`}</td>` +
            `<td>${fio.descricao}</td>` +
            `<td>${fio.rocas}</td>` +
            `<td>${fio.percentual_consumo}</td>` +
            `<td>${fio.empenho}</td>` +
            `<td>${fio.necessidade}</td>` +
            `<td>${fio.estoque_disp}</td>` +
            `</tr>`)).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';

        const dadosMaquinas = maquinas && maquinas.length > 0 ? maquinas.map(maquina => {
            const obj = {
                "0": 'PARADA',
                "1": 'APÓS',
                "2": 'ATIVA',
                "3": 'TROCA DE REFERÊNCIA',
                "4": 'TRANSFORMAÇÃO',
                "5": 'MANUTENÇÃO',
                "6": 'AMOSTRAGEM'
            };
            const situacao = obj[maquina.situacao];
            return (
                `<tr>
                <td>${maquina.maquina}</td>
                <td>${maquina.descricao}</td>
                <td>${maquina.rolos}</td>
                <td>${maquina.grupo}</td>
                <td>${maquina.finura}</td>
                <td>${situacao}</td>
                <td>${maquina.obs}</td>
            </tr>`);
        }).toString().replaceAll('</tr>,<tr>', '</tr><tr>') : '';


        const html = `
        <fieldset class="fios">
            <div class="card card-body">
                <div class="form-row">
                    <div class="col-xl-6 col-12 table-responsive">
                        <table id="tabelaFios" class="table table-sm table-select table-hover" width="100%" style="width: 100%">
                            <thead style="background-color: inherit!important; color: inherit!important;">
                                <tr>
                                    <th>Código</th>
                                    <th>Cor</th>
                                    <th>Descrição</th>
                                    <th>Rocas</th>
                                    <th>% Cons.</th>
                                    <th>Empenho</th>
                                    <th>Necessidade</th>
                                    <th>Estoque Disp.</th>
                                </tr>
                            </thead>
                            <tbody>
                            ${dadosFios}
                            </tbody>
                        </table>
                    </div>
                    <div class="col-xl-6 col-12 table-responsive">
                        <table id="tabelaMaquinas" class="table table-sm table-select table-hover" width="100%" style="width: 100%">
                            <thead style="background-color: inherit!important; color: inherit!important;">
                                <tr>
                                    <th>Máquina</th>
                                    <th>Descrição</th>
                                    <th>Rolos</th>
                                    <th>Grupo</th>
                                    <th>Finura</th>
                                    <th>Situação</th>
                                    <th>Obs</th>
                                </tr>
                            </thead>
                            <tbody>
                               ${dadosMaquinas}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </fieldset>`;
        $(`#dados-${`${id}-${id_cor}`}`).append(html);
    }


    $('#btnLimparTela').on('click', function () {
        // $('#txtReferencia').val('');
        $('#txtMaterial').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtDepositoCru').empty().trigger('change');
        $('#txtDepositoFio').empty().trigger('change');
        // $('#txtCor').val('');
        $('#txtPeriodo1').val('');
        $('#txtPeriodo2').val('');
        $('#txtPeriodo3').val('');
        // $('#txtDepositoCru').val('');
        // $('#txtDepositoFio').val('');
        $('#tecidos').html('');
        $('#prioridade').html('');
        $('#dados').html('');
    });


    function filtrosInvalidos() {
        if (($('#txtPeriodo1').val() == '') || ($('#txtPeriodo2').val() == '') || ($('#txtPeriodo3').val() == '')) {
            msgAlerta('Períodos obrigatórios, verifique.');
            return true;
        }


        if ($('#txtDepositoCru').val() == '') {
            msgAlerta('Depósito Cru obrigatório, verifique.');
            return true;
        }

        if ($('#txtDepositoFio').val() == '') {
            msgAlerta('Depósito Fio obrigatório, verifique.');
            return true;
        }
        return false;
    }


    $('#btnConsultar').on('click', async function () {



        try {
            try {

                $.LoadingOverlay("show");
                if (filtrosInvalidos()) {
                    return;
                }
                $('#dados').html('');
                const filtros = await retornaFiltros();
                const url = `/sisplan/disponibilidadetecidos/v1/buscadados?`;
                const response = await requisicao("GET", url, `&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}`, '', 1800000);

                if (!response) {
                    return;
                }

                const data = await response.json();
                const dados = data.lista;

                // const referencias = $('#txtMaterial').val();
                for (let i = 0; i < dados.length; i++) {
                    await montaDadosTecidos(dados[i]);
                    await montaDadosPrioridadeEFichaTecnica(dados[i]);
                    await montaDadosFiosEMaquinas(dados[i]);

                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });
    // $("#btnGravar").on("click", async function () {
    //     $.LoadingOverlay("show");
    //     $("#btnGravar").prop("disabled", true);
    //     try {
    //         let bZeraLote = false;
    //         const saldo = $("#txtSaldo").val();

    //         if (saldo < 0) {
    //             throw msgAlerta("Não é possível realizar a operação, saldo negativo.");
    //         } else {
    //             await gravaDesdobraLote(bZeraLote);
    //         }

    //     } finally {
    //         $.LoadingOverlay("hide");
    //         $("#btnGravar").prop("disabled", false);
    //     }
    // });

});
