$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCor",
        popover: {
          title: "Cor",
          description:
            "Neste campo, adicionamos o código da cor.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo2",
        popover: {
          title: "Código 2",
          description:
            "Aqui, podemos adicionar um segundo código para a cor.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo, colocamos a descrição desta cor",
          position: "top",
        },
      },
      {
        element: '#txtGrupoCor',
        popover: {
          title: 'Grupo de Cor',
          description: 'Neste campo, colocamos o grupo de cor que esse cadastro pertence, ao clicar na lupa, irá consultar os grupos cadastrados e seleciona-lo.',
          position: 'top'
        }
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a cor.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("COR", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/cor`;
  });

  $(document).ready(function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCor: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
        txtGrupoCor: {
          required: true,
        },
      },
      messages: {
        txtCor: {
          required: "Informe um código válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
        txtGrupoCor: {
          required: "Informe um grupo de cor válido.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#txtGrupoCor").autocompleta(
    1,
    `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );

  $("#btnGrupoCor").pesquisa(
    "#txtGrupoCor",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Grupo Cor",
    "GRUPO_COR"
  );

  $("#btnAGrupoCor").on("click", function () {
    $("#txtGrupoCor").val("");
  });

  $("#txtSubGrupoCor").autocompleta(
    1,
    `JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );

  $("#btnSubGrupoCor").pesquisa(
    "#txtSubGrupoCor",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa SubGrupo Cor",
    "SUBGRUPO_COR"
  );

  $("#btnSubAGrupoCor").on("click", function () {
    $("#txtSubGrupoCor").val("");
  });

  $("#txtClasseComercial").autocompleta(
    1,
    `JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );

  $("#btnClasseComercial").pesquisa(
    "#txtClasseComercial",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe Comercial",
    "CLASSE_COR"
  );

  $("#btnLimpaClasseComercial").on("click", function () {
    $("#txtClasseComercial").val("");
  });

  $("#txtCliente").autocompleta(
    1,
    `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`
  );

  $("#btnCliente").pesquisa(
    "#txtCliente",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`,
    "Pesquisa Cliente",
    "ENTIDADE"
  );

  $("#btnLimpaCliente").on("click", function () {
    $("#txtCliente").val("");
  });

  $("#txtDesigner").autocompleta(
    1,
    `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`
  );

  $("#btnDesigner").pesquisa(
    "#txtDesigner",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`,
    "Pesquisa Designer",
    "ENTIDADE"
  );

  $("#btnLimpaDesigner").on("click", function () {
    $("#txtDesigner").val("");
  });

  $("#txtCilindro").autocompleta(
    1,
    `JSON={ "tabela":"CILINDRO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );

  $("#btnCilindro").pesquisa(
    "#txtCilindro",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CILINDRO", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Cilindro",
    "CILINDRO"
  );

  $("#btnLimpaCilindro").on("click", function () {
    $("#txtCilindro").val("");
  });

  $("#btnLimpaDataVal").on("click", function () {
    $("#txtDataVal").val("");
  });

  $("#btnLimpaDataCad").on("click", function () {
    $("#txtDataCad").val("");
  });

  $('#modalFoto').on('hide.bs.modal', async function () {
    $('#txtArquivoFoto').val('');
  });

  $('#btn-LimpaArquivo').on('click', async function () {
    $('#txtArquivoFoto').val('');
    await buscaFotoCor();
  });

  $('#modalFoto').on('show.bs.modal', async function () {
    await buscaFotoCor();
  });

  $('#btnAdicionaAFoto').on('click', async function () {
    await SalvaFotoCor();
  });


  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let cor = atob(parametros[parametros.length - 1]);

  $('#btnExcluiAFoto').on('click', async function () {
    let responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!responsej) {
      return;
    };
    jsonStr = await responsej.json();
    let pastaFoto = jsonStr.mensagem;
    let pastaCor = pastaFoto + '\\COR\\';
    let response = await requisicao('GET', '/sisplan/funcoes/v1/fotocor?', `CODIGO=${cor}&PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${cor}.jpg`, null);
    jsonRetornado = await response.json();
    if (jsonRetornado.codigo == 200) {
      msgAlerta('Você realmente deseja excluir a foto da cor?', async () => {
        await excluiFotoCor();
      })
    } else {
      msgErro('Cor não tem imagem para excluir!');
      return;
    };
  });

  async function buscaFotoCor() {
    let responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!responsej) {
      return;
    };
    jsonStr = await responsej.json();
    let pastaFoto = jsonStr.mensagem;
    let pastaCor = pastaFoto + '\\COR\\';
    let response = await requisicao('GET', '/sisplan/funcoes/v1/fotocor?', `CODIGO=${cor}&PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${cor}.jpg`, null);
    jsonRetornado = await response.json();
    if (jsonRetornado.codigo == 200) {
      $("#imgFoto").attr('src', `data:image/png;base64,${jsonRetornado.mensagem}`);
      $("#imgFotoModal").attr('src', `data:image/png;base64,${jsonRetornado.mensagem}`);
    } else {
      $("#imgFoto").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
      $("#imgFotoModal").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    };
  };

  await buscaFotoCor();

  async function SalvaFotoCor() {
    imagem = $('#txtArquivoFoto').val();
    if (imagem == '' || imagem == undefined) {
      msgAlerta('Campo da imagem em branco! Por favor, verifique.')
      return;
    };
    let file = document.querySelector('input[type=file]').files[0];
    let reader = new FileReader();
    let baseString;
    reader.onloadend = function () {
      baseString = reader.result
    };
    await reader.readAsDataURL(file);
    let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!response) {
      return;
    };
    jsonStr = await response.json();
    let pastaFoto = jsonStr.mensagem;
    let pastaCor = pastaFoto + '\\COR\\'
    response = await requisicao('POST', '/sisplan/funcoes/v1/fotocor?', `PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${cor}.jpg`, `SBASE64=${encodeURIComponent(baseString)}&FILETYPE=${file.type}`);
    if (!response) {
      msgAlerta('Não foi possível gravar imagem da cor! Tente novamente.')
      return;
    };
    if (response.status != 200) {
      msgAlerta('Não foi possível gravar imagem da cor! Tente novamente.')
      return;
    };
    criaMensagemSucesso('Imagem da cor anexada com sucesso.');
    $('#txtArquivoFoto').val('');
    await buscaFotoCor();
    $('#modalFoto').modal('hide');
  };

  async function excluiFotoCor() {
    let responsel = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!responsel) {
      return;
    };
    jsonStr = await responsel.json();
    const pastaFoto = jsonStr.mensagem;
    const pastaCor = pastaFoto + '\\COR\\'
    let response = await requisicao('DELETE', '/sisplan/funcoes/v1/fotocor?', `PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${cor}.jpg`, null)
    if (!response) {
      msgAlerta('Não foi possível excluir a foto da cor! Por favor, verifique.')
    };
    if (response.status != 200) {
      msgAlerta('Não foi possível excluir a imagem da cor! Tente novamente.')
      return;
    };
    criaMensagemSucesso('Exclusão da foto da cor efetuada com sucesso!')
    await buscaFotoCor();
  };

  $('#btnImprimeAFoto').on('click', async function () {
    let responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!responsej) {
      return;
    };
    jsonStr = await responsej.json();
    let pastaFoto = jsonStr.mensagem;
    let pastaCor = pastaFoto + '\\COR\\';
    let response = await requisicao('GET', '/sisplan/funcoes/v1/fotocor?', `CODIGO=${cor}&PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${cor}.jpg`, null);
    jsonRetornado = await response.json();
    if (jsonRetornado.codigo == 400) {
      msgErro('Não tem imagem para imprimir!');
      return;
    };
    const w = 900;
    const h = 650
    const src = $('#imgFoto')[0].src;
    const dualScreenLeft = window.screenLeft !== undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop !== undefined ? window.screenTop : window.screenY;
    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;
    const systemZoom = width / window.screen.availWidth;
    const left = (width - w) / 2 / systemZoom + dualScreenLeft
    const top = (height - h) / 2 / systemZoom + dualScreenTop
    myWindow = window.open('', '', `
        scrollbars=yes,
        width=${w / systemZoom}, 
        height=${h / systemZoom}, 
        top=${top}, 
        left=${left}
        `);
    myWindow.document.write(`<image src='${src}' style='width: 700; height:450;' alt='foto'/>`);
    myWindow.focus();
    myWindow.print();
  });

  async function converteRbgParaHex(rgb) {
    const r = rgb.substring(0, 3);
    const g = rgb.substring(3, 6);
    const b = rgb.substring(6, 9);

    const hexR = ("0" + parseInt(r, 10).toString(16)).slice(-2);
    const hexG = ("0" + parseInt(g, 10).toString(16)).slice(-2);
    const hexB = ("0" + parseInt(b, 10).toString(16)).slice(-2);

    const hex = '#' + hexR + hexG + hexB;
    return hex
  };

  $(async function () {
    var modalUpload = $("#mdModalUpload");
    var Arquivo = $('#txtArquivoFoto');
    var Botao = $("#btn-AddArquivo");
    Botao.click(function () {
      modalUpload.click();
    });
    modalUpload.change(async function () {
      var NomeArquivo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
      Arquivo.val(NomeArquivo);

      let file = document.querySelector('input[type=file]').files[0];
      let reader = new FileReader();
      let baseString;
      reader.onloadend = function () {
        baseString = reader.result;
        $("#imgFoto").attr('src', baseString);
        $("#imgFotoModal").attr('src', baseString);
      };
      await reader.readAsDataURL(file);
    });
  });

  if (cor != "" && cor != "create") {
    if ((await liberarRegistro("COR", cor)) == false) {
      window.location.href = "../cor";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"cadcor", 
                    "camposSelect":["cor", "descricao", "codigo2", "grupo", "rgb", "subgrupo", "classe_cor", "desc_ecommerce", "desc_info", "pantone", "tinturaria", "designer", "cilindro", "dt_cadastro", "dt_validade", "tipo_cor", "tipo"], 
                    "where": ["cor = '${cor}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          const hexDecimal = await converteRbgParaHex(jsonStr.RESULT[0][0].RGB);


          $("#txtCor").attr("readonly", true);

          $("#txtCor").val(jsonStr.RESULT[0][0].COR);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
          $("#txtCodigo2").val(jsonStr.RESULT[0][0].CODIGO2);
          $('#inputColorRGB').val(`${hexDecimal}`);
          $(`input[value="${jsonStr.RESULT[0][0].TIPO_COR}"]`).prop('checked', true);
          $(`input[value="${jsonStr.RESULT[0][0].TIPO}"]`).prop('checked', true);
          $('#txtDescEcommerce').val(jsonStr.RESULT[0][0].DESC_ECOMMERCE);
          $('#txtPantone').val(jsonStr.RESULT[0][0].PANTONE);
          $('#txtDescInfo').val(jsonStr.RESULT[0][0].DESC_INFO);

          try {
            let respostaGrupoCor = await requisicao(
              "GET",
              "/Sisplan/Funcoes/v1/pesquisa?",
              `JSON={ "tabela":"grupo_cor", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].GRUPO}'"]}`,
              null
            );
            let jsonStringGrupoCor = await respostaGrupoCor.json();
            insereValor(
              $("#txtGrupoCor"),
              jsonStr.RESULT[0][0].GRUPO,
              jsonStringGrupoCor.RESULT[0][0].DESCRICAO
            );

            if (jsonStr.RESULT[0][0].SUBGRUPO != '') {
              let respostaSubGrupoCor = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"subgrupo_cor", 
                      "camposSelect":["descricao"], 
                      "where": ["codigo = '${jsonStr.RESULT[0][0].SUBGRUPO}'"]}`,
                null
              );
              let jsonStringSubGrupoCor = await respostaSubGrupoCor.json();
              insereValor(
                $("#txtSubGrupoCor"),
                jsonStr.RESULT[0][0].SUBGRUPO,
                jsonStringSubGrupoCor.RESULT[0][0].DESCRICAO
              );
            }

            if (jsonStr.RESULT[0][0].CLASSE_COR != '') {
              let respostaClasseCor = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"CLASSE_COR", 
                      "camposSelect":["descricao"], 
                      "where": ["codigo = '${jsonStr.RESULT[0][0].CLASSE_COR}'"]}`,
                null
              );
              let jsonStringClasseCor = await respostaClasseCor.json();
              insereValor(
                $("#txtClasseCor"),
                jsonStr.RESULT[0][0].CLASSE_COR,
                jsonStringClasseCor.RESULT[0][0].DESCRICAO
              );
            }

            if (jsonStr.RESULT[0][0].TINTURARIA != '') {
              let respostaCliente = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"ENTIDADE", 
                      "camposSelect":["NOME"], 
                      "where": ["codcli = '${jsonStr.RESULT[0][0].TINTURARIA}'"]}`,
                null
              );
              let jsonStringCliente = await respostaCliente.json();
              insereValor(
                $("#txtCliente"),
                jsonStr.RESULT[0][0].TINTURARIA,
                jsonStringCliente.RESULT[0][0].NOME
              );
            }

            if (jsonStr.RESULT[0][0].DESIGNER != '') {
              let respostaDesigner = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"ENTIDADE", 
                      "camposSelect":["NOME"], 
                      "where": ["codcli = '${jsonStr.RESULT[0][0].DESIGNER}'"]}`,
                null
              );
              let jsonStringDesigner = await respostaDesigner.json();
              insereValor(
                $("#txtDesigner"),
                jsonStr.RESULT[0][0].DESIGNER,
                jsonStringDesigner.RESULT[0][0].NOME
              );
            };

            if (jsonStr.RESULT[0][0].CILINDRO != '') {
              let respostaDesigner = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"CILINDRO", 
                      "camposSelect":["DESCRICAO"], 
                      "where": ["CODIGO = '${jsonStr.RESULT[0][0].CILINDRO}'"]}`,
                null
              );
              let jsonStringDesigner = await respostaDesigner.json();
              insereValor(
                $("#txtCilindro"),
                jsonStr.RESULT[0][0].CILINDRO,
                jsonStringDesigner.RESULT[0][0].DESCRICAO
              );
            };

            jsonStr.RESULT[0][0].DT_VALIDADE.substring(0, jsonStr.RESULT[0][0].DT_VALIDADE.indexOf(' '))

            $('#txtDataCad').val(jsonStr.RESULT[0][0].DT_CADASTRO.substring(0, jsonStr.RESULT[0][0].DT_CADASTRO.indexOf(' ')) == '' || jsonStr.RESULT[0][0].DT_CADASTRO.substring(0, jsonStr.RESULT[0][0].DT_CADASTRO.indexOf(' ')) == null ? '1899-12-30' : jsonStr.RESULT[0][0].DT_CADASTRO.substring(0, jsonStr.RESULT[0][0].DT_CADASTRO.indexOf(' ')));
            $('#txtDataVal').val(jsonStr.RESULT[0][0].DT_VALIDADE.substring(0, jsonStr.RESULT[0][0].DT_VALIDADE.indexOf(' ')) == '' || jsonStr.RESULT[0][0].DT_VALIDADE.substring(0, jsonStr.RESULT[0][0].DT_VALIDADE.indexOf(' ')) == null ? '1899-12-30' : jsonStr.RESULT[0][0].DT_VALIDADE.substring(0, jsonStr.RESULT[0][0].DT_VALIDADE.indexOf(' ')));


          } catch (error) {
            console.error(error);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $('#imgFoto').on('click', async function () {
    $('#modalFoto').modal('show');
  });

  $('#txtCor').on('blur', async function () {
    const cor = $(this).val();
    if (cor == '') {
      $('#txtCor').val(await RetornaProximo('CADCOR', 'CADCOR', 'COR', 5));
      $("#txtCor").attr("disabled", true);
    }
  });

  $("#txtCor").on("keypress", function (event) {
    let regex = new RegExp("^[a-zA-Z0-9]+$");
    let key = String.fromCharCode(
      !event.charCode ? event.which : event.charCode
    );
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
  });

  $("#txtCor").change(async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"cadcor", 
                "camposSelect":["cor"], 
                "where": ["cor = '${$("#txtCor").val()}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length > 0) {
          msgAlerta("Cor já cadastrada.");
          $("#txtCor").val("");
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        // converte de hexadecimal pra rgb pra gravar no banco de dados
        let corHexadecimal = $('#inputColorRGB').val();
        corHexadecimal = corHexadecimal.replace('#', '');
        const r = parseInt(corHexadecimal.substring(0, 2), 16);
        const g = parseInt(corHexadecimal.substring(2, 4), 16);
        const b = parseInt(corHexadecimal.substring(4, 6), 16);

        const corRGB = (String(r).length < 3 ? '0' + String(r) : String(r)) + (String(g).length < 3 ? '0' + String(g) : String(g)) + (String(b).length < 3 ? '0' + String(b) : String(b));

        let corClasse = {};

        corClasse.COR = $("#txtCor").val().toUpperCase();
        corClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();
        corClasse.CODIGO2 = $("#txtCodigo2").val().toUpperCase();
        corClasse.GRUPO = pegaChave($("#txtGrupoCor").val(), corClasse.GRUPO);
        corClasse.SUBGRUPO = pegaChave('#txtSubGrupoCor');
        corClasse.CLASSE_COR = pegaChave('#txtClasseComercial');
        corClasse.DESC_ECOMMERCE = $('#txtDescEcommerce').val();
        corClasse.DESC_INFO = $('#txtDescInfo').val();
        corClasse.PANTONE = $('#txtPantone').val();
        corClasse.CLIENTE = pegaChave('#txtCliente');
        corClasse.DESIGNER = pegaChave('#txtDesigner');
        corClasse.CILINDRO = pegaChave('#txtCilindro');
        corClasse.DATA_CAD = $('#txtDataCad').val();
        corClasse.DATA_VAL = $('#txtDataVal').val();
        corClasse.RGB = corRGB;
        corClasse.INATIVO = $('#cbInativo').is(':checked');
        corClasse.TIPO_COR = $('input[name="filtroTipoCor"]:checked').val();
        corClasse.TIPO = $('input[name="filtroTipo"]:checked').val();

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/cadcor?",
          `JSON=${encodeURIComponent(JSON.stringify(corClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(`Cadastro da cor: ${corClasse.DESCRICAO} efetuado com sucesso`, "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/cor`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
