/* eslint-disable prefer-destructuring */
$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([{
      element: ".submenuEntrada",
      popover: {
        title: "Menu Entrada de Nota Fiscal",
        description: "Aqui ficam as abas da entrada de nota, clicando em cada item você poderá acessar os dados.",
        position: "right",
      },
    },
    {
      element: "#dadosGerais",
      popover: {
        title: "Dados Gerais",
        description: "Aqui estão os dados gerais de cadastro.",
        position: "top",
      },
    },
    {
      element: "#botaoImportarXml",
      popover: {
        title: "Importar XML",
        description: "Clique aqui para selecionar um XML e importá-lo.",
        position: "top",
      },
    },
    {
      element: "#txtNotaFiscal",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txtSerie",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txtTpDoc",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txtFornecedor",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txtNatureza",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txtTipoFrete",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txttpMovimentacao",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#txtDeposito",
      popover: {
        title: "Campos Obrigatórios",
        description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
        position: "top",
      },
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description: "Clique aqui para voltar a aba acesso.",
        position: "left",
      },
    },
    {
      element: "#btnGravar",
      popover: {
        title: "Botão Gravar",
        description: "Clique aqui para gravar uma nota fiscal.",
        position: "left",
      },
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let xml;
  let jsonXml;
  let tipoItemCadProd;
  await setarDataAtual('txtDtEmissao');
  await setarDataAtual('txtDtEntrada');
  await setarDataAtual('txtDtConsumoInicial');
  await setarDataAtual('txtDtConsumoFinal');
  await setarDataAtual('txtDtApresentacao');
  await setarDataAtual('txtDtVencimento');

  let estaNaArqLocal = false;
  let tabelasUnificadas = true;
  let empresaRequisicao = getCookie('empresa');
  let bDepositoObrigatorio = false;

  await validaArqLocal();

  function mantemDuasCasasDecimais(valor, quantidadeCaracteres) {
    if (valor.toString().indexOf('.') > -1) {
      return parseFloat(valor.toString().substring(0, valor.toString().indexOf('.') + quantidadeCaracteres));
    }
    return valor;
  };

  //autocompleta produto
  $('#txtGrupoProduto').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtUnidadeProduto').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
  $('#txtUnidadeVendaProduto').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
  $('#txtStatusProduto').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtNCMProduto').autocompleta(1, `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCodigoSpedProduto').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtNaturezaProduto').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
  $('#txtCSTICMSProduto').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCSTIPIEntradaProduto').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCSTIPISaidaProduto').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  //autocompleta material
  $('#txtGrupoMaterial').autocompleta(1, `JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtSubGrupoMaterial').autocompleta(1, `JSON={ "tabela":"subgrupo_ma", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtUnidadeMaterial').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
  $('#txtUnidadeCompraMaterial').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
  $('#txtCodigoSpedMaterial').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCSTICMSEntradaMaterial').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCSTICMSSaidaMaterial').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCSTIPIEntradaMaterial').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtCSTIPISaidaMaterial').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtNaturezaMaterial').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);

  //pesquisa produto
  $('#btnGrupoProduto').pesquisa('#txtGrupoProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo', 'GRUPO_PA');
  $('#btnUnidadeProduto').pesquisa('#txtUnidadeProduto', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
  $('#btnUnidadeVendaProduto').pesquisa('#txtUnidadeVendaProduto', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
  $('#btnStatusProduto').pesquisa('#txtStatusProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Status', 'SITPROD');
  $('#btnNCMProduto').pesquisa('#txtNCMProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa NCM', 'TABFIS');
  $('#btnCodigoSpedProduto').pesquisa('#txtCodigoSpedProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Código SPED', 'TABSPED');
  $('#btnNaturezaProduto').pesquisa('#txtNaturezaProduto', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'NATUREZA');
  $('#btnCSTICMSProduto').pesquisa('#txtCSTICMSProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
  $('#btnCSTIPIEntradaProduto').pesquisa('#txtCSTIPIEntradaProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Saída', 'TABIPI');
  $('#btnCSTIPISaidaProduto').pesquisa('#txtCSTIPISaidaProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Entrada', 'TABIPI');

  //pesquisa material
  $('#btnGrupoMaterial').pesquisa('#txtGrupoMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo', 'GRUPO_MA');
  $('#btnSubGrupoMaterial').pesquisa('#txtSubGrupoMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"subgrupo_ma", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa SubGrupo', 'subgrupo_ma');
  $('#btnUnidadeMaterial').pesquisa('#txtUnidadeMaterial', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
  $('#btnUnidadeCompraMaterial').pesquisa('#txtUnidadeCompraMaterial', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
  $('#btnCodigoSpedMaterial').pesquisa('#txtCodigoSpedMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Código SPED', 'TABSPED');
  $('#btnCSTICMSEntradaMaterial').pesquisa('#txtCSTICMSEntradaMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
  $('#btnCSTICMSSaidaMaterial').pesquisa('#txtCSTICMSSaidaMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
  $('#btnIPIEntradaMaterial').pesquisa('#txtCSTIPIEntradaMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Entrada', 'TABIPI');
  $('#btnIPISaidaMaterial').pesquisa('#txtCSTIPISaidaMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Saída', 'TABIPI');
  $('#btnNaturezaMaterial').pesquisa('#txtNaturezaMaterial', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'NATUREZA');

  //limpa campos produto
  $('#btnLimpaGrupoProduto').on('click', function () {
    $('#txtGrupoProduto').val('');
  });

  $('#btnLimpaUnidadeProduto').on('click', function () {
    $('#txtUnidadeProduto').val('');
  });

  $('#btnLimpaUnidadeVendaProduto').on('click', function () {
    $('#txtUnidadeVendaProduto').val('');
  });

  $('#btnLimpaStatusProduto').on('click', function () {
    $('#txtStatusProduto').val('');
  });

  $('#btnLimpaNCMProduto').on('click', function () {
    $('#txtNCMProduto').val('');
  });

  $('#btnLimpaCodigoSpedProduto').on('click', function () {
    $('#txtCodigoSpedProduto').val('');
  });

  $('#btnLimpaNaturezaProduto').on('click', function () {
    $('#txtNaturezaProduto').val('');
  });

  $('#btnLimpaCSTICMSProduto').on('click', function () {
    $('#txtCSTICMSProduto').val('');
  });

  $('#btnLimpaCSTIPIEntradaProduto').on('click', function () {
    $('#txtCSTIPIEntradaProduto').val('');
  });

  $('#btnLimpaCSTIPISaidaProduto').on('click', function () {
    $('#txtCSTIPISaidaProduto').val('');
  });

  //limpa campos material
  $('#btnLimpaGrupoMaterial').on('click', function () {
    $('#txtGrupoMaterial').val('');
  });

  $('#btnLimpaSubGrupoMaterial').on('click', function () {
    $('#txtSubGrupoMaterial').val('');
  });

  $('#btnLimpaUnidadeMaterial').on('click', function () {
    $('#txtUnidadeMaterial').val('');
  });

  $('#btnLimpaUnidadeCompraMaterial').on('click', function () {
    $('#txtUnidadeCompraMaterial').val('');
  });

  $('#btnLimpaCodigoSpedMaterial').on('click', function () {
    $('#txtCodigoSpedMaterial').val('');
  });

  $('#btnLimpaCSTICMSEntradaMaterial').on('click', function () {
    $('#txtCSTICMSEntradaMaterial').val('');
  });

  $('#btnLimpaCSTICMSSaidaMaterial').on('click', function () {
    $('#txtCSTICMSSaidaMaterial').val('');
  });

  $('#btnLimpaIPIEntradaMaterial').on('click', function () {
    $('#txtCSTIPIEntradaMaterial').val('');
  });

  $('#btnLimpaIPISaidaMaterial').on('click', function () {
    $('#txtCSTIPISaidaMaterial').val('');
  });

  $('#btnLimpaNaturezaMaterial').on('click', function () {
    $('#txtNaturezaMaterial').val('');
  });


  $("#txtSerie").on("input", function () {
    let c = this.selectionStart;
    let r = /[^0-9]/gi;
    let v = $(this).val();
    if (r.test(v)) {
      $(this).val(v.replace(r, ""));
      c--;
    }
    this.setSelectionRange(c, c);
  });

  $("#txtNotaFiscal").on("input", function () {
    let c = this.selectionStart;
    let r = /[^0-9]/gi;
    let v = $(this).val();
    if (r.test(v)) {
      $(this).val(v.replace(r, ""));
      c--;
    }
    this.setSelectionRange(c, c);
  });

  $('#txtTpDoc').change(async function () {
    let tpdoc = pegaChave('#txtTpDoc');
    if (tpdoc == '55' || tpdoc == '57' || tpdoc == '67') {
      $('#nsuEntrada').removeClass('d-none');
      $('#txtDocumentoDiv').removeClass('col-md-6');
      $('#txtDocumentoDiv').addClass('col-md-3');
    } else {
      $('#nsuEntrada').addClass('d-none');
      $('#txtDocumentoDiv').removeClass('col-md-3');
      $('#txtDocumentoDiv').addClass('col-md-6');
    }
  });

  $("#txtNatureza").blur(async function () {
    try {
      let natureza;
      natureza = pegaChave("#txtNatureza", natureza);

      if (natureza == '') {
        $("#financeiroMenu").addClass("d-none");
        $("#luzMenu").addClass("d-none");
        return;
      }

      let responseClasse = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela": "natureza", 
                    "camposSelect":["dupli", "tipo", "mov_est"], 
                    "where":["natureza = '${natureza}'"]}`,
        null
      );
      let jsonStr = await responseClasse.json();
      if (jsonStr.RESULT[0][0].DUPLI == "S") {
        $("#financeiroMenu").removeClass("d-none");
      } else {
        $("#financeiroMenu").addClass("d-none");
        let table = $('#tabelaFinanceiro').DataTable();
        table.clear().draw();
      }
      if (jsonStr.RESULT[0][0].TIPO == "E") {
        $("#luzMenu").removeClass("d-none");
      } else {
        $("#luzMenu").addClass("d-none");
      }

      if (jsonStr.RESULT[0][0].MOV_EST == 'S') {
        $('#txtDeposito').rules('add', 'required');
        bDepositoObrigatorio = true;
      } else {
        $('#txtDeposito').rules('remove', 'required');
      }

    } catch (error) {
      console.error(error);
    }
  });

  jQuery.extend(jQuery.validator.messages, {
    required: "Informe um depósito."
  });

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/entrada_nf`;
  });

  $("#btnCadastrarItens").on("click", async function () {
    let listaItensNovos = [];
    const rows = $('#tabelaVincular').DataTable().rows()[0].length;
    for (let i = 0; i < rows; i++) {
      if ($($(".txtVinculaProduto")[i])[0].dataset.codigo == undefined) {
        listaItensNovos[i] = {
          CODIGO: $($(".txtCodigoFor")[i])[0].value,
          DESCRICAO: $($(".txtDescFor")[i])[0].value,
          PRECO: $($(".txtVinculaProduto")[i])[0].dataset.vun,
          LINHA: i,
        };
      }
    }

    if (listaItensNovos.length == 0) {
      msgAlerta("Sem itens para cadastrar!");
      return;
    }

    montaTabelaItensNovos(listaItensNovos);
    $(".dataTables_scroll").children(".dataTables_scrollHead").children(".dataTables_scrollHeadInner").children(".table.table-sm.table-select.table-hover.dataTable.no-footer").css("width", "1079px");
    $(".dataTables_scroll").children(".dataTables_scrollHead").children(".dataTables_scrollHeadInner").children(".table.table-sm.table-select.table-hover.dataTable.no-footer").children('thead').children('tr').children('th.ajusteTipo.sorting').css('width', '0px');
    $(".dataTables_scroll").children(".dataTables_scrollHead").children(".dataTables_scrollHeadInner").children(".table.table-sm.table-select.table-hover.dataTable.no-footer").children('thead').children('tr').children('th.ajusteItem.sorting').css('width', '736px');
    $(".dataTables_scroll").children(".dataTables_scrollBody").children(".table.table-sm.table-select.table-hover.dataTable.no-footer").children("tbody").children("tr").children("td.ajusteItem").css("width", "985px");
    $("#modalCadastrarItens").modal("show");
  });

  $('#modalCadastrarItens').on('shown.bs.modal', async function () {
    await carregaValoresPadroesCadProduto();
    await carregaValoresPadroesCadMaterial();
  });

  $("#btnCadastrar").on("click", async function () {
    const data = $("#tabelaItensNovos").DataTable().data().toArray();
    const faixa = await buscaValor("FAIXA", "CODIGO", "CODIGO", '00');
    let listaProdutos = [];
    let listaMaterias = [];
    let produtos;
    let materiais;
    let contadorProduto = 0;
    let contadorMaterial = 0;

    try {
      $.LoadingOverlay("show");
      for (let i = 0; i < data.length; i++) {
        if ($($('.rgTipoItem')[i]).val() == '') {
          msgAlerta("Necessário informar o tipo dos itens!");
          return;
        }
      }

      if (faixa == undefined) {
        msgAlerta("Para utilizar essa função, cadastre uma faixa de tamanhos com o código 00 e deverá ter somente o tamanho com código 0 cadastrado.");
        return;
      }

      for (let i = 0; i < data.length; i++) {
        if ($($('.rgTipoItem')[i]).val() == 'P') {
          listaProdutos[contadorProduto] = {
            CODIGO: await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6),
            DESCRICAO: data[i].DESCRICAO,
            PRECO_COM: data[i].PRECO,
            PRECO: data[i].PRECO,
            GRUPO: pegaChave("#txtGrupoProduto"),
            UNIDADE: pegaChave("#txtUnidadeProduto"),
            UNI_VENDA: pegaChave("#txtUnidadeVendaProduto"),
            STATUS: pegaChave("#txtStatusProduto"),
            CODFIS: pegaChave("#txtNCMProduto"),
            CODSPED: pegaChave("#txtCodigoSpedProduto"),
            NATUREZA: pegaChave("#txtNaturezaProduto"),
            CODTRIB: pegaChave("#txtCSTICMSProduto"),
            CODIPI_ENT: pegaChave("#txtCSTIPIEntradaProduto"),
            CODIPI: pegaChave("#txtCSTIPISaidaProduto"),
            ICMS: $("#txtPercentualICMSProduto").val(),
            IPI: $("#txtPercentualIPIProduto").val(),
            TRIBUTACAO: $("#rgTributacaoProduto").val(),
            POSSE: $("#rgPosseProduto").val(),
          }
          contadorProduto++;
        }
      }
      for (let i = 0; i < data.length; i++) {
        if ($($('.rgTipoItem')[i]).val() == 'M') {
          listaMaterias[contadorMaterial] = {
            CODIGO: await RetornaProximo('MATERIAL', 'MATERIAL', 'CODIGO', 6),
            DESCRICAO: data[i].DESCRICAO,
            GRUPO: pegaChave("#txtGrupoMaterial"),
            SUB_GRUPO: pegaChave("#txtSubGrupoMaterial"),
            UNIDADE: pegaChave("#txtUnidadeMaterial"),
            UNI_COM: pegaChave("#txtUnidadeCompraMaterial"),
            CODSPED: pegaChave("#txtCodigoSpedMaterial"),
            CODTRI_ENT: pegaChave("#txtCSTICMSEntradaMaterial"),
            CODTRI: pegaChave("#txtCSTICMSSaidaMaterial"),
            CODIPI_ENT: pegaChave("#txtCSTIPIEntradaMaterial"),
            CODIPI: pegaChave("#txtCSTIPISaidaMaterial"),
            ICMS: $("#txtPercentualICMSMaterial").val(),
            IPI: $("#txtPercentualIPIMaterial").val(),
            NATUREZA: pegaChave("#txtNaturezaMaterial"),
            TRIBUTACAO: $("#rgTributacaoMaterial").val(),
            POSSE: $("#rgPosseMaterial").val(),
          }
          contadorMaterial++;
        }
      }

      if (listaProdutos.length > 0) {
        contadorProduto = 0;

        if ($("#txtGrupoProduto").val() == '') {
          msgAlerta("Grupo do produto não informado, verifique!");
          return;
        }

        if ($("#txtUnidadeProduto").val() == '') {
          msgAlerta("Unidade do produto não informada, verifique!");
          return;
        }

        if ($("#txtUnidadeVendaProduto").val() == '') {
          msgAlerta("Unidade de Venda do produto não informada, verifique!");
          return;
        }

        if ($("#txtStatusProduto").val() == '') {
          msgAlerta("Status do produto não informado, verifique!");
          return;
        }

        if ($("#txtNCMProduto").val() == '') {
          msgAlerta("NCM do produto não informado, verifique!");
          return;
        }

        if ($("#txtCodigoSpedProduto").val() == '') {
          msgAlerta("Código Sped do produto não informado, verifique!");
          return;
        }

        if ($("#txtNaturezaProduto").val() == '') {
          msgAlerta("Natureza do produto não informada, verifique!");
          return;
        }

        if ($("#txtCSTICMSProduto").val() == '') {
          msgAlerta("CST ICMS do produto não informado, verifique!");
          return;
        }

        if ($("#txtCSTIPIEntradaProduto").val() == '' || $("#txtCSTIPISaidaProduto").val() == '') {
          msgAlerta("CST IPI do produto não informado, verifique!");
          return;
        }

        if ($("#rgPosseProduto").val() == '') {
          msgAlerta("Posse do produto não informada, verifique!");
          return;
        }

        produtos = {
          produtosNovos: listaProdutos
        };

      }

      if (listaMaterias.length > 0) {
        contadorMaterial = 0;

        if ($("#txtGrupoMaterial").val() == '') {
          msgAlerta("Grupo do material não informado, verifique!");
          return;
        }

        if ($("#txtSubGrupoMaterial").val() == '') {
          msgAlerta("Sub. Grupo do material não informado, verifique!");
          return;
        }

        if ($("#txtCSTICMSEntradaMaterial").val() == '' || $("#txtCSTICMSSaidaMaterial").val() == '') {
          msgAlerta("CST ICMS do material não informado, verifique!");
          return;
        }

        if ($("#txtCSTIPIEntradaMaterial").val() == '' || $("#txtCSTIPISaidaMaterial").val() == '') {
          msgAlerta("CST IPI do material não informado, verifique!");
          return;
        }

        if ($("#txtCodigoSpedMaterial").val() == '') {
          msgAlerta("Código Sped do material não informado, verifique!");
          return;
        }

        if ($("#txtNaturezaMaterial").val() == '') {
          msgAlerta("Natureza do material não informada, verifique!");
          return;
        }

        if ($("#rgTributacaoMaterial").val() == '') {
          msgAlerta("Tributação do material não informada, verifique!");
          return;
        }

        if ($("#rgPosseMaterial").val() == '') {
          msgAlerta("Posse do material não informada, verifique!");
          return;
        }

        materiais = {
          materiaisNovos: listaMaterias
        }

      }

      const response = await requisicao('POST', '/Sisplan/EntradaNF/v1/cadastra_itens?', '', `LISTAPRODUTO=${encodeURIComponent(JSON.stringify(produtos))}
                                                                                        &LISTAMATERIAL=${encodeURIComponent(JSON.stringify(materiais))}`, 90000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgAlerta("Erro ao cadastrar os itens!");
        return;
      }

      for (let i = 0; i < data.length; i++) {
        if ($($('.rgTipoItem')[i]).val() == 'P') {
          $($(".txtVinculaProduto")[data[i].LINHA]).attr("data-codigo", listaProdutos[contadorProduto].CODIGO);
          $($(".txtVinculaProduto")[data[i].LINHA]).attr("data-descricao", data[i].DESCRICAO);
          $($(".txtVinculaProduto")[data[i].LINHA]).attr("data-tipo", $($('.rgTipoItem')[i]).val());
          $($(".txtVinculaProduto")[data[i].LINHA]).val(`${listaProdutos[contadorProduto].CODIGO}` + ' ' + `${data[i].DESCRICAO}`);
          contadorProduto++;
        } else if ($($('.rgTipoItem')[i]).val() == 'M') {
          $($(".txtVinculaProduto")[data[i].LINHA]).attr("data-codigo", listaMaterias[contadorMaterial].CODIGO);
          $($(".txtVinculaProduto")[data[i].LINHA]).attr("data-descricao", data[i].DESCRICAO);
          $($(".txtVinculaProduto")[data[i].LINHA]).attr("data-tipo", $($('.rgTipoItem')[i]).val());
          $($(".txtVinculaProduto")[data[i].LINHA]).val(`${listaMaterias[contadorMaterial].CODIGO}` + ' ' + `${data[i].DESCRICAO}`);
          contadorMaterial++;
        }
      }

      $("#modalCadastrarItens").modal("hide");

      await criaMensagemSucesso("Itens cadastrados com sucesso!");

    } catch (error) {
      $.LoadingOverlay("hide");
      console.error(error);
      msgErro("Não foi possível cadastrar os itens!");
    } finally {
      $.LoadingOverlay("hide");
    }

  });

  async function montaTabelaItensNovos(listaItens) {

    let listaFormatada = [{}];

    listaItens.map((item, i) => {
      listaFormatada[i] = {
        TIPO: item.TIPO = `
        <select id="rgTipoItem${i}" class="input-default focus custom-select rgTipoItem" style="width: 60px;">
          <option value="" selected></option>
          <option value="P">P</option>
          <option value="M">M</option>
        </select>`,
        ITEM: listaItens[i].CODIGO + ' - ' + listaItens[i].DESCRICAO,
        CODIGO: listaItens[i].CODIGO,
        DESCRICAO: listaItens[i].DESCRICAO,
        LINHA: listaItens[i].LINHA,
        PRECO: parseFloat(listaItens[i].PRECO).toFixed(2),
      };
    });

    listaFormatada = listaFormatada.filter(item => {
      return item != undefined && item != null && item != '' && Object.keys(item).length > 0
    });

    const dataSetCols = [];
    const keys = Object.keys(listaFormatada[0]);
    for (let k in keys) {
      dataSetCols.push({
        data: keys[k],
      });
    }

    $('#tabelaItensNovos').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      scrollX: false,
      scrollY: "350px",
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      data: listaFormatada,
      columns: dataSetCols,
      columnDefs: [
        {
          targets: 1,
          className: "ajusteItem",
        }, {
          targets: 0,
          className: "ajusteTipo",
        },
        {
          targets: [2, 3, 4, 5],
          visible: false,
        }
      ]
    });
  }

  $(`#tabelaVincular`).DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    autoWidth: false,
    destroy: true,
    scrollY: '350px',
    columnDefs: [{
      targets: [0],
      visible: false,
    },],
  });

  $("#fileXml").change(async function (event) {
    event.preventDefault();
    const x2js = new X2JS();
    let readXml = null;
    let selectedFile = document.getElementById("fileXml").files[0];
    let reader = new FileReader();
    reader.onload = async function (e) {
      readXml = e.target.result;
      jsonXml = JSON.parse(JSON.stringify(x2js.xml_str2json(readXml)));
      xml = x2js.json2xml_str(jsonXml);
      await preencheXml(jsonXml);
    };
    reader.readAsText(selectedFile);
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let urlEntrada = parametros[parametros.length - 1];

  // mascara campos
  $("#txtConsumoFaturado").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtValorConsumoFaturado").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtOutrasDespesas").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtValorTerceiros").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtFreteConhecimento").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtFreteNF").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtOutrasDesp").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtDesconto").maskMoney({ decimal: ".", thousands: "", precision: 2 });

  $("#txtValorSTCalc").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtBaseSTCalc").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtBaseST").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtBaseICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtPercICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtOutrasICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtCredSN").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtValorCredSN").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtValorST").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtCST20").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtValorICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtIsentasICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtDifAliq").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtValorDifAliq").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtBaseIPI2").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtPercentIPI").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtValorIPI2").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtBasePIS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtAliquotaPIS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtValorPIS").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtBaseCOFINS3").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtAliquotaCOFINS").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtValorCOFINS2").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtOutrasIPI2").maskMoney({ decimal: ".", thousands: "", precision: 2 });
  $("#txtIsentasIPI").maskMoney({ decimal: ".", thousands: "", precision: 2 });

  $("#txtValordaNF").attr("disabled", "disabled");
  $("#txtBaseICMSISS").attr("disabled", "disabled");
  $("#txtBaseICMSST1").attr("disabled", "disabled");
  $("#txtBaseIPI").attr("disabled", "disabled");
  $("#txtOutrasICMSISS").attr("disabled", "disabled");
  $("#txtValorICMSST").attr("disabled", "disabled");
  $("#txtOutrasIPI").attr("disabled", "disabled");
  $("#txtDifICMSSTRecolher").attr("disabled", "disabled");
  $("#txtIsentoICMSISS").attr("disabled", "disabled");
  $("#txtBaseICMSST2").attr("disabled", "disabled");
  $("#txtIsentoIPI").attr("disabled", "disabled");
  $("#txtValorProdutos").attr("disabled", "disabled");
  $("#txtValorICMSISS").attr("disabled", "disabled");
  $("#txtValorICMSSTCalc").attr("disabled", "disabled");
  $("#txtValorIPI").attr("disabled", "disabled");
  $("#txtValorEstoqueCardex").attr("disabled", "disabled");
  $("#txtBaseCofins").attr("disabled", "disabled");
  $("#txtDiferencialAliquota").attr("disabled", "disabled");
  $("#txtValorCofins").attr("disabled", "disabled");
  $("#txtDiferencialValor").attr("disabled", "disabled");
  $("#txtBasePIS2").attr("disabled", "disabled");
  $("#txtAliqCredSimplesNac").attr("disabled", "disabled");
  $("#txtValorPIS2").attr("disabled", "disabled");
  $("#txtValCredSimplesNac").attr("disabled", "disabled");
  $("#txtPerc").attr("disabled", "disabled");
  $("#txtValor").attr("disabled", "disabled");

  // menu entrada de nota
  $("#dadosGeraisMenu").on("click", function () {
    $("#dadosGerais").removeClass("d-none");
    $("#financeiro").addClass("d-none");
    $("#EnergiaTelefonia").addClass("d-none");
    $("#itensCard").addClass("d-none");
    $("#bases").addClass("d-none");
    $("#dadosAdicionais").addClass("d-none");
    $("#notasReferenciadas").addClass("d-none");

    $("#dadosGeraisMenu").addClass("submenuAtivo");
    $("#basesMenu").removeClass("submenuAtivo");
    $("#financeiroMenu").removeClass("submenuAtivo");
    $("#itensNF").removeClass("submenuAtivo");
    $("#luzMenu").removeClass("submenuAtivo");
    $("#dadosAddMenu").removeClass("submenuAtivo");
    $("#notasReferenciadas").removeClass("submenuAtivo");
  });
  $("#notasRef").on("click", function () {
    if ($("#msform").validate().form()) {
      $("#notasReferenciadas").removeClass("d-none");
      $("#dadosGerais").addClass("d-none");
      $("#financeiro").addClass("d-none");
      $("#EnergiaTelefonia").addClass("d-none");
      $("#itensCard").addClass("d-none");
      $("#bases").addClass("d-none");
      $("#dadosAdicionais").addClass("d-none");

      $("#notasReferenciadas").addClass("submenuAtivo");
      $("#dadosGeraisMenu").removeClass("submenuAtivo");
      $("#basesMenu").removeClass("submenuAtivo");
      $("#financeiroMenu").removeClass("submenuAtivo");
      $("#itensNF").removeClass("submenuAtivo");
      $("#luzMenu").removeClass("submenuAtivo");
      $("#dadosAddMenu").removeClass("submenuAtivo");
    }
  });
  $("#basesMenu").on("click", async function () {
    if ($("#msform").validate().form()) {
      $("#bases").removeClass("d-none");
      $("#financeiro").addClass("d-none");
      $("#itensCard").addClass("d-none");
      $("#EnergiaTelefonia").addClass("d-none");
      $("#dadosGerais").addClass("d-none");
      $("#dadosAdicionais").addClass("d-none");
      $("#notasReferenciadas").addClass("d-none");

      $("#basesMenu").addClass("submenuAtivo");
      $("#dadosGeraisMenu").removeClass("submenuAtivo");
      $("#financeiroMenu").removeClass("submenuAtivo");
      $("#itensNF").removeClass("submenuAtivo");
      $("#luzMenu").removeClass("submenuAtivo");
      $("#dadosAddMenu").removeClass("submenuAtivo");
      $("#notasReferenciadas").removeClass("submenuAtivo");

      try {
        $.LoadingOverlay("show");
        try {
          await verificaItens();
          $("#txtBaseICMSISS").trigger("change");
        } catch {
          msgAlerta('Erro ao verificar itens');
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  });
  $("#financeiroMenu").on("click", async function () {
    if ($("#txtValordaNF").val() == "0.00") {
      if (urlEntrada == "create") {
        try {
          $.LoadingOverlay("show");
          try {
            await verificaItens();

            $("#txtBaseICMSISS").trigger("change");
          } catch {
            msgAlerta('Erro ao verificar itens');
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    }

    if ($("#msform").validate().form()) {
      $("#financeiro").removeClass("d-none");
      $("#dadosGerais").addClass("d-none");
      $("#itensCard").addClass("d-none");
      $("#EnergiaTelefonia").addClass("d-none");
      $("#bases").addClass("d-none");
      $("#dadosAdicionais").addClass("d-none");
      $("#notasReferenciadas").addClass("d-none");

      $("#financeiroMenu").addClass("submenuAtivo");
      $("#basesMenu").removeClass("submenuAtivo");
      $("#itensNF").removeClass("submenuAtivo");
      $("#dadosGeraisMenu").removeClass("submenuAtivo");
      $("#luzMenu").removeClass("submenuAtivo");
      $("#dadosAddMenu").removeClass("submenuAtivo");
      $("#notasReferenciadas").removeClass("submenuAtivo");
    }
  });
  $("#luzMenu").on("click", function () {
    if ($("#msform").validate().form()) {
      $("#EnergiaTelefonia").removeClass("d-none");
      $("#financeiro").addClass("d-none");
      $("#dadosGerais").addClass("d-none");
      $("#bases").addClass("d-none");
      $("#itensCard").addClass("d-none");
      $("#dadosAdicionais").addClass("d-none");
      $("#notasReferenciadas").addClass("d-none");

      $("#luzMenu").addClass("submenuAtivo");
      $("#basesMenu").removeClass("submenuAtivo");
      $("#financeiroMenu").removeClass("submenuAtivo");
      $("#itensNF").removeClass("submenuAtivo");
      $("#dadosGeraisMenu").removeClass("submenuAtivo");
      $("#dadosAddMenu").removeClass("submenuAtivo");
      $("#notasReferenciadas").removeClass("submenuAtivo");
    }
  });
  $("#dadosAddMenu").on("click", function () {
    if ($("#msform").validate().form()) {
      $("#dadosAdicionais").removeClass("d-none");
      $("#financeiro").addClass("d-none");
      $("#itensCard").addClass("d-none");
      $("#EnergiaTelefonia").addClass("d-none");
      $("#bases").addClass("d-none");
      $("#dadosGerais").addClass("d-none");
      $("#notasReferenciadas").addClass("d-none");

      $("#dadosAddMenu").addClass("submenuAtivo");
      $("#basesMenu").removeClass("submenuAtivo");
      $("#financeiroMenu").removeClass("submenuAtivo");
      $("#itensNF").removeClass("submenuAtivo");
      $("#luzMenu").removeClass("submenuAtivo");
      $("#dadosGeraisMenu").removeClass("submenuAtivo");
      $("#notasReferenciadas").removeClass("submenuAtivo");
    }
  });
  $("#itensNF").on("click", function () {
    if ($("#msform").validate().form()) {
      atualizaQtdeTotal();
      atualizaPrecoTotal();
      validaNatureza();
      $("#itensCard").removeClass("d-none");
      $("#dadosAdicionais").addClass("d-none");
      $("#financeiro").addClass("d-none");
      $("#EnergiaTelefonia").addClass("d-none");
      $("#bases").addClass("d-none");
      $("#dadosGerais").addClass("d-none");
      $("#notasReferenciadas").addClass("d-none");

      $("#itensNF").addClass("submenuAtivo");
      $("#dadosAddMenu").removeClass("submenuAtivo");
      $("#basesMenu").removeClass("submenuAtivo");
      $("#financeiroMenu").removeClass("submenuAtivo");
      $("#luzMenu").removeClass("submenuAtivo");
      $("#dadosGeraisMenu").removeClass("submenuAtivo");
      $("#notasReferenciadas").removeClass("submenuAtivo");

      if ($(".txtQtde").val() == "") {
        $(".txtQtde").val("0.00");
      }
      if ($(".txtPreco").val() == "") {
        $(".txtPreco").val("0.00");
      }
      if ($(".txtIPI").val() == "") {
        $(".txtIPI").val("0.00");
      }
      if ($(".txtICMS").val() == "") {
        $(".txtICMS").val("0.00");
      }

      const arrNaturezas = $(".txtCFOP").toArray();
      arrNaturezas.forEach((natureza, i) => {
        const naturezaAtual = $($(".txtCFOP")[i]).val();
        if (['', "[] - '"].includes(naturezaAtual)) {
          $($(".txtCFOP")[i]).val($('#txtNatureza').val());
        }
      });


      $(".txtQtde").maskMoney({ decimal: ".", thousands: "", precision: 2 });
      $(".txtPreco").maskMoney({ decimal: ".", thousands: "", precision: 2 });
      $(".txtIPI").maskMoney({ decimal: ".", thousands: "", precision: 2 });
      $(".txtICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });

      $(".txtNCM").autocompleta(
        1,
        `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
      );
      $(".txtCFOP").autocompleta(
        1,
        `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": ["tp_base = '2'"]}`
      );
    }
  });

  async function buscaNotasReferenciadas(nota, codcli, serie, tipo_fiscal) {
    $.LoadingOverlay('show');
    try {
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"NOTA_REF", 
            "camposSelect":["IND_EMIT EMITENTE", "IND_OPER OPERACAO", "SERIE_REF SERIE", "TIPO_FISCAL_REF TIPO_DOC", "NOTA_REF NOTA", "DATA_REF DT_EMISSAO", "CODCLI_REF CODCLI", "COD_REF CODREF", "VALOR VALOR", "PESO PESO", "VAL_LIQ VAL_LIQ", "CHAVE_NFE CHAVE_NFE"],
            "where": ["CODCLI = '${codcli}'", "SERIE = '${serie}'", "NOTA = '${nota}'", "TIPO_FISCAL = '${tipo_fiscal}'"]}`, null);

      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      jsonStr = jsonStr.RESULT[0];

      criaTabelaNotasRef(jsonStr);
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('.controleFloat').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2
  });

  $('#btnLimpaNotaFiscalNR').on('click', function () {
    $('#txtNotaFiscalNR').val('');
  });

  componenteFiltro('cliente', false, false, 'ClienteNR')
  componenteFiltro('tipo_fiscal', false, false, 'ModeloNR')
  componenteFiltro('info_compl', false, false, 'InfComplNR')

  function adicionaEventosNotaTerceiro() {
    $('#txtNotaFiscalNR').off('autocompleta');
    $('#btnNotaFiscalNR').off('pesquisa_serverside');

    $('#btnNotaFiscalNR').pesquisa_serverside(
      ['#txtNotaFiscalNR', '#txtSerieNR', '#txtChaveNR', '#txtValorNR', '#txtValorLiqNR'],
      ['NOTAFISCAL CHAVE', 'SERIE', 'NSU', 'VALOR', 'VAL_CARDEX',],
      ['NOTAFISCAL DESCRICAO', 'SERIE', 'NSU', 'VALOR', 'VAL_CARDEX'],
      `{"tabela":"NOTA_ENTRA",
      "camposSelect":[ "NOTAFISCAL CHAVE", "NOTAFISCAL DESCRICAO", "SERIE", "NSU", "VALOR", "VAL_CARDEX"],
      "camposSelectSubSelect": ["CHAVE", "DESCRICAO", "SERIE", "NSU", "VALOR", "VAL_CARDEX"],
      "groupBySubSelect": ["CHAVE", "DESCRICAO", "NSU", "SERIE", "VALOR", "VAL_CARDEX"],
      "where": null}`,
      'Pesquisa Nota', finalizaConsultaNF, [undefined, true, true, true, true]);
  }

  adicionaEventosNotaTerceiro();

  function adicionaEventosNotaPropria() {
    $('#txtNotaFiscalNR').off('autocompleta');
    $('#btnNotaFiscalNR').off('pesquisa_serverside');

    $('#btnNotaFiscalNR').pesquisa_serverside(
      ['#txtNotaFiscalNR', '#txtChaveNR', '#txtValorNR', '#txtValorLiqNR', '#txtPesoNR'],
      ['FATURA CHAVE', 'CHAVE_NFE', 'VALOR', 'VALOR VALOR_LIQ', 'PESOL'],
      ['FATURA DESCRICAO', 'CHAVE_NFE', 'VALOR', 'VALOR VALOR_LIQ', 'PESOL'],
      `{"tabela":"NOTA",
      "camposSelect":[ "FATURA CHAVE", "FATURA DESCRICAO", "CHAVE_NFE", "VALOR", "VALOR VALOR_LIQ", "PESOL"],
      "camposSelectSubSelect": ["CHAVE", "DESCRICAO", "CHAVE_NFE", "VALOR", "VALOR_LIQ", "PESOL"],
      "groupBySubSelect": ["CHAVE", "DESCRICAO", "CHAVE_NFE", "VALOR", "VALOR_LIQ", "PESOL"],
      "where": null}`,
      'Pesquisa Nota',
      finalizaConsultaNF,
      [undefined, true, true, true, true]
    );
  }

  $('#btnIncluirNR').on('click', function () {
    $('.classNR').val('');
    habilitaEdicaoNR();
    $('#tabelaNotasNR').DataTable().$('tr.selected').removeClass('selected');
  });

  $('#btnDesistirNR').on('click', function () {
    desabilitaEdicaoNR();
  })

  function habilitaEdicaoNR() {
    $('.classNR').prop('disabled', false);
    $('#btnConfirmarNR').removeClass('d-none');
    $('#btnDesistirNR').removeClass('d-none');
    $('#btnIncluirNR').addClass('d-none');
    $('#btnIncluirInfComplNR').addClass('d-none');
    $('#btnAlterarNR').addClass('d-none');
    $('#btnExcluirNR').addClass('d-none');
    $('#txtEmitenteNR').trigger('change');
  }

  function desabilitaEdicaoNR() {
    $('.classNR').val('');
    $('.classNR').prop('disabled', true);
    $('#btnConfirmarNR').addClass('d-none');
    $('#btnDesistirNR').addClass('d-none');
    $('#btnIncluirNR').removeClass('d-none');
    $('#btnIncluirInfComplNR').removeClass('d-none');
    $('#btnAlterarNR').removeClass('d-none');
    $('#btnExcluirNR').removeClass('d-none');
    $('#tabelaNotasNR').DataTable().$('tr.selected').removeClass('selected');
  }

  async function finalizaConsultaNF() {

    $('#txtValorNR').val($('#txtValorNR').val().replaceAll(',', '.'));
    $('#txtValorLiqNR').val($('#txtValorLiqNR').val().replaceAll(',', '.'));
    $('#txtPesoNR').val($('#txtPesoNR').val().replaceAll(',', '.'));

    if ($('#txtEmitenteNR').val() == '0') {
      const serie = (await buscaValor('EMPRESA', 'EMP_SERIENF', 'EMP_ID', getCookie('emp_id'))).EMP_SERIENF;
      insereValor('#txtSerieNR', serie);
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"NOTA", 
            "camposSelect":["NOTA.DT_EMISSAO", "NOTA.CODCLI", "ENTIDADE.NOME"],
            "leftjoin": [{"tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = ENTIDADE.CODCLI"}],
            "where": ["NOTA.FATURA = '${pegaChave('#txtNotaFiscalNR')}'", "SERIE = '${serie}'"]}`, null);

      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      jsonStr = jsonStr.RESULT[0];

      if (jsonStr.length == 0) {
        return;
      }

      insereValor('#txtClienteNR', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtEmissaoNR', jsonStr[0].DT_EMISSAO);
      insereValor('#txtModeloNR', '55', { tabela: 'TIPO_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: '55' });
    } else {
      const serie = $('#txtSerieNR').val();
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"NOTA_ENTRA", 
            "camposSelect":["NOTA_ENTRA.DT_EMISSAO", "NOTA_ENTRA.CREDOR", "ENTIDADE.NOME", "NOTA_ENTRA.TIPO", "TIPO_FISCAL.DESCRICAO DESC_TIPO"],
            "leftjoin": [{"tabela": "ENTIDADE", "condicao": "NOTA_ENTRA.CREDOR = ENTIDADE.CODCLI"},
                         {"tabela": "TIPO_FISCAL", "condicao": "NOTA_ENTRA.TIPO = TIPO_FISCAL.CODIGO"}],
            "where": ["NOTA_ENTRA.NOTAFISCAL = '${pegaChave('#txtNotaFiscalNR')}'", "SERIE = '${serie}'"]}`, null);

      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      jsonStr = jsonStr.RESULT[0];

      if (jsonStr.length == 0) {
        return;
      }

      insereValor('#txtPesoNR', '0');
      insereValor('#txtClienteNR', jsonStr[0].CREDOR, jsonStr[0].NOME);
      insereValor('#txtEmissaoNR', jsonStr[0].DT_EMISSAO);
      insereValor('#txtModeloNR', jsonStr[0].TIPO, jsonStr[0].DESC_TIPO);
    }
  }

  $('#txtEmitenteNR').on('change', function () {
    if (!$(this).val()) {
      $('#txtNotaFiscalNR').prop('disabled', true);
      $('#btnNotaFiscalNR').prop('disabled', true);
      $('#btnLimpaNotaFiscalNR').prop('disabled', true);
    } else {
      $('#txtNotaFiscalNR').prop('disabled', false);
      $('#btnNotaFiscalNR').prop('disabled', false);
      $('#btnLimpaNotaFiscalNR').prop('disabled', false);
    }

    if ($(this).val() == '0') {
      adicionaEventosNotaPropria();
    } else if ($(this).val() == '1') {
      adicionaEventosNotaTerceiro();
    }
  });

  if ($.fn.DataTable.isDataTable('#tabelaNotasNR')) {
    $('#tabelaNotasNR').DataTable().destroy();
    $('#tabelaNotasNR').empty();
  }

  function criaTabelaNotasRef(info) {
    const cols = [
      {
        data: 'OPERACAO',
        title: 'Operação'
      },
      {
        data: 'EMITENTE',
        title: 'Emitente'
      },
      {
        data: 'CODCLI',
        title: 'Codcli'
      },
      {
        data: 'TIPO_DOC',
        title: 'Tipo Doc.'
      },
      {
        data: 'SERIE',
        title: 'Série'
      },
      {
        data: 'DT_EMISSAO',
        title: 'Emissão'
      },
      {
        data: 'NOTA',
        title: 'Nota'
      },
      {
        data: 'CODREF',
        title: 'Codref'
      },
      {
        data: 'PESO',
        title: 'Peso'
      },
      {
        data: 'VALOR',
        title: 'Valor'
      },
      {
        data: 'VAL_LIQ',
        title: 'Valor Líq.'
      },
      {
        data: 'CHAVE_NFE',
        title: 'Chave NFe'
      }];

    $("#tabelaNotasNR").DataTable({
      sort: true,
      paging: false,
      destroy: true,
      ordering: false,
      lengthChange: false,
      filter: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columnDefs: [
        {
          targets: [9, 10],
          render: function (data) {
            return parseFloat(data).toLocaleString("pt-br", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2,
            });
          },
        },
        {
          targets: [5],
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
        },],
      autoWidth: true,
      data: info,
      columns: cols
    }).draw(false);

    $('#tabelaNotasNR').on('click', 'tr', async function () {
      $.LoadingOverlay('show');
      try {
        $('#tabelaNotasNR').DataTable().$('tr.selected').removeClass('selected');
        const data = $('#tabelaNotasNR').DataTable().row($(this)).data();
        $(this).addClass('selected');
        carregaItemNotasRef(data);
      } finally {
        $.LoadingOverlay('hide');
      }
    });
  };

  $('#btnConfirmarNR').on('click', async function () {
    const obj = {
      OPERACAO: $('#txtOperacaoNR').val(),
      EMITENTE: $('#txtEmitenteNR').val(),
      CODCLI: pegaChave('#txtClienteNR'),
      TIPO_DOC: pegaChave('#txtModeloNR'),
      SERIE: $('#txtSerieNR').val(),
      DT_EMISSAO: $('#txtEmissaoNR').val() != '' ? $('#txtEmissaoNR').val() : '1899-12-31',
      NOTA: pegaChave('#txtNotaFiscalNR'),
      CODREF: pegaChave('#txtInfComplNR'),
      PESO: $('#txtPesoNR').val(),
      VALOR: $('#txtValorNR').val(),
      VAL_LIQ: $('#txtValorLiqNR').val(),
      CHAVE_NFE: $('#txtChaveNR').val()
    };

    await incluiItemNotasRef(obj);
  });

  async function incluiItemNotasRef(data) {
    $.LoadingOverlay('show');
    try {
      if (!data.OPERACAO) {
        msgErro('Tipo de operação não informado. Impossível continuar.', () => { $('#txtOperacaoNR').focus() }, () => { $('#txtOperacaoNR').focus() });
        return;
      }
      const row = $('#tabelaNotasNR').DataTable().row($('tr.selected'));
      if (row.length == 0) {
        if (await Existe('NOTA_REF', ['NOTA_REF', 'SERIE_REF', 'CODCLI_REF', 'TIPO_FISCAL'], [data.NOTA, data.SERIE, data.CODCLI, data.TIPO_DOC])) {
          msgErro('Nota fiscal informada já referenciada. Impossível continuar.', () => { $('#txtNotaFiscalNR').focus() }, () => { $('#txtNotaFiscalNR').focus() });
          return;
        }
      }
      if (!data.EMITENTE) {
        msgErro('Tipo de emitente não informado. Impossível continuar.', () => { $('#txtEmitenteNR').focus() }, () => { $('#txtEmitenteNR').focus() });
        return;
      }

      if (!await Existe('ENTIDADE', ['CODCLI'], [data.CODCLI])) {
        msgErro('Cliente não cadastrado. Impossível continuar.', () => { $('#txtClienteNR').focus() }, () => { $('#txtClienteNR').focus() });
        return;
      }

      if (!await Existe('TIPO_FISCAL', ['CODIGO'], [data.TIPO_DOC])) {
        msgErro('Tipo fiscal não cadastrado. Impossível continuar.', () => { $('#txtClienteNR').focus() }, () => { $('#txtClienteNR').focus() });
        return;
      }

      if (!data.CODREF) {
        msgErro('Informação complementar não cadastrada. Impossível continuar.', () => { $('#txtInfoComplNR').focus() }, () => { $('#txtInfoComplNR').focus() });
        return;
      }

      if (data.CODREF == '57') {
        msgAlerta('Deseja sobrescrever o valor do frete na nota fiscal?', () => { }, () => {
          if (row.length == 1) {
            $('#tabelaNotasNR').DataTable().row($('tr.selected')).data(data).draw(false);
          } else {
            $('#tabelaNotasNR').DataTable().row.add(data).draw(false);
          }
          calculaTotaisNotasRef();
          $('#btnDesistirNR').trigger('click');
        }, () => {
          $('#txtFreteConhecimento').val(data.VAL_LIQ);
          if (row.length == 1) {
            $('#tabelaNotasNR').DataTable().row($('tr.selected')).data(data).draw(false);
          } else {
            $('#tabelaNotasNR').DataTable().row.add(data).draw(false);
          }
          calculaTotaisNotasRef();
          $('#btnDesistirNR').trigger('click');
        })
        return;
      }

      if (row.length == 1) {
        $('#tabelaNotasNR').DataTable().row($('tr.selected')).data(data).draw(false);
      } else {
        $('#tabelaNotasNR').DataTable().row.add(data).draw(false);
      }
      calculaTotaisNotasRef();
      $('#btnDesistirNR').trigger('click');

    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível adicionar o item: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function calculaTotaisNotasRef() {
    try {
      if ($("#tabelaNotasNR").DataTable().rows().count() == 0) {
        $('#txtPesoTotalNR').val('0');
        $('#txtValorTotalNR').val('0');
        $('#txtValorLiqTotalNR').val('0');
        return;
      }

      const peso = $("#tabelaNotasNR").DataTable().column(8).data().toArray().reduce((a, b) => parseFloat(a) + parseFloat(b));
      const valor = $("#tabelaNotasNR").DataTable().column(9).data().toArray().reduce((a, b) => parseFloat(a) + parseFloat(b));
      const valorliq = $("#tabelaNotasNR").DataTable().column(10).data().toArray().reduce((a, b) => parseFloat(a) + parseFloat(b));

      $('#txtPesoTotalNR').val(parseFloat(peso).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));

      $('#txtValorTotalNR').val(parseFloat(valor).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));

      $('#txtValorLiqTotalNR').val(parseFloat(valorliq).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));
    } catch (e) {
      console.log(e);
      $('#txtPesoTotalNR').val('0');
      $('#txtValorTotalNR').val('0');
      $('#txtValorLiqTotalNR').val('0');
    }
  }

  function carregaItemNotasRef(data) {
    $('#txtOperacaoNR').val(data.OPERACAO);
    $('#txtEmitenteNR').val(data.EMITENTE);
    insereValor('#txtNotaFiscalNR', data.NOTA, data.NOTA);
    $('#txtEmissaoNR').val(data.DT_EMISSAO);
    $('#txtChaveNR').val(data.CHAVE_NFE);
    $('#txtSerieNR').val(data.SERIE);
    $('#txtValorNR').val(data.VALOR);
    $('#txtValorLiqNR').val(data.VAL_LIQ);
    $('#txtPesoNR').val(data.PESO);
    insereValor('#txtClienteNR', data.CODCLI, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: data.CODCLI });
    insereValor('#txtModeloNR', data.TIPO_DOC, { tabela: 'TIPO_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.TIPO_DOC });
    insereValor('#txtInfComplNR', data.CODREF, { tabela: 'TABREF', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data.CODREF });
  }

  $('#btnAlterarNR').on('click', function () {
    const row = $('#tabelaNotasNR').DataTable().row($('tr.selected'));

    if (row.length == 0) {
      msgErro('Nenhum registro selecionado. Impossível continuar.');
      return;
    }
    habilitaEdicaoNR();
  });

  $('#btnExcluirNR').on('click', function () {
    const row = $('#tabelaNotasNR').DataTable().row($('tr.selected'));

    if (row.length == 0) {
      msgErro('Nenhum registro selecionado. Impossível continuar.');
      return;
    }

    $('#tabelaNotasNR').DataTable().row(row).remove().draw(false);
    $('.classNR').val('');
    calculaTotaisNotasRef();
  })

  async function validaArqLocal() {
    try {
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"arqlocal", 
                "camposSelect":["arquivo"], 
                "where": ["arquivo = 'NOTA_001'"]}`, null);

      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      estaNaArqLocal = jsonStr.RESULT[0].length > 0;
    } catch (error) {
      console.error(error);
    }
  }

  async function RetornaPagar() {
    let fornecedor = $("#txtFornecedor")
      .val()
      .substring(1, $("#txtFornecedor").val().indexOf("] - "));
    let historico = $("#txtHistorico")
      .val()
      .substring(1, $("#txtHistorico").val().indexOf("] - "));
    let situacao = $("#txtSituacao")
      .val()
      .substring(1, $("#txtSituacao").val().indexOf("] - "));
    let conta = $("#txtConta")
      .val()
      .substring(1, $("#txtConta").val().indexOf("] - "));
    let banco = $("#txtBanco")
      .val()
      .substring(1, $("#txtBanco").val().indexOf("] - "));
    let classe = $("#txtClasseGer")
      .val()
      .substring(1, $("#txtClasseGer").val().indexOf("] - "));
    let table = $("#tabelaFinanceiro").DataTable();
    let data = table.rows().data();
    let arrayPagar = [];

    for (let i = 0; i < data.length; i++) {
      let Pagar = {};

      Pagar.DOCTO = data[i][0];
      Pagar.VALOR = data[i][1];
      Pagar.NUM_AP = data[i][2];
      Pagar.LANCAMENTO = parseInt($("#txtLancamento").val());
      Pagar.DT_EMI = new Date().toISOString().slice(0, 10);
      Pagar.DT_VEN = $(`#txtDataPag-${i}`).val();
      if (Pagar.DT_VEN == '') {
        throw new Error('Necessário informar uma data de vencimento válida no financeiro.');
      }
      if (Pagar.DT_VEN.split("/").length > 1) {
        let guardaArray = Pagar.DT_VEN.split("/");
        Pagar.DT_VEN = `${guardaArray[2]}-${guardaArray[1]}-${guardaArray[0]}`;
      }
      Pagar.DUPLI = data[i][5];
      Pagar.EMP_ID = $("#txtEmpId").val();
      Pagar.STATUS = "DUPL";
      Pagar.QTDEPARCELAS = parseInt($("#txtParcela").val());
      Pagar.CODCRE = fornecedor;
      Pagar.HISTORICO = historico;
      Pagar.SITUACAO = situacao;
      Pagar.NUM_OS = classe;
      Pagar.BANCO = banco;
      Pagar.CONTA = conta;
      Pagar.OBS = $("#txtObsPagar").val();

      arrayPagar.push(Pagar);
    }

    if (arrayPagar == "") {
      return "";
    }
    return arrayPagar;
  }

  async function verificaItens() {
    let table = $("#tabelaAddProduto").DataTable();
    let linha = table.rows()[0].length;

    for (let i = 0; i < linha; i++) {
      data = table.rows().data()[i];

      if ($(".txtProduto")[i].value == "") {
        if (i == 0) {
          msgAlerta("Nenhum produto informado.");
          return false;
        }
        $($(".btn-exclui-Prod")[i]).trigger("click");
      }
    }
    return true;
  }

  async function RetornaItensNF() {
    let table = $("#tabelaAddProduto").DataTable();
    let data = table.rows().data()[0];
    let linha = table.rows()[0].length;

    // let fornecedor = $('#txtFornecedor').val().substring(1, $('#txtFornecedor').val().indexOf('] - '));
    let naturezaServ = $("#txtNaturezaServ")
      .val()
      .substring(1, $("#txtNaturezaServ").val().indexOf("] - "));
    let tpDoc = $("#txtTpDoc")
      .val()
      .substring(1, $("#txtTpDoc").val().indexOf("] - "));
    let tpMovimentacao = $("#txttpMovimentacao")
      .val()
      .substring(1, $("#txttpMovimentacao").val().indexOf("] - "));
    // let deposito = $('#txtDeposito').val().substring(1, $('#txtDeposito').val().indexOf('] - '));

    let arrayItens = [];

    for (let i = 0; i < linha; i++) {
      data = table.rows().data()[i];

      let NFentraItem = {};

      NFentraItem.CODIGO = $($(".txtProduto")[i]).attr("data-codigo");
      NFentraItem.COR = $($(".txtProduto")[i]).attr("data-cor");
      NFentraItem.CLAFIS = pegaChave($(".txtNCM")[i].value, NFentraItem.CLAFIS);
      NFentraItem.CODCRE = pegaChave("#txtFornecedor", NFentraItem.CODCRE);
      NFentraItem.CSOSN = data[61];
      NFentraItem.DEPOSITO = data[62];
      NFentraItem.DESCRICAO = data[63];
      NFentraItem.ESTOQUE = data[64];
      NFentraItem.NUMERO = data[69];
      NFentraItem.NATUREZA = pegaChave($(".txtCFOP")[i].value, NFentraItem.NATUREZA);
      NFentraItem.NATUREZA_ORIG = naturezaServ;
      NFentraItem.VALOR = $(".txtPreco")[i].value;
      NFentraItem.PERC_II = data[65];
      NFentraItem.QTDE = $(".txtQtde")[i].value;
      NFentraItem.SERIE = $("#txtSerie").val();
      NFentraItem.TOTAL = data[67];
      NFentraItem.TIPO = $($(".txtProduto")[i]).attr("data-tipo");
      NFentraItem.ORDEM = i + 1;
      NFentraItem.LOTE = data[26];
      if (NFentraItem.TIPO == 'P') {
        NFentraItem.TAM = $($(".txtProduto")[i]).attr("data-tam");
      }
      NFentraItem.TIPO_DOC = tpDoc;
      NFentraItem.TIPO_MOV = tpMovimentacao;
      NFentraItem.DT_FABRICACAO = data[77] != "" ? data[77] : "1899-12-30";
      NFentraItem.DT_VALIDADE = data[78] != "" ? data[78] : "1899-12-30";

      // FISCAL
      NFentraItem.NUMERO_FCI = data[71];
      NFentraItem.INF_PROD = data[72];

      // ICMS
      NFentraItem.CLATRIB = pegaChave(data[75], NFentraItem.CLATRIB);
      NFentraItem.ALIQ_DIF = data[16];
      NFentraItem.ALIQ_SIMPLES = data[73];
      NFentraItem.BASE_ICMS_ST = data[20];
      NFentraItem.BASE_ICMSST_ENT = data[21];
      NFentraItem.BASE_ICMS = data[22];
      NFentraItem.ISENTA_ICMS = data[25];
      NFentraItem.VLR_ICMS = data[31];
      NFentraItem.VALOR_ICMSST_ENT = data[32];
      NFentraItem.VAL_CRED_SIMPLES = data[33];
      NFentraItem.VAL_ICMS_DIF = data[34];
      NFentraItem.VLR_ICMS_ST = data[35];
      NFentraItem.PERC_ICMS_REDUZ = data[74];
      NFentraItem.ICMS = data[66];
      NFentraItem.OUTRAS_ICMS = data[27];

      // IPI
      NFentraItem.CODIPI = pegaChave(data[24], NFentraItem.CODIPI);
      NFentraItem.PERC_IPI = data[76];
      NFentraItem.BASE_IPI = data[19];
      NFentraItem.VLR_IPI = data[36];
      NFentraItem.OUTRAS_IPI = data[28];
      NFentraItem.ISENTA_IPI = data[23];

      // PIS
      NFentraItem.CLA_PIS = pegaChave(data[57], NFentraItem.CLA_PIS);
      NFentraItem.BASE_PIS = data[18];
      NFentraItem.ALIQ_PIS = data[14];
      NFentraItem.VAL_PIS = data[37];

      // COFINS
      NFentraItem.CLA_COFINS = pegaChave(data[58], NFentraItem.CLA_COFINS);
      NFentraItem.BASE_COFINS = data[17];
      NFentraItem.ALIQ_COFINS = data[13];
      NFentraItem.VAL_COFINS = data[38];

      if (data[79] != "") {
        NFentraItem.MANTER_VALOR = data[79];
      } else {
        NFentraItem.MANTER_VALOR = "N";
      }

      arrayItens.push(NFentraItem);
    }

    return arrayItens;
  }

  $("#txtNotaFiscal, #txtSerie, #txtTpDoc, #txtFornecedor").change(
    async function () {
      await validaExisteNota();
    }
  );

  async function preencheXml(jsonXml) {
    $("#botaoImportarXml").addClass("d-none");
    $("#botaoImportarNotaLabel").addClass("d-none");
    try {
      $.LoadingOverlay("show");
      try {
        let qtdeItens = 0;

        let jsonNotaXml = jsonXml.nfeProc.NFe.infNFe;

        await verificaDestinatario(jsonNotaXml.dest.CNPJ);

        await preencheCapaXml(jsonNotaXml);

        await preencheModalProdutos(jsonNotaXml);

        await preencheTotaisXml(jsonNotaXml);

        await preencheFinanceiroXml(jsonNotaXml);

        $("#btnGravaProdutosModal").click(async function () {
          const buscarTribXml = $('#buscarTribXml').prop('checked');
          let verificaVazio = 0;
          qtdeItens = $(".txtVinculaProduto").length;

          for (let i = 0; i < qtdeItens; i++) {
            if ($($(".txtVinculaProduto")[i]).val() == "") {
              msgAlerta("Algum item da nota ainda não foi vinculado à um código interno, favor verificar.");
              verificaVazio += 1;
            }
          }

          if (verificaVazio == 0) {
            try {
              $.LoadingOverlay("show");

              await gravaCodigoFor();

              await preencheProdutosXml(jsonNotaXml, buscarTribXml);

            } finally {
              $.LoadingOverlay("hide");
            }
          }
        });

        $("#txtNatureza").blur(async function () {
          if ((qtdeItens > 0) && ($("#txtNatureza").val() != '')) {
            $(".txtCFOP").val($("#txtNatureza").val());
          }
          if ((!$('#buscarTribXml').prop('checked')) && ($("#txtNatureza").val() != '')) {
            $('#txtBaseICMSISS').trigger('change');
          }
        });
      } catch (error) {
        console.error(error);
        msgErro('Erro ao ler XML.');
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function verificaDestinatario(cnpjDest) {
    try {
      let empresa = getCookie("empresa");
      let cnpj = cnpjDest.replace(
        /^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
        "$1.$2.$3/$4-$5"
      );

      let responseClasse = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela": "empresa", 
                "camposSelect":["emp_nome"], 
                "where":["emp_pat = '${empresa}' AND emp_cnpj = '${cnpj}'"]}`,
        null
      );
      let jsonStr = await responseClasse.json();

      if (jsonStr.RESULT[0].length == 0) {
        msgAlerta(
          "CNPJ da nota importada não coincide com o CNPJ da empresa logada, favor verifique."
        );
        setTimeout(function () {
          location.reload();
        }, 5000);
      }
    } catch (error) {
      console.error(error);
      msgAlerta("Nota importada não possui um CNPJ, favor verifique.");
      setTimeout(function () {
        location.reload();
      }, 5000);
    }
  }

  async function preencheCapaXml(jsonNotaXml) {
    $("#txtNotaFiscal").val(jsonNotaXml.ide.nNF);
    $("#txtSerie").val(jsonNotaXml.ide.serie);
    $("#txtDtEmissao").val(jsonNotaXml.ide.dhEmi.slice(0, 10));
    $("#txtNSU").val(jsonXml.nfeProc.protNFe.infProt.chNFe);

    // TIPO DOCUMENTO
    try {
      let responseClasse = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"tipo_fiscal", 
                                "camposSelect":["descricao"], 
                                "where": ["codigo = '${jsonNotaXml.ide.mod}'"]}`,
        null
      );

      let jsonStrs = await responseClasse.json();

      insereValor(
        "#txtTpDoc",
        jsonNotaXml.ide.mod,
        jsonStrs.RESULT[0][0].DESCRICAO
      );
    } catch (error) {
      console.error(error);
      msgErro('Erro ao preencher capa da nota.');
    }

    let cnpjPesquisa = jsonNotaXml.emit.CNPJ.replace(
      /^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
      "$1.$2.$3/$4-$5"
    );

    // FORNECEDOR
    try {
      let responseClasse = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"entidade", 
                                "camposSelect":["codcli", "nome"], 
                                "where": ["cnpj = '${cnpjPesquisa}'"]}`,
        null
      );

      let jsonStrs = await responseClasse.json();

      if (jsonStrs.RESULT[0].length == 0) {
        msgAlerta(
          "Cliente não cadastrado, favor cadastrá-lo antes de realizar a entrada de nota fiscal."
        );

        let cliente = [];
        cliente.push(
          jsonNotaXml.emit.CNPJ.replace(
            /^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
            "$1.$2.$3/$4-$5"
          )
        );
        cliente.push(jsonNotaXml.emit.IE);
        cliente.push(jsonNotaXml.emit.xNome);
        cliente.push(jsonNotaXml.emit.xFant);
        cliente.push(jsonNotaXml.emit.enderEmit.CEP);
        cliente.push(jsonNotaXml.emit.enderEmit.xMun);
        cliente.push(jsonNotaXml.emit.enderEmit.UF);
        cliente.push(jsonNotaXml.emit.enderEmit.nro);
        cliente.push(jsonNotaXml.emit.enderEmit.xBairro);
        cliente.push(jsonNotaXml.emit.enderEmit.fone);
        let cliente64 = btoa(cliente);

        setTimeout(function () {
          window.location.href = `${BASE_URI}/cliente/${cliente64}`;
        }, 3000);

        return;
      }

      insereValor(
        "#txtFornecedor",
        jsonStrs.RESULT[0][0].CODCLI,
        jsonStrs.RESULT[0][0].NOME
      );

      $(
        "#txtNomeEmpresa"
      )[0].textContent = `Fornecedor: ${jsonStrs.RESULT[0][0].NOME}`;
      $("#txtCnpjEmpresa")[0].textContent = `CNPJ: ${cnpjPesquisa}`;
      $(
        "#txtIeEmpresa"
      )[0].textContent = `Inscrição Estadual: ${jsonNotaXml.emit.IE}`;
      $(
        "#txtCrtEmpresa"
      )[0].textContent = `Código de Regime Tributário: ${jsonNotaXml.emit.CRT}`;
      $(
        "#txtCepEmpresa"
      )[0].textContent = `CEP: ${jsonNotaXml.emit.enderEmit.CEP}`;
      $(
        "#txtCidadeEmpresa"
      )[0].textContent = `Cidade/UF: ${jsonNotaXml.emit.enderEmit.xMun} - ${jsonNotaXml.emit.enderEmit.UF}`;

      $("#txtNotaFiscal").trigger("change");
    } catch (error) {
      console.error(error);
      msgErro('Erro ao carregar XML.');
    }
  }

  async function gravaCodigoFor() {
    try {
      let qtdeItens = $(".txtVinculaProduto").length;
      let nota = {};
      let arrayItem = [];

      nota.CREDOR = pegaChave("#txtFornecedor", nota.CREDOR);

      for (let i = 0; i < qtdeItens; i++) {
        let produto = {};
        produto.CODIGO = $($(".txtVinculaProduto")[i]).val().split(" ")[0];
        produto.CODIGO_FOR = $($(".txtCodigoFor")[i]).val();
        produto.DESCRICAO = $($(".txtVinculaProduto")[i]).attr('data-descricao')
        produto.TIPO = $($(".txtVinculaProduto")[i]).attr('data-tipo');
        arrayItem.push(produto);
      }
      nota.ITENS = arrayItem;

      let response = await requisicao(
        "POST",
        "/Sisplan/EntradaNF/V1/Codigo_Interno?",
        "",
        `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
        null
      );
      if (response.status != 200) {
        let jsonStr = await response.json();
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
      }
    } catch (error) {
      console.error(error);
    }
  }

  async function preencheModalProdutos(jsonNotaXml) {
    try {
      let qtdeItens = jsonNotaXml.det.length;
      if (qtdeItens == undefined) {
        qtdeItens = 1;
      }

      let nota = {};
      let arrayItem = [];

      nota.CREDOR = pegaChave("#txtFornecedor", nota.CREDOR);

      for (let i = 0; i < qtdeItens; i++) {
        let item;
        if (qtdeItens == 1) {
          item = jsonNotaXml.det;
        } else {
          item = jsonNotaXml.det[i];
        }

        $(`#tabelaVincular`)
          .DataTable()
          .row.add([
            i,
            `
                    <td>
                        <div class="input-group">
                            <input type="text" style="margin-top: 2%; margin-left: 2%" class="input-default focus form-control txtVinculaProduto" name="txtVinculaProduto" class="form-control" placeholder="Produto" data-vUn="${item.prod.vUnCom}" readonly>
                            <input type="text" class="d-none txtCodigoFor" value="${item.prod.cProd}" name="txtCodigoFor" readonly>
                            <input type="text" class="d-none txtDescFor" value="${item.prod.xProd}" name="txtCodigoFor" readonly>
                            <input type="text" class="d-none txtClaFis" value="" name="txtCodigoFor" readonly>
                            <div class="input-group-append">
                                <a class="btn-VincularProduto">
                                    <i class="fas fa-search text-red" style="font-weight: bold;margin-left: 10px;margin-right: 10px;font-size: 18px;"></i>
                                </a>
                            </div>
                            &nbsp&nbsp&nbsp➜&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        </div>
                    </td>
                `,
            `${item.prod.cProd} - ${item.prod.xProd}`,
          ])
          .draw();

        let produto = {};

        produto.CODIGO_FOR = item.prod.cProd;
        // produto.TIPO = "P";
        arrayItem.push(produto);
      }

      nota.ITENS = arrayItem;

      let response = await requisicao(
        "POST",
        "/Sisplan/EntradaNF/V1/Codigo_Interno?",
        "GET=S",
        `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
        null
      );
      let jsonString = await response.json();

      for (let i = 0; i < qtdeItens; i++) {
        let preencheProduto = "";
        let preencheClafis = "";
        let item = jsonString.itens[i];
        if (item.codigo != "") {
          preencheProduto = `${item.codigo} ${item.descricao.replace(
            /-/gi,
            ""
          )} - ${item.cor} ${item.desc_cor}${item.tipo == 'P' ? ` - ${item.tam}` : ''}`;

          $($(".txtVinculaProduto")[i]).attr("data-codigo", item.codigo);
          $($(".txtVinculaProduto")[i]).attr("data-descricao", item.descricao);
          $($(".txtVinculaProduto")[i]).attr("data-cor", item.cor);
          $($(".txtVinculaProduto")[i]).attr("data-tipo", item.tipo);
          if ($($(".txtVinculaProduto")[i]).attr("data-tipo") == 'P') {
            $($(".txtVinculaProduto")[i]).attr("data-tam", item.tam);
          }
        }
        if (item.clafis != "") {
          preencheClafis = `[${item.clafis}] - ${item.desc_clafis}`;
        }
        $($(".txtVinculaProduto")[i]).val(preencheProduto);
        $($(".txtClaFis")[i]).val(preencheClafis);
      }

      $("#modalVincularProdutos").modal("show");

      $(".btn-VincularProduto").click(async function () {
        let linha = $(`#tabelaVincular`)
          .DataTable()
          .row($(this).parents("tr"))
          .data()[0];
        $("#modalProduto").css("z-index", "9999");
        $($(".btn-Produto")[0]).trigger("click");

        $("#modalProduto").on("hidden.bs.modal", function () {
          $($(".txtVinculaProduto")[linha]).val($($(".txtProduto")[0]).val());
          $($(".txtVinculaProduto")[linha]).attr('data-codigo', $($(".txtProduto")[0]).attr('data-codigo'));
          $($(".txtVinculaProduto")[linha]).attr('data-descricao', $($(".txtProduto")[0]).attr('data-descricao'));
          $($(".txtVinculaProduto")[linha]).attr('data-cor', $($(".txtProduto")[0]).attr('data-cor'));
          $($(".txtVinculaProduto")[linha]).attr('data-tipo', $($(".txtProduto")[0]).attr('data-tipo'));
          if ($($(".txtVinculaProduto")[linha]).attr('data-tipo') == 'P') {
            $($(".txtVinculaProduto")[linha]).attr('data-tam', $($(".txtProduto")[0]).attr('data-tam'));
          }
          linha = -1;
        });
      });
    } catch (error) {
      console.error(error);
    }
  }

  async function preencheTotaisXml(jsonNotaXml) {
    let valores = jsonNotaXml.total;

    // TOTAIS
    $("#txtValordaNF").val(ArredondarValor(valores.ICMSTot.vNF, 2));
    $("#txtValorContabilização").val(" ");
    $("#txtFreteConhecimento").val(ArredondarValor(valores.ICMSTot.vFrete, 2));
    $("#txtDesconto").val(ArredondarValor(valores.ICMSTot.vDesc, 2));

    // PRODUTO/MATERIAL
    $("#txtBaseICMSISS").val(valores.ICMSTot.vBC);
    $("#txtBaseICMSST1").val(valores.ICMSTot.vBCST);
    $("#txtBaseIPI").val("0.00");

    $("#txtOutrasICMSISS").val(valores.ICMSTot.vOutro);
    $("#txtValorICMSST").val(valores.ICMSTot.vST);
    $("#txtOutrasIPI").val("0.00");
    $("#txtDifICMSSTRecolher").val("0.00");

    $("#txtIsentoICMSISS").val((valores.ICMSTot.vProd - valores.ICMSTot.vBC).toFixed(2));
    $("#txtBaseICMSST2").val("0.00");
    $("#txtIsentoIPI").val("0.00");
    $("#txtValorProdutos").val(valores.ICMSTot.vProd);

    $("#txtValorICMSISS").val(valores.ICMSTot.vICMS);
    $("#txtValorICMSSTCalc").val("0.00");
    $("#txtValorIPI").val(valores.ICMSTot.vIPI);
    $("#txtValorEstoqueCardex").val(valores.ICMSTot.vNF);

    // GERAL - GERAL
    $("#txtBaseCofins").val("0.00");
    $("#txtDiferencialAliquota").val("0.00");

    $("#txtValorCofins").val("0.00");
    $("#txtDiferencialValor").val("0.00");

    $("#txtBasePIS2").val("0.00");
    $("#txtAliqCredSimplesNac").val("0.00");

    $("#txtValorPIS2").val("0.00");
    $("#txtValCredSimplesNac").val("0.00");

    // GERAL - BENEFÍCIO FISCAL
    $("#txtPerc").val("0.00");
    $("#txtValor").val("0.00");
  }

  async function preencheFinanceiroXml(jsonNotaXml) {
    const FormatoDtNovo = "DD/MM/YYYY";

    if (jsonNotaXml.cobr != undefined) {
      let duplicatas = jsonNotaXml.cobr.dup;
      let qtdeDup = duplicatas.length ? duplicatas.length : 1;

      // eslint-disable-next-line no-shadow
      let table = $("#tabelaFinanceiro").DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true
      });

      if (qtdeDup == 1) {
        duplicatas = [duplicatas];
      }

      for (let i = 0; i < qtdeDup; i++) {
        let dup = duplicatas[i];
        let pagar = {};
        pagar.NOTAFISCAL = $("#txtNotaFiscal").val();
        pagar.VALOR = dup.vDup;
        pagar.NUM_AP = await RetornaProximo("PAGTO", "PAGTO", "NUM_AP", 6);
        pagar.LANCAMENTO = $("#txtLancamento").val();
        pagar.DT_VENCTO = dup.dVenc;
        pagar.DUPLI = `${$("#txtNotaFiscal").val()}-${i + 1}`;

        let GeraDuplicata = [
          pagar.NOTAFISCAL,
          pagar.VALOR,
          pagar.NUM_AP,
          pagar.LANCAMENTO,
          `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataPag-${i}" name="txtDataPag" value="${pagar.DT_VENCTO}"></input>`,
          pagar.DUPLI,
        ];

        table.row.add(GeraDuplicata).draw(false);
      }
    }
  }

  async function preencheProdutosXml(jsonNotaXml, buscarTribXml) {
    try {
      $.LoadingOverlay("show");

      try {
        let qtdeItens = jsonNotaXml.det.length;
        if (qtdeItens == undefined) {
          qtdeItens = 1;
        }
        for (let i = 0; i < qtdeItens; i++) {
          $($(`.addProduto`)[$(`.addProduto`).length - 1]).trigger("click");
          let item;
          if (qtdeItens == 1) {
            item = jsonNotaXml.det;
          } else {
            item = jsonNotaXml.det[i];
          }

          if (buscarTribXml) {
            let data = $("#tabelaAddProduto").DataTable().row(i).data();

            // ICMS
            let defICMS = "";
            if (item.imposto.ICMS) {
              defICMS = Object.keys(item.imposto.ICMS)[0];
              let cstIcms = item.imposto.ICMS[`${defICMS}`].orig + item.imposto.ICMS[`${defICMS}`].CST;

              if (qtdeItens > 100) {
                data[75] = `[${cstIcms}] - CST ICMS`;
              } else {
                let response = await requisicao(
                  "GET",
                  "/Sisplan/Funcoes/v1/pesquisa?",
                  `JSON={ "tabela":"tabtri", "camposSelect":["descricao"], 
                              "where": ["codigo = '${cstIcms}' or codigo = '${cstIcms.substring(1)}'"]}`,
                  null
                );
                let jsonStr = await response.json();
                data[75] = `[${cstIcms}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
              }

              data[22] = item.imposto.ICMS[`${defICMS}`].vBC == undefined ? '0.00' : item.imposto.ICMS[`${defICMS}`].vBC;
              data[66] = isNaN(Number(item.imposto.ICMS[`${defICMS}`].pICMS).toFixed(2)) ? '0.00' : Number(item.imposto.ICMS[`${defICMS}`].pICMS).toFixed(2);
              data[31] = item.imposto.ICMS[`${defICMS}`].vICMS == undefined ? '0.00' : item.imposto.ICMS[`${defICMS}`].vICMS;

            } else {
              data[22] = "";
              data[66] = "";
              data[31] = "";
              data[75] = "";
            }

            data[32] = "0.00";
            data[21] = "0.00";
            data[20] = "0.00";
            data[27] = "0.00";
            data[73] = "0.00";
            data[33] = "0.00";
            data[35] = "0.00";
            data[74] = "0.00";
            data[25] = "0.00";
            data[16] = "0.00";
            data[34] = "0.00";

            // IPI
            let defIPI = "";
            if (item.imposto.IPI) {
              defIPI = Object.keys(item.imposto.IPI)[1];
              if (item.imposto.IPI[`${defIPI}`].vBC != undefined) {
                data[19] = item.imposto.IPI[`${defIPI}`].vBC;
              } else {
                data[19] = "0.00";
              }
              if (item.imposto.IPI[`${defIPI}`].pIPI != undefined) {
                data[76] = Number(item.imposto.IPI[`${defIPI}`].pIPI).toFixed(2);
              } else {
                data[76] = "0.00";
              }
              if (item.imposto.IPI[`${defIPI}`].vIPI != undefined) {
                data[36] = item.imposto.IPI[`${defIPI}`].vIPI;
              } else {
                data[36] = "0.00";
              }
            } else {
              data[19] = "0.00";
              data[76] = "0.00";
              data[36] = "0.00";
            }
            data[24] = "";
            data[28] = "0.00";
            data[23] = "0.00";

            // PIS
            if (item.imposto.PIS) {
              let defPIS = Object.keys(item.imposto.PIS)[0];
              data[18] = item.imposto.PIS[`${defPIS}`].vBC != undefined ? item.imposto.PIS[`${defPIS}`].vBC : '';
              data[14] = Number(item.imposto.PIS[`${defPIS}`].pPIS).toFixed(2);
              data[37] = item.imposto.PIS[`${defPIS}`].vPIS != undefined ? item.imposto.PIS[`${defPIS}`].vPIS : '';
            } else {
              data[18] = "";
              data[14] = "";
              data[37] = "";
            }
            data[57] = "";

            // COFINS
            if (item.imposto.COFINS) {
              let defCOFINS = Object.keys(item.imposto.COFINS)[0];
              data[17] = item.imposto.COFINS[`${defCOFINS}`].vBC != undefined ? item.imposto.COFINS[`${defCOFINS}`].vBC : '';
              data[13] = Number(item.imposto.COFINS[`${defCOFINS}`].pCOFINS).toFixed(2);
              data[38] = item.imposto.COFINS[`${defCOFINS}`].vCOFINS != undefined ? item.imposto.COFINS[`${defCOFINS}`].vCOFINS : '';
            } else {
              data[17] = "";
              data[13] = "";
              data[38] = "";
            }
            data[58] = "";

            // MANTER VALOR DIGITADO
            data[79] = 'S';

            $("#tabelaAddProduto").DataTable().row(i).data(data).draw(false);

            if (item.imposto.IPI) {
              if (item.imposto.IPI[`${defIPI}`].pIPI == undefined) {
                $($(".txtIPI")[i]).val("0.00");
              } else {
                $($(".txtIPI")[i]).val(
                  Number(item.imposto.IPI[`${defIPI}`].pIPI).toFixed(2)
                );
              }
            } else {
              $($(".txtIPI")[i]).val("0.00");
            }

            if (item.imposto.ICMS) {
              if (item.imposto.ICMS[`${defICMS}`].pICMS == undefined) {
                $($(".txtICMS")[i]).val("0.00");
              } else {
                $($(".txtICMS")[i]).val(
                  Number(item.imposto.ICMS[`${defICMS}`].pICMS).toFixed(2)
                );
              }
            } else {
              $($(".txtICMS")[i]).val("0.00");
            }

          }

          $($(".txtProduto")[i]).val($($(".txtVinculaProduto")[i]).val());

          $($(".txtProduto")[i]).attr(
            "data-codigo",
            $($(".txtVinculaProduto")[i]).attr("data-codigo")
          );
          $($(".txtProduto")[i]).attr(
            "data-descricao",
            $($(".txtVinculaProduto")[i]).attr("data-descricao")
          );
          $($(".txtProduto")[i]).attr(
            "data-cor",
            $($(".txtVinculaProduto")[i]).attr("data-cor")
          );
          $($(".txtProduto")[i]).attr(
            "data-tipo",
            $($(".txtVinculaProduto")[i]).attr("data-tipo")
          );
          if ($($(".txtProduto")[i]).attr('data-tipo') == 'P') {
            $($(".txtProduto")[i]).attr(
              "data-tam",
              $($(".txtVinculaProduto")[i]).attr("data-tam")
            );
          }

          $($(".txtNCM")[i]).val($($(".txtClaFis")[i]).val());
          $($(".txtQtde")[i]).val(Number(item.prod.qCom));
          $($(".txtPreco")[i]).val(Number(item.prod.vUnCom));

          $($(`.itemProd`)[i]).html(i + 1);
          $("#chamaLoop").trigger("click");
          desabilitaCampos();
        }
        $("#modalVincularProdutos").modal("hide");
        verificaItens();
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtSerie: {
        required: true,
      },
      txtTpDoc: {
        required: true,
      },
      txtFornecedor: {
        required: true,
      },
      txtTipoFrete: {
        required: true,
      },
      txttpMovimentacao: {
        required: true,
      },
      txtNotaFiscal: {
        required: true,
      },
    },
    messages: {
      txtSerie: {
        required: "Série da nota fiscal não informada.",
      },
      txtTpDoc: {
        required: "Informe o Tipo do Documento.",
      },
      txtFornecedor: {
        required: "Informe um Fornecedor.",
      },
      txtTipoFrete: {
        required: "Informe o Tipo de Frete.",
      },
      txttpMovimentacao: {
        required: "Informe o Tipo de Movimentação.",
      },
      txtNotaFiscal: {
        required: "Informe uma Nota Fiscal.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $("#dadosGeraisMenu").trigger("click");
      $(element).removeClass("is-invalid");
    },
  });

  if (urlEntrada.length == 44) {
    const xml = await buscaValor('XML_NOTAS', ['ARQUIVO'], ['CHAVE_NFE'], [urlEntrada]);

    const responseXml = await requisicao("GET", "/sisplan/entradanf/V1/buscaxmlentrada?", `CHAVE=${urlEntrada}`, null);

    if (!responseXml) {
      return;
    }

    const strXml = await responseXml.text();

    const x2js = new X2JS();
    jsonXml = x2js.xml_str2json(strXml);
    await preencheXml(jsonXml);
  }

  if (urlEntrada != "" && urlEntrada != "create" && (urlEntrada.length != 44)) {
    $("#botaoImportarXml").addClass("d-none");
    $("#botaoImportarNotaLabel").addClass("d-none");

    try {
      $.LoadingOverlay("show");
      try {
        let nota = JSON.parse(atob(urlEntrada));
        let response = await requisicao(
          "GET",
          "/Sisplan/EntradaNF/V1/RetornaDados?",
          `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
          null
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();

        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }

        let dados = jsonStr;

        $("#btn-Fornecedor").attr("disabled", "disabled");
        $("#btn-limpa-Fornecedor").attr("disabled", "disabled");
        $("#txtFornecedor").attr("disabled", "disabled");
        $("#txtNotaFiscal").attr("disabled", "disabled");
        $("#txtSerie").attr("disabled", "disabled");
        $("#txtNSU").attr("disabled", "disabled");
        $("#txttpMovimentacao").attr("disabled", "disabled");
        $("#txtValordaNF").attr("disabled", "disabled");

        // DADOS GERAIS
        $("#txtNotaFiscal").val(dados.notafiscal);
        $("#txtSerie").val(dados.serie);
        $("#txtLancamento").val(dados.lancamento);
        insereValor("#txtTpDoc", dados.tipo, dados.desc_tipo);

        let tpdoc = pegaChave('#txtTpDoc');
        if (tpdoc == '55' || tpdoc == '57' || tpdoc == '67') {
          $('#nsuEntrada').removeClass('d-none');
          $('#txtDocumentoDiv').removeClass('col-md-6');
          $('#txtDocumentoDiv').addClass('col-md-3');
        } else {
          $('#nsuEntrada').addClass('d-none');
          $('#txtDocumentoDiv').removeClass('col-md-3');
          $('#txtDocumentoDiv').addClass('col-md-6');
        }

        insereValor("#txtFornecedor", dados.credor, dados.desc_credor);
        $("#txtDtEmissao").val(dados.dt_emissao.slice(0, 10));
        $("#txtDtEntrada").val(dados.dt_entrada.slice(0, 10));
        if (dados.operacao != 0) {
          insereValor("#txtOperacao", dados.operacao, dados.desc_operacao);
        }
        insereValor("#txtNatureza", dados.natureza, dados.desc_natureza);
        $("#txtDocumento").val(dados.docto);
        $("#txtTipoFrete").val(dados.tp_frete);
        if (dados.deposito != "") {
          insereValor("#txtDeposito", dados.deposito, dados.desc_deposito);
        }
        $("#txtNSU").val(dados.nsu);
        if (dados.nat_servico != "") {
          insereValor(
            "#txtNaturezaServ",
            dados.nat_servico,
            dados.desc_nat_servico
          );
        }
        let natureza;
        natureza = pegaChave("#txtNatureza");

        let responseClasse = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela": "natureza", 
                    "camposSelect":["dupli", "tipo"], 
                    "where":["natureza = '${natureza}'"]}`,
          null
        );
        let jsonStrNat = await responseClasse.json();
        if (jsonStrNat.RESULT[0][0].DUPLI == "S") {
          $("#financeiroMenu").removeClass("d-none");
        } else {
          $("#financeiroMenu").addClass("d-none");
        }
        if (jsonStrNat.RESULT[0][0].TIPO == "E") {
          $("#luzMenu").removeClass("d-none");
        } else {
          $("#luzMenu").addClass("d-none");
        }

        // ITENS
        let precoTotal = 0;
        let qtdeTotal = 0;
        let qtdeItens = dados.itens.length;
        for (let i = 0; i < qtdeItens; i++) {
          $($(`.addProduto`)[$(`.addProduto`).length - 1]).trigger("click");


          let item = dados.itens[i];
          precoTotal = precoTotal + item.valor;
          qtdeTotal = qtdeTotal + item.qtde;

          let table = $("#tabelaAddProduto").DataTable();
          let data = table.row(i).data();

          // FISCAL
          data[71] = item.numero_fci;
          data[72] = item.inf_prod;
          // ICMS
          data[75] = `[${item.clatrib}] - ${item.desc_Clatrib}`;
          data[32] = item.valor_icmsst_ent.toFixed(2);
          data[21] = item.base_icmsst_ent.toFixed(2);
          data[20] = item.base_icms_st.toFixed(2);
          data[22] = item.base_icms.toFixed(2);
          data[66] = item.icms.toFixed(2);
          data[27] = item.outras_icms.toFixed(2);
          data[73] = item.aliq_simples.toFixed(2);
          data[33] = item.val_cred_simples.toFixed(2);
          data[35] = item.vlr_icms_st.toFixed(2);
          data[74] = item.perc_icms_reduz.toFixed(2);
          data[31] = item.vlr_icms.toFixed(2);
          data[25] = item.isenta_icms.toFixed(2);
          data[16] = item.aliq_dif.toFixed(2);
          data[34] = item.val_icms_dif.toFixed(2);
          // IPI
          data[24] = `[${item.codipi}] - ${item.desc_codipi}`;
          data[19] = item.base_ipi.toFixed(2);
          data[76] = item.perc_ipi.toFixed(2);
          data[36] = item.vlr_ipi.toFixed(2);
          data[28] = item.outras_ipi.toFixed(2);
          data[23] = item.isenta_ipi.toFixed(2);
          // PIS
          data[57] = `[${item.cla_pis}] - ${item.desc_cla_pis}`;
          data[18] = item.base_pis.toFixed(2);
          data[14] = item.aliq_pis.toFixed(2);
          data[37] = item.val_pis.toFixed(2);
          // COFINS
          data[58] = `[${item.cla_cofins}] - ${item.desc_cla_cofins}`;
          data[17] = item.base_cofins.toFixed(2);
          data[13] = item.aliq_cofins.toFixed(2);
          data[38] = item.val_cofins.toFixed(2);
          // LOTE
          data[26] = item.lote;
          // DT
          data[77] = item.dt_fabricacao.slice(0, 10);
          data[78] = item.dt_validade.slice(0, 10);
          // MANTER VALOR DIGITADO
          data[79] = "N";

          $("#tabelaAddProduto").DataTable().row(i).data(data).draw(false);

          $($(".txtProduto")[i]).val(
            `${item.codigo} ${item.descricao.replace(/-/gi, "")} - ${item.cor
            } ${item.desc_cor}${item.tipo == 'P' ? ` - ${item.tam}` : ''}${item.lote != '' ? ` - ${item.lote}` : ''}`
          );

          $($(".txtProduto")[i]).attr("data-codigo", item.codigo);
          $($(".txtProduto")[i]).attr("data-descricao", item.descricao);
          $($(".txtProduto")[i]).attr("data-cor", item.cor);
          $($(".txtProduto")[i]).attr("data-tipo", item.tipo);
          if (item.tipo == 'P') {
            $($(".txtProduto")[i]).attr("data-tam", item.tam);
          }

          $($(".txtQtde")[i]).val(item.qtde);
          $($(".txtPreco")[i]).val(item.valor);
          $($(".txtCFOP")[i]).val(`[${item.natureza}] - ${item.desc_natureza}`);
          $($(".txtIPI")[i]).val(item.perc_ipi.toFixed(2));
          $($(".txtICMS")[i]).val(item.icms.toFixed(2));
          $($(".txtNCM")[i]).val(`[${item.clafis}] - ${item.desc_clafis}`);

          $($(`.itemProd`)[i]).html(i + 1);
          $("#chamaLoop").trigger("click");


          atualizaInputTotal(precoTotal, qtdeTotal);
        }

        function atualizaInputTotal() {
          $('#txtPrecoTot').html(mantemDuasCasasDecimais(precoTotal, 3));
          $('#txtQtdeTot').html(mantemDuasCasasDecimais(qtdeTotal, 3));
        }


        // BASES
        $("#txtValordaNF").val(ArredondarValor(dados.valor, 2));
        $("#txtValorContabilização").val(" ");
        $("#txtBaseICMSISS").val(dados.base_icm.toFixed(2));
        $("#txtBaseICMSST1").val(dados.base_icms_st.toFixed(2));
        $("#txtBaseIPI").val(dados.base_ipi.toFixed(2));
        $("#txtOutrasICMSISS").val(dados.outras_icm.toFixed(2));
        $("#txtValorICMSST").val(dados.valor_icms_st.toFixed(2));
        $("#txtOutrasIPI").val(dados.outras_ipi.toFixed(2));
        $("#txtDifICMSSTRecolher").val(dados.val_dif_icmsst.toFixed(2));
        $("#txtIsentoICMSISS").val(dados.isenta_icm.toFixed(2));
        $("#txtBaseICMSST2").val(dados.base_icms_st.toFixed(2));
        $("#txtIsentoIPI").val(dados.isenta_ipi.toFixed(2));
        $("#txtValorProdutos").val(dados.val_produtos.toFixed(2));
        $("#txtValorICMSISS").val(dados.valor_icm.toFixed(2));
        $("#txtValorICMSSTCalc").val(dados.valor_icmsst_ent.toFixed(2));
        $("#txtValorIPI").val(dados.valor_ipi.toFixed(2));
        $("#txtValorEstoqueCardex").val(dados.val_cardex.toFixed(2));
        $("#txtFreteConhecimento").val(dados.frete.toFixed(2));
        $("#txtFreteNF").val(dados.fretenf.toFixed(2));
        $("#txtOutrasDesp").val(dados.despesa.toFixed(2));
        $("#txtDesconto").val(dados.desconto.toFixed(2));
        $("#txtBaseCofins").val(dados.base_cofins.toFixed(2));
        $("#txtDiferencialAliquota").val(dados.aliq_dif.toFixed(2));
        $("#txtValorCofins").val(dados.valor_retcofins.toFixed(2));
        $("#txtDiferencialValor").val(dados.val_icms_dif.toFixed(2));
        $("#txtBasePIS2").val(dados.base_pis.toFixed(2));
        $("#txtAliqCredSimplesNac").val(dados.aliq_simples.toFixed(2));
        $("#txtValorPIS2").val(dados.valor_retpis.toFixed(2));
        $("#txtValCredSimplesNac").val(dados.val_cred_simples.toFixed(2));
        $("#txtPerc").val(dados.perc_benef_fiscal.toFixed(2));
        $("#txtValor").val(dados.valor_benef_fiscal.toFixed(2));

        // FINANCEIRO
        $("#txtParcela1").val(dados.venc_1);
        $("#txtParcela2").val(dados.venc_2);
        $("#txtParcela3").val(dados.venc_3);
        $("#txtParcela4").val(dados.venc_4);
        $("#txtParcela5").val(dados.venc_5);
        $("#txtParcela6").val(dados.venc_6);
        $("#txtParcela7").val(dados.venc_7);
        $("#txtParcela8").val(dados.venc_8);
        $("#txtParcela9").val(dados.venc_9);
        $("#txtParcela10").val(dados.venc_10);
        $("#txtParcela11").val(dados.venc_11);
        $("#txtParcela12").val(dados.venc_12);

        if (dados.pagar != null) {
          let qtdeDuplicatas = dados.pagar.length;
          for (let i = 0; i < qtdeDuplicatas; i++) {
            let duplicata = dados.pagar[i];

            if (i == 0) {
              $("#txtHistorico").val(
                `[${duplicata.historico}] - ${duplicata.desc_historico}`
              );
              $("#txtSituacao").val(
                `[${duplicata.situacao}] - ${duplicata.desc_situacao}`
              );
              $("#txtConta").val(
                `[${duplicata.conta}] - ${duplicata.desc_conta}`
              );
              $("#txtBanco").val(
                `[${duplicata.banco}] - ${duplicata.desc_banco}`
              );
              $("#txtClasseGer").val(
                `[${duplicata.num_os}] - ${duplicata.desc_num_os}`
              );
              $("#txtObsPagar").val(duplicata.obs);
              $("#txtParcela").val(qtdeDuplicatas);
            }

            let table = $("#tabelaFinanceiro").DataTable({
              paging: false,
              filter: false,
              info: false,
              order: false,
              autoWidth: false,
              destroy: true
            });

            let dataCerta = duplicata.dt_ven.slice(0, 10).split("-");
            dataCerta = `${dataCerta[2]}/${dataCerta[1]}/${dataCerta[0]}`;

            let GeraDuplicata = [
              $("#txtNotaFiscal").val(),
              duplicata.valor,
              duplicata.num_ap,
              duplicata.lancamento,
              `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataPag-${i}" name="txtDataPag" value="${duplicata.dt_ven.slice(0, 10)}"></input>`,
              duplicata.dupli,
            ];
            table.row.add(GeraDuplicata).draw(false);
          }
        }

        // ENERGIA / TELEFONIA
        $("#txtNrContaTelefone").val(dados.nr_conta);
        $("#txtDtConsumoInicial").val(dados.dt_inicial_consumo.slice(0, 10));
        $("#txtDtConsumoFinal").val(dados.dt_final_consumo.slice(0, 10));
        $("#txtPeriodoPrestacao").val(dados.periodo);
        $("#txtDtApresentacao").val(dados.dt_apresentacao.slice(0, 10));
        $("#txtDtVencimento").val(dados.dt_vencimento_energi.slice(0, 10));
        $("#txtTipoIdentificador").val(dados.tipo_identificador);
        $("#txtCondParticipante").val(dados.cond_participante);
        $("#txtConsumoFaturado").val(dados.consumo_faturado.toFixed(2));
        $("#txtValorConsumoFaturado").val(dados.valor_consumo.toFixed(2));
        $("#txtOutrasDespesas").val(dados.outras_despe_energia.toFixed(2));
        $("#txtValorTerceiros").val(dados.valor_terc_energia.toFixed(2));
        $("#txtCodigoTarifa").val(dados.cod_tarifa);
        $("#txtClasseConsumo").val(dados.classe_consumo);
        $("#txtTipoLigacao").val(dados.tipo_ligacao);
        $("#TipoAssinante").val(dados.tipo_usuario);
        $("#txtGrupoTensao").val(dados.tipo_tensao);
        $("#txtCodClasseConsumo").val(dados.classe_consumo_comun);

        // DADOS ADICIONAIS
        $("#txtDadosAdicionais").val(dados.dados_adicionais);
        if (dados.nsu != '') {
          try {
            const xml = await buscaValor('XML_NOTAS', 'ARQUIVO', 'CHAVE_NFE', `${dados.nsu}' AND OPERACAO = 'E`);
            if (xml.ARQUIVO != '') {//valida se a entrada foi por xml para desabilitar os campos
              desabilitaCampos();
            }
          } catch (error) {
            console.log(error);
          }
        }

        await buscaNotasReferenciadas($('#txtNotaFiscal').val(), pegaChave('#txtFornecedor'), $('#txtSerie').val(), pegaChave('#txtTpDoc'));
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados da NF: ${error}`);
      }
    } finally {
      $(".btn-exclui-Prod").attr("disabled", "disabled");
      $.LoadingOverlay("hide");
    }
  } else {
    await carregaValoresPadroes();
    criaTabelaNotasRef([]);
  }

  let currentFs;
  let nextFs;
  let previousFs; // fieldsets
  let opacity;

  $(".next").click(function () {
    currentFs = $(this).parent();
    nextFs = $(this).parent().next();
    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
    nextFs.show();
    currentFs.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        currentFs.css({
          display: "none",
          position: "relative",
        });
        nextFs.css({
          opacity,
        });
      },
      duration: 600,
    });
  });

  $(".previous").click(function () {
    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;

        currentFs.css({
          display: "none",
          position: "relative",
        });
        previousFs.css({
          opacity,
        });
      },
      duration: 600,
    });
  });

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $(".collapse")
    .on("shown.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-right")
        .removeClass("fa-angle-right")
        .addClass("fa-angle-down");
    })
    .on("hidden.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });
  $(function () {
    $(".valorMask").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
      allowZero: true,
      defaultZero: true,
    });
  });

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'NOTA_ENTRA'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'NATUREZA': {
          if (item.VALOR != '') {
            insereValor('#txtNatureza', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
          }
          break;
        }
        case 'NAT_SERVICO': {
          if (item.VALOR != '') {
            insereValor('#txtNaturezaServ', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
          }
          break;
        }
        case 'OPERACAO': {
          if (item.VALOR != '') {
            insereValor('#txtOperacao', item.VALOR, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'DEPOSITO': {
          if (item.VALOR != '') {
            insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TP_MOV': {
          if (item.VALOR != '') {
            insereValor('#txttpMovimentacao', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'HISTORICO': {
          if (item.VALOR != '') {
            insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'SITUACAO': {
          if (item.VALOR != '') {
            insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CONTA': {
          if (item.VALOR != '') {
            insereValor('#txtConta', item.VALOR, { tabela: 'CADCONTA', campoBusca: 'CONTA', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'BANCO': {
          if (item.VALOR != '') {
            insereValor('#txtBanco', item.VALOR, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'CLASSE': {
          if (item.VALOR != '') {
            insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TIPO_ITEM': {
          if (item.VALOR != '') {
            tipoItemCadProd = item.VALOR
          }
        }
      }
    });
  };

  async function carregaValoresPadroesCadProduto() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABPADRAO.TABELA = 'PRODUTO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(async item => {
      switch (item.CAMPO) {
        case 'UNIDADE': {
          insereValor('#txtUnidadeProduto', item.VALOR, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR });
          break;
        }
        case 'UNI_VENDA': {
          insereValor('#txtUnidadeVendaProduto', item.VALOR, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR });
          break;
        }
        case 'CODFIS': {
          insereValor('#txtNCMProduto', item.VALOR, { tabela: 'TABFIS', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'ICMS': {
          insereValor('#txtPercentualICMSProduto', item.VALOR);
          break;
        }
        case 'CODTRIB': {
          insereValor('#txtCSTICMSProduto', item.VALOR, { tabela: 'TABTRI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'CODIPI': {
          insereValor('#txtCSTIPISaidaProduto', item.VALOR, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'CODIPI_ENT': {
          insereValor('#txtCSTIPIEntradaProduto', item.VALOR, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'TRIBUTACAO': {
          $('#rgTributacaoProduto').val(item.VALOR).change();
          break;
        }
        case 'IPI': {
          insereValor('#txtPercentualIPIProduto', item.VALOR);
          break;
        }
        case 'STATUS': {
          insereValor('#txtStatusProduto', item.VALOR, { tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'SPED': {
          insereValor('#txtCodigoSpedProduto', item.VALOR, { tabela: 'TABSPED', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'GRUPO_PRODUTO': {
          insereValor('#txtGrupoProduto', item.VALOR, { tabela: 'GRUPO_PA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'NATUREZA': {
          insereValor('#txtNaturezaProduto', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
          break;
        }
        case 'POSSE': {
          $('#rgPosseProduto').val(item.VALOR).change();
          break;
        }
      }

      if (tipoItemCadProd != '') {
        $('.rgTipoItem').val(`${tipoItemCadProd}`)
      }
    });
  };

  async function carregaValoresPadroesCadMaterial() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABPADRAO.TABELA = 'MATERIAL'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(async item => {
      switch (item.CAMPO) {
        case 'UNIDADE': {
          insereValor('#txtUnidadeMaterial', item.VALOR, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR });
          break;
        }
        case 'UNI_COM': {
          insereValor('#txtUnidadeCompraMaterial', item.VALOR, { tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR });
          break;
        }
        case 'CODTRI': {
          insereValor('#txtCSTICMSSaidaMaterial', item.VALOR, { tabela: 'TABTRI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'CODTRI_ENT': {
          insereValor('#txtCSTICMSEntradaMaterial', item.VALOR);
          break;
        }
        case 'CODIPI': {
          insereValor('#txtCSTIPISaidaMaterial', item.VALOR, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'CODIPI_ENT': {
          insereValor('#txtCSTIPIEntradaMaterial', item.VALOR, { tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'IPI': {
          insereValor('#txtPercentualIPIMaterial', item.VALOR);
          break;
        }
        case 'SPED': {
          insereValor('#txtCodigoSpedMaterial', item.VALOR, { tabela: 'TABSPED', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'GRUPO_MA': {
          insereValor('#txtGrupoMaterial', item.VALOR, { tabela: 'GRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'SUBGRUPO_MA': {
          insereValor('#txtSubGrupoMaterial', item.VALOR, { tabela: 'SUBGRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          break;
        }
        case 'POSSE': {
          $('#rgPosseMaterial').val(item.VALOR).change();
          break;
        }
      }

      if (tipoItemCadProd != '') {
        $('.rgTipoItem').val(`${tipoItemCadProd}`)
      }
    });
  };

  async function validaTabelasUnificadas(empId, empPat) {
    try {
      const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"NOTA",
            "camposSelect":["FATURA"],
            "where": ["EMP_ID = '${empId}'"]}&EMPRESA=_${empPat}`, null);
      if ((!response) || (response.status != 200)) {
        return;
      }
      const jsonStr = await response.json();

      if (jsonStr.RESULT[0].length > 0) {
        tabelasUnificadas = false;
      }
    } catch (error) {
      tabelasUnificadas = true;
    }
  }

  $('#txtEmpresa').on('blur', async function () {

    const empresa = pegaChave('#txtEmpresa');

    if (empresa == '') {
      return;
    }

    const empId = await retornaEmpId(empresa);

    await validaTabelasUnificadas(empId, empresa);

    $('#txtNumeroNota').prop('disabled', false);
    $('#btnNumeroNota').prop('disabled', false);
    $('#btnANumeroNota').prop('disabled', false);

    $("#btnNumeroNota").unbind();

    if (tabelasUnificadas) {
      $("#txtNumeroNota").autocompleta(1, `JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA chave", "SERIE descricao"], "where": ["EMP_ID = ${empId}"]}`);
      $("#btnNumeroNota").pesquisa("#txtNumeroNota", "FATURA", "SERIE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE"], "where": ["EMP_ID = ${empId}"]}`, "Pesquisa Nota", "NOTA");
    } else {
      empresaRequisicao = `_${empresa}`;
      $("#txtNumeroNota").autocompleta(1, `JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA chave", "SERIE descricao"], "where": ["EMP_ID = ${empId}"]}`, undefined, undefined, undefined, saidaCampoNota, undefined, empresa);
      $("#btnNumeroNota").pesquisa("#txtNumeroNota", "FATURA", "SERIE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE"], "where": ["EMP_ID = ${empId}"]}`, "Pesquisa Nota", "NOTA", '', saidaCampoNota, empresa);
    }
  });

  async function saidaCampoNota() {
    try {
      const empresa = pegaChave('#txtEmpresa');
      const empId = await retornaEmpId(empresa);
      const docto = pegaChave('#txtNumeroNota');
      const serie = pegaDescricao('#txtNumeroNota');
      const json = await retornaJsonPesquisaPadrao(`{ "tabela":"NOTA_ENTRA", "camposSelect":[ "NOTAFISCAL", "SERIE"], "where": ["NOTAFISCAL = '${docto}' AND SERIE = '${serie}' AND EMP_ID = ${empId}"]}`);

      if (json.length > 0) {
        msgAlerta('Já foi dado entrada para essa nota!');
        return;
      }

    } catch (error) {
      console.error(error);
    }
  }

  async function retornaEmpId(empPat) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    const response = await requisicao('GET', url, `JSON={ "tabela":"EMPRESA", "camposSelect":["EMP_ID"], "where": ["EMP_PAT = '_${empPat}'"]}`, null);
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    return jsonStr.RESULT[0][0].EMP_ID;
  }

  $('#btnImportarNota').on('click', function () {
    $('#modal-importar-nota').modal('show');
  });

  $('#btn-confirmar-nota').on('click', async function () {
    const nota = pegaChave('#txtNumeroNota');
    const empresa = $('#txtEmpresa').val();
    const serie = pegaDescricao('#txtNumeroNota');
    const natureza = $('#txtNaturezaImp').val();
    const buscarTribNota = $('#buscarTribNota').prop('checked');
    const operacao = $('#txtOperacaoImp').val();

    if ((nota == '') || (empresa == '') || (serie == '')) {
      msgAlerta('Favor informar todos os dados para realizar a importação.');
      return;
    }

    if ((natureza == '') && (operacao == '')) {
      msgAlerta('Favor informar natureza ou operação.');
      return;
    }

    if (pegaChave('#txtNaturezaImp') != '') {
      await validaObrigatoriedadeDep(pegaChave('#txtNaturezaImp'));
    }

    await importaNota(nota, serie, `_${pegaChave(empresa)}`, natureza, buscarTribNota, operacao);
  });

  async function validaObrigatoriedadeDep(natureza) {
    const responseClasse = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela": "natureza", 
                  "camposSelect":["mov_est"], 
                  "where":["natureza = '${natureza}'"]}`,
      null
    );
    const jsonStr = await responseClasse.json();

    if (jsonStr.RESULT[0][0].MOV_EST == 'S') {
      $('#txtDeposito').rules('add', 'required');
      bDepositoObrigatorio = true;
    } else {
      $('#txtDeposito').rules('remove', 'required');
    }
  };

  async function importaNota(sNota, sSerie, sEmpresa, sNatureza, buscarTribNota, sOperacao) {
    $.LoadingOverlay('show');
    try {
      const notaEContrSerie = await retornaNotaComEmpId(sNota, sEmpresa);
      let nota = estaNaArqLocal ? notaEContrSerie[0] : sNota;

      let dadosCapa = await retornaCapaNota(nota, sSerie, sEmpresa);

      if (dadosCapa == 'false') {
        nota != sNota ? nota = sNota : nota = nota;
        dadosCapa = await retornaCapaNota(nota, sSerie, sEmpresa);
        if (dadosCapa == 'false') {
          msgAlerta('Nota não encontrada, favor verificar os dados.');
          return;
        }
        dadosCapa.FATURA = nota;
      }
      // else {
      // if (BuscaEmpresaNota().EMP_ID == sEmpresa) {
      // dadosCapa.FATURA = nota.substring(0, nota.length - getCookie(sEmpresa,'emp_id').length);   
      // }
      if (estaNaArqLocal == true) {
        dadosCapa.FATURA = dadosCapa.FATURA.substring(0, dadosCapa.FATURA.length - String(notaEContrSerie[2]).length)
      }
      if (notaEContrSerie[1]) {
        dadosCapa.FATURA = dadosCapa.FATURA.substring(0, dadosCapa.FATURA.length - sSerie.length);
      }
      // }

      async function callback() {
        $.LoadingOverlay('show');
        const dadosItens = await retornaItensNota(nota, sSerie);
        await preencheDadosCapa(dadosCapa, sNatureza, sOperacao, sEmpresa);

        if (!dadosItens[0].QTDE) {
          dadosItens.splice(0, 1);
        }

        await validaExisteNota();
        preencheDadosItens(dadosItens, sNatureza, buscarTribNota);
        if (buscarTribNota) {
          preencheDadosTotais(dadosCapa);
        }
        if (!buscarTribNota) {
          setTimeout(() => {
            $.LoadingOverlay('hide');
            $('#txtBaseICMSISS').trigger('change');
          }, 2000);
        } else {
          $.LoadingOverlay('hide');
        }
      }

      if (await validaSeDestinatarioDiferenteEmpresa(dadosCapa.CODCLI_1)) {
        await msgAlerta("CNPJ do Destinatario é diferente da empresa logada, deseja continuar?",
          () => { senhaSupervisor('', async () => { await callback(); }) },
          () => { });
        return;
      }

      await callback();

    } finally {
      $('#modal-importar-nota').modal('hide');
      $.LoadingOverlay('hide');
    }
  }

  function preencheDadosTotais(dados) {
    $("#txtValordaNF").val(ArredondarValor(dados.VALOR, 2));
    $("#txtValorContabilização").val(" ");

    // PRODUTO/MATERIAL
    $("#txtBaseICMSISS").val(dados.BASE_CALC.toFixed(2));
    $("#txtBaseICMSST1").val(dados.BASE_SUBST.toFixed(2));
    $("#txtBaseIPI").val("0.00");

    $("#txtOutrasICMSISS").val("0.00");
    $("#txtValorICMSST").val(dados.VAL_SUBST.toFixed(2));
    $("#txtOutrasIPI").val("0.00");
    $("#txtDifICMSSTRecolher").val("0.00");

    $("#txtIsentoICMSISS").val((dados.VAL_PRODUTOS - dados.BASE_CALC).toFixed(2));
    $("#txtBaseICMSST2").val("0.00");
    $("#txtIsentoIPI").val("0.00");
    $("#txtValorProdutos").val(dados.VAL_PRODUTOS.toFixed(2));

    $("#txtValorICMSISS").val(dados.VAL_ICMS.toFixed(2));
    $("#txtValorICMSSTCalc").val("0.00");
    $("#txtValorIPI").val(dados.VAL_IPI.toFixed(2));
    $("#txtValorEstoqueCardex").val(dados.VALOR.toFixed(2));

    // GERAL - GERAL
    $("#txtBaseCofins").val("0.00");
    $("#txtDiferencialAliquota").val("0.00");

    $("#txtValorCofins").val("0.00");
    $("#txtDiferencialValor").val("0.00");

    $("#txtBasePIS2").val("0.00");
    $("#txtAliqCredSimplesNac").val("0.00");

    $("#txtValorPIS2").val("0.00");
    $("#txtValCredSimplesNac").val("0.00");

    // GERAL - BENEFÍCIO FISCAL
    $("#txtPerc").val("0.00");
    $("#txtValor").val("0.00");
  }

  function preencheDadosItens(itens, sNatureza, buscarTribNota) {
    itens.map((item, i) => {
      if (item.TIPO == '') {
        return;
      }

      $($(`.addProduto`)[$(`.addProduto`).length - 1]).trigger('click');

      if (buscarTribNota) {
        // DADOS TRIBUTAÇÕES
        let data = $("#tabelaAddProduto").DataTable().row(i).data();
        // FISCAL
        data[71] = '';
        data[72] = item.INFADPROD;
        // ICMS
        data[75] = `[${item.CLA_TRIB}] - CST ICMS`;
        data[32] = item.VALOR_ICMSST.toFixed(2);
        data[21] = item.BASE_ICMSST.toFixed(2);
        data[20] = item.BASE_ICMSST.toFixed(2);
        data[22] = item.BASE_ICMS.toFixed(2);
        data[66] = item.PERC_ICMS.toFixed(2);
        data[27] = item.OUTRAS_ICMS ? item.OUTRAS_ICMS.toFixed(2) : '0.00';
        data[73] = '0.00';
        data[33] = '0.00';
        data[35] = item.VALOR_ICMSST.toFixed(2);
        data[74] = item.PERC_ICMS_REDUZ.toFixed(2);
        data[31] = item.VALOR_ICMS.toFixed(2);
        data[25] = item.ISENTAS_ICMS ? item.ISENTAS_ICMS.toFixed(2) : '0.00';
        data[16] = item.PERC_DIF.toFixed(2);
        data[34] = item.VAL_ICMS_DIF.toFixed(2);
        // IPI
        data[24] = `[${item.CLA_IPI}] - CST IPI`;
        data[19] = item.BASE_IPI.toFixed(2);
        data[76] = item.PERC_IPI.toFixed(2);
        data[36] = item.VALOR_IPI.toFixed(2);
        data[28] = item.OUTRAS_IPI ? item.OUTRAS_IPI.toFixed(2) : '0.00';
        data[23] = item.ISENTAS_IPI ? item.ISENTAS_IPI.toFixed(2) : '0.00';
        // PIS
        data[57] = `[${item.CLA_PIS}] - CST PIS`;
        data[18] = item.BASE_PIS_COFINS.toFixed(2);
        data[14] = item.PERC_PIS.toFixed(2);
        data[37] = item.VALOR_PIS.toFixed(2);
        // COFINS
        data[58] = `[${item.CLA_COFINS}] - CST COFINS`;
        data[17] = item.BASE_PIS_COFINS.toFixed(2);
        data[13] = item.PERC_COFINS.toFixed(2);
        data[38] = item.VALOR_COFINS.toFixed(2);
        // LOTE
        data[26] = item.LOTE;
        // DT
        data[77] = '1899-01-01';
        data[78] = '1899-01-01';
        // MANTER VALOR DIGITADO
        data[79] = "S";
        // FIM DADOS TRIBUTAÇÕES
        $("#tabelaAddProduto").DataTable().row(i).data(data).draw(false);
      } else {
        let data = $("#tabelaAddProduto").DataTable().row(i).data();
        // LOTE
        data[26] = item.LOTE;
        $("#tabelaAddProduto").DataTable().row(i).data(data).draw(false);
      }

      $($('.txtProduto')[i]).removeClass('addProdutoFocus');
      $($('.txtProduto')[i]).val(`${item.CODIGO} ${item.DESCRICAO.replace(/-/gi, '')} - ${item.COR} ${item.DESC_COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}${item.LOTE != '' ? ` - ${item.LOTE}` : ''}`);
      $($('.txtProduto')[i]).attr('data-codigo', item.CODIGO);
      $($('.txtProduto')[i]).attr('data-descricao', item.DESCRICAO);
      $($('.txtProduto')[i]).attr('data-cor', item.COR);
      $($('.txtProduto')[i]).attr('data-tipo', item.TIPO);
      if (item.TIPO == 'P') { $($('.txtProduto')[i]).attr('data-tam', item.TAM); }

      $($('.txtQtde')[i]).val(item.QTDE);
      $($('.txtPreco')[i]).val(item.PRECO);
      $($('.txtCFOP')[i]).val(sNatureza);
      $($('.txtIPI')[i]).val(item.PERC_IPI ? item.PERC_IPI : '0.00');
      $($('.txtICMS')[i]).val(item.PERC_ICMS);
      $($('.txtNCM')[i]).val(`[${item.CLA_FIS}] - CÓDIGO NCM`);

      $('#txtPrecoTot').html($('#txtPrecoTot').val() != '' ? $('#txtPrecoTot').val() + item.PRECO : item.PRECO);
      $('#txtQtdeTot').html($('#txtQtdeTot').val() != '' ? $('#txtQtdeTot').val() + item.QTDE : item.QTDE);

      $($(`.itemProd`)[i]).html(i + 1);
      $('#chamaLoop').trigger('click');
    });
  }

  async function retornaItensNota(sNota, sSerie) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;

      let response = await requisicao('GET', url,
        `JSON={ "tabela":"NOTAITEN", 
        "camposSelect":["NOTAITEN.CODIGO", "NOTAITEN.DESCRICAO", "NOTAITEN.COR", "CADCOR.DESCRICAO DESC_COR", "NOTAITEN.TAMANHO TAM", 
                        "NOTAITEN.TIPO_IT TIPO", "NOTAITEN.PRECO", "NOTAITEN.QTDE", "NOTAITEN.PERC_ICMS", "NOTAITEN.PERC_IPI", "NOTAITEN.INFADPROD",
                        "NOTAITEN.CLA_TRIB", "NOTAITEN.VALOR_ICMSST", "NOTAITEN.BASE_ICMSST", "NOTAITEN.BASE_ICMS", "NOTAITEN.PERC_ICMS", "NOTAITEN.OUTRAS_ICMS", "NOTAITEN.PERC_ICMS_REDUZ", "NOTAITEN.VALOR_ICMS",
                        "NOTAITEN.ISENTAS_ICMS", "NOTAITEN.PERC_DIF", "NOTAITEN.VAL_ICMS_DIF", "NOTAITEN.CLA_IPI", "NOTAITEN.BASE_IPI", "NOTAITEN.PERC_IPI", "NOTAITEN.VALOR_IPI", "NOTAITEN.OUTRAS_IPI", "NOTAITEN.ISENTAS_IPI",
                        "NOTAITEN.CLA_PIS", "NOTAITEN.BASE_PIS_COFINS", "NOTAITEN.PERC_PIS", "NOTAITEN.VALOR_PIS", "NOTAITEN.CLA_COFINS", "NOTAITEN.PERC_COFINS", "NOTAITEN.VALOR_COFINS", "NOTAITEN.CLA_FIS",
                        "NOTAITEN.LOTE"
                      ], 
        "leftJoin": [{"tabela" : "CADCOR", "condicao" : "CADCOR.COR = NOTAITEN.COR"}],
        "where": ["NOTAITEN.FATURA = '${sNota}' AND NOTAITEN.SERIE = '${sSerie}'"]}&EMPRESA=${empresaRequisicao}`, null);

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return jsonStr.RESULT[0].length > 0 ? jsonStr.RESULT[0] : 'false';

    } catch (error) {
      console.error(error);
    }
  }

  async function preencheDadosCapa(capa, sNatureza, sOperacao, sEmpresa) {
    insereValor('#txtOperacao', sOperacao);
    insereValor('#txtNatureza', sNatureza);
    insereValor('#txtNotaFiscal', capa.FATURA);
    insereValor('#txtSerie', capa.SERIE);
    insereValor('#txtNSU', capa.CHAVE_NFE);
    insereValor('#txtEmpPathXml', sEmpresa);
    $('#txtTpDoc').val('[55] - NOTA FISCAL ELETRÔNICA').change();
    insereValor('#txtFornecedor', capa.CODCLI, capa.NOME);
    $('#txtTipoFrete').val(capa.CIF == '0' ? '1' : (capa.CIF == '1' ? '2' : (capa.CIF == '2' ? '3' : (capa.CIF == '3' ? '5' : (capa.CIF == '4' ? '6' : (capa.CIF == '9' ? '4' : capa.CIF)))))).change();
    $('#txtDesconto').val(capa.DESCONTO);
    $('#txtDtEmissao').val(capa.DT_EMISSAO.length > 10 ? capa.DT_EMISSAO.slice(0, 10) : capa.DT_EMISSAO);
    if (sOperacao != '') {
      await retornaDepositoOperacao(pegaChave(sOperacao));
    }
  }

  async function retornaCapaNota(sNota, sSerie, sEmpresa) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;

      const pesquisa = {
        tabela: "NOTA",
        camposSelect: ["NOTA.FATURA", "NOTA.SERIE", "ENTIDADE.CODCLI", "ENTIDADE.NOME", "NOTA.CIF", "NOTA.CHAVE_NFE", "NOTA.BASE_CALC", "NOTA.BASE_IPI",
          "NOTA.BASE_SUBST", "NOTA.DESCONTO", "NOTA.DESPESAS", "NOTA.VALOR", "NOTA.VAL_FRETE", "NOTA.VAL_ICMS", "NOTA.VAL_IPI",
          "NOTA.VAL_PRODUTOS", "NOTA.VAL_SUBST", "NOTA.DT_EMISSAO", "NOTA.CODCLI"],
        leftJoin: [{ "tabela": "EMPRESA", "condicao": "EMPRESA.EMP_ID = NOTA.EMP_ID" },
        { "tabela": "ENTIDADE", "condicao": "ENTIDADE.CNPJ = EMPRESA.EMP_CNPJ" }],
        where: [`NOTA.FATURA = '${sNota}' AND NOTA.SERIE = '${sSerie}' AND EMPRESA.EMP_PAT = '${sEmpresa}'`]
      };
      let response = await requisicao('GET', url,
        `JSON=${JSON.stringify(pesquisa)}&EMPRESA=${empresaRequisicao}`, null);

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return jsonStr.RESULT[0].length > 0 ? jsonStr.RESULT[0][0] : 'false';

    } catch (error) {
      console.error(error);
    }
  }

  async function retornaNotaComEmpId(sNota, sEmpresa) {
    try {
      const url = `/sisplan/funcoes/v1/pesquisa?`;

      let response = await requisicao('GET', url,
        `JSON={ "tabela":"EMPRESA", 
        "camposSelect":["EMP_ID", "EMP_CONTR_SERIE"], 
        "where": ["EMP_PAT = '${sEmpresa}'"]}`, null);

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return [(sNota + jsonStr.RESULT[0][0].EMP_ID), jsonStr.RESULT[0][0].EMP_CONTR_SERIE == 'S', jsonStr.RESULT[0][0].EMP_ID];

    } catch (error) {
      console.error(error);
    }
  }

  $('#txtOperacaoImp').on('blur', function () {
    $('#buscarTribNota').prop('disabled', $('#txtOperacaoImp').val() != '');
  });

  function validaNatureza() {
    let validado = true;
    $('.txtCFOP').map((index) => {
      if ($($('.txtCFOP')[index]).val() == '[] - ' || $($('.txtCFOP')[index]).val() == '') {
        $($('.txtCFOP')[index]).val('');
        validado = false;
      }
    });
    if ($('#txtNatureza').val() == '') {
      validado = false;
    };
    return validado;
  };

  await RetornaDepositoPadrao();

  async function RetornaDepositoPadrao() {
    const empresa = getCookie('g_empresa_logada');
    const pesquisaParam = {
      tabela: 'DEPOSITO',
      camposSelect: ['DEPOSITO.CODIGO, DEPOSITO.DESCRICAO'],
      where: [`DEPOSITO.EMPRESA = '${empresa}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 1) {
      insereValor('#txtDeposito', jsonStr[0].CODIGO, jsonStr[0].DESCRICAO);
    }
  }

  async function validaSeDestinatarioDiferenteEmpresa(codCliDestinatario) {
    const cnpjEmpresaLogada = await buscaValor("EMPRESA", "EMP_CNPJ", "EMP_PAT", getCookie("empresa"));
    const cnpjDestinatario = await buscaValor("ENTIDADE", "CNPJ", "CODCLI", codCliDestinatario);

    return (cnpjDestinatario.CNPJ != cnpjEmpresaLogada.EMP_CNPJ);
  }

  $("#btnGravar").click(async function () {
    try {
      if ($("#tabelaFinanceiro").DataTable().row(0).data() != undefined && ($("#txtNotaFiscal").val() == "" || $("#txtHistorico").val() == "" || $("#txtSituacao").val() == "" || $("#txtConta").val() == "" || $("#txtBanco").val() == "" || $("#txtClasseGer").val() == "")) {
        $("#financeiroMenu").trigger("click");

        if ($("#txtHistorico").val() == "") {
          $("#btn-Historico").trigger("click");
          return;
        }

        if ($("#txtSituacao").val() == "") {
          $("#btn-Situacao").trigger("click");
          return;
        }

        if ($("#txtConta").val() == "") {
          $("#btn-Conta").trigger("click");
          return;
        }

        if ($("#txtBanco").val() == "") {
          $("#btn-Banco").trigger("click");
          return;
        }

        if ($("#txtClasseGer").val() == "") {
          $("#btn-ClasseGer").trigger("click");
          return;
        }
      } else {

        if (!validaNatureza()) {
          msgAlerta('Favor verificar a natureza dos itens e da capa.');
          return;
        }

        if (bDepositoObrigatorio && (pegaValor('#txtDeposito') == '')) {
          msgAlerta('Necessário informar um depósito.');
          return;
        }

        if ($("#txtNotaFiscal").val() == "") {
          throw msgAlerta("Necessário informar uma nota fiscal.");
        }

        if ($("#financeiroMenu").hasClass("d-none")) {
          let table = $('#tabelaFinanceiro').DataTable();
          table.clear().draw();
        }

        $.LoadingOverlay("show");
        try {
          let fornecedor = $("#txtFornecedor").val().substring(1, $("#txtFornecedor").val().indexOf("] - "));
          let natureza = $("#txtNatureza").val().substring(1, $("#txtNatureza").val().indexOf("] - "));
          let naturezaServ = $("#txtNaturezaServ").val().substring(1, $("#txtNaturezaServ").val().indexOf("] - "));
          let tpDoc = $("#txtTpDoc").val().substring(1, $("#txtTpDoc").val().indexOf("] - "));
          let deposito = $("#txtDeposito").val().substring(1, $("#txtDeposito").val().indexOf("] - "));
          let pathXml = pegaValor('#txtEmpPathXml');
          let entrada = {};

          entrada.ALIQ_DIF = parseFloat($("#txtDiferencialAliquota").val());
          entrada.ALIQ_SIMPLES = parseFloat($("#txtAliqCredSimplesNac").val());
          entrada.BASE_ICMS_ST = parseFloat($("#txtBaseICMSST1").val());
          entrada.BASE_PIS = parseFloat($("#txtBasePIS2").val());
          entrada.BASE_COFINS = parseFloat($("#txtBaseCofins").val());
          entrada.BASE_INSS = parseFloat($("#txtBaseINSS").val());
          entrada.BASE_IPI = parseFloat($("#txtBaseIPI").val());
          entrada.BASE_ICM = parseFloat($("#txtBaseICMSISS").val());
          entrada.BASE_ICMSST_ENT = parseFloat($("#txtBaseICMSST2").val());
          entrada.BASE_RETPIS = parseFloat($("#txtBasePIS2").val());
          entrada.CREDOR = fornecedor;
          entrada.CLASSE_CONSUMO = $("#txtClasseConsumo").val();
          entrada.CLASSE_CONSUMO_COMUN = $("#txtCodClasseConsumo").val();
          entrada.COD_TARIFA = $("#txtCodigoTarifa").val();
          entrada.COND_PARTICIPANTE = $("#txtCondParticipante").val();
          entrada.CONSUMO_FATURADO = $("#txtConsumoFaturado").val();
          entrada.COFINS = parseFloat($("#txtValorCofins").val());
          entrada.DADOS_ADICIONAIS = $("#txtDadosAdicionais").val();
          entrada.DT_APRESENTACAO = $("#txtDtApresentacao").val();
          entrada.DT_INICIAL_CONSUMO = $("#txtDtConsumoInicial").val();
          entrada.DT_FINAL_CONSUMO = $("#txtDtConsumoFinal").val();
          entrada.DT_VENCIMENTO_ENERGI = $("#txtDtVencimentoEnergia").val();
          entrada.DT_ENTRADA = $("#txtDtEntrada").val();
          entrada.DT_EMISSAO = $("#txtDtEmissao").val();
          entrada.DESPESA = $("#txtOutrasDesp").val();
          entrada.DESCONTO = $("#txtDesconto").val();
          entrada.DEPOSITO = deposito;
          entrada.DOCTO = $('#txtDocumento').val();
          entrada.FRETE = $("#txtFreteConhecimento").val();
          entrada.FRETENF = $("#txtFreteNF").val();
          entrada.GRUPO = pegaChave("#txtClasseGer");
          entrada.ISENTA_ICM = $("#txtIsentoICMSISS").val();
          entrada.ISENTA_IPI = $("#txtIsentoIPI").val();
          entrada.LANCAMENTO = parseInt($("#txtLancamento").val());
          entrada.NSU = $("#txtNSU").val();
          entrada.NR_CONTA = $("#txtNrContaTelefone").val();
          entrada.NATUREZA = natureza;
          entrada.NAT_SERVICO = naturezaServ;
          entrada.NOTAFISCAL = $("#txtNotaFiscal").val();
          entrada.OUTRAS_DESPE_ENERGIA = parseFloat($("#txtOutrasDespesas").val());
          entrada.OUTRAS_ICM = parseFloat($("#txtOutrasICMSISS").val());
          entrada.OUTRAS_IPI = parseFloat($("#txtOutrasIPI").val());
          entrada.PIS = parseFloat($("#txtValorPIS2").val());
          entrada.PERC_BENEF_FISCAL = parseFloat($("#txtPerc").val());
          entrada.OBRA = $("#txtObra").val();
          entrada.OPERACAO = pegaChave("#txtOperacao", entrada.OPERACAO);
          entrada.PERIODO = $("#txtPeriodoPrestacao").val();
          entrada.REGIME = '0';
          entrada.SERIE = $("#txtSerie").val();
          entrada.TIPO = tpDoc;
          entrada.TP_FRETE = $("#txtTipoFrete").val();
          entrada.TP_MOV = pegaChave("#txttpMovimentacao", entrada.TP_MOV);
          entrada.TIPO_LIGACAO = $("#txtTipoLigacao").val();
          entrada.TIPO_TENSAO = $("#txtGrupoTensao").val();
          entrada.TIPO_USUARIO = $("#TipoAssinante").val();
          entrada.TIPO_IDENTIFICADOR = $("#txtTipoIdentificador").val();
          entrada.USUARIO = getCookie('usuario');
          entrada.VALOR = parseFloat($("#txtValor").val());
          entrada.VAL_PRODUTOS = parseFloat($("#txtValorProdutos").val());
          entrada.VALOR_IPI = parseFloat($("#txtValorIPI").val());
          entrada.VALOR_ICMS_ST = parseFloat($("#txtValorICMSST").val());
          entrada.VALOR_RETPIS = parseFloat($("#txtValorPIS2").val());
          entrada.VALOR_RETCOFINS = parseFloat($("#txtValorCofins2").val());
          entrada.VALOR_PCC = parseFloat($("#txtValorCSRFPCC").val());
          entrada.VALOR_IRRF = parseFloat($("#txtValorIRRF").val());
          entrada.VALOR_CSLL = parseFloat($("#txtValorCSLL").val());
          entrada.VAL_ICMS_DIF = parseFloat($("#txtBaseICMSST1").val());
          entrada.VALOR_ISS = parseFloat($("#txtValorISS").val());
          entrada.VALOR_INSS = parseFloat($("#txtValorINSS").val());
          entrada.VALOR_CONSUMO = parseFloat($("#txtValorConsumoFaturado").val());
          entrada.VALOR_TERC_ENERGIA = parseFloat($("#txtValorTerceiros").val());
          entrada.VALOR_ICM = parseFloat($("#txtValorICMSISS").val());
          entrada.VALOR_ICMSST_ENT = parseFloat($("#txtValorICMSSTCalc").val());
          entrada.VAL_DIF_ICMSST = parseFloat($("#txtDifICMSSTRecolher").val());
          entrada.VALOR_BENEF_FISCAL = parseFloat($("#txtValor").val());
          entrada.VAL_CRED_SIMPLES = parseFloat($("#txtValCredSimplesNac").val());
          entrada.EMP_ID = parseFloat($("#txtEmpId").val());
          entrada.RASCUNHO = 'N';

          entrada.VENC_1 = $("#txtParcela1").val();
          entrada.VENC_2 = $("#txtParcela2").val();
          entrada.VENC_3 = $("#txtParcela3").val();
          entrada.VENC_4 = $("#txtParcela4").val();
          entrada.VENC_5 = $("#txtParcela5").val();
          entrada.VENC_6 = $("#txtParcela6").val();
          entrada.VENC_7 = $("#txtParcela7").val();
          entrada.VENC_8 = $("#txtParcela8").val();
          entrada.VENC_9 = $("#txtParcela9").val();
          entrada.VENC_10 = $("#txtParcela10").val();
          entrada.VENC_11 = $("#txtParcela11").val();
          entrada.VENC_12 = $("#txtParcela12").val();

          entrada.CONDICAO =
            ($("#txtParcela1").val() != '' ? parseInt($("#txtParcela1").val()) : 0) +
            ($("#txtParcela2").val() != '' ? parseInt($("#txtParcela2").val()) : 0) +
            ($("#txtParcela3").val() != '' ? parseInt($("#txtParcela3").val()) : 0) +
            ($("#txtParcela4").val() != '' ? parseInt($("#txtParcela4").val()) : 0) +
            ($("#txtParcela5").val() != '' ? parseInt($("#txtParcela5").val()) : 0) +
            ($("#txtParcela6").val() != '' ? parseInt($("#txtParcela6").val()) : 0) +
            ($("#txtParcela7").val() != '' ? parseInt($("#txtParcela7").val()) : 0) +
            ($("#txtParcela8").val() != '' ? parseInt($("#txtParcela8").val()) : 0) +
            ($("#txtParcela9").val() != '' ? parseInt($("#txtParcela9").val()) : 0) +
            ($("#txtParcela10").val() != '' ? parseInt($("#txtParcela10").val()) : 0) +
            ($("#txtParcela11").val() != '' ? parseInt($("#txtParcela11").val()) : 0) +
            ($("#txtParcela12").val() != '' ? parseInt($("#txtParcela12").val()) : 0);

          if (await verificaItens()) {

            entrada.ITENS = await RetornaItensNF();
            let pagar = await RetornaPagar();
            if (pagar != "") {
              entrada.PAGAR = pagar;
            } else if (!$("#financeiroMenu").hasClass("d-none")) {
              msgAlerta("Natureza configurada para gerar duplicatas e nenhuma foi gerada, favor verificar.");
              $("#financeiroMenu").trigger("click");
              return;
            }

            entrada.NOTASREF = $('#tabelaNotasNR').DataTable().data().toArray();

            let response = await requisicao(urlEntrada != "create" ? "PUT" : "POST", "/Sisplan/EntradaNF/V1/EntradaNF?", `EMPRESA=${getCookie('empresa')}&PATHXML=${pathXml}`, `&JSON=${encodeURIComponent(JSON.stringify(entrada))}&XML=${encodeURIComponent(JSON.stringify(xml))}`, 180000);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return;
            }
            $.LoadingOverlay("hide");
            toastr
              .success("Cadastro efetuado com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                  error: "alert-error",
                  info: "alert-info",
                  success: "alert-success",
                  warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                  window.location.href = `${BASE_URI}/entrada_nf`;
                  $("#btnInicio").trigger("click");
                },
              })
              .css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
              });
          };
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível gravar a EntradaNF. ${error}`);
        }
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function retornaDepositoOperacao(sOperacao) {
    const pesquisaParam = {
      tabela: 'OPER_FISCAL',
      camposSelect: ['OPER_FISCAL.DEPOSITO_ENTRADA, DEPOSITO.DESCRICAO'],
      where: [`OPER_FISCAL.CODIGO = '${sOperacao}'`],
      innerJoin: [{ tabela: "DEPOSITO", condicao: "DEPOSITO.CODIGO = OPER_FISCAL.DEPOSITO_ENTRADA" }]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 1) {
      insereValor('#txtDeposito', jsonStr[0].DEPOSITO_ENTRADA, jsonStr[0].DESCRICAO);
    }
  }

  function atualizaQtdeTotal() {
    let qtdeTotal = 0;
    $('.txtQtde').map(index => {
      if ($($('.txtQtde')[index]).val() > 0) {
        qtdeTotal += parseFloat($($('.txtQtde')[index]).val());
      }
    });

    $('#txtQtdeTot').html(qtdeTotal);
  }

  function atualizaPrecoTotal() {
    let precoTotal = 0;
    $('.txtPreco').map(index => {
      if ($($('.txtPreco')[index]).val() > 0) {
        precoTotal += (parseFloat($($('.txtPreco')[index]).val()) * parseFloat($($('.txtQtde')[index]).val()));
      }
    });

    $('#txtPrecoTot').html(precoTotal.toFixed(2));
  }

  async function validaExisteNota() {
    try {
      if (
        $("#txtNotaFiscal").val() != "" &&
        $("#txtSerie").val() != "" &&
        $("#txtTpDoc").val() != "" &&
        $("#txtFornecedor").val() != ""
      ) {
        let nota = $("#txtNotaFiscal").val();
        let serie = $("#txtSerie").val();
        let tpdoc;
        tpdoc = pegaChave("#txtTpDoc");
        let codcre;
        codcre = pegaChave("#txtFornecedor");

        let responseClasse = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela": "NOTA_ENTRA", 
              "camposSelect":["notafiscal"], 
              "where":["notafiscal = '${nota}' AND serie = '${serie}' AND tipo = '${tpdoc}' AND credor = '${codcre}'"]}`,
          null
        );
        let jsonStr = await responseClasse.json();

        if (jsonStr.RESULT[0].length != 0) {
          msgAlerta("Nota fiscal já importada, favor verifique.");
          setTimeout(function () {
            location.reload();
          }, 3000);
        }
      }
    } catch (error) {
      console.error(error);
    }
  }

  function desabilitaCampos() {
    const table = $("#tabelaAddProduto").DataTable();
    const linha = table.rows()[0].length;
    for (let i = 0; i < linha; i++) {
      $($(".btn-exclui-Prod")[i]).prop("disabled", true);
      $($(".addProduto")[i]).prop("disabled", true);
      $($(".txtQtde")[i]).prop("disabled", true);
      $($(".txtPreco")[i]).prop("disabled", true);
    }
  }

});