$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#totalclientes",
        popover: {
          title: "Total de Clientes",
          description: "Aqui você poderá ver seu número total de clientes.",
          position: "right",
        },
      },
      {
        element: "#totalativos",
        popover: {
          title: "Clientes Ativos",
          description: "Aqui você poderá ver a quantidade de clientes ativos.",
          position: "right",
        },
      },
      {
        element: "#totalbloqueados",
        popover: {
          title: "Clientes Bloqueados",
          description:
            "Aqui você poderá ver a quantidade de clientes bloqueados.",
          position: "left",
        },
      },
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta dos clientes/fornecedores.",
          position: "right",
        },
      },
      {
        element: "#btn-novoClientes",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um cliente/fornecedor.",
          position: "right",
        },
      },
      {
        element: "#tabelaClientesForne",
        popover: {
          title: "Tabela Clientes/Fornecedores",
          description: "Aqui estão os dados dos clientes/fornecedores.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ENTIDADE");
  const buscaRegiao = await CopiaParametro('VENDA', 77);

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btn-novoClientes").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cliente/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  componenteFiltro("entidade", true);
  componenteFiltro("representante", true);
  componenteFiltro("grupoCli", true);
  componenteFiltro("situacao", true);
  componenteFiltro("historico", true);
  componenteFiltro("classe", true);
  componenteFiltro("perfil", true);
  componenteFiltro("ramoAtividade", true);
  componenteFiltro("regEstado", true);
  componenteFiltro("regFrete", true);
  componenteFiltro("tabPreco", true);
  componenteFiltro("transportadora", true);
  if (await apenasClientesVinculadosAoRepresentante()) {
    await bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentante', '#btnRepresentante', '#btnLimpaRepresentante');
  }

  if (buscaRegiao == '1') {
    await preencheRegiao('#txtRegEstado');
  }

  $("#tabelaClientes").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaClientes').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'ENTIDADE');
  });

  $("#tabelaClientes").on('click', "#btnMapa", async function () {
    const data = $('#tabelaClientes').DataTable().row($(this).parents('tr')).data();
    const codcli = data[0];
    await buscaEndereco(codcli);
  });

  async function buscaEndereco(codcli) {
    const url = "/Sisplan/Funcoes/v1/pesquisa?";
    try {
      const pesquisa = {
        tabela: 'ENTIDADE',
        camposSelect: ['ENTIDADE.CODCLI', 'ENTIDADE.ENDERECO', 'ENTIDADE.NUM_ENT', 'CIDADE.NOME', 'CIDADE.COD_UF'],
        leftJoin: [{ tabela: 'CADCEP', condicao: 'CADCEP.CEP = ENTIDADE.CEP' },
        { tabela: 'CIDADE', condicao: 'CIDADE.CODIGO = CADCEP.CODMUN' }],
        where: [`ENTIDADE.CODCLI = '${codcli}'`]
      }

      const response = await requisicao("GET", url, `JSON=${JSON.stringify(pesquisa)}`);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        return error;
      }
      jsonStr = await response.json();
      const endereco = jsonStr.RESULT[0][0].ENDERECO;
      const numero = jsonStr.RESULT[0][0].NUM_ENT;
      const cidade = jsonStr.RESULT[0][0].NOME;
      const estado = jsonStr.RESULT[0][0].COD_UF;

      window.open(
        `http://maps.google.com.br/maps?q=${endereco + ',' + numero},${cidade}-${estado}`,
        '_blank' // <- This is what makes it open in a new window.
      );

    } catch (error) {
      console.error(error);
    }
  }

  async function atualizaTotais() {
    let url = "/Sisplan/Funcoes/v1/pesquisa?";
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"entidade", 
                "camposSelect":["count(codcli) CODCLI", "count(CASE WHEN ATIVO = 'S' THEN 1 ELSE null end) ATIVO", "count(CASE WHEN bloqueio = 'S' THEN 1 ELSE NULL end) BLOQUEIO"], 
                "where": ["1=1"] }`
      );
      if (!response) {
        return;
      }
      if (response.status != 200) {
        return error;
      }
      jsonStr = await response.json();
      $("#txt_val_total").html(jsonStr.RESULT[0][0].CODCLI);
      $("#txt_val_ativos").html(jsonStr.RESULT[0][0].ATIVO);
      $("#txt_val_bloqueados").html(jsonStr.RESULT[0][0].BLOQUEIO);
    } catch (error) {
      console.error(error);
    }
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      `    <button class="dropdown-item" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout Cliente.FR3"' : 'title="Imprimir"' }id="btn-imprimir">Imprimir</button>     ` +
      '    <button class="dropdown-item"" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
      '    <button class="dropdown-item"" title="Mapa" id="btnMapa">Mapa</button>     ' +
      '</div>';
    return retorno;
  };

  await consultaClientes();
  atualizaTotais();

  $("#tabelaClientes").on("click", "#btn-imprimir", async function () {
    try {
      $.LoadingOverlay("show");

      let data = $("#tabelaClientes")
        .DataTable()
        .row($(this).parents("tr"))
        .data();
      let url = `/sisplan/impressao/v1/cliente?codcli=${data[0]}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('Cliente');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Cliente');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnConsultar").on("click", async function () {
    await consultaClientes(true);
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtDataDe").val("1200-01-01");
    $("#txtDataAniverDe").val("1200-01-01");
    $("#txtDataAte").val("2500-12-01");
    $("#txtDataAniverAte").val("2500-12-01");
    $("#txtAtivo").val("");
    $("#txtBloqueado").val("");
    $('#txtEntidade').empty().trigger('change');
    if (!$('#txtRepresentante').attr('disabled')) {
      $('#txtRepresentante').empty().trigger('change');
    }
    $('#txtGrupoCli').empty().trigger('change');
    $('#txtSituacao').empty().trigger('change');
    $('#txtHistorico').empty().trigger('change');
    $('#txtClasse').empty().trigger('change');
    $('#txtPerfil').empty().trigger('change');
    $('#txtRamoAtividade').empty().trigger('change');
    $('#txtRegEstado').empty().trigger('change');
    $('#txtRegFrete').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#txtTransportadora').empty().trigger('change');

  });

  async function consultaClientes() {
    try {
      // let response;
      $.LoadingOverlay("show");

      const formataParams = async (txt, nomeColuna) => {
        const listaFiltro = await formataListas($(txt).val().toString());
        return listaFiltro === "" ? "" : `AND ${nomeColuna} IN (${listaFiltro})`;
      };

      const formataDataParams = (dataDe, dataAte, colunaTabela) =>
        dataDe !== "1200-01-01" || dataAte !== "2500-12-31"
          ? ` and ${colunaTabela} >= '${dataDe}' and ${colunaTabela} <= '${dataAte}'`
          : '';

      let params = '[" 1=1 ';

      const dataCadastro = formataDataParams(
        $("#txtDataDe").val(),
        $("#txtDataAte").val(),
        "DATA_CAD"
      );

      const dataAniver = formataDataParams(
        $("#txtDataAniverDe").val(),
        $("#txtDataAniverAte").val(),
        "DT_NASC"
      );

      params += await formataParams("#txtEntidade", "CODCLI");
      params += await formataParams("#txtAtivo", "ATIVO");
      params += await formataParams("#txtBloqueado", "BLOQUEIO");
      params += await formataParams("#txtGrupoCli", "GRUPO");
      params += await formataParams("#txtRepresentante", "CODREP");
      params += await formataParams("#txtSituacao", "SIT_DUP");
      params += await formataParams("#txtHistorico", "HISTORICO");
      params += await formataParams("#txtClasse", "CLASSE");
      params += await formataParams("#txtPerfil", "PERFIL");
      params += await formataParams("#txtRamoAtividade", "SIT_CLI");
      params += await formataParams("#txtRegEstado", "REG_ESTADO");
      params += await formataParams("#txtRegFrete", "FRETE");
      params += await formataParams("#txtTabPreco", "TABELA");
      params += await formataParams("#txtTransportadora", "TRANSPORTE");
      params += dataCadastro;
      params += dataAniver;
      params += ' "]';
      // params = `["1=1 ${codcliente}, ${ativo}, ${bloqueado}, ${dataCadastro == "" ? "" : dataCadastro}, ${dataAniver == "" ? "" : dataAniver} "]`;

      $("#tabelaClientes").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ", "ATIVO" ], "where": ${params == "" ? "null" : params}}`,
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
        ],
      });
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível buscar os dados do cliente: ${error}`);
    }
  }

  $("#tabelaClientes").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClientes")
        .DataTable()
        .row($(this).parents("tr"))
        .data();
      let clienteLiberado = await liberarRegistro("ENTIDADE", data[0]);
      if (clienteLiberado) {
        window.location.href = `cliente/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaClientes").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClientes").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("ENTIDADE", data[0]);
      if (clienteLiberado) {
        window.location.href = `cliente/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  // $("input[type='search']").on("keydown", function () {
  //   if (window.event.which === 13) {
  //     $("#btn-editar").trigger("click");
  //   }
  // });

  $("#tabelaClientes").on("click", "#btnExcluir", async function () {
    $.LoadingOverlay("show");
    try {
      if (permissaoUsuarioLogado.EXCLUI == "S") {
        const data = $("#tabelaClientes").DataTable().row($(this).parents("tr")).data();
        await deletaEntidade(data[0]);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  async function deletaEntidade(codcli) {
    try {
      const response = await requisicao("DELETE", "/Sisplan/Cliente/V1/Entidade?", `CODCLI=${codcli}`);

      if (!response) {
        throw msgAlerta("Não foi possível deletar a entidade, tente novamente.");
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        throw msgAlerta(jsonStr.mensagem);
      } else {
        criaMensagemSucesso(`Entidade ${codcli} deletada com sucesso.`, () => { window.location.reload() });
      }

    } catch (error) {
      console.log(error);
    }
  }

});
