$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaMarca',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma marca.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaMarca',
                popover: {
                    title: 'Tabela Marcas',
                    description: 'Aqui estão os dados das marca cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CADSERVICO");

    $('#cbRecalcular').on('click', function () {
        $('#cbRecalcular').is(':checked') ? $('#divRecalculo').removeClass('d-none') : $('#divRecalculo').addClass('d-none')
    })

    // autocompleta
    $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    // pesquisa
    $('#btnCodigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Serviço', 'SERVICO');
    $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo', 'GRUPO_MA');
    // limpacampo
    $('#btnLimpaCodigo').on('click', function () {
        $('#txtCodigo').val('');
    });
    $('#btnLimpaGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtCodigo').val('');
        $('#txtGrupo').val('');
        $('#txtComplemento').val('');
        $('#rgTodas').click()
    });

    $('#btnNovoServico').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadservico/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };
    await consultaServico();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaServico(true);
    });

    async function consultaServico(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response = '';
            let servico = '';
            servico += pegaChave('#txtCodigo') != '' ? ` AND CODIGO = '${pegaChave('#txtCodigo')}'` : '';
            servico += pegaChave('#txtGrupo') != '' ? ` AND GRUPO = '${pegaChave('#txtGrupo')}'` : '';
            servico += $('#txtComplemento').val() != '' ? ` AND COMPLEMENTO LIKE ('[PERCENTUAL]${$('#txtComplemento').val()}[PERCENTUAL]')` : '';
            servico += $('input[name="opcoesRadio"]:checked').val() != '' ? ` AND SIT_TRIB = '${$('input[name="opcoesRadio"]:checked').val()}'` : '';
            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["1=1 ${servico}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', null);
            }

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaServico').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#tabelaServico').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaServico').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CADSERVICO', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadservico/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaServico tbody').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaServico').DataTable().row(this).data();
            let registroLiberado = await verificarRegistro('CADSERVICO', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadservico/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaServico').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaServico").DataTable().row($(this).parents("tr")).data()
                await excluiRegistro(data.CODIGO);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function validaExclusao(data) {
        let servico = '';
        servico = await buscaValor('NF_ENTRA_ITEN', 'CODIGO', 'CODIGO', data);
        if (!!servico) {
            throw msgAlerta('Serviço sendo usado na Entrada de Nota Fiscal');
        }
        servico = await buscaValor('OS_ITEN', 'CODIGO', 'CODIGO', data);
        if (!!servico) {
            throw msgAlerta('Serviço sendo usado na Ordem de Serviço');
        }
    }

    async function excluiRegistro(data) {
        await validaExclusao(data)
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/servico?", `CODIGO=${encodeURIComponent(data)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadservico`;
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});