$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CADCUPOMDESCONTO");


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  consultaCupons();

  $("#btn-filtros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $('#btnConsultar').trigger('click');


  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaCupons(true);
  });

  $('#btnNovoCupom').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cadcupomdesconto/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('CADCUPOMDESCONTO', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/cadcupomdesconto`;
  });

  $('#btn-limpa-codigo').on('click', function () {
    $('#txtCodigo').val('');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtCodigo').val('');
    $('#dtInicio').val('1200-01-01');
    $('#dtFim').val('2500-12-31');
  });

  $('#btn-codigo-filtro').pesquisa_serverside(['#txtCodigo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CUPOMDESCONTO", "camposSelect":[ "CODIGO", "DESCRICAO", "DT_INICIO", "DT_FINAL"], "where": null}', 'Pesquisa Cupom');
  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"CUPOMDESCONTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  async function consultaCupons(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      const dtInicio = "'" + $('#dtInicio').val() + "'";
      const dtFim = "'" + $('#dtFim').val() + "'";
      let cupom = pegaChave('#txtCodigo') != '' ? ` AND CODIGO = '${pegaChave('#txtCodigo')}'` : '';
      if (bBotao) {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CUPOMDESCONTO", "camposSelect":["CODIGO", "DESCRICAO", "COALESCE(PERC_DESC,0) PERC_DESC", "COALESCE(VALOR,0) VALOR_DESC", "DT_INICIO", "DT_FINAL", "QUANTIDADE", "(SELECT COUNT(*) FROM [VENDA] VENDA WHERE VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO) QUANTIDADE_UTILIZADA"], "where": ["(DT_INICIO >= ${dtInicio} and DT_FINAL <= ${dtFim}) ${cupom}"]}`, null); //(dt_emissao >= ${dtCadastroDe} and dt_emissao <= ${dtCadastroAte})
      } else {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"CUPOMDESCONTO", "camposSelect":["CODIGO", "DESCRICAO", "COALESCE(PERC_DESC,0) PERC_DESC", "COALESCE(VALOR,0) VALOR_DESC", "DT_INICIO", "DT_FINAL", "QUANTIDADE", "(SELECT COUNT(*) FROM [VENDA] VENDA WHERE VENDA.CUPOM_DESCONTO = CUPOMDESCONTO.CODIGO) QUANTIDADE_UTILIZADA"], "where": null, "limit": 10000}', null);
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaCupom').DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [{
          "data": "CODIGO"
        },
        {
          "data": "DESCRICAO"
        },
        {
          "data": "PERC_DESC"
        },
        {
          "data": "VALOR_DESC"
        },
        {
          "data": "DT_INICIO"
        },
        {
          "data": "DT_FINAL"
        },
        {
          "data": "QUANTIDADE"
        },
        {
          "data": "QUANTIDADE_UTILIZADA"
        },
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        },
        {
          render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
              });
          },
          targets: [2,3],
          "className": 'pr-4 text-right'
        },
        {
          targets: [6,7],
          "className": 'pr-4 text-right'
        }
      ]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaCupom').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaCupom').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('CADCUPOMDESCONTO', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `cadcupomdesconto/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCupom').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaCupom').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('CADCUPOMDESCONTO', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `cadcupomdesconto/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCupom').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCupom").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/cupomdesconto?", `CODIGO=${valorLinha.CODIGO}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});