$(document).ready(async function () {
    const utilizaProdMat = await CopiaParametro('VENDA', 17);
    const utilizaTabCorTam = await CopiaParametro('VENDA', 5);
    const tabPrecoPadrao = await CopiaParametro('VENDA', 2);
    let registroPreenchido = []
    let control = {
        indicePrecoNovo: utilizaTabCorTam == 1 ? 8 : 5,
        indicePrecoAntigo: utilizaTabCorTam == 1 ? 7 : 4
    }

    if (utilizaTabCorTam == 0 || utilizaProdMat == 1) {
        $('#divCor').addClass('d-none');
        $('#divTamanho').addClass('d-none');
        $('#divCodigo').removeClass('col-sm-3');
        $('#divCodigo').addClass('col-sm-6');
        $('#divTabeladePreco').removeClass('col-sm-3');
        $('#divTabeladePreco').addClass('col-sm-6');
    }

    let decimais = parseInt(await CopiaParametro("SISTEMA", 1)) + 2;

    if (isNaN(decimais)) {
        decimais = 2;
    };

    criaAutocompletasEPesquisas();

    $('#radioProduto').on('click', async function () {
        if (utilizaTabCorTam == 0) {
            $('#divCor').addClass('d-none');
            $('#divTamanho').addClass('d-none');
            $('#divCodigo').removeClass('col-sm-3');
            $('#divCodigo').addClass('col-sm-6');
            $('#divTabeladePreco').removeClass('col-sm-3');
            $('#divTabeladePreco').addClass('col-sm-6');
        } else {
            $('#divCor').removeClass('d-none');
            $('#divTamanho').removeClass('d-none');
            $('#divCodigo').addClass('col-sm-3');
            $('#divCodigo').removeClass('col-sm-6');
            $('#divTabeladePreco').addClass('col-sm-3');
            $('#divTabeladePreco').removeClass('col-sm-6');

            $('#txtTamanho').pesquisa_variosServerside(1, '{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA" ], "where": null}', 'TAM', 'FAIXA');
            $('#btnTamanho').pesquisa_serversideSel('#txtTamanho', `{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"], "where": null}`, 'Pesquisa de Tamanho');

            $('#txtCor').pesquisa_variosServerside(1, '{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'COR', 'DESCRICAO');
            $('#btnCor').pesquisa_serversideSel('#txtCor', `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cor');
        }

        $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Produto');
    });

    $('#radioMaterial').on('click', async function () {
        $('#divCor').addClass('d-none');
        $('#divTamanho').addClass('d-none');
        $('#divCodigo').removeClass('col-sm-3');
        $('#divCodigo').addClass('col-sm-6');
        $('#divTabeladePreco').removeClass('col-sm-3');
        $('#divTabeladePreco').addClass('col-sm-6');

        $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Material');
    });

    async function buscaDadosCampos() {
        let rgTipo = $('#radioProduto').is(':checked') ? 'PRODUTO' : $('#radioMaterial').is(':checked') ? 'MATERIAL' : null;

        objeto = {
            regiao: pegaChave('#txtTabPreco') != '' ? pegaChave('#txtTabPreco') : '',
            tam: $('#txtTamanho').val() != '' ? await formataListas($('#txtTamanho').val().toString()) : '',
            cor: $('#txtCor').val() != '' ? await formataListas($('#txtCor').val().toString()) : '',
            codigo: $('#txtCodigo').val() != '' ? await formataListas($('#txtCodigo').val().toString()) : '',
            tipo: rgTipo,
            utilizaCorTam: utilizaTabCorTam
        }
        return objeto;
    }

    $('#btnConsultar').on('click', async function () {
        const colunasDataTable = await retornaColunas();
        if ($.fn.DataTable.isDataTable('#tabelaAlteraPreco')) {
            $("#tabelaAlteraPreco").DataTable().destroy();
            $("#tabelaAlteraPreco").empty();
        };

        if ($('#txtTabPreco').val() == '') {
            msgErro('Obrigatório informar uma tabela de preço para fazer a consulta!');
            return;
        };

        try {
            const params = await buscaDadosCampos();

            const response = await requisicao('GET', `/sisplan/alterapreco/v1/buscaprecos?`, `JSON=${JSON.stringify(params)}`, '', 90000);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();

            $('#tabelaAlteraPreco').DataTable({
                paging: true,
                filter: true,
                lengthChange: true,
                length: false,
                order: false,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",

                    },
                },
                columns: colunasDataTable,
                data: jsonStr,
                columnDefs: [
                    {
                        targets: [control.indicePrecoNovo], render: function (data, type, row, meta) {
                            return `<input type="text" class="input-default form-control input-preconovo" id="txtPrecoNovo${meta.row}" class="form-control"></input>`
                        }
                    },
                    {
                        targets: [control.indicePrecoAntigo], render: function (data, type, row) {
                            const numeroformatado = parseFloat(data.replace(',', '.')).toFixed(decimais).replace('.', ',')
                            return numeroformatado;
                        }
                    }
                ]
            });

            $('#tabelaAlteraPreco_filter label').css('display', 'none');
            $('#tabelaAlteraPreco_filter').prepend(
                '<div class="col-6">' +
                '<h6 style="display: flex; margin-left: 11%;">Alterar preço de todos</h6 > ' +
                '<input style="width:89%;" type="text" class="mb-1 input-default focus form-control" id="txtAlteraTodosPrecos" name="txtAlteraTodosPrecos" class="form-control">' +
                '</div>'
            );

            await trataInputsAlteracao();

        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravar').on('click', async function () {
        const qtdeRegistrosDataTable = $('#tabelaAlteraPreco').DataTable().data().toArray();

        if (qtdeRegistrosDataTable <= 0) {
            msgErro('Não existe registro para gravar! Verifique.');
            return;
        };

        if (registroPreenchido.length <= 0) {
            msgErro('Você não informou nenhum preço para alteração! Verifique');
            return;
        };

        await gravaNovosPrecos();
    });

    $('#txtTabPreco').val(tabPrecoPadrao);

    async function gravaNovosPrecos() {
        try {
            $.LoadingOverlay('show');

            let tipoTabelaPreco;

            if (utilizaTabCorTam == 1 && utilizaProdMat == 0) {
                tipoTabelaPreco = 1;
            } else {
                tipoTabelaPreco = 0
            }

            const url = '/sisplan/alterapreco/v1/atualizapreco?';
            const response = await requisicao('PUT', url, `TIPOTABELAPRECO=${tipoTabelaPreco}`, JSON.stringify({ PrecosAlterados: registroPreenchido }), 180000);

            if (!response) {
                msgErro('Não foi possível alterar os preços! Verifique.');
                return;
            };

            if (response.status == 200) {
                criaMensagemSucesso('Preços alterados com sucesso!', () => { window.location.href = window.location.href; });
                return;
            };

            if (response.status != 200) {
                msgErro('Não foi possível alterar os preços! Verifique.');
                return;
            };

        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaColunas() {
        let dataSetColsPreco = [];
        let columnsPreco = []
        if (utilizaTabCorTam == '1' && utilizaProdMat == 0) {
            columnsPreco = [{
                title: 'Código ',
                data: 'codigo',
            },
            {
                title: 'Descrição',
                data: 'descricao',
            },
            {
                title: 'Cor',
                data: 'cor',
            },
            {
                title: 'Descrição da Cor',
                data: 'desc_cor',
            },
            {
                title: 'Tam',
                data: 'tam',
            },
            {
                title: 'Região',
                data: 'regiao',
            },
            {
                title: 'Descrição da Região',
                data: 'desc_regiao',
            },
            {
                title: 'Preço Antigo',
                data: 'preco_antigo',
            },
            {
                title: 'Preço Novo',
                data: 'preco_novo',
            }];
        } else {
            columnsPreco = [{
                title: 'Código ',
                data: 'codigo',
            },
            {
                title: 'Descrição',
                data: 'descricao',
            },
            {
                title: 'Região',
                data: 'regiao',
            },
            {
                title: 'Descrição da Região',
                data: 'desc_regiao',
            },
            {
                title: 'Preço Antigo',
                data: 'preco_antigo',
            },
            {
                title: 'Preço Novo',
                data: 'preco_novo',
            }];
        }
        columnsPreco.forEach((column) => {
            dataSetColsPreco.push({
                title: column.title,
                data: column.data,
            });
        });
        return dataSetColsPreco;
    };

    function criaAutocompletasEPesquisas() {
        $.LoadingOverlay('show')
        try {
            if (utilizaProdMat == '1') {
                $('#radioMaterial').prop('checked', true);
                $('#radioProduto').prop('checked', false);
                $('#btnCodigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Material');
                $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
            } else {
                $('#radioProduto').prop('checked', true);
                $('#radioMaterial').prop('checked', false);
                $('#btnCodigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Produto');
                $('#btnCor').pesquisa_serverside(['#txtCor'], ["COR"], ["DESCRICAO"], `{"tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Cor');
                $('#btnTamanho').pesquisa_serverside(['#txtTamanho'], ["TAM"], ["FAIXA"], `{"tabela":"TABTAM", "camposSelect":["TAM", "FAIXA"], "where": ["1=1"]}`, 'Pesquisa de Tamanho');
                $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE", "FAIXA DESCRICAO"], "where": null}`);
                $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $('#txtTamanho').listaFiltros();
                $('#txtCor').listaFiltros();
                $('#btnlimparTamanho').on('click', function () {
                    if ($('#txtTamanho').val() == '') {
                        $('#listaTamanho').val('');
                    }
                    $('#txtTamanho').val('');
                });
                $('#btnlimparCor').on('click', function () {
                    if ($('#txtCor').val() == '') {
                        $('#listaCor').val('');
                    }
                    $('#txtCor').val('');
                });
            };

            $('#txtCodigo').listaFiltros();

            $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": ["LIBERADO = 'S'"]}`);
            $('#btnTabPreco').pesquisa_serverside(['#txtTabPreco'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"], "where": ["LIBERADO = 'S'"]}`, 'Pesquisa de Tabela de Preço');

            $('#btnlimparTabPreco').on('click', function () {
                $('#txtTabPreco').val('');
            });
        } finally {
            $.LoadingOverlay('hide')
        }
    };

    $("#btnlimparTamanho").on('click', function () {
        $('#txtTamanho').empty().trigger('change');
    });

    $("#btnlimparCor").on('click', function () {
        $('#txtCor').empty().trigger('change');
    });

    $("#btnlimparTabPreco").on('click', function () {
        $('#txtTabPreco').empty().trigger('change');
    });

    $("#btnlimparCodigo").on('click', function () {
        $('#txtCodigo').empty().trigger('change');
    });

    $('#btnLimpar').on('click', function () {
        $('#txtTabPreco').val('');
        $('#txtCodigo').empty().trigger('change');
        $('#txtTabPreco').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtTamanho').empty().trigger('change');
    });

    if (utilizaProdMat == '1') {
        $('#radioProduto').trigger('click');
        $('#radioMaterial').trigger('click');
    } else {
        $('#radioMaterial').trigger('click');
        $('#radioProduto').trigger('click');
    }

    async function trataInputsAlteracao() {
        $('.input-preconovo').on('focusin', async function () {
            $("#tabelaAlteraPreco").dataTable().$("tr.selected").removeClass("selected");
            $(this).closest('tr').addClass("selected");
        });

        $('.input-preconovo').maskMoney({
            decimal: '.',
            thousands: '',
            precision: decimais ?? 2
        });

        $('#txtAlteraTodosPrecos').maskMoney({
            decimal: '.',
            thousands: '',
            precision: decimais ?? 2
        });

        $('#txtAlteraTodosPrecos').on('blur', async function () {
            var novoPreco = $(this).val();
            if (novoPreco) {
                new Promise((resolve, reject) => {
                    msgAlerta('Deseja realmente alterar o preço de todos os produtos  \nEssa ação percorrerá todas as páginas da tabela e resultará na seleção completa dos registros.',
                        () => {
                            alteraTodosPrecos(novoPreco)
                            resolve()
                        },
                        () => {
                            $('#txtAlteraTodosPrecos').val('')
                        },
                        () => {
                            alteraTodosPrecos(novoPreco)
                            resolve()
                        },
                        () => {
                            $('#txtAlteraTodosPrecos').val('')
                        }
                    )
                })
            }
        });

        $('#tabelaAlteraPreco').DataTable().on('change', ".input-preconovo", async function () {
            newValue = $(this).val();
            const dados = $('#tabelaAlteraPreco').DataTable().row($(this).closest('tr')).data();
            if (utilizaTabCorTam == 1) {
                if ($(this).val()) {
                    registroPreenchido.push({ codigo: dados.codigo, regiao: dados.regiao, tam: dados.tam, cor: dados.cor, preco_novo: newValue })
                    $('#tabelaAlteraPreco').DataTable().row($(this).closest('tr')).data().preco_novo = newValue
                } else {
                    $(this).val('')
                    $('#tabelaAlteraPreco').DataTable().row($(this).closest('tr')).data().preco_novo = ''
                    registroPreenchido.splice(registroPreenchido.filter((item) => dados.codigo == item.codigo && dados.regiao == item.regiao && dados.tam == item.tam && dados.cor == item.cor)[0], 1)
                }
            } else {
                if ($(this).val()) {
                    registroPreenchido.push({ codigo: dados.codigo, regiao: dados.regiao, preco_novo: newValue })
                    $('#tabelaAlteraPreco').DataTable().row($(this).closest('tr')).data().preco_novo = newValue
                } else {
                    $(this).val('')
                    $('#tabelaAlteraPreco').DataTable().row($(this).closest('tr')).data().preco_novo = ''
                    registroPreenchido.splice(registroPreenchido.filter((item) => dados.codigo == item.codigo && dados.regiao == item.regiao)[0], 1)
                }
            }
        });

        $('#tabelaAlteraPreco').on('draw.dt', async function () {
            $('#tabelaAlteraPreco').DataTable().rows().data().$(`.input-preconovo`).toArray().forEach((campoPreco, i) => {
                if ($(campoPreco).val() == '') {
                    $(campoPreco).val($('#txtAlteraTodosPrecos').val())
                }
            })
        });
    }

    async function alteraTodosPrecos(novoPreco) {
        registroPreenchido = []
        var formattedPrice = novoPreco.toLocaleString('pt-BR', {
            style: 'currency',
            currency: 'BRL'
        });

        $('#tabelaAlteraPreco').DataTable().rows().data().toArray().map((item, i) => {
            const dados = $(item).find('.input-preconovo').prevObject[0]
            $(`#txtPrecoNovo${i}`).val(formattedPrice)
            $('#tabelaAlteraPreco').DataTable().rows(i).data().toArray()[0].preco_novo = formattedPrice
            if (utilizaTabCorTam == 1) {
                registroPreenchido.push({ codigo: dados.codigo, regiao: dados.regiao, tam: dados.tam, cor: dados.cor, preco_novo: formattedPrice })
            } else {
                registroPreenchido.push({ codigo: dados.codigo, regiao: dados.regiao, preco_novo: formattedPrice })
            }
        });
    }
});